package software.amazon.awscdk.services.apigatewayv2;

/**
 * Supported integration subtypes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpStepFunctionsIntegration;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * StateMachine stateMachine;
 * HttpApi httpApi;
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/start")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpStepFunctionsIntegration.Builder.create("StartExecutionIntegration")
 *                 .stateMachine(stateMachine)
 *                 .subtype(HttpIntegrationSubtype.STEPFUNCTIONS_START_EXECUTION)
 *                 .build())
 *         .build());
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/start-sync")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpStepFunctionsIntegration.Builder.create("StartSyncExecutionIntegration")
 *                 .stateMachine(stateMachine)
 *                 .subtype(HttpIntegrationSubtype.STEPFUNCTIONS_START_SYNC_EXECUTION)
 *                 .build())
 *         .build());
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/stop")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpStepFunctionsIntegration.Builder.create("StopExecutionIntegration")
 *                 .stateMachine(stateMachine)
 *                 .subtype(HttpIntegrationSubtype.STEPFUNCTIONS_STOP_EXECUTION)
 *                 // For the `STOP_EXECUTION` subtype, it is necessary to specify the `executionArn`.
 *                 .parameterMapping(new ParameterMapping().custom("ExecutionArn", "$request.querystring.executionArn"))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.613Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpIntegrationSubtype")
public enum HttpIntegrationSubtype {
    /**
     * EventBridge PutEvents integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EVENTBRIDGE_PUT_EVENTS,
    /**
     * SQS SendMessage integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SQS_SEND_MESSAGE,
    /**
     * SQS ReceiveMessage integration,.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SQS_RECEIVE_MESSAGE,
    /**
     * SQS DeleteMessage integration,.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SQS_DELETE_MESSAGE,
    /**
     * SQS PurgeQueue integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SQS_PURGE_QUEUE,
    /**
     * AppConfig GetConfiguration integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    APPCONFIG_GET_CONFIGURATION,
    /**
     * Kinesis PutRecord integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KINESIS_PUT_RECORD,
    /**
     * Step Functions StartExecution integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STEPFUNCTIONS_START_EXECUTION,
    /**
     * Step Functions StartSyncExecution integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STEPFUNCTIONS_START_SYNC_EXECUTION,
    /**
     * Step Functions StopExecution integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STEPFUNCTIONS_STOP_EXECUTION,
}
