package software.amazon.awscdk.services.apigatewayv2;

/**
 * Time period for which quota settings apply.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * WebSocketApi api;
 * WebSocketStage stage;
 * RateLimitedApiKey key = RateLimitedApiKey.Builder.create(this, "rate-limited-api-key")
 *         .customerId("test-customer")
 *         .apiStages(List.of(UsagePlanPerApiStage.builder()
 *                 .api(api)
 *                 .stage(stage)
 *                 .build()))
 *         .quota(QuotaSettings.builder()
 *                 .limit(10000)
 *                 .period(Period.MONTH)
 *                 .build())
 *         .throttle(ThrottleSettings.builder()
 *                 .rateLimit(100)
 *                 .burstLimit(200)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.654Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.Period")
public enum Period {
    /**
     * The quota resets every day.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DAY,
    /**
     * The quota resets every week.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WEEK,
    /**
     * The quota resets every month.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTH,
}
