package software.amazon.awscdk.services.apigatewayv2;

/**
 * An API Gateway ApiKey, for which a rate limiting configuration can be specified.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * WebSocketApi api;
 * WebSocketStage stage;
 * RateLimitedApiKey key = RateLimitedApiKey.Builder.create(this, "rate-limited-api-key")
 *         .customerId("test-customer")
 *         .apiStages(List.of(UsagePlanPerApiStage.builder()
 *                 .api(api)
 *                 .stage(stage)
 *                 .build()))
 *         .quota(QuotaSettings.builder()
 *                 .limit(10000)
 *                 .period(Period.MONTH)
 *                 .build())
 *         .throttle(ThrottleSettings.builder()
 *                 .rateLimit(100)
 *                 .burstLimit(200)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.655Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.RateLimitedApiKey")
public class RateLimitedApiKey extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.IApiKey {

    protected RateLimitedApiKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RateLimitedApiKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.RateLimitedApiKey.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RateLimitedApiKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.RateLimitedApiKeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RateLimitedApiKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Permits the IAM principal all read operations through this key.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits the IAM principal all read and write operations through this key.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Permits the IAM principal all write operations through this key.
     * <p>
     * @param grantee The principal to grant access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The API key ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "keyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The API key ID.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyId() {
        return software.amazon.jsii.Kernel.get(this, "keyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.RateLimitedApiKey}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.RateLimitedApiKey> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigatewayv2.RateLimitedApiKeyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A name for the API key.
         * <p>
         * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
         * <p>
         * Default: automatically generated name
         * <p>
         * @return {@code this}
         * @param apiKeyName A name for the API key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyName(final java.lang.String apiKeyName) {
            this.props().apiKeyName(apiKeyName);
            return this;
        }

        /**
         * A description of the purpose of the API key.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param description A description of the purpose of the API key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The value of the API key.
         * <p>
         * Must be at least 20 characters long.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param value The value of the API key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(final java.lang.String value) {
            this.props().value(value);
            return this;
        }

        /**
         * An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param customerId An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerId(final java.lang.String customerId) {
            this.props().customerId(customerId);
            return this;
        }

        /**
         * Indicates whether the API key can be used by clients.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Indicates whether the API key can be used by clients. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * Specifies whether the key identifier is distinct from the created API key value.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param generateDistinctId Specifies whether the key identifier is distinct from the created API key value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateDistinctId(final java.lang.Boolean generateDistinctId) {
            this.props().generateDistinctId(generateDistinctId);
            return this;
        }

        /**
         * API Stages to be associated with the RateLimitedApiKey.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param apiStages API Stages to be associated with the RateLimitedApiKey. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStages(final java.util.List<? extends software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage> apiStages) {
            this.props().apiStages(apiStages);
            return this;
        }

        /**
         * Number of requests clients can make in a given time period.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param quota Number of requests clients can make in a given time period. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(final software.amazon.awscdk.services.apigatewayv2.QuotaSettings quota) {
            this.props().quota(quota);
            return this;
        }

        /**
         * Overall throttle settings for the API.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param throttle Overall throttle settings for the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(final software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle) {
            this.props().throttle(throttle);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.RateLimitedApiKey}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.RateLimitedApiKey build() {
            return new software.amazon.awscdk.services.apigatewayv2.RateLimitedApiKey(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigatewayv2.RateLimitedApiKeyProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigatewayv2.RateLimitedApiKeyProps.Builder();
            }
            return this.props;
        }
    }
}
