package software.amazon.awscdk.services.apigatewayv2;

/**
 * RateLimitedApiKey properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * WebSocketApi api;
 * WebSocketStage stage;
 * RateLimitedApiKey key = RateLimitedApiKey.Builder.create(this, "rate-limited-api-key")
 *         .customerId("test-customer")
 *         .apiStages(List.of(UsagePlanPerApiStage.builder()
 *                 .api(api)
 *                 .stage(stage)
 *                 .build()))
 *         .quota(QuotaSettings.builder()
 *                 .limit(10000)
 *                 .period(Period.MONTH)
 *                 .build())
 *         .throttle(ThrottleSettings.builder()
 *                 .rateLimit(100)
 *                 .burstLimit(200)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.656Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.RateLimitedApiKeyProps")
@software.amazon.jsii.Jsii.Proxy(RateLimitedApiKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RateLimitedApiKeyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigatewayv2.ApiKeyProps {

    /**
     * API Stages to be associated with the RateLimitedApiKey.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage> getApiStages() {
        return null;
    }

    /**
     * Number of requests clients can make in a given time period.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.QuotaSettings getQuota() {
        return null;
    }

    /**
     * Overall throttle settings for the API.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.ThrottleSettings getThrottle() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RateLimitedApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RateLimitedApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RateLimitedApiKeyProps> {
        java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage> apiStages;
        software.amazon.awscdk.services.apigatewayv2.QuotaSettings quota;
        software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle;
        java.lang.String customerId;
        java.lang.Boolean enabled;
        java.lang.Boolean generateDistinctId;
        java.lang.String apiKeyName;
        java.lang.String description;
        java.lang.String value;

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getApiStages}
         * @param apiStages API Stages to be associated with the RateLimitedApiKey.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder apiStages(java.util.List<? extends software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage> apiStages) {
            this.apiStages = (java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage>)apiStages;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getQuota}
         * @param quota Number of requests clients can make in a given time period.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(software.amazon.awscdk.services.apigatewayv2.QuotaSettings quota) {
            this.quota = quota;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getThrottle}
         * @param throttle Overall throttle settings for the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getCustomerId}
         * @param customerId An AWS Marketplace customer identifier to use when integrating with the AWS SaaS Marketplace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerId(java.lang.String customerId) {
            this.customerId = customerId;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getEnabled}
         * @param enabled Indicates whether the API key can be used by clients.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getGenerateDistinctId}
         * @param generateDistinctId Specifies whether the key identifier is distinct from the created API key value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateDistinctId(java.lang.Boolean generateDistinctId) {
            this.generateDistinctId = generateDistinctId;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getApiKeyName}
         * @param apiKeyName A name for the API key.
         *                   If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyName(java.lang.String apiKeyName) {
            this.apiKeyName = apiKeyName;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getDescription}
         * @param description A description of the purpose of the API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link RateLimitedApiKeyProps#getValue}
         * @param value The value of the API key.
         *              Must be at least 20 characters long.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.String value) {
            this.value = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RateLimitedApiKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RateLimitedApiKeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RateLimitedApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateLimitedApiKeyProps {
        private final java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage> apiStages;
        private final software.amazon.awscdk.services.apigatewayv2.QuotaSettings quota;
        private final software.amazon.awscdk.services.apigatewayv2.ThrottleSettings throttle;
        private final java.lang.String customerId;
        private final java.lang.Boolean enabled;
        private final java.lang.Boolean generateDistinctId;
        private final java.lang.String apiKeyName;
        private final java.lang.String description;
        private final java.lang.String value;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiStages = software.amazon.jsii.Kernel.get(this, "apiStages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage.class)));
            this.quota = software.amazon.jsii.Kernel.get(this, "quota", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.QuotaSettings.class));
            this.throttle = software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ThrottleSettings.class));
            this.customerId = software.amazon.jsii.Kernel.get(this, "customerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.generateDistinctId = software.amazon.jsii.Kernel.get(this, "generateDistinctId", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.apiKeyName = software.amazon.jsii.Kernel.get(this, "apiKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiStages = (java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage>)builder.apiStages;
            this.quota = builder.quota;
            this.throttle = builder.throttle;
            this.customerId = builder.customerId;
            this.enabled = builder.enabled;
            this.generateDistinctId = builder.generateDistinctId;
            this.apiKeyName = builder.apiKeyName;
            this.description = builder.description;
            this.value = builder.value;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigatewayv2.UsagePlanPerApiStage> getApiStages() {
            return this.apiStages;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.QuotaSettings getQuota() {
            return this.quota;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        public final java.lang.String getCustomerId() {
            return this.customerId;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.Boolean getGenerateDistinctId() {
            return this.generateDistinctId;
        }

        @Override
        public final java.lang.String getApiKeyName() {
            return this.apiKeyName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getValue() {
            return this.value;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiStages() != null) {
                data.set("apiStages", om.valueToTree(this.getApiStages()));
            }
            if (this.getQuota() != null) {
                data.set("quota", om.valueToTree(this.getQuota()));
            }
            if (this.getThrottle() != null) {
                data.set("throttle", om.valueToTree(this.getThrottle()));
            }
            if (this.getCustomerId() != null) {
                data.set("customerId", om.valueToTree(this.getCustomerId()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getGenerateDistinctId() != null) {
                data.set("generateDistinctId", om.valueToTree(this.getGenerateDistinctId()));
            }
            if (this.getApiKeyName() != null) {
                data.set("apiKeyName", om.valueToTree(this.getApiKeyName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getValue() != null) {
                data.set("value", om.valueToTree(this.getValue()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.RateLimitedApiKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RateLimitedApiKeyProps.Jsii$Proxy that = (RateLimitedApiKeyProps.Jsii$Proxy) o;

            if (this.apiStages != null ? !this.apiStages.equals(that.apiStages) : that.apiStages != null) return false;
            if (this.quota != null ? !this.quota.equals(that.quota) : that.quota != null) return false;
            if (this.throttle != null ? !this.throttle.equals(that.throttle) : that.throttle != null) return false;
            if (this.customerId != null ? !this.customerId.equals(that.customerId) : that.customerId != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.generateDistinctId != null ? !this.generateDistinctId.equals(that.generateDistinctId) : that.generateDistinctId != null) return false;
            if (this.apiKeyName != null ? !this.apiKeyName.equals(that.apiKeyName) : that.apiKeyName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiStages != null ? this.apiStages.hashCode() : 0;
            result = 31 * result + (this.quota != null ? this.quota.hashCode() : 0);
            result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
            result = 31 * result + (this.customerId != null ? this.customerId.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.generateDistinctId != null ? this.generateDistinctId.hashCode() : 0);
            result = 31 * result + (this.apiKeyName != null ? this.apiKeyName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}
