package software.amazon.awscdk.services.apigatewayv2;

/**
 * Represents the API stages that a usage plan applies to.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * WebSocketApi api = new WebSocketApi(this, "my-api");
 * WebSocketStage stage = WebSocketStage.Builder.create(this, "my-stage")
 *         .webSocketApi(api)
 *         .stageName("dev")
 *         .build();
 * UsagePlan usagePlan = UsagePlan.Builder.create(this, "my-usage-plan")
 *         .usagePlanName("Basic")
 *         .build();
 * usagePlan.addApiStage(UsagePlanPerApiStage.builder()
 *         .api(api)
 *         .stage(stage)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.659Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.UsagePlanPerApiStage")
@software.amazon.jsii.Jsii.Proxy(UsagePlanPerApiStage.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UsagePlanPerApiStage extends software.amazon.jsii.JsiiSerializable {

    /**
     * The WebSocket API to associate with the usage plan.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getApi() {
        return null;
    }

    /**
     * [disable-awslint:ref-via-interface].
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IWebSocketStage getStage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UsagePlanPerApiStage}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UsagePlanPerApiStage}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UsagePlanPerApiStage> {
        software.amazon.awscdk.services.apigatewayv2.IWebSocketApi api;
        software.amazon.awscdk.services.apigatewayv2.IWebSocketStage stage;

        /**
         * Sets the value of {@link UsagePlanPerApiStage#getApi}
         * @param api The WebSocket API to associate with the usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi api) {
            this.api = api;
            return this;
        }

        /**
         * Sets the value of {@link UsagePlanPerApiStage#getStage}
         * @param stage [disable-awslint:ref-via-interface].
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stage(software.amazon.awscdk.services.apigatewayv2.IWebSocketStage stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UsagePlanPerApiStage}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UsagePlanPerApiStage build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UsagePlanPerApiStage}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UsagePlanPerApiStage {
        private final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi api;
        private final software.amazon.awscdk.services.apigatewayv2.IWebSocketStage stage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.api = software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi.class));
            this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketStage.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.api = builder.api;
            this.stage = builder.stage;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getApi() {
            return this.api;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IWebSocketStage getStage() {
            return this.stage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApi() != null) {
                data.set("api", om.valueToTree(this.getApi()));
            }
            if (this.getStage() != null) {
                data.set("stage", om.valueToTree(this.getStage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.UsagePlanPerApiStage"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UsagePlanPerApiStage.Jsii$Proxy that = (UsagePlanPerApiStage.Jsii$Proxy) o;

            if (this.api != null ? !this.api.equals(that.api) : that.api != null) return false;
            return this.stage != null ? this.stage.equals(that.stage) : that.stage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.api != null ? this.api.hashCode() : 0;
            result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
            return result;
        }
    }
}
