package software.amazon.awscdk.services.apigatewayv2;

/**
 * Define a new VPC Link Specifies an API Gateway VPC link for a HTTP API to access resources in an Amazon Virtual Private Cloud (VPC).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpAlbIntegration;
 * Vpc vpc = new Vpc(this, "VPC");
 * ApplicationLoadBalancer alb = ApplicationLoadBalancer.Builder.create(this, "AppLoadBalancer").vpc(vpc).build();
 * VpcLink vpcLink = VpcLink.Builder.create(this, "VpcLink").vpc(vpc).build();
 * // Creating an HTTP ALB Integration:
 * HttpAlbIntegration albIntegration = HttpAlbIntegration.Builder.create("ALBIntegration", alb.getListeners()[0]).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.660Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.VpcLink")
public class VpcLink extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.IVpcLink {

    protected VpcLink(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpcLink(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.VpcLink.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public VpcLink(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.VpcLinkProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a VPC Link by specifying its attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IVpcLink fromVpcLinkAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.VpcLinkAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.VpcLink.class, "fromVpcLinkAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IVpcLink.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Adds the provided security groups to the vpc link.
     * <p>
     * @param groups This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup... groups) {
        software.amazon.jsii.Kernel.call(this, "addSecurityGroups", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(groups).toArray(Object[]::new));
    }

    /**
     * Adds the provided subnets to the vpc link.
     * <p>
     * @param subnets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSubnets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISubnet... subnets) {
        software.amazon.jsii.Kernel.call(this, "addSubnets", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(subnets).toArray(Object[]::new));
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The VPC to which this VPC Link is associated with.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
    }

    /**
     * Physical ID of the VpcLink resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcLinkId() {
        return software.amazon.jsii.Kernel.get(this, "vpcLinkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.VpcLink}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.VpcLink> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.VpcLinkProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.VpcLinkProps.Builder();
        }

        /**
         * The VPC in which the private resources reside.
         * <p>
         * @return {@code this}
         * @param vpc The VPC in which the private resources reside. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * A list of security groups for the VPC link.
         * <p>
         * Default: - no security groups. Use `addSecurityGroups` to add security groups
         * <p>
         * @return {@code this}
         * @param securityGroups A list of security groups for the VPC link. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * A list of subnets for the VPC link.
         * <p>
         * Default: - private subnets of the provided VPC. Use `addSubnets` to add more subnets
         * <p>
         * @return {@code this}
         * @param subnets A list of subnets for the VPC link. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(final software.amazon.awscdk.services.ec2.SubnetSelection subnets) {
            this.props.subnets(subnets);
            return this;
        }

        /**
         * The name used to label and identify the VPC link.
         * <p>
         * Default: - automatically generated name
         * <p>
         * @return {@code this}
         * @param vpcLinkName The name used to label and identify the VPC link. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLinkName(final java.lang.String vpcLinkName) {
            this.props.vpcLinkName(vpcLinkName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.VpcLink}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.VpcLink build() {
            return new software.amazon.awscdk.services.apigatewayv2.VpcLink(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
