package software.amazon.awscdk.services.apigatewayv2;

/**
 * Properties to initialize an instance of <code>WebSocketAuthorizer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * WebSocketApi webSocketApi;
 * WebSocketAuthorizerProps webSocketAuthorizerProps = WebSocketAuthorizerProps.builder()
 *         .identitySource(List.of("identitySource"))
 *         .type(WebSocketAuthorizerType.LAMBDA)
 *         .webSocketApi(webSocketApi)
 *         // the properties below are optional
 *         .authorizerName("authorizerName")
 *         .authorizerUri("authorizerUri")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.665Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketAuthorizerProps")
@software.amazon.jsii.Jsii.Proxy(WebSocketAuthorizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketAuthorizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identity source for which authorization is requested.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getIdentitySource();

    /**
     * The type of authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketAuthorizerType getType();

    /**
     * WebSocket Api to attach the authorizer to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getWebSocketApi();

    /**
     * Name of the authorizer.
     * <p>
     * Default: - id of the WebSocketAuthorizer construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerName() {
        return null;
    }

    /**
     * The authorizer's Uniform Resource Identifier (URI).
     * <p>
     * For REQUEST authorizers, this must be a well-formed Lambda function URI.
     * <p>
     * Default: - required for Request authorizer types
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerUri() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WebSocketAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketAuthorizerProps> {
        java.util.List<java.lang.String> identitySource;
        software.amazon.awscdk.services.apigatewayv2.WebSocketAuthorizerType type;
        software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi;
        java.lang.String authorizerName;
        java.lang.String authorizerUri;

        /**
         * Sets the value of {@link WebSocketAuthorizerProps#getIdentitySource}
         * @param identitySource The identity source for which authorization is requested. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(java.util.List<java.lang.String> identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketAuthorizerProps#getType}
         * @param type The type of authorizer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.apigatewayv2.WebSocketAuthorizerType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketAuthorizerProps#getWebSocketApi}
         * @param webSocketApi WebSocket Api to attach the authorizer to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webSocketApi(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi) {
            this.webSocketApi = webSocketApi;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketAuthorizerProps#getAuthorizerName}
         * @param authorizerName Name of the authorizer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(java.lang.String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketAuthorizerProps#getAuthorizerUri}
         * @param authorizerUri The authorizer's Uniform Resource Identifier (URI).
         *                      For REQUEST authorizers, this must be a well-formed Lambda function URI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerUri(java.lang.String authorizerUri) {
            this.authorizerUri = authorizerUri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketAuthorizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketAuthorizerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketAuthorizerProps {
        private final java.util.List<java.lang.String> identitySource;
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketAuthorizerType type;
        private final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi;
        private final java.lang.String authorizerName;
        private final java.lang.String authorizerUri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.identitySource = software.amazon.jsii.Kernel.get(this, "identitySource", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketAuthorizerType.class));
            this.webSocketApi = software.amazon.jsii.Kernel.get(this, "webSocketApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi.class));
            this.authorizerName = software.amazon.jsii.Kernel.get(this, "authorizerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerUri = software.amazon.jsii.Kernel.get(this, "authorizerUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.identitySource = java.util.Objects.requireNonNull(builder.identitySource, "identitySource is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.webSocketApi = java.util.Objects.requireNonNull(builder.webSocketApi, "webSocketApi is required");
            this.authorizerName = builder.authorizerName;
            this.authorizerUri = builder.authorizerUri;
        }

        @Override
        public final java.util.List<java.lang.String> getIdentitySource() {
            return this.identitySource;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.WebSocketAuthorizerType getType() {
            return this.type;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getWebSocketApi() {
            return this.webSocketApi;
        }

        @Override
        public final java.lang.String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        public final java.lang.String getAuthorizerUri() {
            return this.authorizerUri;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("identitySource", om.valueToTree(this.getIdentitySource()));
            data.set("type", om.valueToTree(this.getType()));
            data.set("webSocketApi", om.valueToTree(this.getWebSocketApi()));
            if (this.getAuthorizerName() != null) {
                data.set("authorizerName", om.valueToTree(this.getAuthorizerName()));
            }
            if (this.getAuthorizerUri() != null) {
                data.set("authorizerUri", om.valueToTree(this.getAuthorizerUri()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.WebSocketAuthorizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketAuthorizerProps.Jsii$Proxy that = (WebSocketAuthorizerProps.Jsii$Proxy) o;

            if (!identitySource.equals(that.identitySource)) return false;
            if (!type.equals(that.type)) return false;
            if (!webSocketApi.equals(that.webSocketApi)) return false;
            if (this.authorizerName != null ? !this.authorizerName.equals(that.authorizerName) : that.authorizerName != null) return false;
            return this.authorizerUri != null ? this.authorizerUri.equals(that.authorizerUri) : that.authorizerUri == null;
        }

        @Override
        public final int hashCode() {
            int result = this.identitySource.hashCode();
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.webSocketApi.hashCode());
            result = 31 * result + (this.authorizerName != null ? this.authorizerName.hashCode() : 0);
            result = 31 * result + (this.authorizerUri != null ? this.authorizerUri.hashCode() : 0);
            return result;
        }
    }
}
