package software.amazon.awscdk.services.appflow;

/**
 * Properties for defining a <code>CfnFlow</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appflow.*;
 * CfnFlowProps cfnFlowProps = CfnFlowProps.builder()
 *         .destinationFlowConfigList(List.of(DestinationFlowConfigProperty.builder()
 *                 .connectorType("connectorType")
 *                 .destinationConnectorProperties(DestinationConnectorPropertiesProperty.builder()
 *                         .customConnector(CustomConnectorDestinationPropertiesProperty.builder()
 *                                 .entityName("entityName")
 *                                 // the properties below are optional
 *                                 .customProperties(Map.of(
 *                                         "customPropertiesKey", "customProperties"))
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .eventBridge(EventBridgeDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .lookoutMetrics(LookoutMetricsDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .marketo(MarketoDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .redshift(RedshiftDestinationPropertiesProperty.builder()
 *                                 .intermediateBucketName("intermediateBucketName")
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .s3(S3DestinationPropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .s3OutputFormatConfig(S3OutputFormatConfigProperty.builder()
 *                                         .aggregationConfig(AggregationConfigProperty.builder()
 *                                                 .aggregationType("aggregationType")
 *                                                 .targetFileSize(123)
 *                                                 .build())
 *                                         .fileType("fileType")
 *                                         .prefixConfig(PrefixConfigProperty.builder()
 *                                                 .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
 *                                                 .prefixFormat("prefixFormat")
 *                                                 .prefixType("prefixType")
 *                                                 .build())
 *                                         .preserveSourceDataTyping(false)
 *                                         .build())
 *                                 .build())
 *                         .salesforce(SalesforceDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .dataTransferApi("dataTransferApi")
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .sapoData(SAPODataDestinationPropertiesProperty.builder()
 *                                 .objectPath("objectPath")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .successResponseHandlingConfig(SuccessResponseHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .build())
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .snowflake(SnowflakeDestinationPropertiesProperty.builder()
 *                                 .intermediateBucketName("intermediateBucketName")
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .upsolver(UpsolverDestinationPropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .s3OutputFormatConfig(UpsolverS3OutputFormatConfigProperty.builder()
 *                                         .prefixConfig(PrefixConfigProperty.builder()
 *                                                 .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
 *                                                 .prefixFormat("prefixFormat")
 *                                                 .prefixType("prefixType")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .aggregationConfig(AggregationConfigProperty.builder()
 *                                                 .aggregationType("aggregationType")
 *                                                 .targetFileSize(123)
 *                                                 .build())
 *                                         .fileType("fileType")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .build())
 *                         .zendesk(ZendeskDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .apiVersion("apiVersion")
 *                 .connectorProfileName("connectorProfileName")
 *                 .build()))
 *         .flowName("flowName")
 *         .sourceFlowConfig(SourceFlowConfigProperty.builder()
 *                 .connectorType("connectorType")
 *                 .sourceConnectorProperties(SourceConnectorPropertiesProperty.builder()
 *                         .amplitude(AmplitudeSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .customConnector(CustomConnectorSourcePropertiesProperty.builder()
 *                                 .entityName("entityName")
 *                                 // the properties below are optional
 *                                 .customProperties(Map.of(
 *                                         "customPropertiesKey", "customProperties"))
 *                                 .dataTransferApi(DataTransferApiProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .datadog(DatadogSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .dynatrace(DynatraceSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .googleAnalytics(GoogleAnalyticsSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .inforNexus(InforNexusSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .marketo(MarketoSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .pardot(PardotSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .s3(S3SourcePropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .bucketPrefix("bucketPrefix")
 *                                 // the properties below are optional
 *                                 .s3InputFormatConfig(S3InputFormatConfigProperty.builder()
 *                                         .s3InputFileType("s3InputFileType")
 *                                         .build())
 *                                 .build())
 *                         .salesforce(SalesforceSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .dataTransferApi("dataTransferApi")
 *                                 .enableDynamicFieldUpdate(false)
 *                                 .includeDeletedRecords(false)
 *                                 .build())
 *                         .sapoData(SAPODataSourcePropertiesProperty.builder()
 *                                 .objectPath("objectPath")
 *                                 // the properties below are optional
 *                                 .paginationConfig(SAPODataPaginationConfigProperty.builder()
 *                                         .maxPageSize(123)
 *                                         .build())
 *                                 .parallelismConfig(SAPODataParallelismConfigProperty.builder()
 *                                         .maxParallelism(123)
 *                                         .build())
 *                                 .build())
 *                         .serviceNow(ServiceNowSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .singular(SingularSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .slack(SlackSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .trendmicro(TrendmicroSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .veeva(VeevaSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .documentType("documentType")
 *                                 .includeAllVersions(false)
 *                                 .includeRenditions(false)
 *                                 .includeSourceFiles(false)
 *                                 .build())
 *                         .zendesk(ZendeskSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .apiVersion("apiVersion")
 *                 .connectorProfileName("connectorProfileName")
 *                 .incrementalPullConfig(IncrementalPullConfigProperty.builder()
 *                         .datetimeTypeFieldName("datetimeTypeFieldName")
 *                         .build())
 *                 .build())
 *         .tasks(List.of(TaskProperty.builder()
 *                 .sourceFields(List.of("sourceFields"))
 *                 .taskType("taskType")
 *                 // the properties below are optional
 *                 .connectorOperator(ConnectorOperatorProperty.builder()
 *                         .amplitude("amplitude")
 *                         .customConnector("customConnector")
 *                         .datadog("datadog")
 *                         .dynatrace("dynatrace")
 *                         .googleAnalytics("googleAnalytics")
 *                         .inforNexus("inforNexus")
 *                         .marketo("marketo")
 *                         .pardot("pardot")
 *                         .s3("s3")
 *                         .salesforce("salesforce")
 *                         .sapoData("sapoData")
 *                         .serviceNow("serviceNow")
 *                         .singular("singular")
 *                         .slack("slack")
 *                         .trendmicro("trendmicro")
 *                         .veeva("veeva")
 *                         .zendesk("zendesk")
 *                         .build())
 *                 .destinationField("destinationField")
 *                 .taskProperties(List.of(TaskPropertiesObjectProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .triggerConfig(TriggerConfigProperty.builder()
 *                 .triggerType("triggerType")
 *                 // the properties below are optional
 *                 .triggerProperties(ScheduledTriggerPropertiesProperty.builder()
 *                         .scheduleExpression("scheduleExpression")
 *                         // the properties below are optional
 *                         .dataPullMode("dataPullMode")
 *                         .firstExecutionFrom(123)
 *                         .flowErrorDeactivationThreshold(123)
 *                         .scheduleEndTime(123)
 *                         .scheduleOffset(123)
 *                         .scheduleStartTime(123)
 *                         .timeZone("timeZone")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .flowStatus("flowStatus")
 *         .kmsArn("kmsArn")
 *         .metadataCatalogConfig(MetadataCatalogConfigProperty.builder()
 *                 .glueDataCatalog(GlueDataCatalogProperty.builder()
 *                         .databaseName("databaseName")
 *                         .roleArn("roleArn")
 *                         .tablePrefix("tablePrefix")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:25.889Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlowProps")
@software.amazon.jsii.Jsii.Proxy(CfnFlowProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFlowProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The configuration that controls how Amazon AppFlow places data in the destination connector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-destinationflowconfiglist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-destinationflowconfiglist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDestinationFlowConfigList();

    /**
     * The specified name of the flow.
     * <p>
     * Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-flowname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-flowname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFlowName();

    /**
     * Contains information about the configuration of the source connector used in the flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-sourceflowconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-sourceflowconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSourceFlowConfig();

    /**
     * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tasks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tasks</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTasks();

    /**
     * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-triggerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-triggerconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTriggerConfig();

    /**
     * A user-entered description of the flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Sets the status of the flow. You can specify one of the following values:.
     * <p>
     * <ul>
     * <li><strong>Active</strong> - The flow runs based on the trigger settings that you defined. Active scheduled flows run as scheduled, and active event-triggered flows run when the specified change event occurs. However, active on-demand flows run only when you manually start them by using Amazon AppFlow.</li>
     * <li><strong>Suspended</strong> - You can use this option to deactivate an active flow. Scheduled and event-triggered flows will cease to run until you reactive them. This value only affects scheduled and event-triggered flows. It has no effect for on-demand flows.</li>
     * </ul>
     * <p>
     * If you omit the FlowStatus parameter, Amazon AppFlow creates the flow with a default status. The default status for on-demand flows is Active. The default status for scheduled and event-triggered flows is Draft, which means they’re not yet active.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-flowstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-flowstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFlowStatus() {
        return null;
    }

    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
     * <p>
     * This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-kmsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-kmsarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsArn() {
        return null;
    }

    /**
     * Specifies the configuration that Amazon AppFlow uses when it catalogs your data.
     * <p>
     * When Amazon AppFlow catalogs your data, it stores metadata in a data catalog.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-metadatacatalogconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-metadatacatalogconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetadataCatalogConfig() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for your flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFlowProps> {
        java.lang.Object destinationFlowConfigList;
        java.lang.String flowName;
        java.lang.Object sourceFlowConfig;
        java.lang.Object tasks;
        java.lang.Object triggerConfig;
        java.lang.String description;
        java.lang.String flowStatus;
        java.lang.String kmsArn;
        java.lang.Object metadataCatalogConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFlowProps#getDestinationFlowConfigList}
         * @param destinationFlowConfigList The configuration that controls how Amazon AppFlow places data in the destination connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationFlowConfigList(software.amazon.awscdk.IResolvable destinationFlowConfigList) {
            this.destinationFlowConfigList = destinationFlowConfigList;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDestinationFlowConfigList}
         * @param destinationFlowConfigList The configuration that controls how Amazon AppFlow places data in the destination connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationFlowConfigList(java.util.List<? extends java.lang.Object> destinationFlowConfigList) {
            this.destinationFlowConfigList = destinationFlowConfigList;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getFlowName}
         * @param flowName The specified name of the flow. This parameter is required.
         *                 Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowName(java.lang.String flowName) {
            this.flowName = flowName;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getSourceFlowConfig}
         * @param sourceFlowConfig Contains information about the configuration of the source connector used in the flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFlowConfig(software.amazon.awscdk.IResolvable sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getSourceFlowConfig}
         * @param sourceFlowConfig Contains information about the configuration of the source connector used in the flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFlowConfig(software.amazon.awscdk.services.appflow.CfnFlow.SourceFlowConfigProperty sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTasks}
         * @param tasks A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tasks(software.amazon.awscdk.IResolvable tasks) {
            this.tasks = tasks;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTasks}
         * @param tasks A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tasks(java.util.List<? extends java.lang.Object> tasks) {
            this.tasks = tasks;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTriggerConfig}
         * @param triggerConfig The trigger settings that determine how and when Amazon AppFlow runs the specified flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfig(software.amazon.awscdk.IResolvable triggerConfig) {
            this.triggerConfig = triggerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTriggerConfig}
         * @param triggerConfig The trigger settings that determine how and when Amazon AppFlow runs the specified flow. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfig(software.amazon.awscdk.services.appflow.CfnFlow.TriggerConfigProperty triggerConfig) {
            this.triggerConfig = triggerConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getDescription}
         * @param description A user-entered description of the flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getFlowStatus}
         * @param flowStatus Sets the status of the flow. You can specify one of the following values:.
         *                   <ul>
         *                   <li><strong>Active</strong> - The flow runs based on the trigger settings that you defined. Active scheduled flows run as scheduled, and active event-triggered flows run when the specified change event occurs. However, active on-demand flows run only when you manually start them by using Amazon AppFlow.</li>
         *                   <li><strong>Suspended</strong> - You can use this option to deactivate an active flow. Scheduled and event-triggered flows will cease to run until you reactive them. This value only affects scheduled and event-triggered flows. It has no effect for on-demand flows.</li>
         *                   </ul>
         *                   <p>
         *                   If you omit the FlowStatus parameter, Amazon AppFlow creates the flow with a default status. The default status for on-demand flows is Active. The default status for scheduled and event-triggered flows is Draft, which means they’re not yet active.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowStatus(java.lang.String flowStatus) {
            this.flowStatus = flowStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getKmsArn}
         * @param kmsArn The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
         *               This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsArn(java.lang.String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getMetadataCatalogConfig}
         * @param metadataCatalogConfig Specifies the configuration that Amazon AppFlow uses when it catalogs your data.
         *                              When Amazon AppFlow catalogs your data, it stores metadata in a data catalog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataCatalogConfig(software.amazon.awscdk.IResolvable metadataCatalogConfig) {
            this.metadataCatalogConfig = metadataCatalogConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getMetadataCatalogConfig}
         * @param metadataCatalogConfig Specifies the configuration that Amazon AppFlow uses when it catalogs your data.
         *                              When Amazon AppFlow catalogs your data, it stores metadata in a data catalog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataCatalogConfig(software.amazon.awscdk.services.appflow.CfnFlow.MetadataCatalogConfigProperty metadataCatalogConfig) {
            this.metadataCatalogConfig = metadataCatalogConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnFlowProps#getTags}
         * @param tags The tags used to organize, track, or control access for your flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFlowProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFlowProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFlowProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFlowProps {
        private final java.lang.Object destinationFlowConfigList;
        private final java.lang.String flowName;
        private final java.lang.Object sourceFlowConfig;
        private final java.lang.Object tasks;
        private final java.lang.Object triggerConfig;
        private final java.lang.String description;
        private final java.lang.String flowStatus;
        private final java.lang.String kmsArn;
        private final java.lang.Object metadataCatalogConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationFlowConfigList = software.amazon.jsii.Kernel.get(this, "destinationFlowConfigList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.flowName = software.amazon.jsii.Kernel.get(this, "flowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceFlowConfig = software.amazon.jsii.Kernel.get(this, "sourceFlowConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tasks = software.amazon.jsii.Kernel.get(this, "tasks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.triggerConfig = software.amazon.jsii.Kernel.get(this, "triggerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.flowStatus = software.amazon.jsii.Kernel.get(this, "flowStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsArn = software.amazon.jsii.Kernel.get(this, "kmsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metadataCatalogConfig = software.amazon.jsii.Kernel.get(this, "metadataCatalogConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationFlowConfigList = java.util.Objects.requireNonNull(builder.destinationFlowConfigList, "destinationFlowConfigList is required");
            this.flowName = java.util.Objects.requireNonNull(builder.flowName, "flowName is required");
            this.sourceFlowConfig = java.util.Objects.requireNonNull(builder.sourceFlowConfig, "sourceFlowConfig is required");
            this.tasks = java.util.Objects.requireNonNull(builder.tasks, "tasks is required");
            this.triggerConfig = java.util.Objects.requireNonNull(builder.triggerConfig, "triggerConfig is required");
            this.description = builder.description;
            this.flowStatus = builder.flowStatus;
            this.kmsArn = builder.kmsArn;
            this.metadataCatalogConfig = builder.metadataCatalogConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDestinationFlowConfigList() {
            return this.destinationFlowConfigList;
        }

        @Override
        public final java.lang.String getFlowName() {
            return this.flowName;
        }

        @Override
        public final java.lang.Object getSourceFlowConfig() {
            return this.sourceFlowConfig;
        }

        @Override
        public final java.lang.Object getTasks() {
            return this.tasks;
        }

        @Override
        public final java.lang.Object getTriggerConfig() {
            return this.triggerConfig;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getFlowStatus() {
            return this.flowStatus;
        }

        @Override
        public final java.lang.String getKmsArn() {
            return this.kmsArn;
        }

        @Override
        public final java.lang.Object getMetadataCatalogConfig() {
            return this.metadataCatalogConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationFlowConfigList", om.valueToTree(this.getDestinationFlowConfigList()));
            data.set("flowName", om.valueToTree(this.getFlowName()));
            data.set("sourceFlowConfig", om.valueToTree(this.getSourceFlowConfig()));
            data.set("tasks", om.valueToTree(this.getTasks()));
            data.set("triggerConfig", om.valueToTree(this.getTriggerConfig()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFlowStatus() != null) {
                data.set("flowStatus", om.valueToTree(this.getFlowStatus()));
            }
            if (this.getKmsArn() != null) {
                data.set("kmsArn", om.valueToTree(this.getKmsArn()));
            }
            if (this.getMetadataCatalogConfig() != null) {
                data.set("metadataCatalogConfig", om.valueToTree(this.getMetadataCatalogConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlowProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFlowProps.Jsii$Proxy that = (CfnFlowProps.Jsii$Proxy) o;

            if (!destinationFlowConfigList.equals(that.destinationFlowConfigList)) return false;
            if (!flowName.equals(that.flowName)) return false;
            if (!sourceFlowConfig.equals(that.sourceFlowConfig)) return false;
            if (!tasks.equals(that.tasks)) return false;
            if (!triggerConfig.equals(that.triggerConfig)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.flowStatus != null ? !this.flowStatus.equals(that.flowStatus) : that.flowStatus != null) return false;
            if (this.kmsArn != null ? !this.kmsArn.equals(that.kmsArn) : that.kmsArn != null) return false;
            if (this.metadataCatalogConfig != null ? !this.metadataCatalogConfig.equals(that.metadataCatalogConfig) : that.metadataCatalogConfig != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationFlowConfigList.hashCode();
            result = 31 * result + (this.flowName.hashCode());
            result = 31 * result + (this.sourceFlowConfig.hashCode());
            result = 31 * result + (this.tasks.hashCode());
            result = 31 * result + (this.triggerConfig.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.flowStatus != null ? this.flowStatus.hashCode() : 0);
            result = 31 * result + (this.kmsArn != null ? this.kmsArn.hashCode() : 0);
            result = 31 * result + (this.metadataCatalogConfig != null ? this.metadataCatalogConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
