package software.amazon.awscdk.services.appmesh;

/**
 * Properties for Mesh Service Discovery.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh = Mesh.Builder.create(this, "AppMesh")
 *         .meshName("myAwsMesh")
 *         .serviceDiscovery(MeshServiceDiscovery.builder()
 *                 .ipPreference(IpPreference.IPV4_ONLY)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.199Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.MeshServiceDiscovery")
@software.amazon.jsii.Jsii.Proxy(MeshServiceDiscovery.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MeshServiceDiscovery extends software.amazon.jsii.JsiiSerializable {

    /**
     * IP preference applied to all Virtual Nodes in the Mesh.
     * <p>
     * Default: - No IP preference is applied to any of the Virtual Nodes in the Mesh.
     * Virtual Nodes without an IP preference will have the following configured.
     * Envoy listeners are configured to bind only to IPv4.
     * Envoy will use IPv4 when sending traffic to a local application.
     * For DNS service discovery, the Envoy DNS resolver to prefer using IPv6 and fall back to IPv4.
     * For CloudMap service discovery, App Mesh will prefer using IPv4 and fall back to IPv6 for IPs returned by CloudMap.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.IpPreference getIpPreference() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MeshServiceDiscovery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MeshServiceDiscovery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MeshServiceDiscovery> {
        software.amazon.awscdk.services.appmesh.IpPreference ipPreference;

        /**
         * Sets the value of {@link MeshServiceDiscovery#getIpPreference}
         * @param ipPreference IP preference applied to all Virtual Nodes in the Mesh.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipPreference(software.amazon.awscdk.services.appmesh.IpPreference ipPreference) {
            this.ipPreference = ipPreference;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MeshServiceDiscovery}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MeshServiceDiscovery build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MeshServiceDiscovery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MeshServiceDiscovery {
        private final software.amazon.awscdk.services.appmesh.IpPreference ipPreference;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ipPreference = software.amazon.jsii.Kernel.get(this, "ipPreference", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IpPreference.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ipPreference = builder.ipPreference;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IpPreference getIpPreference() {
            return this.ipPreference;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIpPreference() != null) {
                data.set("ipPreference", om.valueToTree(this.getIpPreference()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.MeshServiceDiscovery"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MeshServiceDiscovery.Jsii$Proxy that = (MeshServiceDiscovery.Jsii$Proxy) o;

            return this.ipPreference != null ? this.ipPreference.equals(that.ipPreference) : that.ipPreference == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ipPreference != null ? this.ipPreference.hashCode() : 0;
            return result;
        }
    }
}
