package software.amazon.awscdk.services.appmesh;

/**
 * Represents the outlier detection for a listener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * // Cloud Map service discovery is currently required for host ejection by outlier detection
 * Vpc vpc = new Vpc(this, "vpc");
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(this, "test-namespace")
 *         .vpc(vpc)
 *         .name("domain.local")
 *         .build();
 * Service service = namespace.createService("Svc");
 * VirtualNode node = mesh.addVirtualNode("virtual-node", VirtualNodeBaseProps.builder()
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .outlierDetection(OutlierDetection.builder()
 *                         .baseEjectionDuration(Duration.seconds(10))
 *                         .interval(Duration.seconds(30))
 *                         .maxEjectionPercent(50)
 *                         .maxServerErrors(5)
 *                         .build())
 *                 .build())))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.201Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.OutlierDetection")
@software.amazon.jsii.Jsii.Proxy(OutlierDetection.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OutlierDetection extends software.amazon.jsii.JsiiSerializable {

    /**
     * The base amount of time for which a host is ejected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getBaseEjectionDuration();

    /**
     * The time interval between ejection sweep analysis.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getInterval();

    /**
     * Maximum percentage of hosts in load balancing pool for upstream service that can be ejected.
     * <p>
     * Will eject at
     * least one host regardless of the value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxEjectionPercent();

    /**
     * Number of consecutive 5xx errors required for ejection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxServerErrors();

    /**
     * @return a {@link Builder} of {@link OutlierDetection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OutlierDetection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OutlierDetection> {
        software.amazon.awscdk.Duration baseEjectionDuration;
        software.amazon.awscdk.Duration interval;
        java.lang.Number maxEjectionPercent;
        java.lang.Number maxServerErrors;

        /**
         * Sets the value of {@link OutlierDetection#getBaseEjectionDuration}
         * @param baseEjectionDuration The base amount of time for which a host is ejected. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseEjectionDuration(software.amazon.awscdk.Duration baseEjectionDuration) {
            this.baseEjectionDuration = baseEjectionDuration;
            return this;
        }

        /**
         * Sets the value of {@link OutlierDetection#getInterval}
         * @param interval The time interval between ejection sweep analysis. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interval(software.amazon.awscdk.Duration interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Sets the value of {@link OutlierDetection#getMaxEjectionPercent}
         * @param maxEjectionPercent Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. This parameter is required.
         *                           Will eject at
         *                           least one host regardless of the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEjectionPercent(java.lang.Number maxEjectionPercent) {
            this.maxEjectionPercent = maxEjectionPercent;
            return this;
        }

        /**
         * Sets the value of {@link OutlierDetection#getMaxServerErrors}
         * @param maxServerErrors Number of consecutive 5xx errors required for ejection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxServerErrors(java.lang.Number maxServerErrors) {
            this.maxServerErrors = maxServerErrors;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OutlierDetection}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OutlierDetection build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OutlierDetection}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutlierDetection {
        private final software.amazon.awscdk.Duration baseEjectionDuration;
        private final software.amazon.awscdk.Duration interval;
        private final java.lang.Number maxEjectionPercent;
        private final java.lang.Number maxServerErrors;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.baseEjectionDuration = software.amazon.jsii.Kernel.get(this, "baseEjectionDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.maxEjectionPercent = software.amazon.jsii.Kernel.get(this, "maxEjectionPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxServerErrors = software.amazon.jsii.Kernel.get(this, "maxServerErrors", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.baseEjectionDuration = java.util.Objects.requireNonNull(builder.baseEjectionDuration, "baseEjectionDuration is required");
            this.interval = java.util.Objects.requireNonNull(builder.interval, "interval is required");
            this.maxEjectionPercent = java.util.Objects.requireNonNull(builder.maxEjectionPercent, "maxEjectionPercent is required");
            this.maxServerErrors = java.util.Objects.requireNonNull(builder.maxServerErrors, "maxServerErrors is required");
        }

        @Override
        public final software.amazon.awscdk.Duration getBaseEjectionDuration() {
            return this.baseEjectionDuration;
        }

        @Override
        public final software.amazon.awscdk.Duration getInterval() {
            return this.interval;
        }

        @Override
        public final java.lang.Number getMaxEjectionPercent() {
            return this.maxEjectionPercent;
        }

        @Override
        public final java.lang.Number getMaxServerErrors() {
            return this.maxServerErrors;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("baseEjectionDuration", om.valueToTree(this.getBaseEjectionDuration()));
            data.set("interval", om.valueToTree(this.getInterval()));
            data.set("maxEjectionPercent", om.valueToTree(this.getMaxEjectionPercent()));
            data.set("maxServerErrors", om.valueToTree(this.getMaxServerErrors()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.OutlierDetection"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OutlierDetection.Jsii$Proxy that = (OutlierDetection.Jsii$Proxy) o;

            if (!baseEjectionDuration.equals(that.baseEjectionDuration)) return false;
            if (!interval.equals(that.interval)) return false;
            if (!maxEjectionPercent.equals(that.maxEjectionPercent)) return false;
            return this.maxServerErrors.equals(that.maxServerErrors);
        }

        @Override
        public final int hashCode() {
            int result = this.baseEjectionDuration.hashCode();
            result = 31 * result + (this.interval.hashCode());
            result = 31 * result + (this.maxEjectionPercent.hashCode());
            result = 31 * result + (this.maxServerErrors.hashCode());
            return result;
        }
    }
}
