package software.amazon.awscdk.services.appmesh;

/**
 * Basic configuration properties for a VirtualNode.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Mesh mesh;
 * Vpc vpc = new Vpc(this, "vpc");
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(this, "test-namespace")
 *         .vpc(vpc)
 *         .name("domain.local")
 *         .build();
 * Service service = namespace.createService("Svc");
 * VirtualNode node = mesh.addVirtualNode("virtual-node", VirtualNodeBaseProps.builder()
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8081)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5)) // minimum
 *                         .path("/health-check-path")
 *                         .timeout(Duration.seconds(2)) // minimum
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .build())))
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.229Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualNodeBaseProps")
@software.amazon.jsii.Jsii.Proxy(VirtualNodeBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualNodeBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Access Logging Configuration for the virtual node.
     * <p>
     * Default: - No access logging
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.AccessLog getAccessLog() {
        return null;
    }

    /**
     * Default Configuration Virtual Node uses to communicate with Virtual Service.
     * <p>
     * Default: - No Config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.BackendDefaults getBackendDefaults() {
        return null;
    }

    /**
     * Virtual Services that this is node expected to send outbound traffic to.
     * <p>
     * Default: - No backends
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appmesh.Backend> getBackends() {
        return null;
    }

    /**
     * Initial listener for the virtual node.
     * <p>
     * Default: - No listeners
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appmesh.VirtualNodeListener> getListeners() {
        return null;
    }

    /**
     * Defines how upstream clients will discover this VirtualNode.
     * <p>
     * Default: - No Service Discovery
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.ServiceDiscovery getServiceDiscovery() {
        return null;
    }

    /**
     * The name of the VirtualNode.
     * <p>
     * Default: - A name is automatically determined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVirtualNodeName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VirtualNodeBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualNodeBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualNodeBaseProps> {
        software.amazon.awscdk.services.appmesh.AccessLog accessLog;
        software.amazon.awscdk.services.appmesh.BackendDefaults backendDefaults;
        java.util.List<software.amazon.awscdk.services.appmesh.Backend> backends;
        java.util.List<software.amazon.awscdk.services.appmesh.VirtualNodeListener> listeners;
        software.amazon.awscdk.services.appmesh.ServiceDiscovery serviceDiscovery;
        java.lang.String virtualNodeName;

        /**
         * Sets the value of {@link VirtualNodeBaseProps#getAccessLog}
         * @param accessLog Access Logging Configuration for the virtual node.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLog(software.amazon.awscdk.services.appmesh.AccessLog accessLog) {
            this.accessLog = accessLog;
            return this;
        }

        /**
         * Sets the value of {@link VirtualNodeBaseProps#getBackendDefaults}
         * @param backendDefaults Default Configuration Virtual Node uses to communicate with Virtual Service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backendDefaults(software.amazon.awscdk.services.appmesh.BackendDefaults backendDefaults) {
            this.backendDefaults = backendDefaults;
            return this;
        }

        /**
         * Sets the value of {@link VirtualNodeBaseProps#getBackends}
         * @param backends Virtual Services that this is node expected to send outbound traffic to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder backends(java.util.List<? extends software.amazon.awscdk.services.appmesh.Backend> backends) {
            this.backends = (java.util.List<software.amazon.awscdk.services.appmesh.Backend>)backends;
            return this;
        }

        /**
         * Sets the value of {@link VirtualNodeBaseProps#getListeners}
         * @param listeners Initial listener for the virtual node.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder listeners(java.util.List<? extends software.amazon.awscdk.services.appmesh.VirtualNodeListener> listeners) {
            this.listeners = (java.util.List<software.amazon.awscdk.services.appmesh.VirtualNodeListener>)listeners;
            return this;
        }

        /**
         * Sets the value of {@link VirtualNodeBaseProps#getServiceDiscovery}
         * @param serviceDiscovery Defines how upstream clients will discover this VirtualNode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceDiscovery(software.amazon.awscdk.services.appmesh.ServiceDiscovery serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            return this;
        }

        /**
         * Sets the value of {@link VirtualNodeBaseProps#getVirtualNodeName}
         * @param virtualNodeName The name of the VirtualNode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualNodeName(java.lang.String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualNodeBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualNodeBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualNodeBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualNodeBaseProps {
        private final software.amazon.awscdk.services.appmesh.AccessLog accessLog;
        private final software.amazon.awscdk.services.appmesh.BackendDefaults backendDefaults;
        private final java.util.List<software.amazon.awscdk.services.appmesh.Backend> backends;
        private final java.util.List<software.amazon.awscdk.services.appmesh.VirtualNodeListener> listeners;
        private final software.amazon.awscdk.services.appmesh.ServiceDiscovery serviceDiscovery;
        private final java.lang.String virtualNodeName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessLog = software.amazon.jsii.Kernel.get(this, "accessLog", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.AccessLog.class));
            this.backendDefaults = software.amazon.jsii.Kernel.get(this, "backendDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.BackendDefaults.class));
            this.backends = software.amazon.jsii.Kernel.get(this, "backends", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.Backend.class)));
            this.listeners = software.amazon.jsii.Kernel.get(this, "listeners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualNodeListener.class)));
            this.serviceDiscovery = software.amazon.jsii.Kernel.get(this, "serviceDiscovery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.ServiceDiscovery.class));
            this.virtualNodeName = software.amazon.jsii.Kernel.get(this, "virtualNodeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessLog = builder.accessLog;
            this.backendDefaults = builder.backendDefaults;
            this.backends = (java.util.List<software.amazon.awscdk.services.appmesh.Backend>)builder.backends;
            this.listeners = (java.util.List<software.amazon.awscdk.services.appmesh.VirtualNodeListener>)builder.listeners;
            this.serviceDiscovery = builder.serviceDiscovery;
            this.virtualNodeName = builder.virtualNodeName;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.AccessLog getAccessLog() {
            return this.accessLog;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.BackendDefaults getBackendDefaults() {
            return this.backendDefaults;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.Backend> getBackends() {
            return this.backends;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.VirtualNodeListener> getListeners() {
            return this.listeners;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.ServiceDiscovery getServiceDiscovery() {
            return this.serviceDiscovery;
        }

        @Override
        public final java.lang.String getVirtualNodeName() {
            return this.virtualNodeName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessLog() != null) {
                data.set("accessLog", om.valueToTree(this.getAccessLog()));
            }
            if (this.getBackendDefaults() != null) {
                data.set("backendDefaults", om.valueToTree(this.getBackendDefaults()));
            }
            if (this.getBackends() != null) {
                data.set("backends", om.valueToTree(this.getBackends()));
            }
            if (this.getListeners() != null) {
                data.set("listeners", om.valueToTree(this.getListeners()));
            }
            if (this.getServiceDiscovery() != null) {
                data.set("serviceDiscovery", om.valueToTree(this.getServiceDiscovery()));
            }
            if (this.getVirtualNodeName() != null) {
                data.set("virtualNodeName", om.valueToTree(this.getVirtualNodeName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualNodeBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualNodeBaseProps.Jsii$Proxy that = (VirtualNodeBaseProps.Jsii$Proxy) o;

            if (this.accessLog != null ? !this.accessLog.equals(that.accessLog) : that.accessLog != null) return false;
            if (this.backendDefaults != null ? !this.backendDefaults.equals(that.backendDefaults) : that.backendDefaults != null) return false;
            if (this.backends != null ? !this.backends.equals(that.backends) : that.backends != null) return false;
            if (this.listeners != null ? !this.listeners.equals(that.listeners) : that.listeners != null) return false;
            if (this.serviceDiscovery != null ? !this.serviceDiscovery.equals(that.serviceDiscovery) : that.serviceDiscovery != null) return false;
            return this.virtualNodeName != null ? this.virtualNodeName.equals(that.virtualNodeName) : that.virtualNodeName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessLog != null ? this.accessLog.hashCode() : 0;
            result = 31 * result + (this.backendDefaults != null ? this.backendDefaults.hashCode() : 0);
            result = 31 * result + (this.backends != null ? this.backends.hashCode() : 0);
            result = 31 * result + (this.listeners != null ? this.listeners.hashCode() : 0);
            result = 31 * result + (this.serviceDiscovery != null ? this.serviceDiscovery.hashCode() : 0);
            result = 31 * result + (this.virtualNodeName != null ? this.virtualNodeName.hashCode() : 0);
            return result;
        }
    }
}
