package software.amazon.awscdk.services.appsync;

/**
 * Domain name configuration for AppSync.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.certificatemanager.*;
 * import software.amazon.awscdk.services.route53.*;
 * String myDomainName = "api.example.com";
 * Certificate certificate = Certificate.Builder.create(this, "cert").domainName(myDomainName).build();
 * AppSyncAuthProvider apiKeyProvider = AppSyncAuthProvider.builder()
 *         .authorizationType(AppSyncAuthorizationType.API_KEY)
 *         .build();
 * EventApi api = EventApi.Builder.create(this, "api")
 *         .apiName("Api")
 *         .ownerContact("OwnerContact")
 *         .authorizationConfig(EventApiAuthConfig.builder()
 *                 .authProviders(List.of(apiKeyProvider))
 *                 .connectionAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultPublishAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultSubscribeAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .build())
 *         // Custom Domain Settings
 *         .domainName(AppSyncDomainOptions.builder()
 *                 .certificate(certificate)
 *                 .domainName(myDomainName)
 *                 .build())
 *         .build();
 * api.addChannelNamespace("default");
 * // You can get custom HTTP/Realtime endpoint
 * // You can get custom HTTP/Realtime endpoint
 * CfnOutput.Builder.create(this, "AWS AppSync Events HTTP endpoint").value(api.getCustomHttpEndpoint()).build();
 * CfnOutput.Builder.create(this, "AWS AppSync Events Realtime endpoint").value(api.getCustomRealtimeEndpoint()).build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.347Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncDomainOptions")
@software.amazon.jsii.Jsii.Proxy(AppSyncDomainOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AppSyncDomainOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The certificate to use with the domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate();

    /**
     * The actual domain name.
     * <p>
     * For example, <code>api.example.com</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * @return a {@link Builder} of {@link AppSyncDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AppSyncDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AppSyncDomainOptions> {
        software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        java.lang.String domainName;

        /**
         * Sets the value of {@link AppSyncDomainOptions#getCertificate}
         * @param certificate The certificate to use with the domain name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link AppSyncDomainOptions#getDomainName}
         * @param domainName The actual domain name. This parameter is required.
         *                   For example, <code>api.example.com</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AppSyncDomainOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AppSyncDomainOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AppSyncDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AppSyncDomainOptions {
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final java.lang.String domainName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificate = java.util.Objects.requireNonNull(builder.certificate, "certificate is required");
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("certificate", om.valueToTree(this.getCertificate()));
            data.set("domainName", om.valueToTree(this.getDomainName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.AppSyncDomainOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AppSyncDomainOptions.Jsii$Proxy that = (AppSyncDomainOptions.Jsii$Proxy) o;

            if (!certificate.equals(that.certificate)) return false;
            return this.domainName.equals(that.domainName);
        }

        @Override
        public final int hashCode() {
            int result = this.certificate.hashCode();
            result = 31 * result + (this.domainName.hashCode());
            return result;
        }
    }
}
