package software.amazon.awscdk.services.appsync;

/**
 * Authorization configuration for the Event API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * AppSyncAuthProvider apiKeyProvider = AppSyncAuthProvider.builder()
 *         .authorizationType(AppSyncAuthorizationType.API_KEY)
 *         .build();
 * EventApi api = EventApi.Builder.create(this, "api")
 *         .apiName("Api")
 *         .ownerContact("OwnerContact")
 *         .authorizationConfig(EventApiAuthConfig.builder()
 *                 .authProviders(List.of(apiKeyProvider))
 *                 .connectionAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultPublishAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultSubscribeAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .build())
 *         .logConfig(AppSyncLogConfig.builder()
 *                 .fieldLogLevel(AppSyncFieldLogLevel.INFO)
 *                 .retention(RetentionDays.ONE_WEEK)
 *                 .build())
 *         .build();
 * api.addChannelNamespace("default");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.448Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.EventApiAuthConfig")
@software.amazon.jsii.Jsii.Proxy(EventApiAuthConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventApiAuthConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Auth providers for use in connection, publish, and subscribe operations.
     * <p>
     * Default: - API Key authorization
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthProvider> getAuthProviders() {
        return null;
    }

    /**
     * Connection auth modes.
     * <p>
     * Default: - API Key authorization
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getConnectionAuthModeTypes() {
        return null;
    }

    /**
     * Default publish auth modes.
     * <p>
     * Default: - API Key authorization
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getDefaultPublishAuthModeTypes() {
        return null;
    }

    /**
     * Default subscribe auth modes.
     * <p>
     * Default: - API Key authorization
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getDefaultSubscribeAuthModeTypes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventApiAuthConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventApiAuthConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventApiAuthConfig> {
        java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthProvider> authProviders;
        java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> connectionAuthModeTypes;
        java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> defaultPublishAuthModeTypes;
        java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> defaultSubscribeAuthModeTypes;

        /**
         * Sets the value of {@link EventApiAuthConfig#getAuthProviders}
         * @param authProviders Auth providers for use in connection, publish, and subscribe operations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder authProviders(java.util.List<? extends software.amazon.awscdk.services.appsync.AppSyncAuthProvider> authProviders) {
            this.authProviders = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthProvider>)authProviders;
            return this;
        }

        /**
         * Sets the value of {@link EventApiAuthConfig#getConnectionAuthModeTypes}
         * @param connectionAuthModeTypes Connection auth modes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder connectionAuthModeTypes(java.util.List<? extends software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> connectionAuthModeTypes) {
            this.connectionAuthModeTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)connectionAuthModeTypes;
            return this;
        }

        /**
         * Sets the value of {@link EventApiAuthConfig#getDefaultPublishAuthModeTypes}
         * @param defaultPublishAuthModeTypes Default publish auth modes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder defaultPublishAuthModeTypes(java.util.List<? extends software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> defaultPublishAuthModeTypes) {
            this.defaultPublishAuthModeTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)defaultPublishAuthModeTypes;
            return this;
        }

        /**
         * Sets the value of {@link EventApiAuthConfig#getDefaultSubscribeAuthModeTypes}
         * @param defaultSubscribeAuthModeTypes Default subscribe auth modes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder defaultSubscribeAuthModeTypes(java.util.List<? extends software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> defaultSubscribeAuthModeTypes) {
            this.defaultSubscribeAuthModeTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)defaultSubscribeAuthModeTypes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventApiAuthConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventApiAuthConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventApiAuthConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventApiAuthConfig {
        private final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthProvider> authProviders;
        private final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> connectionAuthModeTypes;
        private final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> defaultPublishAuthModeTypes;
        private final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> defaultSubscribeAuthModeTypes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authProviders = software.amazon.jsii.Kernel.get(this, "authProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthProvider.class)));
            this.connectionAuthModeTypes = software.amazon.jsii.Kernel.get(this, "connectionAuthModeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class)));
            this.defaultPublishAuthModeTypes = software.amazon.jsii.Kernel.get(this, "defaultPublishAuthModeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class)));
            this.defaultSubscribeAuthModeTypes = software.amazon.jsii.Kernel.get(this, "defaultSubscribeAuthModeTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authProviders = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthProvider>)builder.authProviders;
            this.connectionAuthModeTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)builder.connectionAuthModeTypes;
            this.defaultPublishAuthModeTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)builder.defaultPublishAuthModeTypes;
            this.defaultSubscribeAuthModeTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)builder.defaultSubscribeAuthModeTypes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthProvider> getAuthProviders() {
            return this.authProviders;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getConnectionAuthModeTypes() {
            return this.connectionAuthModeTypes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getDefaultPublishAuthModeTypes() {
            return this.defaultPublishAuthModeTypes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getDefaultSubscribeAuthModeTypes() {
            return this.defaultSubscribeAuthModeTypes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthProviders() != null) {
                data.set("authProviders", om.valueToTree(this.getAuthProviders()));
            }
            if (this.getConnectionAuthModeTypes() != null) {
                data.set("connectionAuthModeTypes", om.valueToTree(this.getConnectionAuthModeTypes()));
            }
            if (this.getDefaultPublishAuthModeTypes() != null) {
                data.set("defaultPublishAuthModeTypes", om.valueToTree(this.getDefaultPublishAuthModeTypes()));
            }
            if (this.getDefaultSubscribeAuthModeTypes() != null) {
                data.set("defaultSubscribeAuthModeTypes", om.valueToTree(this.getDefaultSubscribeAuthModeTypes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.EventApiAuthConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventApiAuthConfig.Jsii$Proxy that = (EventApiAuthConfig.Jsii$Proxy) o;

            if (this.authProviders != null ? !this.authProviders.equals(that.authProviders) : that.authProviders != null) return false;
            if (this.connectionAuthModeTypes != null ? !this.connectionAuthModeTypes.equals(that.connectionAuthModeTypes) : that.connectionAuthModeTypes != null) return false;
            if (this.defaultPublishAuthModeTypes != null ? !this.defaultPublishAuthModeTypes.equals(that.defaultPublishAuthModeTypes) : that.defaultPublishAuthModeTypes != null) return false;
            return this.defaultSubscribeAuthModeTypes != null ? this.defaultSubscribeAuthModeTypes.equals(that.defaultSubscribeAuthModeTypes) : that.defaultSubscribeAuthModeTypes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authProviders != null ? this.authProviders.hashCode() : 0;
            result = 31 * result + (this.connectionAuthModeTypes != null ? this.connectionAuthModeTypes.hashCode() : 0);
            result = 31 * result + (this.defaultPublishAuthModeTypes != null ? this.defaultPublishAuthModeTypes.hashCode() : 0);
            result = 31 * result + (this.defaultSubscribeAuthModeTypes != null ? this.defaultSubscribeAuthModeTypes.hashCode() : 0);
            return result;
        }
    }
}
