package software.amazon.awscdk.services.appsync;

/**
 * log-level for fields in AppSync.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * GraphqlApi.Builder.create(this, "api")
 *         .authorizationConfig(AuthorizationConfig.builder().build())
 *         .name("myApi")
 *         .definition(Definition.fromFile(join(__dirname, "myApi.graphql")))
 *         .logConfig(LogConfig.builder()
 *                 .fieldLogLevel(FieldLogLevel.INFO)
 *                 .retention(RetentionDays.ONE_WEEK)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.465Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.FieldLogLevel")
public enum FieldLogLevel {
    /**
     * Resolver logging is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
    /**
     * Only Error messages appear in logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ERROR,
    /**
     * Info and Error messages appear in logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFO,
    /**
     * Debug, Info, and Error messages, appear in logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEBUG,
    /**
     * All messages (Debug, Error, Info, and Trace) appear in logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL,
}
