package software.amazon.awscdk.services.appsync;

/**
 * Invoke types for direct Lambda data sources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EventApi api;
 * AppSyncLambdaDataSource lambdaDataSource;
 * // Lambda data source for publish handler
 * api.addChannelNamespace("lambda-ns", ChannelNamespaceOptions.builder()
 *         .code(Code.fromInline("/* event handler code here.*&#47;"))
 *         .publishHandlerConfig(HandlerConfig.builder()
 *                 .dataSource(lambdaDataSource)
 *                 .build())
 *         .build());
 * // Direct Lambda data source for publish handler
 * api.addChannelNamespace("lambda-direct-ns", ChannelNamespaceOptions.builder()
 *         .publishHandlerConfig(HandlerConfig.builder()
 *                 .dataSource(lambdaDataSource)
 *                 .direct(true)
 *                 .build())
 *         .build());
 * api.addChannelNamespace("lambda-direct-async-ns", ChannelNamespaceOptions.builder()
 *         .publishHandlerConfig(HandlerConfig.builder()
 *                 .dataSource(lambdaDataSource)
 *                 .direct(true)
 *                 .lambdaInvokeType(LambdaInvokeType.EVENT)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.488Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.LambdaInvokeType")
public enum LambdaInvokeType {
    /**
     * Invoke function asynchronously.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EVENT,
    /**
     * Invoke function synchronously.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUEST_RESPONSE,
}
