package software.amazon.awscdk.services.aps;

/**
 * Properties for defining a <code>CfnScraper</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.aps.*;
 * CfnScraperProps cfnScraperProps = CfnScraperProps.builder()
 *         .destination(DestinationProperty.builder()
 *                 .ampConfiguration(AmpConfigurationProperty.builder()
 *                         .workspaceArn("workspaceArn")
 *                         .build())
 *                 .build())
 *         .scrapeConfiguration(ScrapeConfigurationProperty.builder()
 *                 .configurationBlob("configurationBlob")
 *                 .build())
 *         .source(SourceProperty.builder()
 *                 .eksConfiguration(EksConfigurationProperty.builder()
 *                         .clusterArn("clusterArn")
 *                         .subnetIds(List.of("subnetIds"))
 *                         // the properties below are optional
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .alias("alias")
 *         .roleConfiguration(RoleConfigurationProperty.builder()
 *                 .sourceRoleArn("sourceRoleArn")
 *                 .targetRoleArn("targetRoleArn")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.540Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_aps.CfnScraperProps")
@software.amazon.jsii.Jsii.Proxy(CfnScraperProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnScraperProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Managed Service for Prometheus workspace the scraper sends metrics to.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-destination</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

    /**
     * The configuration in use by the scraper.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-scrapeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-scrapeconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getScrapeConfiguration();

    /**
     * The Amazon EKS cluster from which the scraper collects metrics.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-source</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSource();

    /**
     * An optional user-assigned scraper alias.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-alias</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAlias() {
        return null;
    }

    /**
     * The role configuration in an Amazon Managed Service for Prometheus scraper.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-roleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-roleconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRoleConfiguration() {
        return null;
    }

    /**
     * (Optional) The list of tag keys and values associated with the scraper.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-aps-scraper.html#cfn-aps-scraper-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnScraperProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnScraperProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnScraperProps> {
        java.lang.Object destination;
        java.lang.Object scrapeConfiguration;
        java.lang.Object source;
        java.lang.String alias;
        java.lang.Object roleConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnScraperProps#getDestination}
         * @param destination The Amazon Managed Service for Prometheus workspace the scraper sends metrics to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.IResolvable destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link CfnScraperProps#getDestination}
         * @param destination The Amazon Managed Service for Prometheus workspace the scraper sends metrics to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destination(software.amazon.awscdk.services.aps.CfnScraper.DestinationProperty destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Sets the value of {@link CfnScraperProps#getScrapeConfiguration}
         * @param scrapeConfiguration The configuration in use by the scraper. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scrapeConfiguration(software.amazon.awscdk.IResolvable scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScraperProps#getScrapeConfiguration}
         * @param scrapeConfiguration The configuration in use by the scraper. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scrapeConfiguration(software.amazon.awscdk.services.aps.CfnScraper.ScrapeConfigurationProperty scrapeConfiguration) {
            this.scrapeConfiguration = scrapeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScraperProps#getSource}
         * @param source The Amazon EKS cluster from which the scraper collects metrics. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.IResolvable source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CfnScraperProps#getSource}
         * @param source The Amazon EKS cluster from which the scraper collects metrics. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.services.aps.CfnScraper.SourceProperty source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CfnScraperProps#getAlias}
         * @param alias An optional user-assigned scraper alias.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(java.lang.String alias) {
            this.alias = alias;
            return this;
        }

        /**
         * Sets the value of {@link CfnScraperProps#getRoleConfiguration}
         * @param roleConfiguration The role configuration in an Amazon Managed Service for Prometheus scraper.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleConfiguration(software.amazon.awscdk.IResolvable roleConfiguration) {
            this.roleConfiguration = roleConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScraperProps#getRoleConfiguration}
         * @param roleConfiguration The role configuration in an Amazon Managed Service for Prometheus scraper.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleConfiguration(software.amazon.awscdk.services.aps.CfnScraper.RoleConfigurationProperty roleConfiguration) {
            this.roleConfiguration = roleConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScraperProps#getTags}
         * @param tags (Optional) The list of tag keys and values associated with the scraper.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnScraperProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnScraperProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnScraperProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnScraperProps {
        private final java.lang.Object destination;
        private final java.lang.Object scrapeConfiguration;
        private final java.lang.Object source;
        private final java.lang.String alias;
        private final java.lang.Object roleConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scrapeConfiguration = software.amazon.jsii.Kernel.get(this, "scrapeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleConfiguration = software.amazon.jsii.Kernel.get(this, "roleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
            this.scrapeConfiguration = java.util.Objects.requireNonNull(builder.scrapeConfiguration, "scrapeConfiguration is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.alias = builder.alias;
            this.roleConfiguration = builder.roleConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDestination() {
            return this.destination;
        }

        @Override
        public final java.lang.Object getScrapeConfiguration() {
            return this.scrapeConfiguration;
        }

        @Override
        public final java.lang.Object getSource() {
            return this.source;
        }

        @Override
        public final java.lang.String getAlias() {
            return this.alias;
        }

        @Override
        public final java.lang.Object getRoleConfiguration() {
            return this.roleConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destination", om.valueToTree(this.getDestination()));
            data.set("scrapeConfiguration", om.valueToTree(this.getScrapeConfiguration()));
            data.set("source", om.valueToTree(this.getSource()));
            if (this.getAlias() != null) {
                data.set("alias", om.valueToTree(this.getAlias()));
            }
            if (this.getRoleConfiguration() != null) {
                data.set("roleConfiguration", om.valueToTree(this.getRoleConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_aps.CfnScraperProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnScraperProps.Jsii$Proxy that = (CfnScraperProps.Jsii$Proxy) o;

            if (!destination.equals(that.destination)) return false;
            if (!scrapeConfiguration.equals(that.scrapeConfiguration)) return false;
            if (!source.equals(that.source)) return false;
            if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) return false;
            if (this.roleConfiguration != null ? !this.roleConfiguration.equals(that.roleConfiguration) : that.roleConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destination.hashCode();
            result = 31 * result + (this.scrapeConfiguration.hashCode());
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
            result = 31 * result + (this.roleConfiguration != null ? this.roleConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
