package software.amazon.awscdk.services.arcregionswitch;

/**
 * Represents a Region switch plan.
 * <p>
 * A plan defines the steps required to shift traffic from one AWS Region to another.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.arcregionswitch.*;
 * StepProperty stepProperty_;
 * CfnPlan cfnPlan = CfnPlan.Builder.create(this, "MyCfnPlan")
 *         .executionRole("executionRole")
 *         .name("name")
 *         .recoveryApproach("recoveryApproach")
 *         .regions(List.of("regions"))
 *         .workflows(List.of(WorkflowProperty.builder()
 *                 .workflowTargetAction("workflowTargetAction")
 *                 // the properties below are optional
 *                 .steps(List.of(StepProperty.builder()
 *                         .executionBlockConfiguration(ExecutionBlockConfigurationProperty.builder()
 *                                 .arcRoutingControlConfig(ArcRoutingControlConfigurationProperty.builder()
 *                                         .regionAndRoutingControls(Map.of(
 *                                                 "regionAndRoutingControlsKey", List.of(ArcRoutingControlStateProperty.builder()
 *                                                         .routingControlArn("routingControlArn")
 *                                                         .state("state")
 *                                                         .build())))
 *                                         // the properties below are optional
 *                                         .crossAccountRole("crossAccountRole")
 *                                         .externalId("externalId")
 *                                         .timeoutMinutes(123)
 *                                         .build())
 *                                 .customActionLambdaConfig(CustomActionLambdaConfigurationProperty.builder()
 *                                         .lambdas(List.of(LambdasProperty.builder()
 *                                                 .arn("arn")
 *                                                 .crossAccountRole("crossAccountRole")
 *                                                 .externalId("externalId")
 *                                                 .build()))
 *                                         .regionToRun("regionToRun")
 *                                         .retryIntervalMinutes(123)
 *                                         // the properties below are optional
 *                                         .timeoutMinutes(123)
 *                                         .ungraceful(LambdaUngracefulProperty.builder()
 *                                                 .behavior("behavior")
 *                                                 .build())
 *                                         .build())
 *                                 .ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfigurationProperty.builder()
 *                                         .asgs(List.of(AsgProperty.builder()
 *                                                 .arn("arn")
 *                                                 .crossAccountRole("crossAccountRole")
 *                                                 .externalId("externalId")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .capacityMonitoringApproach("capacityMonitoringApproach")
 *                                         .targetPercent(123)
 *                                         .timeoutMinutes(123)
 *                                         .ungraceful(Ec2UngracefulProperty.builder()
 *                                                 .minimumSuccessPercentage(123)
 *                                                 .build())
 *                                         .build())
 *                                 .ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfigurationProperty.builder()
 *                                         .services(List.of(ServiceProperty.builder()
 *                                                 .clusterArn("clusterArn")
 *                                                 .crossAccountRole("crossAccountRole")
 *                                                 .externalId("externalId")
 *                                                 .serviceArn("serviceArn")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .capacityMonitoringApproach("capacityMonitoringApproach")
 *                                         .targetPercent(123)
 *                                         .timeoutMinutes(123)
 *                                         .ungraceful(EcsUngracefulProperty.builder()
 *                                                 .minimumSuccessPercentage(123)
 *                                                 .build())
 *                                         .build())
 *                                 .eksResourceScalingConfig(EksResourceScalingConfigurationProperty.builder()
 *                                         .kubernetesResourceType(KubernetesResourceTypeProperty.builder()
 *                                                 .apiVersion("apiVersion")
 *                                                 .kind("kind")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .capacityMonitoringApproach("capacityMonitoringApproach")
 *                                         .eksClusters(List.of(EksClusterProperty.builder()
 *                                                 .clusterArn("clusterArn")
 *                                                 // the properties below are optional
 *                                                 .crossAccountRole("crossAccountRole")
 *                                                 .externalId("externalId")
 *                                                 .build()))
 *                                         .scalingResources(List.of(Map.of(
 *                                                 "scalingResourcesKey", Map.of(
 *                                                         "scalingResourcesKey", KubernetesScalingResourceProperty.builder()
 *                                                                 .name("name")
 *                                                                 .namespace("namespace")
 *                                                                 // the properties below are optional
 *                                                                 .hpaName("hpaName")
 *                                                                 .build()))))
 *                                         .targetPercent(123)
 *                                         .timeoutMinutes(123)
 *                                         .ungraceful(EksResourceScalingUngracefulProperty.builder()
 *                                                 .minimumSuccessPercentage(123)
 *                                                 .build())
 *                                         .build())
 *                                 .executionApprovalConfig(ExecutionApprovalConfigurationProperty.builder()
 *                                         .approvalRole("approvalRole")
 *                                         // the properties below are optional
 *                                         .timeoutMinutes(123)
 *                                         .build())
 *                                 .globalAuroraConfig(GlobalAuroraConfigurationProperty.builder()
 *                                         .behavior("behavior")
 *                                         .databaseClusterArns(List.of("databaseClusterArns"))
 *                                         .globalClusterIdentifier("globalClusterIdentifier")
 *                                         // the properties below are optional
 *                                         .crossAccountRole("crossAccountRole")
 *                                         .externalId("externalId")
 *                                         .timeoutMinutes(123)
 *                                         .ungraceful(GlobalAuroraUngracefulProperty.builder()
 *                                                 .ungraceful("ungraceful")
 *                                                 .build())
 *                                         .build())
 *                                 .parallelConfig(ParallelExecutionBlockConfigurationProperty.builder()
 *                                         .steps(List.of(stepProperty_))
 *                                         .build())
 *                                 .regionSwitchPlanConfig(RegionSwitchPlanConfigurationProperty.builder()
 *                                         .arn("arn")
 *                                         // the properties below are optional
 *                                         .crossAccountRole("crossAccountRole")
 *                                         .externalId("externalId")
 *                                         .build())
 *                                 .route53HealthCheckConfig(Route53HealthCheckConfigurationProperty.builder()
 *                                         .hostedZoneId("hostedZoneId")
 *                                         .recordName("recordName")
 *                                         // the properties below are optional
 *                                         .crossAccountRole("crossAccountRole")
 *                                         .externalId("externalId")
 *                                         .recordSets(List.of(Route53ResourceRecordSetProperty.builder()
 *                                                 .recordSetIdentifier("recordSetIdentifier")
 *                                                 .region("region")
 *                                                 .build()))
 *                                         .timeoutMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .executionBlockType("executionBlockType")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build()))
 *                 .workflowDescription("workflowDescription")
 *                 .workflowTargetRegion("workflowTargetRegion")
 *                 .build()))
 *         // the properties below are optional
 *         .associatedAlarms(Map.of(
 *                 "associatedAlarmsKey", AssociatedAlarmProperty.builder()
 *                         .alarmType("alarmType")
 *                         .resourceIdentifier("resourceIdentifier")
 *                         // the properties below are optional
 *                         .crossAccountRole("crossAccountRole")
 *                         .externalId("externalId")
 *                         .build()))
 *         .description("description")
 *         .primaryRegion("primaryRegion")
 *         .recoveryTimeObjectiveMinutes(123)
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .triggers(List.of(TriggerProperty.builder()
 *                 .action("action")
 *                 .conditions(List.of(TriggerConditionProperty.builder()
 *                         .associatedAlarmName("associatedAlarmName")
 *                         .condition("condition")
 *                         .build()))
 *                 .minDelayMinutesBetweenExecutions(123)
 *                 .targetRegion("targetRegion")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.559Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan")
public class CfnPlan extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnPlan(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPlan(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.arcregionswitch.CfnPlan.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPlan(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.arcregionswitch.CfnPlanProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Represents a Region switch plan.
     * <p>
     * A plan defines the steps required to shift traffic from one AWS Region to another.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrHealthChecksForPlan() {
        return software.amazon.jsii.Kernel.get(this, "attrHealthChecksForPlan", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The owner of a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOwner() {
        return software.amazon.jsii.Kernel.get(this, "attrOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrRoute53HealthChecks() {
        return software.amazon.jsii.Kernel.get(this, "attrRoute53HealthChecks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The version for the plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The execution role for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole() {
        return software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The execution role for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRole(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRole", java.util.Objects.requireNonNull(value, "executionRole is required"));
    }

    /**
     * The name for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive (activePassive).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRecoveryApproach() {
        return software.amazon.jsii.Kernel.get(this, "recoveryApproach", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive (activePassive).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecoveryApproach(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "recoveryApproach", java.util.Objects.requireNonNull(value, "recoveryApproach is required"));
    }

    /**
     * The AWS Regions for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRegions() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The AWS Regions for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "regions", java.util.Objects.requireNonNull(value, "regions is required"));
    }

    /**
     * The workflows for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getWorkflows() {
        return software.amazon.jsii.Kernel.get(this, "workflows", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The workflows for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkflows(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workflows", java.util.Objects.requireNonNull(value, "workflows is required"));
    }

    /**
     * The workflows for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkflows(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.arcregionswitch.CfnPlan.WorkflowProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.arcregionswitch.CfnPlan.WorkflowProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "workflows", java.util.Objects.requireNonNull(value, "workflows is required"));
    }

    /**
     * The associated application health alarms for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedAlarms() {
        return software.amazon.jsii.Kernel.get(this, "associatedAlarms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The associated application health alarms for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedAlarms(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "associatedAlarms", value);
    }

    /**
     * The associated application health alarms for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociatedAlarms(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.arcregionswitch.CfnPlan.AssociatedAlarmProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.arcregionswitch.CfnPlan.AssociatedAlarmProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "associatedAlarms", value);
    }

    /**
     * The description for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The primary Region for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrimaryRegion() {
        return software.amazon.jsii.Kernel.get(this, "primaryRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The primary Region for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrimaryRegion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "primaryRegion", value);
    }

    /**
     * The recovery time objective for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRecoveryTimeObjectiveMinutes() {
        return software.amazon.jsii.Kernel.get(this, "recoveryTimeObjectiveMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The recovery time objective for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecoveryTimeObjectiveMinutes(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "recoveryTimeObjectiveMinutes", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The triggers for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTriggers() {
        return software.amazon.jsii.Kernel.get(this, "triggers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The triggers for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "triggers", value);
    }

    /**
     * The triggers for a plan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.arcregionswitch.CfnPlan.TriggerProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.arcregionswitch.CfnPlan.TriggerProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "triggers", value);
    }
    /**
     * Configuration for ARC routing controls used in a Region switch plan.
     * <p>
     * Routing controls are simple on/off switches that you can use to shift traffic away from an impaired Region.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * ArcRoutingControlConfigurationProperty arcRoutingControlConfigurationProperty = ArcRoutingControlConfigurationProperty.builder()
     *         .regionAndRoutingControls(Map.of(
     *                 "regionAndRoutingControlsKey", List.of(ArcRoutingControlStateProperty.builder()
     *                         .routingControlArn("routingControlArn")
     *                         .state("state")
     *                         .build())))
     *         // the properties below are optional
     *         .crossAccountRole("crossAccountRole")
     *         .externalId("externalId")
     *         .timeoutMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.ArcRoutingControlConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ArcRoutingControlConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArcRoutingControlConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Region and ARC routing controls for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolconfiguration.html#cfn-arcregionswitch-plan-arcroutingcontrolconfiguration-regionandroutingcontrols">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolconfiguration.html#cfn-arcregionswitch-plan-arcroutingcontrolconfiguration-regionandroutingcontrols</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRegionAndRoutingControls();

        /**
         * The cross account role for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolconfiguration.html#cfn-arcregionswitch-plan-arcroutingcontrolconfiguration-crossaccountrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolconfiguration.html#cfn-arcregionswitch-plan-arcroutingcontrolconfiguration-crossaccountrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossAccountRole() {
            return null;
        }

        /**
         * The external ID (secret key) for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolconfiguration.html#cfn-arcregionswitch-plan-arcroutingcontrolconfiguration-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolconfiguration.html#cfn-arcregionswitch-plan-arcroutingcontrolconfiguration-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The timeout value specified for the configuration.
         * <p>
         * Default: - 60
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolconfiguration.html#cfn-arcregionswitch-plan-arcroutingcontrolconfiguration-timeoutminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolconfiguration.html#cfn-arcregionswitch-plan-arcroutingcontrolconfiguration-timeoutminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArcRoutingControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArcRoutingControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArcRoutingControlConfigurationProperty> {
            java.lang.Object regionAndRoutingControls;
            java.lang.String crossAccountRole;
            java.lang.String externalId;
            java.lang.Number timeoutMinutes;

            /**
             * Sets the value of {@link ArcRoutingControlConfigurationProperty#getRegionAndRoutingControls}
             * @param regionAndRoutingControls The Region and ARC routing controls for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regionAndRoutingControls(software.amazon.awscdk.IResolvable regionAndRoutingControls) {
                this.regionAndRoutingControls = regionAndRoutingControls;
                return this;
            }

            /**
             * Sets the value of {@link ArcRoutingControlConfigurationProperty#getRegionAndRoutingControls}
             * @param regionAndRoutingControls The Region and ARC routing controls for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regionAndRoutingControls(java.util.Map<java.lang.String, ? extends java.lang.Object> regionAndRoutingControls) {
                this.regionAndRoutingControls = regionAndRoutingControls;
                return this;
            }

            /**
             * Sets the value of {@link ArcRoutingControlConfigurationProperty#getCrossAccountRole}
             * @param crossAccountRole The cross account role for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossAccountRole(java.lang.String crossAccountRole) {
                this.crossAccountRole = crossAccountRole;
                return this;
            }

            /**
             * Sets the value of {@link ArcRoutingControlConfigurationProperty#getExternalId}
             * @param externalId The external ID (secret key) for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link ArcRoutingControlConfigurationProperty#getTimeoutMinutes}
             * @param timeoutMinutes The timeout value specified for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMinutes(java.lang.Number timeoutMinutes) {
                this.timeoutMinutes = timeoutMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArcRoutingControlConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArcRoutingControlConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArcRoutingControlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArcRoutingControlConfigurationProperty {
            private final java.lang.Object regionAndRoutingControls;
            private final java.lang.String crossAccountRole;
            private final java.lang.String externalId;
            private final java.lang.Number timeoutMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.regionAndRoutingControls = software.amazon.jsii.Kernel.get(this, "regionAndRoutingControls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.crossAccountRole = software.amazon.jsii.Kernel.get(this, "crossAccountRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutMinutes = software.amazon.jsii.Kernel.get(this, "timeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.regionAndRoutingControls = java.util.Objects.requireNonNull(builder.regionAndRoutingControls, "regionAndRoutingControls is required");
                this.crossAccountRole = builder.crossAccountRole;
                this.externalId = builder.externalId;
                this.timeoutMinutes = builder.timeoutMinutes;
            }

            @Override
            public final java.lang.Object getRegionAndRoutingControls() {
                return this.regionAndRoutingControls;
            }

            @Override
            public final java.lang.String getCrossAccountRole() {
                return this.crossAccountRole;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.Number getTimeoutMinutes() {
                return this.timeoutMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("regionAndRoutingControls", om.valueToTree(this.getRegionAndRoutingControls()));
                if (this.getCrossAccountRole() != null) {
                    data.set("crossAccountRole", om.valueToTree(this.getCrossAccountRole()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getTimeoutMinutes() != null) {
                    data.set("timeoutMinutes", om.valueToTree(this.getTimeoutMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.ArcRoutingControlConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArcRoutingControlConfigurationProperty.Jsii$Proxy that = (ArcRoutingControlConfigurationProperty.Jsii$Proxy) o;

                if (!regionAndRoutingControls.equals(that.regionAndRoutingControls)) return false;
                if (this.crossAccountRole != null ? !this.crossAccountRole.equals(that.crossAccountRole) : that.crossAccountRole != null) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                return this.timeoutMinutes != null ? this.timeoutMinutes.equals(that.timeoutMinutes) : that.timeoutMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.regionAndRoutingControls.hashCode();
                result = 31 * result + (this.crossAccountRole != null ? this.crossAccountRole.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.timeoutMinutes != null ? this.timeoutMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * ArcRoutingControlStateProperty arcRoutingControlStateProperty = ArcRoutingControlStateProperty.builder()
     *         .routingControlArn("routingControlArn")
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolstate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolstate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.ArcRoutingControlStateProperty")
    @software.amazon.jsii.Jsii.Proxy(ArcRoutingControlStateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArcRoutingControlStateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolstate.html#cfn-arcregionswitch-plan-arcroutingcontrolstate-routingcontrolarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolstate.html#cfn-arcregionswitch-plan-arcroutingcontrolstate-routingcontrolarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoutingControlArn();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolstate.html#cfn-arcregionswitch-plan-arcroutingcontrolstate-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-arcroutingcontrolstate.html#cfn-arcregionswitch-plan-arcroutingcontrolstate-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getState();

        /**
         * @return a {@link Builder} of {@link ArcRoutingControlStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArcRoutingControlStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArcRoutingControlStateProperty> {
            java.lang.String routingControlArn;
            java.lang.String state;

            /**
             * Sets the value of {@link ArcRoutingControlStateProperty#getRoutingControlArn}
             * @param routingControlArn the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder routingControlArn(java.lang.String routingControlArn) {
                this.routingControlArn = routingControlArn;
                return this;
            }

            /**
             * Sets the value of {@link ArcRoutingControlStateProperty#getState}
             * @param state the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArcRoutingControlStateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArcRoutingControlStateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArcRoutingControlStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArcRoutingControlStateProperty {
            private final java.lang.String routingControlArn;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.routingControlArn = software.amazon.jsii.Kernel.get(this, "routingControlArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.routingControlArn = java.util.Objects.requireNonNull(builder.routingControlArn, "routingControlArn is required");
                this.state = java.util.Objects.requireNonNull(builder.state, "state is required");
            }

            @Override
            public final java.lang.String getRoutingControlArn() {
                return this.routingControlArn;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("routingControlArn", om.valueToTree(this.getRoutingControlArn()));
                data.set("state", om.valueToTree(this.getState()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.ArcRoutingControlStateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArcRoutingControlStateProperty.Jsii$Proxy that = (ArcRoutingControlStateProperty.Jsii$Proxy) o;

                if (!routingControlArn.equals(that.routingControlArn)) return false;
                return this.state.equals(that.state);
            }

            @Override
            public final int hashCode() {
                int result = this.routingControlArn.hashCode();
                result = 31 * result + (this.state.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration for an Amazon EC2 Auto Scaling group used in a Region switch plan.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * AsgProperty asgProperty = AsgProperty.builder()
     *         .arn("arn")
     *         .crossAccountRole("crossAccountRole")
     *         .externalId("externalId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-asg.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-asg.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.AsgProperty")
    @software.amazon.jsii.Jsii.Proxy(AsgProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AsgProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the EC2 Auto Scaling group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-asg.html#cfn-arcregionswitch-plan-asg-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-asg.html#cfn-arcregionswitch-plan-asg-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * The cross account role for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-asg.html#cfn-arcregionswitch-plan-asg-crossaccountrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-asg.html#cfn-arcregionswitch-plan-asg-crossaccountrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossAccountRole() {
            return null;
        }

        /**
         * The external ID (secret key) for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-asg.html#cfn-arcregionswitch-plan-asg-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-asg.html#cfn-arcregionswitch-plan-asg-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AsgProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AsgProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AsgProperty> {
            java.lang.String arn;
            java.lang.String crossAccountRole;
            java.lang.String externalId;

            /**
             * Sets the value of {@link AsgProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the EC2 Auto Scaling group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link AsgProperty#getCrossAccountRole}
             * @param crossAccountRole The cross account role for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossAccountRole(java.lang.String crossAccountRole) {
                this.crossAccountRole = crossAccountRole;
                return this;
            }

            /**
             * Sets the value of {@link AsgProperty#getExternalId}
             * @param externalId The external ID (secret key) for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AsgProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AsgProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AsgProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsgProperty {
            private final java.lang.String arn;
            private final java.lang.String crossAccountRole;
            private final java.lang.String externalId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crossAccountRole = software.amazon.jsii.Kernel.get(this, "crossAccountRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
                this.crossAccountRole = builder.crossAccountRole;
                this.externalId = builder.externalId;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getCrossAccountRole() {
                return this.crossAccountRole;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getCrossAccountRole() != null) {
                    data.set("crossAccountRole", om.valueToTree(this.getCrossAccountRole()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.AsgProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AsgProperty.Jsii$Proxy that = (AsgProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                if (this.crossAccountRole != null ? !this.crossAccountRole.equals(that.crossAccountRole) : that.crossAccountRole != null) return false;
                return this.externalId != null ? this.externalId.equals(that.externalId) : that.externalId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.crossAccountRole != null ? this.crossAccountRole.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An Amazon CloudWatch alarm associated with a Region switch plan.
     * <p>
     * These alarms can be used to trigger automatic execution of the plan.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * AssociatedAlarmProperty associatedAlarmProperty = AssociatedAlarmProperty.builder()
     *         .alarmType("alarmType")
     *         .resourceIdentifier("resourceIdentifier")
     *         // the properties below are optional
     *         .crossAccountRole("crossAccountRole")
     *         .externalId("externalId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-associatedalarm.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-associatedalarm.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.AssociatedAlarmProperty")
    @software.amazon.jsii.Jsii.Proxy(AssociatedAlarmProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssociatedAlarmProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The alarm type for an associated alarm.
         * <p>
         * An associated CloudWatch alarm can be an application health alarm or a trigger alarm.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-associatedalarm.html#cfn-arcregionswitch-plan-associatedalarm-alarmtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-associatedalarm.html#cfn-arcregionswitch-plan-associatedalarm-alarmtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlarmType();

        /**
         * The resource identifier for alarms that you associate with a plan.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-associatedalarm.html#cfn-arcregionswitch-plan-associatedalarm-resourceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-associatedalarm.html#cfn-arcregionswitch-plan-associatedalarm-resourceidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceIdentifier();

        /**
         * The cross account role for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-associatedalarm.html#cfn-arcregionswitch-plan-associatedalarm-crossaccountrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-associatedalarm.html#cfn-arcregionswitch-plan-associatedalarm-crossaccountrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossAccountRole() {
            return null;
        }

        /**
         * The external ID (secret key) for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-associatedalarm.html#cfn-arcregionswitch-plan-associatedalarm-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-associatedalarm.html#cfn-arcregionswitch-plan-associatedalarm-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssociatedAlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssociatedAlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssociatedAlarmProperty> {
            java.lang.String alarmType;
            java.lang.String resourceIdentifier;
            java.lang.String crossAccountRole;
            java.lang.String externalId;

            /**
             * Sets the value of {@link AssociatedAlarmProperty#getAlarmType}
             * @param alarmType The alarm type for an associated alarm. This parameter is required.
             *                  An associated CloudWatch alarm can be an application health alarm or a trigger alarm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmType(java.lang.String alarmType) {
                this.alarmType = alarmType;
                return this;
            }

            /**
             * Sets the value of {@link AssociatedAlarmProperty#getResourceIdentifier}
             * @param resourceIdentifier The resource identifier for alarms that you associate with a plan. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceIdentifier(java.lang.String resourceIdentifier) {
                this.resourceIdentifier = resourceIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link AssociatedAlarmProperty#getCrossAccountRole}
             * @param crossAccountRole The cross account role for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossAccountRole(java.lang.String crossAccountRole) {
                this.crossAccountRole = crossAccountRole;
                return this;
            }

            /**
             * Sets the value of {@link AssociatedAlarmProperty#getExternalId}
             * @param externalId The external ID (secret key) for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssociatedAlarmProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssociatedAlarmProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssociatedAlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssociatedAlarmProperty {
            private final java.lang.String alarmType;
            private final java.lang.String resourceIdentifier;
            private final java.lang.String crossAccountRole;
            private final java.lang.String externalId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmType = software.amazon.jsii.Kernel.get(this, "alarmType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceIdentifier = software.amazon.jsii.Kernel.get(this, "resourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crossAccountRole = software.amazon.jsii.Kernel.get(this, "crossAccountRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmType = java.util.Objects.requireNonNull(builder.alarmType, "alarmType is required");
                this.resourceIdentifier = java.util.Objects.requireNonNull(builder.resourceIdentifier, "resourceIdentifier is required");
                this.crossAccountRole = builder.crossAccountRole;
                this.externalId = builder.externalId;
            }

            @Override
            public final java.lang.String getAlarmType() {
                return this.alarmType;
            }

            @Override
            public final java.lang.String getResourceIdentifier() {
                return this.resourceIdentifier;
            }

            @Override
            public final java.lang.String getCrossAccountRole() {
                return this.crossAccountRole;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarmType", om.valueToTree(this.getAlarmType()));
                data.set("resourceIdentifier", om.valueToTree(this.getResourceIdentifier()));
                if (this.getCrossAccountRole() != null) {
                    data.set("crossAccountRole", om.valueToTree(this.getCrossAccountRole()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.AssociatedAlarmProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssociatedAlarmProperty.Jsii$Proxy that = (AssociatedAlarmProperty.Jsii$Proxy) o;

                if (!alarmType.equals(that.alarmType)) return false;
                if (!resourceIdentifier.equals(that.resourceIdentifier)) return false;
                if (this.crossAccountRole != null ? !this.crossAccountRole.equals(that.crossAccountRole) : that.crossAccountRole != null) return false;
                return this.externalId != null ? this.externalId.equals(that.externalId) : that.externalId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alarmType.hashCode();
                result = 31 * result + (this.resourceIdentifier.hashCode());
                result = 31 * result + (this.crossAccountRole != null ? this.crossAccountRole.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for AWS Lambda functions that perform custom actions during a Region switch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * CustomActionLambdaConfigurationProperty customActionLambdaConfigurationProperty = CustomActionLambdaConfigurationProperty.builder()
     *         .lambdas(List.of(LambdasProperty.builder()
     *                 .arn("arn")
     *                 .crossAccountRole("crossAccountRole")
     *                 .externalId("externalId")
     *                 .build()))
     *         .regionToRun("regionToRun")
     *         .retryIntervalMinutes(123)
     *         // the properties below are optional
     *         .timeoutMinutes(123)
     *         .ungraceful(LambdaUngracefulProperty.builder()
     *                 .behavior("behavior")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.CustomActionLambdaConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomActionLambdaConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomActionLambdaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Lambda functions for the execution block.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html#cfn-arcregionswitch-plan-customactionlambdaconfiguration-lambdas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html#cfn-arcregionswitch-plan-customactionlambdaconfiguration-lambdas</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLambdas();

        /**
         * The AWS Region for the function to run in.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html#cfn-arcregionswitch-plan-customactionlambdaconfiguration-regiontorun">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html#cfn-arcregionswitch-plan-customactionlambdaconfiguration-regiontorun</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegionToRun();

        /**
         * The retry interval specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html#cfn-arcregionswitch-plan-customactionlambdaconfiguration-retryintervalminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html#cfn-arcregionswitch-plan-customactionlambdaconfiguration-retryintervalminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRetryIntervalMinutes();

        /**
         * The timeout value specified for the configuration.
         * <p>
         * Default: - 60
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html#cfn-arcregionswitch-plan-customactionlambdaconfiguration-timeoutminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html#cfn-arcregionswitch-plan-customactionlambdaconfiguration-timeoutminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutMinutes() {
            return null;
        }

        /**
         * The settings for ungraceful execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html#cfn-arcregionswitch-plan-customactionlambdaconfiguration-ungraceful">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-customactionlambdaconfiguration.html#cfn-arcregionswitch-plan-customactionlambdaconfiguration-ungraceful</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUngraceful() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomActionLambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomActionLambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomActionLambdaConfigurationProperty> {
            java.lang.Object lambdas;
            java.lang.String regionToRun;
            java.lang.Number retryIntervalMinutes;
            java.lang.Number timeoutMinutes;
            java.lang.Object ungraceful;

            /**
             * Sets the value of {@link CustomActionLambdaConfigurationProperty#getLambdas}
             * @param lambdas The AWS Lambda functions for the execution block. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdas(software.amazon.awscdk.IResolvable lambdas) {
                this.lambdas = lambdas;
                return this;
            }

            /**
             * Sets the value of {@link CustomActionLambdaConfigurationProperty#getLambdas}
             * @param lambdas The AWS Lambda functions for the execution block. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdas(java.util.List<? extends java.lang.Object> lambdas) {
                this.lambdas = lambdas;
                return this;
            }

            /**
             * Sets the value of {@link CustomActionLambdaConfigurationProperty#getRegionToRun}
             * @param regionToRun The AWS Region for the function to run in. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regionToRun(java.lang.String regionToRun) {
                this.regionToRun = regionToRun;
                return this;
            }

            /**
             * Sets the value of {@link CustomActionLambdaConfigurationProperty#getRetryIntervalMinutes}
             * @param retryIntervalMinutes The retry interval specified. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryIntervalMinutes(java.lang.Number retryIntervalMinutes) {
                this.retryIntervalMinutes = retryIntervalMinutes;
                return this;
            }

            /**
             * Sets the value of {@link CustomActionLambdaConfigurationProperty#getTimeoutMinutes}
             * @param timeoutMinutes The timeout value specified for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMinutes(java.lang.Number timeoutMinutes) {
                this.timeoutMinutes = timeoutMinutes;
                return this;
            }

            /**
             * Sets the value of {@link CustomActionLambdaConfigurationProperty#getUngraceful}
             * @param ungraceful The settings for ungraceful execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ungraceful(software.amazon.awscdk.IResolvable ungraceful) {
                this.ungraceful = ungraceful;
                return this;
            }

            /**
             * Sets the value of {@link CustomActionLambdaConfigurationProperty#getUngraceful}
             * @param ungraceful The settings for ungraceful execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ungraceful(software.amazon.awscdk.services.arcregionswitch.CfnPlan.LambdaUngracefulProperty ungraceful) {
                this.ungraceful = ungraceful;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomActionLambdaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomActionLambdaConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomActionLambdaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomActionLambdaConfigurationProperty {
            private final java.lang.Object lambdas;
            private final java.lang.String regionToRun;
            private final java.lang.Number retryIntervalMinutes;
            private final java.lang.Number timeoutMinutes;
            private final java.lang.Object ungraceful;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdas = software.amazon.jsii.Kernel.get(this, "lambdas", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regionToRun = software.amazon.jsii.Kernel.get(this, "regionToRun", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retryIntervalMinutes = software.amazon.jsii.Kernel.get(this, "retryIntervalMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeoutMinutes = software.amazon.jsii.Kernel.get(this, "timeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ungraceful = software.amazon.jsii.Kernel.get(this, "ungraceful", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdas = java.util.Objects.requireNonNull(builder.lambdas, "lambdas is required");
                this.regionToRun = java.util.Objects.requireNonNull(builder.regionToRun, "regionToRun is required");
                this.retryIntervalMinutes = java.util.Objects.requireNonNull(builder.retryIntervalMinutes, "retryIntervalMinutes is required");
                this.timeoutMinutes = builder.timeoutMinutes;
                this.ungraceful = builder.ungraceful;
            }

            @Override
            public final java.lang.Object getLambdas() {
                return this.lambdas;
            }

            @Override
            public final java.lang.String getRegionToRun() {
                return this.regionToRun;
            }

            @Override
            public final java.lang.Number getRetryIntervalMinutes() {
                return this.retryIntervalMinutes;
            }

            @Override
            public final java.lang.Number getTimeoutMinutes() {
                return this.timeoutMinutes;
            }

            @Override
            public final java.lang.Object getUngraceful() {
                return this.ungraceful;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdas", om.valueToTree(this.getLambdas()));
                data.set("regionToRun", om.valueToTree(this.getRegionToRun()));
                data.set("retryIntervalMinutes", om.valueToTree(this.getRetryIntervalMinutes()));
                if (this.getTimeoutMinutes() != null) {
                    data.set("timeoutMinutes", om.valueToTree(this.getTimeoutMinutes()));
                }
                if (this.getUngraceful() != null) {
                    data.set("ungraceful", om.valueToTree(this.getUngraceful()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.CustomActionLambdaConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomActionLambdaConfigurationProperty.Jsii$Proxy that = (CustomActionLambdaConfigurationProperty.Jsii$Proxy) o;

                if (!lambdas.equals(that.lambdas)) return false;
                if (!regionToRun.equals(that.regionToRun)) return false;
                if (!retryIntervalMinutes.equals(that.retryIntervalMinutes)) return false;
                if (this.timeoutMinutes != null ? !this.timeoutMinutes.equals(that.timeoutMinutes) : that.timeoutMinutes != null) return false;
                return this.ungraceful != null ? this.ungraceful.equals(that.ungraceful) : that.ungraceful == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lambdas.hashCode();
                result = 31 * result + (this.regionToRun.hashCode());
                result = 31 * result + (this.retryIntervalMinutes.hashCode());
                result = 31 * result + (this.timeoutMinutes != null ? this.timeoutMinutes.hashCode() : 0);
                result = 31 * result + (this.ungraceful != null ? this.ungraceful.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for increasing the capacity of Amazon EC2 Auto Scaling groups during a Region switch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * Ec2AsgCapacityIncreaseConfigurationProperty ec2AsgCapacityIncreaseConfigurationProperty = Ec2AsgCapacityIncreaseConfigurationProperty.builder()
     *         .asgs(List.of(AsgProperty.builder()
     *                 .arn("arn")
     *                 .crossAccountRole("crossAccountRole")
     *                 .externalId("externalId")
     *                 .build()))
     *         // the properties below are optional
     *         .capacityMonitoringApproach("capacityMonitoringApproach")
     *         .targetPercent(123)
     *         .timeoutMinutes(123)
     *         .ungraceful(Ec2UngracefulProperty.builder()
     *                 .minimumSuccessPercentage(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.Ec2AsgCapacityIncreaseConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(Ec2AsgCapacityIncreaseConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Ec2AsgCapacityIncreaseConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The EC2 Auto Scaling groups for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration-asgs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration-asgs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAsgs();

        /**
         * The monitoring approach that you specify EC2 Auto Scaling groups for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration-capacitymonitoringapproach">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration-capacitymonitoringapproach</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityMonitoringApproach() {
            return null;
        }

        /**
         * The target percentage that you specify for EC2 Auto Scaling groups.
         * <p>
         * Default: - 100
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration-targetpercent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration-targetpercent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetPercent() {
            return null;
        }

        /**
         * The timeout value specified for the configuration.
         * <p>
         * Default: - 60
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration-timeoutminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration-timeoutminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutMinutes() {
            return null;
        }

        /**
         * The settings for ungraceful execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration-ungraceful">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ec2asgcapacityincreaseconfiguration-ungraceful</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUngraceful() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Ec2AsgCapacityIncreaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Ec2AsgCapacityIncreaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Ec2AsgCapacityIncreaseConfigurationProperty> {
            java.lang.Object asgs;
            java.lang.String capacityMonitoringApproach;
            java.lang.Number targetPercent;
            java.lang.Number timeoutMinutes;
            java.lang.Object ungraceful;

            /**
             * Sets the value of {@link Ec2AsgCapacityIncreaseConfigurationProperty#getAsgs}
             * @param asgs The EC2 Auto Scaling groups for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder asgs(software.amazon.awscdk.IResolvable asgs) {
                this.asgs = asgs;
                return this;
            }

            /**
             * Sets the value of {@link Ec2AsgCapacityIncreaseConfigurationProperty#getAsgs}
             * @param asgs The EC2 Auto Scaling groups for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder asgs(java.util.List<? extends java.lang.Object> asgs) {
                this.asgs = asgs;
                return this;
            }

            /**
             * Sets the value of {@link Ec2AsgCapacityIncreaseConfigurationProperty#getCapacityMonitoringApproach}
             * @param capacityMonitoringApproach The monitoring approach that you specify EC2 Auto Scaling groups for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityMonitoringApproach(java.lang.String capacityMonitoringApproach) {
                this.capacityMonitoringApproach = capacityMonitoringApproach;
                return this;
            }

            /**
             * Sets the value of {@link Ec2AsgCapacityIncreaseConfigurationProperty#getTargetPercent}
             * @param targetPercent The target percentage that you specify for EC2 Auto Scaling groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetPercent(java.lang.Number targetPercent) {
                this.targetPercent = targetPercent;
                return this;
            }

            /**
             * Sets the value of {@link Ec2AsgCapacityIncreaseConfigurationProperty#getTimeoutMinutes}
             * @param timeoutMinutes The timeout value specified for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMinutes(java.lang.Number timeoutMinutes) {
                this.timeoutMinutes = timeoutMinutes;
                return this;
            }

            /**
             * Sets the value of {@link Ec2AsgCapacityIncreaseConfigurationProperty#getUngraceful}
             * @param ungraceful The settings for ungraceful execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ungraceful(software.amazon.awscdk.IResolvable ungraceful) {
                this.ungraceful = ungraceful;
                return this;
            }

            /**
             * Sets the value of {@link Ec2AsgCapacityIncreaseConfigurationProperty#getUngraceful}
             * @param ungraceful The settings for ungraceful execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ungraceful(software.amazon.awscdk.services.arcregionswitch.CfnPlan.Ec2UngracefulProperty ungraceful) {
                this.ungraceful = ungraceful;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ec2AsgCapacityIncreaseConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Ec2AsgCapacityIncreaseConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Ec2AsgCapacityIncreaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ec2AsgCapacityIncreaseConfigurationProperty {
            private final java.lang.Object asgs;
            private final java.lang.String capacityMonitoringApproach;
            private final java.lang.Number targetPercent;
            private final java.lang.Number timeoutMinutes;
            private final java.lang.Object ungraceful;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.asgs = software.amazon.jsii.Kernel.get(this, "asgs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.capacityMonitoringApproach = software.amazon.jsii.Kernel.get(this, "capacityMonitoringApproach", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetPercent = software.amazon.jsii.Kernel.get(this, "targetPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeoutMinutes = software.amazon.jsii.Kernel.get(this, "timeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ungraceful = software.amazon.jsii.Kernel.get(this, "ungraceful", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.asgs = java.util.Objects.requireNonNull(builder.asgs, "asgs is required");
                this.capacityMonitoringApproach = builder.capacityMonitoringApproach;
                this.targetPercent = builder.targetPercent;
                this.timeoutMinutes = builder.timeoutMinutes;
                this.ungraceful = builder.ungraceful;
            }

            @Override
            public final java.lang.Object getAsgs() {
                return this.asgs;
            }

            @Override
            public final java.lang.String getCapacityMonitoringApproach() {
                return this.capacityMonitoringApproach;
            }

            @Override
            public final java.lang.Number getTargetPercent() {
                return this.targetPercent;
            }

            @Override
            public final java.lang.Number getTimeoutMinutes() {
                return this.timeoutMinutes;
            }

            @Override
            public final java.lang.Object getUngraceful() {
                return this.ungraceful;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("asgs", om.valueToTree(this.getAsgs()));
                if (this.getCapacityMonitoringApproach() != null) {
                    data.set("capacityMonitoringApproach", om.valueToTree(this.getCapacityMonitoringApproach()));
                }
                if (this.getTargetPercent() != null) {
                    data.set("targetPercent", om.valueToTree(this.getTargetPercent()));
                }
                if (this.getTimeoutMinutes() != null) {
                    data.set("timeoutMinutes", om.valueToTree(this.getTimeoutMinutes()));
                }
                if (this.getUngraceful() != null) {
                    data.set("ungraceful", om.valueToTree(this.getUngraceful()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.Ec2AsgCapacityIncreaseConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Ec2AsgCapacityIncreaseConfigurationProperty.Jsii$Proxy that = (Ec2AsgCapacityIncreaseConfigurationProperty.Jsii$Proxy) o;

                if (!asgs.equals(that.asgs)) return false;
                if (this.capacityMonitoringApproach != null ? !this.capacityMonitoringApproach.equals(that.capacityMonitoringApproach) : that.capacityMonitoringApproach != null) return false;
                if (this.targetPercent != null ? !this.targetPercent.equals(that.targetPercent) : that.targetPercent != null) return false;
                if (this.timeoutMinutes != null ? !this.timeoutMinutes.equals(that.timeoutMinutes) : that.timeoutMinutes != null) return false;
                return this.ungraceful != null ? this.ungraceful.equals(that.ungraceful) : that.ungraceful == null;
            }

            @Override
            public final int hashCode() {
                int result = this.asgs.hashCode();
                result = 31 * result + (this.capacityMonitoringApproach != null ? this.capacityMonitoringApproach.hashCode() : 0);
                result = 31 * result + (this.targetPercent != null ? this.targetPercent.hashCode() : 0);
                result = 31 * result + (this.timeoutMinutes != null ? this.timeoutMinutes.hashCode() : 0);
                result = 31 * result + (this.ungraceful != null ? this.ungraceful.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for handling failures when performing operations on EC2 resources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * Ec2UngracefulProperty ec2UngracefulProperty = Ec2UngracefulProperty.builder()
     *         .minimumSuccessPercentage(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2ungraceful.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2ungraceful.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.Ec2UngracefulProperty")
    @software.amazon.jsii.Jsii.Proxy(Ec2UngracefulProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Ec2UngracefulProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum success percentage that you specify for EC2 Auto Scaling groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2ungraceful.html#cfn-arcregionswitch-plan-ec2ungraceful-minimumsuccesspercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ec2ungraceful.html#cfn-arcregionswitch-plan-ec2ungraceful-minimumsuccesspercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimumSuccessPercentage();

        /**
         * @return a {@link Builder} of {@link Ec2UngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Ec2UngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Ec2UngracefulProperty> {
            java.lang.Number minimumSuccessPercentage;

            /**
             * Sets the value of {@link Ec2UngracefulProperty#getMinimumSuccessPercentage}
             * @param minimumSuccessPercentage The minimum success percentage that you specify for EC2 Auto Scaling groups. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumSuccessPercentage(java.lang.Number minimumSuccessPercentage) {
                this.minimumSuccessPercentage = minimumSuccessPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Ec2UngracefulProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Ec2UngracefulProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Ec2UngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ec2UngracefulProperty {
            private final java.lang.Number minimumSuccessPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.minimumSuccessPercentage = software.amazon.jsii.Kernel.get(this, "minimumSuccessPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.minimumSuccessPercentage = java.util.Objects.requireNonNull(builder.minimumSuccessPercentage, "minimumSuccessPercentage is required");
            }

            @Override
            public final java.lang.Number getMinimumSuccessPercentage() {
                return this.minimumSuccessPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("minimumSuccessPercentage", om.valueToTree(this.getMinimumSuccessPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.Ec2UngracefulProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Ec2UngracefulProperty.Jsii$Proxy that = (Ec2UngracefulProperty.Jsii$Proxy) o;

                return this.minimumSuccessPercentage.equals(that.minimumSuccessPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.minimumSuccessPercentage.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration for an AWS ECS capacity increase.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * EcsCapacityIncreaseConfigurationProperty ecsCapacityIncreaseConfigurationProperty = EcsCapacityIncreaseConfigurationProperty.builder()
     *         .services(List.of(ServiceProperty.builder()
     *                 .clusterArn("clusterArn")
     *                 .crossAccountRole("crossAccountRole")
     *                 .externalId("externalId")
     *                 .serviceArn("serviceArn")
     *                 .build()))
     *         // the properties below are optional
     *         .capacityMonitoringApproach("capacityMonitoringApproach")
     *         .targetPercent(123)
     *         .timeoutMinutes(123)
     *         .ungraceful(EcsUngracefulProperty.builder()
     *                 .minimumSuccessPercentage(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.EcsCapacityIncreaseConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsCapacityIncreaseConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsCapacityIncreaseConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The services specified for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ecscapacityincreaseconfiguration-services">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ecscapacityincreaseconfiguration-services</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getServices();

        /**
         * The monitoring approach specified for the configuration, for example, <code>Most_Recent</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ecscapacityincreaseconfiguration-capacitymonitoringapproach">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ecscapacityincreaseconfiguration-capacitymonitoringapproach</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityMonitoringApproach() {
            return null;
        }

        /**
         * The target percentage specified for the configuration.
         * <p>
         * Default: - 100
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ecscapacityincreaseconfiguration-targetpercent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ecscapacityincreaseconfiguration-targetpercent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetPercent() {
            return null;
        }

        /**
         * The timeout value specified for the configuration.
         * <p>
         * Default: - 60
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ecscapacityincreaseconfiguration-timeoutminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ecscapacityincreaseconfiguration-timeoutminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutMinutes() {
            return null;
        }

        /**
         * The settings for ungraceful execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ecscapacityincreaseconfiguration-ungraceful">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecscapacityincreaseconfiguration.html#cfn-arcregionswitch-plan-ecscapacityincreaseconfiguration-ungraceful</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUngraceful() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EcsCapacityIncreaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsCapacityIncreaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsCapacityIncreaseConfigurationProperty> {
            java.lang.Object services;
            java.lang.String capacityMonitoringApproach;
            java.lang.Number targetPercent;
            java.lang.Number timeoutMinutes;
            java.lang.Object ungraceful;

            /**
             * Sets the value of {@link EcsCapacityIncreaseConfigurationProperty#getServices}
             * @param services The services specified for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder services(software.amazon.awscdk.IResolvable services) {
                this.services = services;
                return this;
            }

            /**
             * Sets the value of {@link EcsCapacityIncreaseConfigurationProperty#getServices}
             * @param services The services specified for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder services(java.util.List<? extends java.lang.Object> services) {
                this.services = services;
                return this;
            }

            /**
             * Sets the value of {@link EcsCapacityIncreaseConfigurationProperty#getCapacityMonitoringApproach}
             * @param capacityMonitoringApproach The monitoring approach specified for the configuration, for example, <code>Most_Recent</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityMonitoringApproach(java.lang.String capacityMonitoringApproach) {
                this.capacityMonitoringApproach = capacityMonitoringApproach;
                return this;
            }

            /**
             * Sets the value of {@link EcsCapacityIncreaseConfigurationProperty#getTargetPercent}
             * @param targetPercent The target percentage specified for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetPercent(java.lang.Number targetPercent) {
                this.targetPercent = targetPercent;
                return this;
            }

            /**
             * Sets the value of {@link EcsCapacityIncreaseConfigurationProperty#getTimeoutMinutes}
             * @param timeoutMinutes The timeout value specified for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMinutes(java.lang.Number timeoutMinutes) {
                this.timeoutMinutes = timeoutMinutes;
                return this;
            }

            /**
             * Sets the value of {@link EcsCapacityIncreaseConfigurationProperty#getUngraceful}
             * @param ungraceful The settings for ungraceful execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ungraceful(software.amazon.awscdk.IResolvable ungraceful) {
                this.ungraceful = ungraceful;
                return this;
            }

            /**
             * Sets the value of {@link EcsCapacityIncreaseConfigurationProperty#getUngraceful}
             * @param ungraceful The settings for ungraceful execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ungraceful(software.amazon.awscdk.services.arcregionswitch.CfnPlan.EcsUngracefulProperty ungraceful) {
                this.ungraceful = ungraceful;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsCapacityIncreaseConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsCapacityIncreaseConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsCapacityIncreaseConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsCapacityIncreaseConfigurationProperty {
            private final java.lang.Object services;
            private final java.lang.String capacityMonitoringApproach;
            private final java.lang.Number targetPercent;
            private final java.lang.Number timeoutMinutes;
            private final java.lang.Object ungraceful;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.services = software.amazon.jsii.Kernel.get(this, "services", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.capacityMonitoringApproach = software.amazon.jsii.Kernel.get(this, "capacityMonitoringApproach", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetPercent = software.amazon.jsii.Kernel.get(this, "targetPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeoutMinutes = software.amazon.jsii.Kernel.get(this, "timeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ungraceful = software.amazon.jsii.Kernel.get(this, "ungraceful", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.services = java.util.Objects.requireNonNull(builder.services, "services is required");
                this.capacityMonitoringApproach = builder.capacityMonitoringApproach;
                this.targetPercent = builder.targetPercent;
                this.timeoutMinutes = builder.timeoutMinutes;
                this.ungraceful = builder.ungraceful;
            }

            @Override
            public final java.lang.Object getServices() {
                return this.services;
            }

            @Override
            public final java.lang.String getCapacityMonitoringApproach() {
                return this.capacityMonitoringApproach;
            }

            @Override
            public final java.lang.Number getTargetPercent() {
                return this.targetPercent;
            }

            @Override
            public final java.lang.Number getTimeoutMinutes() {
                return this.timeoutMinutes;
            }

            @Override
            public final java.lang.Object getUngraceful() {
                return this.ungraceful;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("services", om.valueToTree(this.getServices()));
                if (this.getCapacityMonitoringApproach() != null) {
                    data.set("capacityMonitoringApproach", om.valueToTree(this.getCapacityMonitoringApproach()));
                }
                if (this.getTargetPercent() != null) {
                    data.set("targetPercent", om.valueToTree(this.getTargetPercent()));
                }
                if (this.getTimeoutMinutes() != null) {
                    data.set("timeoutMinutes", om.valueToTree(this.getTimeoutMinutes()));
                }
                if (this.getUngraceful() != null) {
                    data.set("ungraceful", om.valueToTree(this.getUngraceful()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.EcsCapacityIncreaseConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsCapacityIncreaseConfigurationProperty.Jsii$Proxy that = (EcsCapacityIncreaseConfigurationProperty.Jsii$Proxy) o;

                if (!services.equals(that.services)) return false;
                if (this.capacityMonitoringApproach != null ? !this.capacityMonitoringApproach.equals(that.capacityMonitoringApproach) : that.capacityMonitoringApproach != null) return false;
                if (this.targetPercent != null ? !this.targetPercent.equals(that.targetPercent) : that.targetPercent != null) return false;
                if (this.timeoutMinutes != null ? !this.timeoutMinutes.equals(that.timeoutMinutes) : that.timeoutMinutes != null) return false;
                return this.ungraceful != null ? this.ungraceful.equals(that.ungraceful) : that.ungraceful == null;
            }

            @Override
            public final int hashCode() {
                int result = this.services.hashCode();
                result = 31 * result + (this.capacityMonitoringApproach != null ? this.capacityMonitoringApproach.hashCode() : 0);
                result = 31 * result + (this.targetPercent != null ? this.targetPercent.hashCode() : 0);
                result = 31 * result + (this.timeoutMinutes != null ? this.timeoutMinutes.hashCode() : 0);
                result = 31 * result + (this.ungraceful != null ? this.ungraceful.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The settings for ungraceful execution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * EcsUngracefulProperty ecsUngracefulProperty = EcsUngracefulProperty.builder()
     *         .minimumSuccessPercentage(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecsungraceful.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecsungraceful.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.EcsUngracefulProperty")
    @software.amazon.jsii.Jsii.Proxy(EcsUngracefulProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EcsUngracefulProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum success percentage specified for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecsungraceful.html#cfn-arcregionswitch-plan-ecsungraceful-minimumsuccesspercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ecsungraceful.html#cfn-arcregionswitch-plan-ecsungraceful-minimumsuccesspercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimumSuccessPercentage();

        /**
         * @return a {@link Builder} of {@link EcsUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EcsUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EcsUngracefulProperty> {
            java.lang.Number minimumSuccessPercentage;

            /**
             * Sets the value of {@link EcsUngracefulProperty#getMinimumSuccessPercentage}
             * @param minimumSuccessPercentage The minimum success percentage specified for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumSuccessPercentage(java.lang.Number minimumSuccessPercentage) {
                this.minimumSuccessPercentage = minimumSuccessPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EcsUngracefulProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EcsUngracefulProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EcsUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsUngracefulProperty {
            private final java.lang.Number minimumSuccessPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.minimumSuccessPercentage = software.amazon.jsii.Kernel.get(this, "minimumSuccessPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.minimumSuccessPercentage = java.util.Objects.requireNonNull(builder.minimumSuccessPercentage, "minimumSuccessPercentage is required");
            }

            @Override
            public final java.lang.Number getMinimumSuccessPercentage() {
                return this.minimumSuccessPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("minimumSuccessPercentage", om.valueToTree(this.getMinimumSuccessPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.EcsUngracefulProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EcsUngracefulProperty.Jsii$Proxy that = (EcsUngracefulProperty.Jsii$Proxy) o;

                return this.minimumSuccessPercentage.equals(that.minimumSuccessPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.minimumSuccessPercentage.hashCode();
                return result;
            }
        }
    }
    /**
     * The AWS EKS cluster execution block configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * EksClusterProperty eksClusterProperty = EksClusterProperty.builder()
     *         .clusterArn("clusterArn")
     *         // the properties below are optional
     *         .crossAccountRole("crossAccountRole")
     *         .externalId("externalId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ekscluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ekscluster.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.EksClusterProperty")
    @software.amazon.jsii.Jsii.Proxy(EksClusterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksClusterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of an AWS EKS cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ekscluster.html#cfn-arcregionswitch-plan-ekscluster-clusterarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ekscluster.html#cfn-arcregionswitch-plan-ekscluster-clusterarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterArn();

        /**
         * The cross account role for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ekscluster.html#cfn-arcregionswitch-plan-ekscluster-crossaccountrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ekscluster.html#cfn-arcregionswitch-plan-ekscluster-crossaccountrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossAccountRole() {
            return null;
        }

        /**
         * The external ID (secret key) for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ekscluster.html#cfn-arcregionswitch-plan-ekscluster-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-ekscluster.html#cfn-arcregionswitch-plan-ekscluster-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksClusterProperty> {
            java.lang.String clusterArn;
            java.lang.String crossAccountRole;
            java.lang.String externalId;

            /**
             * Sets the value of {@link EksClusterProperty#getClusterArn}
             * @param clusterArn The Amazon Resource Name (ARN) of an AWS EKS cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterArn(java.lang.String clusterArn) {
                this.clusterArn = clusterArn;
                return this;
            }

            /**
             * Sets the value of {@link EksClusterProperty#getCrossAccountRole}
             * @param crossAccountRole The cross account role for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossAccountRole(java.lang.String crossAccountRole) {
                this.crossAccountRole = crossAccountRole;
                return this;
            }

            /**
             * Sets the value of {@link EksClusterProperty#getExternalId}
             * @param externalId The external ID (secret key) for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksClusterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksClusterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksClusterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksClusterProperty {
            private final java.lang.String clusterArn;
            private final java.lang.String crossAccountRole;
            private final java.lang.String externalId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterArn = software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crossAccountRole = software.amazon.jsii.Kernel.get(this, "crossAccountRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterArn = java.util.Objects.requireNonNull(builder.clusterArn, "clusterArn is required");
                this.crossAccountRole = builder.crossAccountRole;
                this.externalId = builder.externalId;
            }

            @Override
            public final java.lang.String getClusterArn() {
                return this.clusterArn;
            }

            @Override
            public final java.lang.String getCrossAccountRole() {
                return this.crossAccountRole;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterArn", om.valueToTree(this.getClusterArn()));
                if (this.getCrossAccountRole() != null) {
                    data.set("crossAccountRole", om.valueToTree(this.getCrossAccountRole()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.EksClusterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksClusterProperty.Jsii$Proxy that = (EksClusterProperty.Jsii$Proxy) o;

                if (!clusterArn.equals(that.clusterArn)) return false;
                if (this.crossAccountRole != null ? !this.crossAccountRole.equals(that.crossAccountRole) : that.crossAccountRole != null) return false;
                return this.externalId != null ? this.externalId.equals(that.externalId) : that.externalId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clusterArn.hashCode();
                result = 31 * result + (this.crossAccountRole != null ? this.crossAccountRole.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The AWS EKS resource scaling configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * EksResourceScalingConfigurationProperty eksResourceScalingConfigurationProperty = EksResourceScalingConfigurationProperty.builder()
     *         .kubernetesResourceType(KubernetesResourceTypeProperty.builder()
     *                 .apiVersion("apiVersion")
     *                 .kind("kind")
     *                 .build())
     *         // the properties below are optional
     *         .capacityMonitoringApproach("capacityMonitoringApproach")
     *         .eksClusters(List.of(EksClusterProperty.builder()
     *                 .clusterArn("clusterArn")
     *                 // the properties below are optional
     *                 .crossAccountRole("crossAccountRole")
     *                 .externalId("externalId")
     *                 .build()))
     *         .scalingResources(List.of(Map.of(
     *                 "scalingResourcesKey", Map.of(
     *                         "scalingResourcesKey", KubernetesScalingResourceProperty.builder()
     *                                 .name("name")
     *                                 .namespace("namespace")
     *                                 // the properties below are optional
     *                                 .hpaName("hpaName")
     *                                 .build()))))
     *         .targetPercent(123)
     *         .timeoutMinutes(123)
     *         .ungraceful(EksResourceScalingUngracefulProperty.builder()
     *                 .minimumSuccessPercentage(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.EksResourceScalingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EksResourceScalingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksResourceScalingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Kubernetes resource type for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-kubernetesresourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-kubernetesresourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKubernetesResourceType();

        /**
         * The monitoring approach for the configuration, that is, whether it was sampled in the last 24 hours or autoscaled in the last 24 hours.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-capacitymonitoringapproach">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-capacitymonitoringapproach</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityMonitoringApproach() {
            return null;
        }

        /**
         * The clusters for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-eksclusters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-eksclusters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEksClusters() {
            return null;
        }

        /**
         * The scaling resources for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-scalingresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-scalingresources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScalingResources() {
            return null;
        }

        /**
         * The target percentage for the configuration.
         * <p>
         * Default: - 100
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-targetpercent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-targetpercent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetPercent() {
            return null;
        }

        /**
         * The timeout value specified for the configuration.
         * <p>
         * Default: - 60
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-timeoutminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-timeoutminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutMinutes() {
            return null;
        }

        /**
         * The settings for ungraceful execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-ungraceful">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingconfiguration.html#cfn-arcregionswitch-plan-eksresourcescalingconfiguration-ungraceful</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUngraceful() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksResourceScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksResourceScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksResourceScalingConfigurationProperty> {
            java.lang.Object kubernetesResourceType;
            java.lang.String capacityMonitoringApproach;
            java.lang.Object eksClusters;
            java.lang.Object scalingResources;
            java.lang.Number targetPercent;
            java.lang.Number timeoutMinutes;
            java.lang.Object ungraceful;

            /**
             * Sets the value of {@link EksResourceScalingConfigurationProperty#getKubernetesResourceType}
             * @param kubernetesResourceType The Kubernetes resource type for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kubernetesResourceType(software.amazon.awscdk.IResolvable kubernetesResourceType) {
                this.kubernetesResourceType = kubernetesResourceType;
                return this;
            }

            /**
             * Sets the value of {@link EksResourceScalingConfigurationProperty#getKubernetesResourceType}
             * @param kubernetesResourceType The Kubernetes resource type for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kubernetesResourceType(software.amazon.awscdk.services.arcregionswitch.CfnPlan.KubernetesResourceTypeProperty kubernetesResourceType) {
                this.kubernetesResourceType = kubernetesResourceType;
                return this;
            }

            /**
             * Sets the value of {@link EksResourceScalingConfigurationProperty#getCapacityMonitoringApproach}
             * @param capacityMonitoringApproach The monitoring approach for the configuration, that is, whether it was sampled in the last 24 hours or autoscaled in the last 24 hours.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityMonitoringApproach(java.lang.String capacityMonitoringApproach) {
                this.capacityMonitoringApproach = capacityMonitoringApproach;
                return this;
            }

            /**
             * Sets the value of {@link EksResourceScalingConfigurationProperty#getEksClusters}
             * @param eksClusters The clusters for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eksClusters(software.amazon.awscdk.IResolvable eksClusters) {
                this.eksClusters = eksClusters;
                return this;
            }

            /**
             * Sets the value of {@link EksResourceScalingConfigurationProperty#getEksClusters}
             * @param eksClusters The clusters for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eksClusters(java.util.List<? extends java.lang.Object> eksClusters) {
                this.eksClusters = eksClusters;
                return this;
            }

            /**
             * Sets the value of {@link EksResourceScalingConfigurationProperty#getScalingResources}
             * @param scalingResources The scaling resources for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingResources(software.amazon.awscdk.IResolvable scalingResources) {
                this.scalingResources = scalingResources;
                return this;
            }

            /**
             * Sets the value of {@link EksResourceScalingConfigurationProperty#getScalingResources}
             * @param scalingResources The scaling resources for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scalingResources(java.util.List<? extends java.lang.Object> scalingResources) {
                this.scalingResources = scalingResources;
                return this;
            }

            /**
             * Sets the value of {@link EksResourceScalingConfigurationProperty#getTargetPercent}
             * @param targetPercent The target percentage for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetPercent(java.lang.Number targetPercent) {
                this.targetPercent = targetPercent;
                return this;
            }

            /**
             * Sets the value of {@link EksResourceScalingConfigurationProperty#getTimeoutMinutes}
             * @param timeoutMinutes The timeout value specified for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMinutes(java.lang.Number timeoutMinutes) {
                this.timeoutMinutes = timeoutMinutes;
                return this;
            }

            /**
             * Sets the value of {@link EksResourceScalingConfigurationProperty#getUngraceful}
             * @param ungraceful The settings for ungraceful execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ungraceful(software.amazon.awscdk.IResolvable ungraceful) {
                this.ungraceful = ungraceful;
                return this;
            }

            /**
             * Sets the value of {@link EksResourceScalingConfigurationProperty#getUngraceful}
             * @param ungraceful The settings for ungraceful execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ungraceful(software.amazon.awscdk.services.arcregionswitch.CfnPlan.EksResourceScalingUngracefulProperty ungraceful) {
                this.ungraceful = ungraceful;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksResourceScalingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksResourceScalingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksResourceScalingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksResourceScalingConfigurationProperty {
            private final java.lang.Object kubernetesResourceType;
            private final java.lang.String capacityMonitoringApproach;
            private final java.lang.Object eksClusters;
            private final java.lang.Object scalingResources;
            private final java.lang.Number targetPercent;
            private final java.lang.Number timeoutMinutes;
            private final java.lang.Object ungraceful;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kubernetesResourceType = software.amazon.jsii.Kernel.get(this, "kubernetesResourceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.capacityMonitoringApproach = software.amazon.jsii.Kernel.get(this, "capacityMonitoringApproach", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.eksClusters = software.amazon.jsii.Kernel.get(this, "eksClusters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scalingResources = software.amazon.jsii.Kernel.get(this, "scalingResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetPercent = software.amazon.jsii.Kernel.get(this, "targetPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeoutMinutes = software.amazon.jsii.Kernel.get(this, "timeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ungraceful = software.amazon.jsii.Kernel.get(this, "ungraceful", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kubernetesResourceType = java.util.Objects.requireNonNull(builder.kubernetesResourceType, "kubernetesResourceType is required");
                this.capacityMonitoringApproach = builder.capacityMonitoringApproach;
                this.eksClusters = builder.eksClusters;
                this.scalingResources = builder.scalingResources;
                this.targetPercent = builder.targetPercent;
                this.timeoutMinutes = builder.timeoutMinutes;
                this.ungraceful = builder.ungraceful;
            }

            @Override
            public final java.lang.Object getKubernetesResourceType() {
                return this.kubernetesResourceType;
            }

            @Override
            public final java.lang.String getCapacityMonitoringApproach() {
                return this.capacityMonitoringApproach;
            }

            @Override
            public final java.lang.Object getEksClusters() {
                return this.eksClusters;
            }

            @Override
            public final java.lang.Object getScalingResources() {
                return this.scalingResources;
            }

            @Override
            public final java.lang.Number getTargetPercent() {
                return this.targetPercent;
            }

            @Override
            public final java.lang.Number getTimeoutMinutes() {
                return this.timeoutMinutes;
            }

            @Override
            public final java.lang.Object getUngraceful() {
                return this.ungraceful;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kubernetesResourceType", om.valueToTree(this.getKubernetesResourceType()));
                if (this.getCapacityMonitoringApproach() != null) {
                    data.set("capacityMonitoringApproach", om.valueToTree(this.getCapacityMonitoringApproach()));
                }
                if (this.getEksClusters() != null) {
                    data.set("eksClusters", om.valueToTree(this.getEksClusters()));
                }
                if (this.getScalingResources() != null) {
                    data.set("scalingResources", om.valueToTree(this.getScalingResources()));
                }
                if (this.getTargetPercent() != null) {
                    data.set("targetPercent", om.valueToTree(this.getTargetPercent()));
                }
                if (this.getTimeoutMinutes() != null) {
                    data.set("timeoutMinutes", om.valueToTree(this.getTimeoutMinutes()));
                }
                if (this.getUngraceful() != null) {
                    data.set("ungraceful", om.valueToTree(this.getUngraceful()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.EksResourceScalingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksResourceScalingConfigurationProperty.Jsii$Proxy that = (EksResourceScalingConfigurationProperty.Jsii$Proxy) o;

                if (!kubernetesResourceType.equals(that.kubernetesResourceType)) return false;
                if (this.capacityMonitoringApproach != null ? !this.capacityMonitoringApproach.equals(that.capacityMonitoringApproach) : that.capacityMonitoringApproach != null) return false;
                if (this.eksClusters != null ? !this.eksClusters.equals(that.eksClusters) : that.eksClusters != null) return false;
                if (this.scalingResources != null ? !this.scalingResources.equals(that.scalingResources) : that.scalingResources != null) return false;
                if (this.targetPercent != null ? !this.targetPercent.equals(that.targetPercent) : that.targetPercent != null) return false;
                if (this.timeoutMinutes != null ? !this.timeoutMinutes.equals(that.timeoutMinutes) : that.timeoutMinutes != null) return false;
                return this.ungraceful != null ? this.ungraceful.equals(that.ungraceful) : that.ungraceful == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kubernetesResourceType.hashCode();
                result = 31 * result + (this.capacityMonitoringApproach != null ? this.capacityMonitoringApproach.hashCode() : 0);
                result = 31 * result + (this.eksClusters != null ? this.eksClusters.hashCode() : 0);
                result = 31 * result + (this.scalingResources != null ? this.scalingResources.hashCode() : 0);
                result = 31 * result + (this.targetPercent != null ? this.targetPercent.hashCode() : 0);
                result = 31 * result + (this.timeoutMinutes != null ? this.timeoutMinutes.hashCode() : 0);
                result = 31 * result + (this.ungraceful != null ? this.ungraceful.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The ungraceful settings for AWS EKS resource scaling.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * EksResourceScalingUngracefulProperty eksResourceScalingUngracefulProperty = EksResourceScalingUngracefulProperty.builder()
     *         .minimumSuccessPercentage(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingungraceful.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingungraceful.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.EksResourceScalingUngracefulProperty")
    @software.amazon.jsii.Jsii.Proxy(EksResourceScalingUngracefulProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksResourceScalingUngracefulProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum success percentage for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingungraceful.html#cfn-arcregionswitch-plan-eksresourcescalingungraceful-minimumsuccesspercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-eksresourcescalingungraceful.html#cfn-arcregionswitch-plan-eksresourcescalingungraceful-minimumsuccesspercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimumSuccessPercentage();

        /**
         * @return a {@link Builder} of {@link EksResourceScalingUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksResourceScalingUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksResourceScalingUngracefulProperty> {
            java.lang.Number minimumSuccessPercentage;

            /**
             * Sets the value of {@link EksResourceScalingUngracefulProperty#getMinimumSuccessPercentage}
             * @param minimumSuccessPercentage The minimum success percentage for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumSuccessPercentage(java.lang.Number minimumSuccessPercentage) {
                this.minimumSuccessPercentage = minimumSuccessPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksResourceScalingUngracefulProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksResourceScalingUngracefulProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksResourceScalingUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksResourceScalingUngracefulProperty {
            private final java.lang.Number minimumSuccessPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.minimumSuccessPercentage = software.amazon.jsii.Kernel.get(this, "minimumSuccessPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.minimumSuccessPercentage = java.util.Objects.requireNonNull(builder.minimumSuccessPercentage, "minimumSuccessPercentage is required");
            }

            @Override
            public final java.lang.Number getMinimumSuccessPercentage() {
                return this.minimumSuccessPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("minimumSuccessPercentage", om.valueToTree(this.getMinimumSuccessPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.EksResourceScalingUngracefulProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksResourceScalingUngracefulProperty.Jsii$Proxy that = (EksResourceScalingUngracefulProperty.Jsii$Proxy) o;

                return this.minimumSuccessPercentage.equals(that.minimumSuccessPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.minimumSuccessPercentage.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration for approval steps in a Region switch plan execution.
     * <p>
     * Approval steps require manual intervention before the execution can proceed.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * ExecutionApprovalConfigurationProperty executionApprovalConfigurationProperty = ExecutionApprovalConfigurationProperty.builder()
     *         .approvalRole("approvalRole")
     *         // the properties below are optional
     *         .timeoutMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionapprovalconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionapprovalconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.ExecutionApprovalConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExecutionApprovalConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExecutionApprovalConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IAM approval role for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionapprovalconfiguration.html#cfn-arcregionswitch-plan-executionapprovalconfiguration-approvalrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionapprovalconfiguration.html#cfn-arcregionswitch-plan-executionapprovalconfiguration-approvalrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApprovalRole();

        /**
         * The timeout value specified for the configuration.
         * <p>
         * Default: - 60
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionapprovalconfiguration.html#cfn-arcregionswitch-plan-executionapprovalconfiguration-timeoutminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionapprovalconfiguration.html#cfn-arcregionswitch-plan-executionapprovalconfiguration-timeoutminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExecutionApprovalConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExecutionApprovalConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExecutionApprovalConfigurationProperty> {
            java.lang.String approvalRole;
            java.lang.Number timeoutMinutes;

            /**
             * Sets the value of {@link ExecutionApprovalConfigurationProperty#getApprovalRole}
             * @param approvalRole The IAM approval role for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder approvalRole(java.lang.String approvalRole) {
                this.approvalRole = approvalRole;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionApprovalConfigurationProperty#getTimeoutMinutes}
             * @param timeoutMinutes The timeout value specified for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMinutes(java.lang.Number timeoutMinutes) {
                this.timeoutMinutes = timeoutMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExecutionApprovalConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExecutionApprovalConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExecutionApprovalConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecutionApprovalConfigurationProperty {
            private final java.lang.String approvalRole;
            private final java.lang.Number timeoutMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.approvalRole = software.amazon.jsii.Kernel.get(this, "approvalRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutMinutes = software.amazon.jsii.Kernel.get(this, "timeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.approvalRole = java.util.Objects.requireNonNull(builder.approvalRole, "approvalRole is required");
                this.timeoutMinutes = builder.timeoutMinutes;
            }

            @Override
            public final java.lang.String getApprovalRole() {
                return this.approvalRole;
            }

            @Override
            public final java.lang.Number getTimeoutMinutes() {
                return this.timeoutMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("approvalRole", om.valueToTree(this.getApprovalRole()));
                if (this.getTimeoutMinutes() != null) {
                    data.set("timeoutMinutes", om.valueToTree(this.getTimeoutMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.ExecutionApprovalConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExecutionApprovalConfigurationProperty.Jsii$Proxy that = (ExecutionApprovalConfigurationProperty.Jsii$Proxy) o;

                if (!approvalRole.equals(that.approvalRole)) return false;
                return this.timeoutMinutes != null ? this.timeoutMinutes.equals(that.timeoutMinutes) : that.timeoutMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.approvalRole.hashCode();
                result = 31 * result + (this.timeoutMinutes != null ? this.timeoutMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Execution block configurations for a workflow in a Region switch plan.
     * <p>
     * An execution block represents a specific type of action to perform during a Region switch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * ExecutionBlockConfigurationProperty executionBlockConfigurationProperty_;
     * ExecutionBlockConfigurationProperty executionBlockConfigurationProperty = ExecutionBlockConfigurationProperty.builder()
     *         .arcRoutingControlConfig(ArcRoutingControlConfigurationProperty.builder()
     *                 .regionAndRoutingControls(Map.of(
     *                         "regionAndRoutingControlsKey", List.of(ArcRoutingControlStateProperty.builder()
     *                                 .routingControlArn("routingControlArn")
     *                                 .state("state")
     *                                 .build())))
     *                 // the properties below are optional
     *                 .crossAccountRole("crossAccountRole")
     *                 .externalId("externalId")
     *                 .timeoutMinutes(123)
     *                 .build())
     *         .customActionLambdaConfig(CustomActionLambdaConfigurationProperty.builder()
     *                 .lambdas(List.of(LambdasProperty.builder()
     *                         .arn("arn")
     *                         .crossAccountRole("crossAccountRole")
     *                         .externalId("externalId")
     *                         .build()))
     *                 .regionToRun("regionToRun")
     *                 .retryIntervalMinutes(123)
     *                 // the properties below are optional
     *                 .timeoutMinutes(123)
     *                 .ungraceful(LambdaUngracefulProperty.builder()
     *                         .behavior("behavior")
     *                         .build())
     *                 .build())
     *         .ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfigurationProperty.builder()
     *                 .asgs(List.of(AsgProperty.builder()
     *                         .arn("arn")
     *                         .crossAccountRole("crossAccountRole")
     *                         .externalId("externalId")
     *                         .build()))
     *                 // the properties below are optional
     *                 .capacityMonitoringApproach("capacityMonitoringApproach")
     *                 .targetPercent(123)
     *                 .timeoutMinutes(123)
     *                 .ungraceful(Ec2UngracefulProperty.builder()
     *                         .minimumSuccessPercentage(123)
     *                         .build())
     *                 .build())
     *         .ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfigurationProperty.builder()
     *                 .services(List.of(ServiceProperty.builder()
     *                         .clusterArn("clusterArn")
     *                         .crossAccountRole("crossAccountRole")
     *                         .externalId("externalId")
     *                         .serviceArn("serviceArn")
     *                         .build()))
     *                 // the properties below are optional
     *                 .capacityMonitoringApproach("capacityMonitoringApproach")
     *                 .targetPercent(123)
     *                 .timeoutMinutes(123)
     *                 .ungraceful(EcsUngracefulProperty.builder()
     *                         .minimumSuccessPercentage(123)
     *                         .build())
     *                 .build())
     *         .eksResourceScalingConfig(EksResourceScalingConfigurationProperty.builder()
     *                 .kubernetesResourceType(KubernetesResourceTypeProperty.builder()
     *                         .apiVersion("apiVersion")
     *                         .kind("kind")
     *                         .build())
     *                 // the properties below are optional
     *                 .capacityMonitoringApproach("capacityMonitoringApproach")
     *                 .eksClusters(List.of(EksClusterProperty.builder()
     *                         .clusterArn("clusterArn")
     *                         // the properties below are optional
     *                         .crossAccountRole("crossAccountRole")
     *                         .externalId("externalId")
     *                         .build()))
     *                 .scalingResources(List.of(Map.of(
     *                         "scalingResourcesKey", Map.of(
     *                                 "scalingResourcesKey", KubernetesScalingResourceProperty.builder()
     *                                         .name("name")
     *                                         .namespace("namespace")
     *                                         // the properties below are optional
     *                                         .hpaName("hpaName")
     *                                         .build()))))
     *                 .targetPercent(123)
     *                 .timeoutMinutes(123)
     *                 .ungraceful(EksResourceScalingUngracefulProperty.builder()
     *                         .minimumSuccessPercentage(123)
     *                         .build())
     *                 .build())
     *         .executionApprovalConfig(ExecutionApprovalConfigurationProperty.builder()
     *                 .approvalRole("approvalRole")
     *                 // the properties below are optional
     *                 .timeoutMinutes(123)
     *                 .build())
     *         .globalAuroraConfig(GlobalAuroraConfigurationProperty.builder()
     *                 .behavior("behavior")
     *                 .databaseClusterArns(List.of("databaseClusterArns"))
     *                 .globalClusterIdentifier("globalClusterIdentifier")
     *                 // the properties below are optional
     *                 .crossAccountRole("crossAccountRole")
     *                 .externalId("externalId")
     *                 .timeoutMinutes(123)
     *                 .ungraceful(GlobalAuroraUngracefulProperty.builder()
     *                         .ungraceful("ungraceful")
     *                         .build())
     *                 .build())
     *         .parallelConfig(ParallelExecutionBlockConfigurationProperty.builder()
     *                 .steps(List.of(StepProperty.builder()
     *                         .executionBlockConfiguration(executionBlockConfigurationProperty_)
     *                         .executionBlockType("executionBlockType")
     *                         .name("name")
     *                         // the properties below are optional
     *                         .description("description")
     *                         .build()))
     *                 .build())
     *         .regionSwitchPlanConfig(RegionSwitchPlanConfigurationProperty.builder()
     *                 .arn("arn")
     *                 // the properties below are optional
     *                 .crossAccountRole("crossAccountRole")
     *                 .externalId("externalId")
     *                 .build())
     *         .route53HealthCheckConfig(Route53HealthCheckConfigurationProperty.builder()
     *                 .hostedZoneId("hostedZoneId")
     *                 .recordName("recordName")
     *                 // the properties below are optional
     *                 .crossAccountRole("crossAccountRole")
     *                 .externalId("externalId")
     *                 .recordSets(List.of(Route53ResourceRecordSetProperty.builder()
     *                         .recordSetIdentifier("recordSetIdentifier")
     *                         .region("region")
     *                         .build()))
     *                 .timeoutMinutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.ExecutionBlockConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExecutionBlockConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExecutionBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An ARC routing control execution block.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-arcroutingcontrolconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-arcroutingcontrolconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getArcRoutingControlConfig() {
            return null;
        }

        /**
         * An AWS Lambda execution block.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-customactionlambdaconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-customactionlambdaconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomActionLambdaConfig() {
            return null;
        }

        /**
         * An EC2 Auto Scaling group execution block.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-ec2asgcapacityincreaseconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-ec2asgcapacityincreaseconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEc2AsgCapacityIncreaseConfig() {
            return null;
        }

        /**
         * The capacity increase specified for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-ecscapacityincreaseconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-ecscapacityincreaseconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEcsCapacityIncreaseConfig() {
            return null;
        }

        /**
         * An AWS EKS resource scaling execution block.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-eksresourcescalingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-eksresourcescalingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEksResourceScalingConfig() {
            return null;
        }

        /**
         * A manual approval execution block.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-executionapprovalconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-executionapprovalconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExecutionApprovalConfig() {
            return null;
        }

        /**
         * An Aurora Global Database execution block.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-globalauroraconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-globalauroraconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlobalAuroraConfig() {
            return null;
        }

        /**
         * A parallel configuration execution block.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-parallelconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-parallelconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParallelConfig() {
            return null;
        }

        /**
         * A Region switch plan execution block.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-regionswitchplanconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-regionswitchplanconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRegionSwitchPlanConfig() {
            return null;
        }

        /**
         * The Amazon Route 53 health check configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-route53healthcheckconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-executionblockconfiguration.html#cfn-arcregionswitch-plan-executionblockconfiguration-route53healthcheckconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoute53HealthCheckConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExecutionBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExecutionBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExecutionBlockConfigurationProperty> {
            java.lang.Object arcRoutingControlConfig;
            java.lang.Object customActionLambdaConfig;
            java.lang.Object ec2AsgCapacityIncreaseConfig;
            java.lang.Object ecsCapacityIncreaseConfig;
            java.lang.Object eksResourceScalingConfig;
            java.lang.Object executionApprovalConfig;
            java.lang.Object globalAuroraConfig;
            java.lang.Object parallelConfig;
            java.lang.Object regionSwitchPlanConfig;
            java.lang.Object route53HealthCheckConfig;

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getArcRoutingControlConfig}
             * @param arcRoutingControlConfig An ARC routing control execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arcRoutingControlConfig(software.amazon.awscdk.IResolvable arcRoutingControlConfig) {
                this.arcRoutingControlConfig = arcRoutingControlConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getArcRoutingControlConfig}
             * @param arcRoutingControlConfig An ARC routing control execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arcRoutingControlConfig(software.amazon.awscdk.services.arcregionswitch.CfnPlan.ArcRoutingControlConfigurationProperty arcRoutingControlConfig) {
                this.arcRoutingControlConfig = arcRoutingControlConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getCustomActionLambdaConfig}
             * @param customActionLambdaConfig An AWS Lambda execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customActionLambdaConfig(software.amazon.awscdk.IResolvable customActionLambdaConfig) {
                this.customActionLambdaConfig = customActionLambdaConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getCustomActionLambdaConfig}
             * @param customActionLambdaConfig An AWS Lambda execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customActionLambdaConfig(software.amazon.awscdk.services.arcregionswitch.CfnPlan.CustomActionLambdaConfigurationProperty customActionLambdaConfig) {
                this.customActionLambdaConfig = customActionLambdaConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getEc2AsgCapacityIncreaseConfig}
             * @param ec2AsgCapacityIncreaseConfig An EC2 Auto Scaling group execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2AsgCapacityIncreaseConfig(software.amazon.awscdk.IResolvable ec2AsgCapacityIncreaseConfig) {
                this.ec2AsgCapacityIncreaseConfig = ec2AsgCapacityIncreaseConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getEc2AsgCapacityIncreaseConfig}
             * @param ec2AsgCapacityIncreaseConfig An EC2 Auto Scaling group execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2AsgCapacityIncreaseConfig(software.amazon.awscdk.services.arcregionswitch.CfnPlan.Ec2AsgCapacityIncreaseConfigurationProperty ec2AsgCapacityIncreaseConfig) {
                this.ec2AsgCapacityIncreaseConfig = ec2AsgCapacityIncreaseConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getEcsCapacityIncreaseConfig}
             * @param ecsCapacityIncreaseConfig The capacity increase specified for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecsCapacityIncreaseConfig(software.amazon.awscdk.IResolvable ecsCapacityIncreaseConfig) {
                this.ecsCapacityIncreaseConfig = ecsCapacityIncreaseConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getEcsCapacityIncreaseConfig}
             * @param ecsCapacityIncreaseConfig The capacity increase specified for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ecsCapacityIncreaseConfig(software.amazon.awscdk.services.arcregionswitch.CfnPlan.EcsCapacityIncreaseConfigurationProperty ecsCapacityIncreaseConfig) {
                this.ecsCapacityIncreaseConfig = ecsCapacityIncreaseConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getEksResourceScalingConfig}
             * @param eksResourceScalingConfig An AWS EKS resource scaling execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eksResourceScalingConfig(software.amazon.awscdk.IResolvable eksResourceScalingConfig) {
                this.eksResourceScalingConfig = eksResourceScalingConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getEksResourceScalingConfig}
             * @param eksResourceScalingConfig An AWS EKS resource scaling execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eksResourceScalingConfig(software.amazon.awscdk.services.arcregionswitch.CfnPlan.EksResourceScalingConfigurationProperty eksResourceScalingConfig) {
                this.eksResourceScalingConfig = eksResourceScalingConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getExecutionApprovalConfig}
             * @param executionApprovalConfig A manual approval execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionApprovalConfig(software.amazon.awscdk.IResolvable executionApprovalConfig) {
                this.executionApprovalConfig = executionApprovalConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getExecutionApprovalConfig}
             * @param executionApprovalConfig A manual approval execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionApprovalConfig(software.amazon.awscdk.services.arcregionswitch.CfnPlan.ExecutionApprovalConfigurationProperty executionApprovalConfig) {
                this.executionApprovalConfig = executionApprovalConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getGlobalAuroraConfig}
             * @param globalAuroraConfig An Aurora Global Database execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalAuroraConfig(software.amazon.awscdk.IResolvable globalAuroraConfig) {
                this.globalAuroraConfig = globalAuroraConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getGlobalAuroraConfig}
             * @param globalAuroraConfig An Aurora Global Database execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalAuroraConfig(software.amazon.awscdk.services.arcregionswitch.CfnPlan.GlobalAuroraConfigurationProperty globalAuroraConfig) {
                this.globalAuroraConfig = globalAuroraConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getParallelConfig}
             * @param parallelConfig A parallel configuration execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelConfig(software.amazon.awscdk.IResolvable parallelConfig) {
                this.parallelConfig = parallelConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getParallelConfig}
             * @param parallelConfig A parallel configuration execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelConfig(software.amazon.awscdk.services.arcregionswitch.CfnPlan.ParallelExecutionBlockConfigurationProperty parallelConfig) {
                this.parallelConfig = parallelConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getRegionSwitchPlanConfig}
             * @param regionSwitchPlanConfig A Region switch plan execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regionSwitchPlanConfig(software.amazon.awscdk.IResolvable regionSwitchPlanConfig) {
                this.regionSwitchPlanConfig = regionSwitchPlanConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getRegionSwitchPlanConfig}
             * @param regionSwitchPlanConfig A Region switch plan execution block.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regionSwitchPlanConfig(software.amazon.awscdk.services.arcregionswitch.CfnPlan.RegionSwitchPlanConfigurationProperty regionSwitchPlanConfig) {
                this.regionSwitchPlanConfig = regionSwitchPlanConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getRoute53HealthCheckConfig}
             * @param route53HealthCheckConfig The Amazon Route 53 health check configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder route53HealthCheckConfig(software.amazon.awscdk.IResolvable route53HealthCheckConfig) {
                this.route53HealthCheckConfig = route53HealthCheckConfig;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionBlockConfigurationProperty#getRoute53HealthCheckConfig}
             * @param route53HealthCheckConfig The Amazon Route 53 health check configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder route53HealthCheckConfig(software.amazon.awscdk.services.arcregionswitch.CfnPlan.Route53HealthCheckConfigurationProperty route53HealthCheckConfig) {
                this.route53HealthCheckConfig = route53HealthCheckConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExecutionBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExecutionBlockConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExecutionBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecutionBlockConfigurationProperty {
            private final java.lang.Object arcRoutingControlConfig;
            private final java.lang.Object customActionLambdaConfig;
            private final java.lang.Object ec2AsgCapacityIncreaseConfig;
            private final java.lang.Object ecsCapacityIncreaseConfig;
            private final java.lang.Object eksResourceScalingConfig;
            private final java.lang.Object executionApprovalConfig;
            private final java.lang.Object globalAuroraConfig;
            private final java.lang.Object parallelConfig;
            private final java.lang.Object regionSwitchPlanConfig;
            private final java.lang.Object route53HealthCheckConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arcRoutingControlConfig = software.amazon.jsii.Kernel.get(this, "arcRoutingControlConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customActionLambdaConfig = software.amazon.jsii.Kernel.get(this, "customActionLambdaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ec2AsgCapacityIncreaseConfig = software.amazon.jsii.Kernel.get(this, "ec2AsgCapacityIncreaseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ecsCapacityIncreaseConfig = software.amazon.jsii.Kernel.get(this, "ecsCapacityIncreaseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eksResourceScalingConfig = software.amazon.jsii.Kernel.get(this, "eksResourceScalingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionApprovalConfig = software.amazon.jsii.Kernel.get(this, "executionApprovalConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.globalAuroraConfig = software.amazon.jsii.Kernel.get(this, "globalAuroraConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parallelConfig = software.amazon.jsii.Kernel.get(this, "parallelConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regionSwitchPlanConfig = software.amazon.jsii.Kernel.get(this, "regionSwitchPlanConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.route53HealthCheckConfig = software.amazon.jsii.Kernel.get(this, "route53HealthCheckConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arcRoutingControlConfig = builder.arcRoutingControlConfig;
                this.customActionLambdaConfig = builder.customActionLambdaConfig;
                this.ec2AsgCapacityIncreaseConfig = builder.ec2AsgCapacityIncreaseConfig;
                this.ecsCapacityIncreaseConfig = builder.ecsCapacityIncreaseConfig;
                this.eksResourceScalingConfig = builder.eksResourceScalingConfig;
                this.executionApprovalConfig = builder.executionApprovalConfig;
                this.globalAuroraConfig = builder.globalAuroraConfig;
                this.parallelConfig = builder.parallelConfig;
                this.regionSwitchPlanConfig = builder.regionSwitchPlanConfig;
                this.route53HealthCheckConfig = builder.route53HealthCheckConfig;
            }

            @Override
            public final java.lang.Object getArcRoutingControlConfig() {
                return this.arcRoutingControlConfig;
            }

            @Override
            public final java.lang.Object getCustomActionLambdaConfig() {
                return this.customActionLambdaConfig;
            }

            @Override
            public final java.lang.Object getEc2AsgCapacityIncreaseConfig() {
                return this.ec2AsgCapacityIncreaseConfig;
            }

            @Override
            public final java.lang.Object getEcsCapacityIncreaseConfig() {
                return this.ecsCapacityIncreaseConfig;
            }

            @Override
            public final java.lang.Object getEksResourceScalingConfig() {
                return this.eksResourceScalingConfig;
            }

            @Override
            public final java.lang.Object getExecutionApprovalConfig() {
                return this.executionApprovalConfig;
            }

            @Override
            public final java.lang.Object getGlobalAuroraConfig() {
                return this.globalAuroraConfig;
            }

            @Override
            public final java.lang.Object getParallelConfig() {
                return this.parallelConfig;
            }

            @Override
            public final java.lang.Object getRegionSwitchPlanConfig() {
                return this.regionSwitchPlanConfig;
            }

            @Override
            public final java.lang.Object getRoute53HealthCheckConfig() {
                return this.route53HealthCheckConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArcRoutingControlConfig() != null) {
                    data.set("arcRoutingControlConfig", om.valueToTree(this.getArcRoutingControlConfig()));
                }
                if (this.getCustomActionLambdaConfig() != null) {
                    data.set("customActionLambdaConfig", om.valueToTree(this.getCustomActionLambdaConfig()));
                }
                if (this.getEc2AsgCapacityIncreaseConfig() != null) {
                    data.set("ec2AsgCapacityIncreaseConfig", om.valueToTree(this.getEc2AsgCapacityIncreaseConfig()));
                }
                if (this.getEcsCapacityIncreaseConfig() != null) {
                    data.set("ecsCapacityIncreaseConfig", om.valueToTree(this.getEcsCapacityIncreaseConfig()));
                }
                if (this.getEksResourceScalingConfig() != null) {
                    data.set("eksResourceScalingConfig", om.valueToTree(this.getEksResourceScalingConfig()));
                }
                if (this.getExecutionApprovalConfig() != null) {
                    data.set("executionApprovalConfig", om.valueToTree(this.getExecutionApprovalConfig()));
                }
                if (this.getGlobalAuroraConfig() != null) {
                    data.set("globalAuroraConfig", om.valueToTree(this.getGlobalAuroraConfig()));
                }
                if (this.getParallelConfig() != null) {
                    data.set("parallelConfig", om.valueToTree(this.getParallelConfig()));
                }
                if (this.getRegionSwitchPlanConfig() != null) {
                    data.set("regionSwitchPlanConfig", om.valueToTree(this.getRegionSwitchPlanConfig()));
                }
                if (this.getRoute53HealthCheckConfig() != null) {
                    data.set("route53HealthCheckConfig", om.valueToTree(this.getRoute53HealthCheckConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.ExecutionBlockConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExecutionBlockConfigurationProperty.Jsii$Proxy that = (ExecutionBlockConfigurationProperty.Jsii$Proxy) o;

                if (this.arcRoutingControlConfig != null ? !this.arcRoutingControlConfig.equals(that.arcRoutingControlConfig) : that.arcRoutingControlConfig != null) return false;
                if (this.customActionLambdaConfig != null ? !this.customActionLambdaConfig.equals(that.customActionLambdaConfig) : that.customActionLambdaConfig != null) return false;
                if (this.ec2AsgCapacityIncreaseConfig != null ? !this.ec2AsgCapacityIncreaseConfig.equals(that.ec2AsgCapacityIncreaseConfig) : that.ec2AsgCapacityIncreaseConfig != null) return false;
                if (this.ecsCapacityIncreaseConfig != null ? !this.ecsCapacityIncreaseConfig.equals(that.ecsCapacityIncreaseConfig) : that.ecsCapacityIncreaseConfig != null) return false;
                if (this.eksResourceScalingConfig != null ? !this.eksResourceScalingConfig.equals(that.eksResourceScalingConfig) : that.eksResourceScalingConfig != null) return false;
                if (this.executionApprovalConfig != null ? !this.executionApprovalConfig.equals(that.executionApprovalConfig) : that.executionApprovalConfig != null) return false;
                if (this.globalAuroraConfig != null ? !this.globalAuroraConfig.equals(that.globalAuroraConfig) : that.globalAuroraConfig != null) return false;
                if (this.parallelConfig != null ? !this.parallelConfig.equals(that.parallelConfig) : that.parallelConfig != null) return false;
                if (this.regionSwitchPlanConfig != null ? !this.regionSwitchPlanConfig.equals(that.regionSwitchPlanConfig) : that.regionSwitchPlanConfig != null) return false;
                return this.route53HealthCheckConfig != null ? this.route53HealthCheckConfig.equals(that.route53HealthCheckConfig) : that.route53HealthCheckConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arcRoutingControlConfig != null ? this.arcRoutingControlConfig.hashCode() : 0;
                result = 31 * result + (this.customActionLambdaConfig != null ? this.customActionLambdaConfig.hashCode() : 0);
                result = 31 * result + (this.ec2AsgCapacityIncreaseConfig != null ? this.ec2AsgCapacityIncreaseConfig.hashCode() : 0);
                result = 31 * result + (this.ecsCapacityIncreaseConfig != null ? this.ecsCapacityIncreaseConfig.hashCode() : 0);
                result = 31 * result + (this.eksResourceScalingConfig != null ? this.eksResourceScalingConfig.hashCode() : 0);
                result = 31 * result + (this.executionApprovalConfig != null ? this.executionApprovalConfig.hashCode() : 0);
                result = 31 * result + (this.globalAuroraConfig != null ? this.globalAuroraConfig.hashCode() : 0);
                result = 31 * result + (this.parallelConfig != null ? this.parallelConfig.hashCode() : 0);
                result = 31 * result + (this.regionSwitchPlanConfig != null ? this.regionSwitchPlanConfig.hashCode() : 0);
                result = 31 * result + (this.route53HealthCheckConfig != null ? this.route53HealthCheckConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for Amazon Aurora global databases used in a Region switch plan.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * GlobalAuroraConfigurationProperty globalAuroraConfigurationProperty = GlobalAuroraConfigurationProperty.builder()
     *         .behavior("behavior")
     *         .databaseClusterArns(List.of("databaseClusterArns"))
     *         .globalClusterIdentifier("globalClusterIdentifier")
     *         // the properties below are optional
     *         .crossAccountRole("crossAccountRole")
     *         .externalId("externalId")
     *         .timeoutMinutes(123)
     *         .ungraceful(GlobalAuroraUngracefulProperty.builder()
     *                 .ungraceful("ungraceful")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.GlobalAuroraConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(GlobalAuroraConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlobalAuroraConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The behavior for a global database, that is, only allow switchover or also allow failover.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-behavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-behavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBehavior();

        /**
         * The database cluster Amazon Resource Names (ARNs) for a global database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-databaseclusterarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-databaseclusterarns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDatabaseClusterArns();

        /**
         * The global cluster identifier for a global database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-globalclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-globalclusteridentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGlobalClusterIdentifier();

        /**
         * The cross account role for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-crossaccountrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-crossaccountrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossAccountRole() {
            return null;
        }

        /**
         * The external ID (secret key) for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The timeout value specified for the configuration.
         * <p>
         * Default: - 60
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-timeoutminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-timeoutminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutMinutes() {
            return null;
        }

        /**
         * The settings for ungraceful execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-ungraceful">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraconfiguration.html#cfn-arcregionswitch-plan-globalauroraconfiguration-ungraceful</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUngraceful() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlobalAuroraConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlobalAuroraConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlobalAuroraConfigurationProperty> {
            java.lang.String behavior;
            java.util.List<java.lang.String> databaseClusterArns;
            java.lang.String globalClusterIdentifier;
            java.lang.String crossAccountRole;
            java.lang.String externalId;
            java.lang.Number timeoutMinutes;
            java.lang.Object ungraceful;

            /**
             * Sets the value of {@link GlobalAuroraConfigurationProperty#getBehavior}
             * @param behavior The behavior for a global database, that is, only allow switchover or also allow failover. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder behavior(java.lang.String behavior) {
                this.behavior = behavior;
                return this;
            }

            /**
             * Sets the value of {@link GlobalAuroraConfigurationProperty#getDatabaseClusterArns}
             * @param databaseClusterArns The database cluster Amazon Resource Names (ARNs) for a global database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseClusterArns(java.util.List<java.lang.String> databaseClusterArns) {
                this.databaseClusterArns = databaseClusterArns;
                return this;
            }

            /**
             * Sets the value of {@link GlobalAuroraConfigurationProperty#getGlobalClusterIdentifier}
             * @param globalClusterIdentifier The global cluster identifier for a global database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalClusterIdentifier(java.lang.String globalClusterIdentifier) {
                this.globalClusterIdentifier = globalClusterIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link GlobalAuroraConfigurationProperty#getCrossAccountRole}
             * @param crossAccountRole The cross account role for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossAccountRole(java.lang.String crossAccountRole) {
                this.crossAccountRole = crossAccountRole;
                return this;
            }

            /**
             * Sets the value of {@link GlobalAuroraConfigurationProperty#getExternalId}
             * @param externalId The external ID (secret key) for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link GlobalAuroraConfigurationProperty#getTimeoutMinutes}
             * @param timeoutMinutes The timeout value specified for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMinutes(java.lang.Number timeoutMinutes) {
                this.timeoutMinutes = timeoutMinutes;
                return this;
            }

            /**
             * Sets the value of {@link GlobalAuroraConfigurationProperty#getUngraceful}
             * @param ungraceful The settings for ungraceful execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ungraceful(software.amazon.awscdk.IResolvable ungraceful) {
                this.ungraceful = ungraceful;
                return this;
            }

            /**
             * Sets the value of {@link GlobalAuroraConfigurationProperty#getUngraceful}
             * @param ungraceful The settings for ungraceful execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ungraceful(software.amazon.awscdk.services.arcregionswitch.CfnPlan.GlobalAuroraUngracefulProperty ungraceful) {
                this.ungraceful = ungraceful;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlobalAuroraConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlobalAuroraConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlobalAuroraConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalAuroraConfigurationProperty {
            private final java.lang.String behavior;
            private final java.util.List<java.lang.String> databaseClusterArns;
            private final java.lang.String globalClusterIdentifier;
            private final java.lang.String crossAccountRole;
            private final java.lang.String externalId;
            private final java.lang.Number timeoutMinutes;
            private final java.lang.Object ungraceful;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.behavior = software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseClusterArns = software.amazon.jsii.Kernel.get(this, "databaseClusterArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.globalClusterIdentifier = software.amazon.jsii.Kernel.get(this, "globalClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crossAccountRole = software.amazon.jsii.Kernel.get(this, "crossAccountRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutMinutes = software.amazon.jsii.Kernel.get(this, "timeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.ungraceful = software.amazon.jsii.Kernel.get(this, "ungraceful", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.behavior = java.util.Objects.requireNonNull(builder.behavior, "behavior is required");
                this.databaseClusterArns = java.util.Objects.requireNonNull(builder.databaseClusterArns, "databaseClusterArns is required");
                this.globalClusterIdentifier = java.util.Objects.requireNonNull(builder.globalClusterIdentifier, "globalClusterIdentifier is required");
                this.crossAccountRole = builder.crossAccountRole;
                this.externalId = builder.externalId;
                this.timeoutMinutes = builder.timeoutMinutes;
                this.ungraceful = builder.ungraceful;
            }

            @Override
            public final java.lang.String getBehavior() {
                return this.behavior;
            }

            @Override
            public final java.util.List<java.lang.String> getDatabaseClusterArns() {
                return this.databaseClusterArns;
            }

            @Override
            public final java.lang.String getGlobalClusterIdentifier() {
                return this.globalClusterIdentifier;
            }

            @Override
            public final java.lang.String getCrossAccountRole() {
                return this.crossAccountRole;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.Number getTimeoutMinutes() {
                return this.timeoutMinutes;
            }

            @Override
            public final java.lang.Object getUngraceful() {
                return this.ungraceful;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("behavior", om.valueToTree(this.getBehavior()));
                data.set("databaseClusterArns", om.valueToTree(this.getDatabaseClusterArns()));
                data.set("globalClusterIdentifier", om.valueToTree(this.getGlobalClusterIdentifier()));
                if (this.getCrossAccountRole() != null) {
                    data.set("crossAccountRole", om.valueToTree(this.getCrossAccountRole()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getTimeoutMinutes() != null) {
                    data.set("timeoutMinutes", om.valueToTree(this.getTimeoutMinutes()));
                }
                if (this.getUngraceful() != null) {
                    data.set("ungraceful", om.valueToTree(this.getUngraceful()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.GlobalAuroraConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlobalAuroraConfigurationProperty.Jsii$Proxy that = (GlobalAuroraConfigurationProperty.Jsii$Proxy) o;

                if (!behavior.equals(that.behavior)) return false;
                if (!databaseClusterArns.equals(that.databaseClusterArns)) return false;
                if (!globalClusterIdentifier.equals(that.globalClusterIdentifier)) return false;
                if (this.crossAccountRole != null ? !this.crossAccountRole.equals(that.crossAccountRole) : that.crossAccountRole != null) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                if (this.timeoutMinutes != null ? !this.timeoutMinutes.equals(that.timeoutMinutes) : that.timeoutMinutes != null) return false;
                return this.ungraceful != null ? this.ungraceful.equals(that.ungraceful) : that.ungraceful == null;
            }

            @Override
            public final int hashCode() {
                int result = this.behavior.hashCode();
                result = 31 * result + (this.databaseClusterArns.hashCode());
                result = 31 * result + (this.globalClusterIdentifier.hashCode());
                result = 31 * result + (this.crossAccountRole != null ? this.crossAccountRole.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.timeoutMinutes != null ? this.timeoutMinutes.hashCode() : 0);
                result = 31 * result + (this.ungraceful != null ? this.ungraceful.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for handling failures when performing operations on Aurora global databases.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * GlobalAuroraUngracefulProperty globalAuroraUngracefulProperty = GlobalAuroraUngracefulProperty.builder()
     *         .ungraceful("ungraceful")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraungraceful.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraungraceful.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.GlobalAuroraUngracefulProperty")
    @software.amazon.jsii.Jsii.Proxy(GlobalAuroraUngracefulProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlobalAuroraUngracefulProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The settings for ungraceful execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraungraceful.html#cfn-arcregionswitch-plan-globalauroraungraceful-ungraceful">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-globalauroraungraceful.html#cfn-arcregionswitch-plan-globalauroraungraceful-ungraceful</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUngraceful() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GlobalAuroraUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlobalAuroraUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlobalAuroraUngracefulProperty> {
            java.lang.String ungraceful;

            /**
             * Sets the value of {@link GlobalAuroraUngracefulProperty#getUngraceful}
             * @param ungraceful The settings for ungraceful execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ungraceful(java.lang.String ungraceful) {
                this.ungraceful = ungraceful;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlobalAuroraUngracefulProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlobalAuroraUngracefulProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlobalAuroraUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalAuroraUngracefulProperty {
            private final java.lang.String ungraceful;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ungraceful = software.amazon.jsii.Kernel.get(this, "ungraceful", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ungraceful = builder.ungraceful;
            }

            @Override
            public final java.lang.String getUngraceful() {
                return this.ungraceful;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUngraceful() != null) {
                    data.set("ungraceful", om.valueToTree(this.getUngraceful()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.GlobalAuroraUngracefulProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlobalAuroraUngracefulProperty.Jsii$Proxy that = (GlobalAuroraUngracefulProperty.Jsii$Proxy) o;

                return this.ungraceful != null ? this.ungraceful.equals(that.ungraceful) : that.ungraceful == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ungraceful != null ? this.ungraceful.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * HealthCheckStateProperty healthCheckStateProperty = HealthCheckStateProperty.builder()
     *         .healthCheckId("healthCheckId")
     *         .region("region")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-healthcheckstate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-healthcheckstate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.HealthCheckStateProperty")
    @software.amazon.jsii.Jsii.Proxy(HealthCheckStateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HealthCheckStateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-healthcheckstate.html#cfn-arcregionswitch-plan-healthcheckstate-healthcheckid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-healthcheckstate.html#cfn-arcregionswitch-plan-healthcheckstate-healthcheckid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckId() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-healthcheckstate.html#cfn-arcregionswitch-plan-healthcheckstate-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-healthcheckstate.html#cfn-arcregionswitch-plan-healthcheckstate-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HealthCheckStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HealthCheckStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HealthCheckStateProperty> {
            java.lang.String healthCheckId;
            java.lang.String region;

            /**
             * Sets the value of {@link HealthCheckStateProperty#getHealthCheckId}
             * @param healthCheckId the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheckId(java.lang.String healthCheckId) {
                this.healthCheckId = healthCheckId;
                return this;
            }

            /**
             * Sets the value of {@link HealthCheckStateProperty#getRegion}
             * @param region the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HealthCheckStateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HealthCheckStateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HealthCheckStateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheckStateProperty {
            private final java.lang.String healthCheckId;
            private final java.lang.String region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.healthCheckId = software.amazon.jsii.Kernel.get(this, "healthCheckId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.healthCheckId = builder.healthCheckId;
                this.region = builder.region;
            }

            @Override
            public final java.lang.String getHealthCheckId() {
                return this.healthCheckId;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHealthCheckId() != null) {
                    data.set("healthCheckId", om.valueToTree(this.getHealthCheckId()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.HealthCheckStateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HealthCheckStateProperty.Jsii$Proxy that = (HealthCheckStateProperty.Jsii$Proxy) o;

                if (this.healthCheckId != null ? !this.healthCheckId.equals(that.healthCheckId) : that.healthCheckId != null) return false;
                return this.region != null ? this.region.equals(that.region) : that.region == null;
            }

            @Override
            public final int hashCode() {
                int result = this.healthCheckId != null ? this.healthCheckId.hashCode() : 0;
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the type of Kubernetes resource to scale in an Amazon EKS cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * KubernetesResourceTypeProperty kubernetesResourceTypeProperty = KubernetesResourceTypeProperty.builder()
     *         .apiVersion("apiVersion")
     *         .kind("kind")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesresourcetype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesresourcetype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.KubernetesResourceTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(KubernetesResourceTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KubernetesResourceTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The API version type for the Kubernetes resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesresourcetype.html#cfn-arcregionswitch-plan-kubernetesresourcetype-apiversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesresourcetype.html#cfn-arcregionswitch-plan-kubernetesresourcetype-apiversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiVersion();

        /**
         * The kind for the Kubernetes resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesresourcetype.html#cfn-arcregionswitch-plan-kubernetesresourcetype-kind">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesresourcetype.html#cfn-arcregionswitch-plan-kubernetesresourcetype-kind</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKind();

        /**
         * @return a {@link Builder} of {@link KubernetesResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KubernetesResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KubernetesResourceTypeProperty> {
            java.lang.String apiVersion;
            java.lang.String kind;

            /**
             * Sets the value of {@link KubernetesResourceTypeProperty#getApiVersion}
             * @param apiVersion The API version type for the Kubernetes resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiVersion(java.lang.String apiVersion) {
                this.apiVersion = apiVersion;
                return this;
            }

            /**
             * Sets the value of {@link KubernetesResourceTypeProperty#getKind}
             * @param kind The kind for the Kubernetes resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kind(java.lang.String kind) {
                this.kind = kind;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KubernetesResourceTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KubernetesResourceTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KubernetesResourceTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KubernetesResourceTypeProperty {
            private final java.lang.String apiVersion;
            private final java.lang.String kind;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiVersion = software.amazon.jsii.Kernel.get(this, "apiVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kind = software.amazon.jsii.Kernel.get(this, "kind", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiVersion = java.util.Objects.requireNonNull(builder.apiVersion, "apiVersion is required");
                this.kind = java.util.Objects.requireNonNull(builder.kind, "kind is required");
            }

            @Override
            public final java.lang.String getApiVersion() {
                return this.apiVersion;
            }

            @Override
            public final java.lang.String getKind() {
                return this.kind;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiVersion", om.valueToTree(this.getApiVersion()));
                data.set("kind", om.valueToTree(this.getKind()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.KubernetesResourceTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KubernetesResourceTypeProperty.Jsii$Proxy that = (KubernetesResourceTypeProperty.Jsii$Proxy) o;

                if (!apiVersion.equals(that.apiVersion)) return false;
                return this.kind.equals(that.kind);
            }

            @Override
            public final int hashCode() {
                int result = this.apiVersion.hashCode();
                result = 31 * result + (this.kind.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines a Kubernetes resource to scale in an Amazon EKS cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * KubernetesScalingResourceProperty kubernetesScalingResourceProperty = KubernetesScalingResourceProperty.builder()
     *         .name("name")
     *         .namespace("namespace")
     *         // the properties below are optional
     *         .hpaName("hpaName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesscalingresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesscalingresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.KubernetesScalingResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(KubernetesScalingResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KubernetesScalingResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name for the Kubernetes resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesscalingresource.html#cfn-arcregionswitch-plan-kubernetesscalingresource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesscalingresource.html#cfn-arcregionswitch-plan-kubernetesscalingresource-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The namespace for the Kubernetes resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesscalingresource.html#cfn-arcregionswitch-plan-kubernetesscalingresource-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesscalingresource.html#cfn-arcregionswitch-plan-kubernetesscalingresource-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

        /**
         * The hpaname for the Kubernetes resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesscalingresource.html#cfn-arcregionswitch-plan-kubernetesscalingresource-hpaname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-kubernetesscalingresource.html#cfn-arcregionswitch-plan-kubernetesscalingresource-hpaname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHpaName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KubernetesScalingResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KubernetesScalingResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KubernetesScalingResourceProperty> {
            java.lang.String name;
            java.lang.String namespace;
            java.lang.String hpaName;

            /**
             * Sets the value of {@link KubernetesScalingResourceProperty#getName}
             * @param name The name for the Kubernetes resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link KubernetesScalingResourceProperty#getNamespace}
             * @param namespace The namespace for the Kubernetes resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link KubernetesScalingResourceProperty#getHpaName}
             * @param hpaName The hpaname for the Kubernetes resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hpaName(java.lang.String hpaName) {
                this.hpaName = hpaName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KubernetesScalingResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KubernetesScalingResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KubernetesScalingResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KubernetesScalingResourceProperty {
            private final java.lang.String name;
            private final java.lang.String namespace;
            private final java.lang.String hpaName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hpaName = software.amazon.jsii.Kernel.get(this, "hpaName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
                this.hpaName = builder.hpaName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.String getHpaName() {
                return this.hpaName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("namespace", om.valueToTree(this.getNamespace()));
                if (this.getHpaName() != null) {
                    data.set("hpaName", om.valueToTree(this.getHpaName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.KubernetesScalingResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KubernetesScalingResourceProperty.Jsii$Proxy that = (KubernetesScalingResourceProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!namespace.equals(that.namespace)) return false;
                return this.hpaName != null ? this.hpaName.equals(that.hpaName) : that.hpaName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.namespace.hashCode());
                result = 31 * result + (this.hpaName != null ? this.hpaName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for handling failures when invoking Lambda functions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * LambdaUngracefulProperty lambdaUngracefulProperty = LambdaUngracefulProperty.builder()
     *         .behavior("behavior")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdaungraceful.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdaungraceful.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.LambdaUngracefulProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaUngracefulProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaUngracefulProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ungraceful behavior for a Lambda function, which must be set to <code>skip</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdaungraceful.html#cfn-arcregionswitch-plan-lambdaungraceful-behavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdaungraceful.html#cfn-arcregionswitch-plan-lambdaungraceful-behavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBehavior() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaUngracefulProperty> {
            java.lang.String behavior;

            /**
             * Sets the value of {@link LambdaUngracefulProperty#getBehavior}
             * @param behavior The ungraceful behavior for a Lambda function, which must be set to <code>skip</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder behavior(java.lang.String behavior) {
                this.behavior = behavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaUngracefulProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaUngracefulProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaUngracefulProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaUngracefulProperty {
            private final java.lang.String behavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.behavior = software.amazon.jsii.Kernel.get(this, "behavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.behavior = builder.behavior;
            }

            @Override
            public final java.lang.String getBehavior() {
                return this.behavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBehavior() != null) {
                    data.set("behavior", om.valueToTree(this.getBehavior()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.LambdaUngracefulProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaUngracefulProperty.Jsii$Proxy that = (LambdaUngracefulProperty.Jsii$Proxy) o;

                return this.behavior != null ? this.behavior.equals(that.behavior) : that.behavior == null;
            }

            @Override
            public final int hashCode() {
                int result = this.behavior != null ? this.behavior.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configuration for AWS Lambda functions used in a Region switch plan.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * LambdasProperty lambdasProperty = LambdasProperty.builder()
     *         .arn("arn")
     *         .crossAccountRole("crossAccountRole")
     *         .externalId("externalId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdas.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdas.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.LambdasProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdasProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdasProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdas.html#cfn-arcregionswitch-plan-lambdas-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdas.html#cfn-arcregionswitch-plan-lambdas-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArn() {
            return null;
        }

        /**
         * The cross account role for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdas.html#cfn-arcregionswitch-plan-lambdas-crossaccountrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdas.html#cfn-arcregionswitch-plan-lambdas-crossaccountrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossAccountRole() {
            return null;
        }

        /**
         * The external ID (secret key) for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdas.html#cfn-arcregionswitch-plan-lambdas-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-lambdas.html#cfn-arcregionswitch-plan-lambdas-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdasProperty> {
            java.lang.String arn;
            java.lang.String crossAccountRole;
            java.lang.String externalId;

            /**
             * Sets the value of {@link LambdasProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link LambdasProperty#getCrossAccountRole}
             * @param crossAccountRole The cross account role for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossAccountRole(java.lang.String crossAccountRole) {
                this.crossAccountRole = crossAccountRole;
                return this;
            }

            /**
             * Sets the value of {@link LambdasProperty#getExternalId}
             * @param externalId The external ID (secret key) for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdasProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdasProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdasProperty {
            private final java.lang.String arn;
            private final java.lang.String crossAccountRole;
            private final java.lang.String externalId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crossAccountRole = software.amazon.jsii.Kernel.get(this, "crossAccountRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = builder.arn;
                this.crossAccountRole = builder.crossAccountRole;
                this.externalId = builder.externalId;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getCrossAccountRole() {
                return this.crossAccountRole;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArn() != null) {
                    data.set("arn", om.valueToTree(this.getArn()));
                }
                if (this.getCrossAccountRole() != null) {
                    data.set("crossAccountRole", om.valueToTree(this.getCrossAccountRole()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.LambdasProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdasProperty.Jsii$Proxy that = (LambdasProperty.Jsii$Proxy) o;

                if (this.arn != null ? !this.arn.equals(that.arn) : that.arn != null) return false;
                if (this.crossAccountRole != null ? !this.crossAccountRole.equals(that.crossAccountRole) : that.crossAccountRole != null) return false;
                return this.externalId != null ? this.externalId.equals(that.externalId) : that.externalId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn != null ? this.arn.hashCode() : 0;
                result = 31 * result + (this.crossAccountRole != null ? this.crossAccountRole.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for steps that should be executed in parallel during a Region switch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * ParallelExecutionBlockConfigurationProperty parallelExecutionBlockConfigurationProperty_;
     * ParallelExecutionBlockConfigurationProperty parallelExecutionBlockConfigurationProperty = ParallelExecutionBlockConfigurationProperty.builder()
     *         .steps(List.of(StepProperty.builder()
     *                 .executionBlockConfiguration(ExecutionBlockConfigurationProperty.builder()
     *                         .arcRoutingControlConfig(ArcRoutingControlConfigurationProperty.builder()
     *                                 .regionAndRoutingControls(Map.of(
     *                                         "regionAndRoutingControlsKey", List.of(ArcRoutingControlStateProperty.builder()
     *                                                 .routingControlArn("routingControlArn")
     *                                                 .state("state")
     *                                                 .build())))
     *                                 // the properties below are optional
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .timeoutMinutes(123)
     *                                 .build())
     *                         .customActionLambdaConfig(CustomActionLambdaConfigurationProperty.builder()
     *                                 .lambdas(List.of(LambdasProperty.builder()
     *                                         .arn("arn")
     *                                         .crossAccountRole("crossAccountRole")
     *                                         .externalId("externalId")
     *                                         .build()))
     *                                 .regionToRun("regionToRun")
     *                                 .retryIntervalMinutes(123)
     *                                 // the properties below are optional
     *                                 .timeoutMinutes(123)
     *                                 .ungraceful(LambdaUngracefulProperty.builder()
     *                                         .behavior("behavior")
     *                                         .build())
     *                                 .build())
     *                         .ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfigurationProperty.builder()
     *                                 .asgs(List.of(AsgProperty.builder()
     *                                         .arn("arn")
     *                                         .crossAccountRole("crossAccountRole")
     *                                         .externalId("externalId")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .capacityMonitoringApproach("capacityMonitoringApproach")
     *                                 .targetPercent(123)
     *                                 .timeoutMinutes(123)
     *                                 .ungraceful(Ec2UngracefulProperty.builder()
     *                                         .minimumSuccessPercentage(123)
     *                                         .build())
     *                                 .build())
     *                         .ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfigurationProperty.builder()
     *                                 .services(List.of(ServiceProperty.builder()
     *                                         .clusterArn("clusterArn")
     *                                         .crossAccountRole("crossAccountRole")
     *                                         .externalId("externalId")
     *                                         .serviceArn("serviceArn")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .capacityMonitoringApproach("capacityMonitoringApproach")
     *                                 .targetPercent(123)
     *                                 .timeoutMinutes(123)
     *                                 .ungraceful(EcsUngracefulProperty.builder()
     *                                         .minimumSuccessPercentage(123)
     *                                         .build())
     *                                 .build())
     *                         .eksResourceScalingConfig(EksResourceScalingConfigurationProperty.builder()
     *                                 .kubernetesResourceType(KubernetesResourceTypeProperty.builder()
     *                                         .apiVersion("apiVersion")
     *                                         .kind("kind")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .capacityMonitoringApproach("capacityMonitoringApproach")
     *                                 .eksClusters(List.of(EksClusterProperty.builder()
     *                                         .clusterArn("clusterArn")
     *                                         // the properties below are optional
     *                                         .crossAccountRole("crossAccountRole")
     *                                         .externalId("externalId")
     *                                         .build()))
     *                                 .scalingResources(List.of(Map.of(
     *                                         "scalingResourcesKey", Map.of(
     *                                                 "scalingResourcesKey", KubernetesScalingResourceProperty.builder()
     *                                                         .name("name")
     *                                                         .namespace("namespace")
     *                                                         // the properties below are optional
     *                                                         .hpaName("hpaName")
     *                                                         .build()))))
     *                                 .targetPercent(123)
     *                                 .timeoutMinutes(123)
     *                                 .ungraceful(EksResourceScalingUngracefulProperty.builder()
     *                                         .minimumSuccessPercentage(123)
     *                                         .build())
     *                                 .build())
     *                         .executionApprovalConfig(ExecutionApprovalConfigurationProperty.builder()
     *                                 .approvalRole("approvalRole")
     *                                 // the properties below are optional
     *                                 .timeoutMinutes(123)
     *                                 .build())
     *                         .globalAuroraConfig(GlobalAuroraConfigurationProperty.builder()
     *                                 .behavior("behavior")
     *                                 .databaseClusterArns(List.of("databaseClusterArns"))
     *                                 .globalClusterIdentifier("globalClusterIdentifier")
     *                                 // the properties below are optional
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .timeoutMinutes(123)
     *                                 .ungraceful(GlobalAuroraUngracefulProperty.builder()
     *                                         .ungraceful("ungraceful")
     *                                         .build())
     *                                 .build())
     *                         .parallelConfig(parallelExecutionBlockConfigurationProperty_)
     *                         .regionSwitchPlanConfig(RegionSwitchPlanConfigurationProperty.builder()
     *                                 .arn("arn")
     *                                 // the properties below are optional
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .build())
     *                         .route53HealthCheckConfig(Route53HealthCheckConfigurationProperty.builder()
     *                                 .hostedZoneId("hostedZoneId")
     *                                 .recordName("recordName")
     *                                 // the properties below are optional
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .recordSets(List.of(Route53ResourceRecordSetProperty.builder()
     *                                         .recordSetIdentifier("recordSetIdentifier")
     *                                         .region("region")
     *                                         .build()))
     *                                 .timeoutMinutes(123)
     *                                 .build())
     *                         .build())
     *                 .executionBlockType("executionBlockType")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-parallelexecutionblockconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-parallelexecutionblockconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.ParallelExecutionBlockConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ParallelExecutionBlockConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParallelExecutionBlockConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The steps for a parallel execution block.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-parallelexecutionblockconfiguration.html#cfn-arcregionswitch-plan-parallelexecutionblockconfiguration-steps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-parallelexecutionblockconfiguration.html#cfn-arcregionswitch-plan-parallelexecutionblockconfiguration-steps</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSteps();

        /**
         * @return a {@link Builder} of {@link ParallelExecutionBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParallelExecutionBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParallelExecutionBlockConfigurationProperty> {
            java.lang.Object steps;

            /**
             * Sets the value of {@link ParallelExecutionBlockConfigurationProperty#getSteps}
             * @param steps The steps for a parallel execution block. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder steps(software.amazon.awscdk.IResolvable steps) {
                this.steps = steps;
                return this;
            }

            /**
             * Sets the value of {@link ParallelExecutionBlockConfigurationProperty#getSteps}
             * @param steps The steps for a parallel execution block. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder steps(java.util.List<? extends java.lang.Object> steps) {
                this.steps = steps;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParallelExecutionBlockConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParallelExecutionBlockConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParallelExecutionBlockConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParallelExecutionBlockConfigurationProperty {
            private final java.lang.Object steps;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.steps = software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.steps = java.util.Objects.requireNonNull(builder.steps, "steps is required");
            }

            @Override
            public final java.lang.Object getSteps() {
                return this.steps;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("steps", om.valueToTree(this.getSteps()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.ParallelExecutionBlockConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParallelExecutionBlockConfigurationProperty.Jsii$Proxy that = (ParallelExecutionBlockConfigurationProperty.Jsii$Proxy) o;

                return this.steps.equals(that.steps);
            }

            @Override
            public final int hashCode() {
                int result = this.steps.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration for nested Region switch plans.
     * <p>
     * This allows one Region switch plan to trigger another plan as part of its execution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * RegionSwitchPlanConfigurationProperty regionSwitchPlanConfigurationProperty = RegionSwitchPlanConfigurationProperty.builder()
     *         .arn("arn")
     *         // the properties below are optional
     *         .crossAccountRole("crossAccountRole")
     *         .externalId("externalId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-regionswitchplanconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-regionswitchplanconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.RegionSwitchPlanConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RegionSwitchPlanConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegionSwitchPlanConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the plan configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-regionswitchplanconfiguration.html#cfn-arcregionswitch-plan-regionswitchplanconfiguration-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-regionswitchplanconfiguration.html#cfn-arcregionswitch-plan-regionswitchplanconfiguration-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The cross account role for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-regionswitchplanconfiguration.html#cfn-arcregionswitch-plan-regionswitchplanconfiguration-crossaccountrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-regionswitchplanconfiguration.html#cfn-arcregionswitch-plan-regionswitchplanconfiguration-crossaccountrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossAccountRole() {
            return null;
        }

        /**
         * The external ID (secret key) for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-regionswitchplanconfiguration.html#cfn-arcregionswitch-plan-regionswitchplanconfiguration-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-regionswitchplanconfiguration.html#cfn-arcregionswitch-plan-regionswitchplanconfiguration-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RegionSwitchPlanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegionSwitchPlanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegionSwitchPlanConfigurationProperty> {
            java.lang.String arn;
            java.lang.String crossAccountRole;
            java.lang.String externalId;

            /**
             * Sets the value of {@link RegionSwitchPlanConfigurationProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the plan configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link RegionSwitchPlanConfigurationProperty#getCrossAccountRole}
             * @param crossAccountRole The cross account role for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossAccountRole(java.lang.String crossAccountRole) {
                this.crossAccountRole = crossAccountRole;
                return this;
            }

            /**
             * Sets the value of {@link RegionSwitchPlanConfigurationProperty#getExternalId}
             * @param externalId The external ID (secret key) for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegionSwitchPlanConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegionSwitchPlanConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegionSwitchPlanConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegionSwitchPlanConfigurationProperty {
            private final java.lang.String arn;
            private final java.lang.String crossAccountRole;
            private final java.lang.String externalId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crossAccountRole = software.amazon.jsii.Kernel.get(this, "crossAccountRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.crossAccountRole = builder.crossAccountRole;
                this.externalId = builder.externalId;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.String getCrossAccountRole() {
                return this.crossAccountRole;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                if (this.getCrossAccountRole() != null) {
                    data.set("crossAccountRole", om.valueToTree(this.getCrossAccountRole()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.RegionSwitchPlanConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegionSwitchPlanConfigurationProperty.Jsii$Proxy that = (RegionSwitchPlanConfigurationProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                if (this.crossAccountRole != null ? !this.crossAccountRole.equals(that.crossAccountRole) : that.crossAccountRole != null) return false;
                return this.externalId != null ? this.externalId.equals(that.externalId) : that.externalId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.crossAccountRole != null ? this.crossAccountRole.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon Route 53 health check configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * Route53HealthCheckConfigurationProperty route53HealthCheckConfigurationProperty = Route53HealthCheckConfigurationProperty.builder()
     *         .hostedZoneId("hostedZoneId")
     *         .recordName("recordName")
     *         // the properties below are optional
     *         .crossAccountRole("crossAccountRole")
     *         .externalId("externalId")
     *         .recordSets(List.of(Route53ResourceRecordSetProperty.builder()
     *                 .recordSetIdentifier("recordSetIdentifier")
     *                 .region("region")
     *                 .build()))
     *         .timeoutMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.Route53HealthCheckConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(Route53HealthCheckConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Route53HealthCheckConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Route 53 health check configuration hosted zone ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-hostedzoneid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-hostedzoneid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHostedZoneId();

        /**
         * The Amazon Route 53 health check configuration record name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-recordname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-recordname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRecordName();

        /**
         * The cross account role for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-crossaccountrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-crossaccountrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossAccountRole() {
            return null;
        }

        /**
         * The external ID (secret key) for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The Amazon Route 53 health check configuration record sets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-recordsets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-recordsets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRecordSets() {
            return null;
        }

        /**
         * The Amazon Route 53 health check configuration time out (in minutes).
         * <p>
         * Default: - 60
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-timeoutminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthcheckconfiguration.html#cfn-arcregionswitch-plan-route53healthcheckconfiguration-timeoutminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Route53HealthCheckConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Route53HealthCheckConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Route53HealthCheckConfigurationProperty> {
            java.lang.String hostedZoneId;
            java.lang.String recordName;
            java.lang.String crossAccountRole;
            java.lang.String externalId;
            java.lang.Object recordSets;
            java.lang.Number timeoutMinutes;

            /**
             * Sets the value of {@link Route53HealthCheckConfigurationProperty#getHostedZoneId}
             * @param hostedZoneId The Amazon Route 53 health check configuration hosted zone ID. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneId(java.lang.String hostedZoneId) {
                this.hostedZoneId = hostedZoneId;
                return this;
            }

            /**
             * Sets the value of {@link Route53HealthCheckConfigurationProperty#getRecordName}
             * @param recordName The Amazon Route 53 health check configuration record name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordName(java.lang.String recordName) {
                this.recordName = recordName;
                return this;
            }

            /**
             * Sets the value of {@link Route53HealthCheckConfigurationProperty#getCrossAccountRole}
             * @param crossAccountRole The cross account role for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossAccountRole(java.lang.String crossAccountRole) {
                this.crossAccountRole = crossAccountRole;
                return this;
            }

            /**
             * Sets the value of {@link Route53HealthCheckConfigurationProperty#getExternalId}
             * @param externalId The external ID (secret key) for the configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link Route53HealthCheckConfigurationProperty#getRecordSets}
             * @param recordSets The Amazon Route 53 health check configuration record sets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordSets(software.amazon.awscdk.IResolvable recordSets) {
                this.recordSets = recordSets;
                return this;
            }

            /**
             * Sets the value of {@link Route53HealthCheckConfigurationProperty#getRecordSets}
             * @param recordSets The Amazon Route 53 health check configuration record sets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordSets(java.util.List<? extends java.lang.Object> recordSets) {
                this.recordSets = recordSets;
                return this;
            }

            /**
             * Sets the value of {@link Route53HealthCheckConfigurationProperty#getTimeoutMinutes}
             * @param timeoutMinutes The Amazon Route 53 health check configuration time out (in minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMinutes(java.lang.Number timeoutMinutes) {
                this.timeoutMinutes = timeoutMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Route53HealthCheckConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Route53HealthCheckConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Route53HealthCheckConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Route53HealthCheckConfigurationProperty {
            private final java.lang.String hostedZoneId;
            private final java.lang.String recordName;
            private final java.lang.String crossAccountRole;
            private final java.lang.String externalId;
            private final java.lang.Object recordSets;
            private final java.lang.Number timeoutMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostedZoneId = software.amazon.jsii.Kernel.get(this, "hostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordName = software.amazon.jsii.Kernel.get(this, "recordName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crossAccountRole = software.amazon.jsii.Kernel.get(this, "crossAccountRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordSets = software.amazon.jsii.Kernel.get(this, "recordSets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutMinutes = software.amazon.jsii.Kernel.get(this, "timeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostedZoneId = java.util.Objects.requireNonNull(builder.hostedZoneId, "hostedZoneId is required");
                this.recordName = java.util.Objects.requireNonNull(builder.recordName, "recordName is required");
                this.crossAccountRole = builder.crossAccountRole;
                this.externalId = builder.externalId;
                this.recordSets = builder.recordSets;
                this.timeoutMinutes = builder.timeoutMinutes;
            }

            @Override
            public final java.lang.String getHostedZoneId() {
                return this.hostedZoneId;
            }

            @Override
            public final java.lang.String getRecordName() {
                return this.recordName;
            }

            @Override
            public final java.lang.String getCrossAccountRole() {
                return this.crossAccountRole;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.Object getRecordSets() {
                return this.recordSets;
            }

            @Override
            public final java.lang.Number getTimeoutMinutes() {
                return this.timeoutMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hostedZoneId", om.valueToTree(this.getHostedZoneId()));
                data.set("recordName", om.valueToTree(this.getRecordName()));
                if (this.getCrossAccountRole() != null) {
                    data.set("crossAccountRole", om.valueToTree(this.getCrossAccountRole()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getRecordSets() != null) {
                    data.set("recordSets", om.valueToTree(this.getRecordSets()));
                }
                if (this.getTimeoutMinutes() != null) {
                    data.set("timeoutMinutes", om.valueToTree(this.getTimeoutMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.Route53HealthCheckConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Route53HealthCheckConfigurationProperty.Jsii$Proxy that = (Route53HealthCheckConfigurationProperty.Jsii$Proxy) o;

                if (!hostedZoneId.equals(that.hostedZoneId)) return false;
                if (!recordName.equals(that.recordName)) return false;
                if (this.crossAccountRole != null ? !this.crossAccountRole.equals(that.crossAccountRole) : that.crossAccountRole != null) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                if (this.recordSets != null ? !this.recordSets.equals(that.recordSets) : that.recordSets != null) return false;
                return this.timeoutMinutes != null ? this.timeoutMinutes.equals(that.timeoutMinutes) : that.timeoutMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hostedZoneId.hashCode();
                result = 31 * result + (this.recordName.hashCode());
                result = 31 * result + (this.crossAccountRole != null ? this.crossAccountRole.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.recordSets != null ? this.recordSets.hashCode() : 0);
                result = 31 * result + (this.timeoutMinutes != null ? this.timeoutMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * Route53HealthChecksProperty route53HealthChecksProperty = Route53HealthChecksProperty.builder()
     *         .healthCheckIds(List.of("healthCheckIds"))
     *         .hostedZoneIds(List.of("hostedZoneIds"))
     *         .recordNames(List.of("recordNames"))
     *         .regions(List.of("regions"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthchecks.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthchecks.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.Route53HealthChecksProperty")
    @software.amazon.jsii.Jsii.Proxy(Route53HealthChecksProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Route53HealthChecksProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthchecks.html#cfn-arcregionswitch-plan-route53healthchecks-healthcheckids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthchecks.html#cfn-arcregionswitch-plan-route53healthchecks-healthcheckids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHealthCheckIds() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthchecks.html#cfn-arcregionswitch-plan-route53healthchecks-hostedzoneids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthchecks.html#cfn-arcregionswitch-plan-route53healthchecks-hostedzoneids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHostedZoneIds() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthchecks.html#cfn-arcregionswitch-plan-route53healthchecks-recordnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthchecks.html#cfn-arcregionswitch-plan-route53healthchecks-recordnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRecordNames() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthchecks.html#cfn-arcregionswitch-plan-route53healthchecks-regions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53healthchecks.html#cfn-arcregionswitch-plan-route53healthchecks-regions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRegions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Route53HealthChecksProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Route53HealthChecksProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Route53HealthChecksProperty> {
            java.util.List<java.lang.String> healthCheckIds;
            java.util.List<java.lang.String> hostedZoneIds;
            java.util.List<java.lang.String> recordNames;
            java.util.List<java.lang.String> regions;

            /**
             * Sets the value of {@link Route53HealthChecksProperty#getHealthCheckIds}
             * @param healthCheckIds the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder healthCheckIds(java.util.List<java.lang.String> healthCheckIds) {
                this.healthCheckIds = healthCheckIds;
                return this;
            }

            /**
             * Sets the value of {@link Route53HealthChecksProperty#getHostedZoneIds}
             * @param hostedZoneIds the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostedZoneIds(java.util.List<java.lang.String> hostedZoneIds) {
                this.hostedZoneIds = hostedZoneIds;
                return this;
            }

            /**
             * Sets the value of {@link Route53HealthChecksProperty#getRecordNames}
             * @param recordNames the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordNames(java.util.List<java.lang.String> recordNames) {
                this.recordNames = recordNames;
                return this;
            }

            /**
             * Sets the value of {@link Route53HealthChecksProperty#getRegions}
             * @param regions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regions(java.util.List<java.lang.String> regions) {
                this.regions = regions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Route53HealthChecksProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Route53HealthChecksProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Route53HealthChecksProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Route53HealthChecksProperty {
            private final java.util.List<java.lang.String> healthCheckIds;
            private final java.util.List<java.lang.String> hostedZoneIds;
            private final java.util.List<java.lang.String> recordNames;
            private final java.util.List<java.lang.String> regions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.healthCheckIds = software.amazon.jsii.Kernel.get(this, "healthCheckIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.hostedZoneIds = software.amazon.jsii.Kernel.get(this, "hostedZoneIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.recordNames = software.amazon.jsii.Kernel.get(this, "recordNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.healthCheckIds = builder.healthCheckIds;
                this.hostedZoneIds = builder.hostedZoneIds;
                this.recordNames = builder.recordNames;
                this.regions = builder.regions;
            }

            @Override
            public final java.util.List<java.lang.String> getHealthCheckIds() {
                return this.healthCheckIds;
            }

            @Override
            public final java.util.List<java.lang.String> getHostedZoneIds() {
                return this.hostedZoneIds;
            }

            @Override
            public final java.util.List<java.lang.String> getRecordNames() {
                return this.recordNames;
            }

            @Override
            public final java.util.List<java.lang.String> getRegions() {
                return this.regions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHealthCheckIds() != null) {
                    data.set("healthCheckIds", om.valueToTree(this.getHealthCheckIds()));
                }
                if (this.getHostedZoneIds() != null) {
                    data.set("hostedZoneIds", om.valueToTree(this.getHostedZoneIds()));
                }
                if (this.getRecordNames() != null) {
                    data.set("recordNames", om.valueToTree(this.getRecordNames()));
                }
                if (this.getRegions() != null) {
                    data.set("regions", om.valueToTree(this.getRegions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.Route53HealthChecksProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Route53HealthChecksProperty.Jsii$Proxy that = (Route53HealthChecksProperty.Jsii$Proxy) o;

                if (this.healthCheckIds != null ? !this.healthCheckIds.equals(that.healthCheckIds) : that.healthCheckIds != null) return false;
                if (this.hostedZoneIds != null ? !this.hostedZoneIds.equals(that.hostedZoneIds) : that.hostedZoneIds != null) return false;
                if (this.recordNames != null ? !this.recordNames.equals(that.recordNames) : that.recordNames != null) return false;
                return this.regions != null ? this.regions.equals(that.regions) : that.regions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.healthCheckIds != null ? this.healthCheckIds.hashCode() : 0;
                result = 31 * result + (this.hostedZoneIds != null ? this.hostedZoneIds.hashCode() : 0);
                result = 31 * result + (this.recordNames != null ? this.recordNames.hashCode() : 0);
                result = 31 * result + (this.regions != null ? this.regions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon Route 53 record set.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * Route53ResourceRecordSetProperty route53ResourceRecordSetProperty = Route53ResourceRecordSetProperty.builder()
     *         .recordSetIdentifier("recordSetIdentifier")
     *         .region("region")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53resourcerecordset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53resourcerecordset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.Route53ResourceRecordSetProperty")
    @software.amazon.jsii.Jsii.Proxy(Route53ResourceRecordSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Route53ResourceRecordSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Route 53 record set identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53resourcerecordset.html#cfn-arcregionswitch-plan-route53resourcerecordset-recordsetidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53resourcerecordset.html#cfn-arcregionswitch-plan-route53resourcerecordset-recordsetidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordSetIdentifier() {
            return null;
        }

        /**
         * The Amazon Route 53 record set Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53resourcerecordset.html#cfn-arcregionswitch-plan-route53resourcerecordset-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-route53resourcerecordset.html#cfn-arcregionswitch-plan-route53resourcerecordset-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Route53ResourceRecordSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Route53ResourceRecordSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Route53ResourceRecordSetProperty> {
            java.lang.String recordSetIdentifier;
            java.lang.String region;

            /**
             * Sets the value of {@link Route53ResourceRecordSetProperty#getRecordSetIdentifier}
             * @param recordSetIdentifier The Amazon Route 53 record set identifier.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordSetIdentifier(java.lang.String recordSetIdentifier) {
                this.recordSetIdentifier = recordSetIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link Route53ResourceRecordSetProperty#getRegion}
             * @param region The Amazon Route 53 record set Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Route53ResourceRecordSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Route53ResourceRecordSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Route53ResourceRecordSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Route53ResourceRecordSetProperty {
            private final java.lang.String recordSetIdentifier;
            private final java.lang.String region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.recordSetIdentifier = software.amazon.jsii.Kernel.get(this, "recordSetIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.recordSetIdentifier = builder.recordSetIdentifier;
                this.region = builder.region;
            }

            @Override
            public final java.lang.String getRecordSetIdentifier() {
                return this.recordSetIdentifier;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRecordSetIdentifier() != null) {
                    data.set("recordSetIdentifier", om.valueToTree(this.getRecordSetIdentifier()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.Route53ResourceRecordSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Route53ResourceRecordSetProperty.Jsii$Proxy that = (Route53ResourceRecordSetProperty.Jsii$Proxy) o;

                if (this.recordSetIdentifier != null ? !this.recordSetIdentifier.equals(that.recordSetIdentifier) : that.recordSetIdentifier != null) return false;
                return this.region != null ? this.region.equals(that.region) : that.region == null;
            }

            @Override
            public final int hashCode() {
                int result = this.recordSetIdentifier != null ? this.recordSetIdentifier.hashCode() : 0;
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The service for a cross account role.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * ServiceProperty serviceProperty = ServiceProperty.builder()
     *         .clusterArn("clusterArn")
     *         .crossAccountRole("crossAccountRole")
     *         .externalId("externalId")
     *         .serviceArn("serviceArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-service.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-service.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.ServiceProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The cluster Amazon Resource Name (ARN) for a service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-service.html#cfn-arcregionswitch-plan-service-clusterarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-service.html#cfn-arcregionswitch-plan-service-clusterarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClusterArn() {
            return null;
        }

        /**
         * The cross account role for a service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-service.html#cfn-arcregionswitch-plan-service-crossaccountrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-service.html#cfn-arcregionswitch-plan-service-crossaccountrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCrossAccountRole() {
            return null;
        }

        /**
         * The external ID (secret key) for the service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-service.html#cfn-arcregionswitch-plan-service-externalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-service.html#cfn-arcregionswitch-plan-service-externalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExternalId() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for a service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-service.html#cfn-arcregionswitch-plan-service-servicearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-service.html#cfn-arcregionswitch-plan-service-servicearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceProperty> {
            java.lang.String clusterArn;
            java.lang.String crossAccountRole;
            java.lang.String externalId;
            java.lang.String serviceArn;

            /**
             * Sets the value of {@link ServiceProperty#getClusterArn}
             * @param clusterArn The cluster Amazon Resource Name (ARN) for a service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterArn(java.lang.String clusterArn) {
                this.clusterArn = clusterArn;
                return this;
            }

            /**
             * Sets the value of {@link ServiceProperty#getCrossAccountRole}
             * @param crossAccountRole The cross account role for a service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossAccountRole(java.lang.String crossAccountRole) {
                this.crossAccountRole = crossAccountRole;
                return this;
            }

            /**
             * Sets the value of {@link ServiceProperty#getExternalId}
             * @param externalId The external ID (secret key) for the service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder externalId(java.lang.String externalId) {
                this.externalId = externalId;
                return this;
            }

            /**
             * Sets the value of {@link ServiceProperty#getServiceArn}
             * @param serviceArn The Amazon Resource Name (ARN) for a service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceArn(java.lang.String serviceArn) {
                this.serviceArn = serviceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceProperty {
            private final java.lang.String clusterArn;
            private final java.lang.String crossAccountRole;
            private final java.lang.String externalId;
            private final java.lang.String serviceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterArn = software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crossAccountRole = software.amazon.jsii.Kernel.get(this, "crossAccountRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.externalId = software.amazon.jsii.Kernel.get(this, "externalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceArn = software.amazon.jsii.Kernel.get(this, "serviceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterArn = builder.clusterArn;
                this.crossAccountRole = builder.crossAccountRole;
                this.externalId = builder.externalId;
                this.serviceArn = builder.serviceArn;
            }

            @Override
            public final java.lang.String getClusterArn() {
                return this.clusterArn;
            }

            @Override
            public final java.lang.String getCrossAccountRole() {
                return this.crossAccountRole;
            }

            @Override
            public final java.lang.String getExternalId() {
                return this.externalId;
            }

            @Override
            public final java.lang.String getServiceArn() {
                return this.serviceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClusterArn() != null) {
                    data.set("clusterArn", om.valueToTree(this.getClusterArn()));
                }
                if (this.getCrossAccountRole() != null) {
                    data.set("crossAccountRole", om.valueToTree(this.getCrossAccountRole()));
                }
                if (this.getExternalId() != null) {
                    data.set("externalId", om.valueToTree(this.getExternalId()));
                }
                if (this.getServiceArn() != null) {
                    data.set("serviceArn", om.valueToTree(this.getServiceArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.ServiceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceProperty.Jsii$Proxy that = (ServiceProperty.Jsii$Proxy) o;

                if (this.clusterArn != null ? !this.clusterArn.equals(that.clusterArn) : that.clusterArn != null) return false;
                if (this.crossAccountRole != null ? !this.crossAccountRole.equals(that.crossAccountRole) : that.crossAccountRole != null) return false;
                if (this.externalId != null ? !this.externalId.equals(that.externalId) : that.externalId != null) return false;
                return this.serviceArn != null ? this.serviceArn.equals(that.serviceArn) : that.serviceArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clusterArn != null ? this.clusterArn.hashCode() : 0;
                result = 31 * result + (this.crossAccountRole != null ? this.crossAccountRole.hashCode() : 0);
                result = 31 * result + (this.externalId != null ? this.externalId.hashCode() : 0);
                result = 31 * result + (this.serviceArn != null ? this.serviceArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a step in a Region switch plan workflow.
     * <p>
     * Each step performs a specific action during the Region switch process.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * StepProperty stepProperty_;
     * StepProperty stepProperty = StepProperty.builder()
     *         .executionBlockConfiguration(ExecutionBlockConfigurationProperty.builder()
     *                 .arcRoutingControlConfig(ArcRoutingControlConfigurationProperty.builder()
     *                         .regionAndRoutingControls(Map.of(
     *                                 "regionAndRoutingControlsKey", List.of(ArcRoutingControlStateProperty.builder()
     *                                         .routingControlArn("routingControlArn")
     *                                         .state("state")
     *                                         .build())))
     *                         // the properties below are optional
     *                         .crossAccountRole("crossAccountRole")
     *                         .externalId("externalId")
     *                         .timeoutMinutes(123)
     *                         .build())
     *                 .customActionLambdaConfig(CustomActionLambdaConfigurationProperty.builder()
     *                         .lambdas(List.of(LambdasProperty.builder()
     *                                 .arn("arn")
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .build()))
     *                         .regionToRun("regionToRun")
     *                         .retryIntervalMinutes(123)
     *                         // the properties below are optional
     *                         .timeoutMinutes(123)
     *                         .ungraceful(LambdaUngracefulProperty.builder()
     *                                 .behavior("behavior")
     *                                 .build())
     *                         .build())
     *                 .ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfigurationProperty.builder()
     *                         .asgs(List.of(AsgProperty.builder()
     *                                 .arn("arn")
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .capacityMonitoringApproach("capacityMonitoringApproach")
     *                         .targetPercent(123)
     *                         .timeoutMinutes(123)
     *                         .ungraceful(Ec2UngracefulProperty.builder()
     *                                 .minimumSuccessPercentage(123)
     *                                 .build())
     *                         .build())
     *                 .ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfigurationProperty.builder()
     *                         .services(List.of(ServiceProperty.builder()
     *                                 .clusterArn("clusterArn")
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .serviceArn("serviceArn")
     *                                 .build()))
     *                         // the properties below are optional
     *                         .capacityMonitoringApproach("capacityMonitoringApproach")
     *                         .targetPercent(123)
     *                         .timeoutMinutes(123)
     *                         .ungraceful(EcsUngracefulProperty.builder()
     *                                 .minimumSuccessPercentage(123)
     *                                 .build())
     *                         .build())
     *                 .eksResourceScalingConfig(EksResourceScalingConfigurationProperty.builder()
     *                         .kubernetesResourceType(KubernetesResourceTypeProperty.builder()
     *                                 .apiVersion("apiVersion")
     *                                 .kind("kind")
     *                                 .build())
     *                         // the properties below are optional
     *                         .capacityMonitoringApproach("capacityMonitoringApproach")
     *                         .eksClusters(List.of(EksClusterProperty.builder()
     *                                 .clusterArn("clusterArn")
     *                                 // the properties below are optional
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .build()))
     *                         .scalingResources(List.of(Map.of(
     *                                 "scalingResourcesKey", Map.of(
     *                                         "scalingResourcesKey", KubernetesScalingResourceProperty.builder()
     *                                                 .name("name")
     *                                                 .namespace("namespace")
     *                                                 // the properties below are optional
     *                                                 .hpaName("hpaName")
     *                                                 .build()))))
     *                         .targetPercent(123)
     *                         .timeoutMinutes(123)
     *                         .ungraceful(EksResourceScalingUngracefulProperty.builder()
     *                                 .minimumSuccessPercentage(123)
     *                                 .build())
     *                         .build())
     *                 .executionApprovalConfig(ExecutionApprovalConfigurationProperty.builder()
     *                         .approvalRole("approvalRole")
     *                         // the properties below are optional
     *                         .timeoutMinutes(123)
     *                         .build())
     *                 .globalAuroraConfig(GlobalAuroraConfigurationProperty.builder()
     *                         .behavior("behavior")
     *                         .databaseClusterArns(List.of("databaseClusterArns"))
     *                         .globalClusterIdentifier("globalClusterIdentifier")
     *                         // the properties below are optional
     *                         .crossAccountRole("crossAccountRole")
     *                         .externalId("externalId")
     *                         .timeoutMinutes(123)
     *                         .ungraceful(GlobalAuroraUngracefulProperty.builder()
     *                                 .ungraceful("ungraceful")
     *                                 .build())
     *                         .build())
     *                 .parallelConfig(ParallelExecutionBlockConfigurationProperty.builder()
     *                         .steps(List.of(stepProperty_))
     *                         .build())
     *                 .regionSwitchPlanConfig(RegionSwitchPlanConfigurationProperty.builder()
     *                         .arn("arn")
     *                         // the properties below are optional
     *                         .crossAccountRole("crossAccountRole")
     *                         .externalId("externalId")
     *                         .build())
     *                 .route53HealthCheckConfig(Route53HealthCheckConfigurationProperty.builder()
     *                         .hostedZoneId("hostedZoneId")
     *                         .recordName("recordName")
     *                         // the properties below are optional
     *                         .crossAccountRole("crossAccountRole")
     *                         .externalId("externalId")
     *                         .recordSets(List.of(Route53ResourceRecordSetProperty.builder()
     *                                 .recordSetIdentifier("recordSetIdentifier")
     *                                 .region("region")
     *                                 .build()))
     *                         .timeoutMinutes(123)
     *                         .build())
     *                 .build())
     *         .executionBlockType("executionBlockType")
     *         .name("name")
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-step.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-step.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.StepProperty")
    @software.amazon.jsii.Jsii.Proxy(StepProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StepProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for an execution block in a workflow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-step.html#cfn-arcregionswitch-plan-step-executionblockconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-step.html#cfn-arcregionswitch-plan-step-executionblockconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getExecutionBlockConfiguration();

        /**
         * The type of an execution block in a workflow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-step.html#cfn-arcregionswitch-plan-step-executionblocktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-step.html#cfn-arcregionswitch-plan-step-executionblocktype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExecutionBlockType();

        /**
         * The name of a step in a workflow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-step.html#cfn-arcregionswitch-plan-step-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-step.html#cfn-arcregionswitch-plan-step-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The description of a step in a workflow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-step.html#cfn-arcregionswitch-plan-step-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-step.html#cfn-arcregionswitch-plan-step-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StepProperty> {
            java.lang.Object executionBlockConfiguration;
            java.lang.String executionBlockType;
            java.lang.String name;
            java.lang.String description;

            /**
             * Sets the value of {@link StepProperty#getExecutionBlockConfiguration}
             * @param executionBlockConfiguration The configuration for an execution block in a workflow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionBlockConfiguration(software.amazon.awscdk.IResolvable executionBlockConfiguration) {
                this.executionBlockConfiguration = executionBlockConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StepProperty#getExecutionBlockConfiguration}
             * @param executionBlockConfiguration The configuration for an execution block in a workflow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionBlockConfiguration(software.amazon.awscdk.services.arcregionswitch.CfnPlan.ExecutionBlockConfigurationProperty executionBlockConfiguration) {
                this.executionBlockConfiguration = executionBlockConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StepProperty#getExecutionBlockType}
             * @param executionBlockType The type of an execution block in a workflow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionBlockType(java.lang.String executionBlockType) {
                this.executionBlockType = executionBlockType;
                return this;
            }

            /**
             * Sets the value of {@link StepProperty#getName}
             * @param name The name of a step in a workflow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link StepProperty#getDescription}
             * @param description The description of a step in a workflow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StepProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StepProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepProperty {
            private final java.lang.Object executionBlockConfiguration;
            private final java.lang.String executionBlockType;
            private final java.lang.String name;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executionBlockConfiguration = software.amazon.jsii.Kernel.get(this, "executionBlockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionBlockType = software.amazon.jsii.Kernel.get(this, "executionBlockType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executionBlockConfiguration = java.util.Objects.requireNonNull(builder.executionBlockConfiguration, "executionBlockConfiguration is required");
                this.executionBlockType = java.util.Objects.requireNonNull(builder.executionBlockType, "executionBlockType is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.Object getExecutionBlockConfiguration() {
                return this.executionBlockConfiguration;
            }

            @Override
            public final java.lang.String getExecutionBlockType() {
                return this.executionBlockType;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("executionBlockConfiguration", om.valueToTree(this.getExecutionBlockConfiguration()));
                data.set("executionBlockType", om.valueToTree(this.getExecutionBlockType()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.StepProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StepProperty.Jsii$Proxy that = (StepProperty.Jsii$Proxy) o;

                if (!executionBlockConfiguration.equals(that.executionBlockConfiguration)) return false;
                if (!executionBlockType.equals(that.executionBlockType)) return false;
                if (!name.equals(that.name)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.executionBlockConfiguration.hashCode();
                result = 31 * result + (this.executionBlockType.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a condition that must be met for a trigger to fire.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * TriggerConditionProperty triggerConditionProperty = TriggerConditionProperty.builder()
     *         .associatedAlarmName("associatedAlarmName")
     *         .condition("condition")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-triggercondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-triggercondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.TriggerConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(TriggerConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TriggerConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the CloudWatch alarm associated with the condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-triggercondition.html#cfn-arcregionswitch-plan-triggercondition-associatedalarmname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-triggercondition.html#cfn-arcregionswitch-plan-triggercondition-associatedalarmname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAssociatedAlarmName();

        /**
         * The condition that must be met.
         * <p>
         * Valid values include ALARM and OK.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-triggercondition.html#cfn-arcregionswitch-plan-triggercondition-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-triggercondition.html#cfn-arcregionswitch-plan-triggercondition-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCondition();

        /**
         * @return a {@link Builder} of {@link TriggerConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TriggerConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TriggerConditionProperty> {
            java.lang.String associatedAlarmName;
            java.lang.String condition;

            /**
             * Sets the value of {@link TriggerConditionProperty#getAssociatedAlarmName}
             * @param associatedAlarmName The name of the CloudWatch alarm associated with the condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associatedAlarmName(java.lang.String associatedAlarmName) {
                this.associatedAlarmName = associatedAlarmName;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConditionProperty#getCondition}
             * @param condition The condition that must be met. This parameter is required.
             *                  Valid values include ALARM and OK.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TriggerConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TriggerConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerConditionProperty {
            private final java.lang.String associatedAlarmName;
            private final java.lang.String condition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.associatedAlarmName = software.amazon.jsii.Kernel.get(this, "associatedAlarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.associatedAlarmName = java.util.Objects.requireNonNull(builder.associatedAlarmName, "associatedAlarmName is required");
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
            }

            @Override
            public final java.lang.String getAssociatedAlarmName() {
                return this.associatedAlarmName;
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("associatedAlarmName", om.valueToTree(this.getAssociatedAlarmName()));
                data.set("condition", om.valueToTree(this.getCondition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.TriggerConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TriggerConditionProperty.Jsii$Proxy that = (TriggerConditionProperty.Jsii$Proxy) o;

                if (!associatedAlarmName.equals(that.associatedAlarmName)) return false;
                return this.condition.equals(that.condition);
            }

            @Override
            public final int hashCode() {
                int result = this.associatedAlarmName.hashCode();
                result = 31 * result + (this.condition.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines a condition that can automatically trigger the execution of a Region switch plan.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * TriggerProperty triggerProperty = TriggerProperty.builder()
     *         .action("action")
     *         .conditions(List.of(TriggerConditionProperty.builder()
     *                 .associatedAlarmName("associatedAlarmName")
     *                 .condition("condition")
     *                 .build()))
     *         .minDelayMinutesBetweenExecutions(123)
     *         .targetRegion("targetRegion")
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.TriggerProperty")
    @software.amazon.jsii.Jsii.Proxy(TriggerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TriggerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to perform when the trigger fires.
         * <p>
         * Valid values include ACTIVATE and DEACTIVATE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html#cfn-arcregionswitch-plan-trigger-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html#cfn-arcregionswitch-plan-trigger-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * The conditions that must be met for the trigger to fire.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html#cfn-arcregionswitch-plan-trigger-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html#cfn-arcregionswitch-plan-trigger-conditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConditions();

        /**
         * The minimum time, in minutes, that must elapse between automatic executions of the plan.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html#cfn-arcregionswitch-plan-trigger-mindelayminutesbetweenexecutions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html#cfn-arcregionswitch-plan-trigger-mindelayminutesbetweenexecutions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinDelayMinutesBetweenExecutions();

        /**
         * The AWS Region for a trigger.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html#cfn-arcregionswitch-plan-trigger-targetregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html#cfn-arcregionswitch-plan-trigger-targetregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetRegion();

        /**
         * The description for a trigger.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html#cfn-arcregionswitch-plan-trigger-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-trigger.html#cfn-arcregionswitch-plan-trigger-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TriggerProperty> {
            java.lang.String action;
            java.lang.Object conditions;
            java.lang.Number minDelayMinutesBetweenExecutions;
            java.lang.String targetRegion;
            java.lang.String description;

            /**
             * Sets the value of {@link TriggerProperty#getAction}
             * @param action The action to perform when the trigger fires. This parameter is required.
             *               Valid values include ACTIVATE and DEACTIVATE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link TriggerProperty#getConditions}
             * @param conditions The conditions that must be met for the trigger to fire. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(software.amazon.awscdk.IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link TriggerProperty#getConditions}
             * @param conditions The conditions that must be met for the trigger to fire. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link TriggerProperty#getMinDelayMinutesBetweenExecutions}
             * @param minDelayMinutesBetweenExecutions The minimum time, in minutes, that must elapse between automatic executions of the plan. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minDelayMinutesBetweenExecutions(java.lang.Number minDelayMinutesBetweenExecutions) {
                this.minDelayMinutesBetweenExecutions = minDelayMinutesBetweenExecutions;
                return this;
            }

            /**
             * Sets the value of {@link TriggerProperty#getTargetRegion}
             * @param targetRegion The AWS Region for a trigger. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetRegion(java.lang.String targetRegion) {
                this.targetRegion = targetRegion;
                return this;
            }

            /**
             * Sets the value of {@link TriggerProperty#getDescription}
             * @param description The description for a trigger.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TriggerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TriggerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerProperty {
            private final java.lang.String action;
            private final java.lang.Object conditions;
            private final java.lang.Number minDelayMinutesBetweenExecutions;
            private final java.lang.String targetRegion;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.minDelayMinutesBetweenExecutions = software.amazon.jsii.Kernel.get(this, "minDelayMinutesBetweenExecutions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.targetRegion = software.amazon.jsii.Kernel.get(this, "targetRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.conditions = java.util.Objects.requireNonNull(builder.conditions, "conditions is required");
                this.minDelayMinutesBetweenExecutions = java.util.Objects.requireNonNull(builder.minDelayMinutesBetweenExecutions, "minDelayMinutesBetweenExecutions is required");
                this.targetRegion = java.util.Objects.requireNonNull(builder.targetRegion, "targetRegion is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getConditions() {
                return this.conditions;
            }

            @Override
            public final java.lang.Number getMinDelayMinutesBetweenExecutions() {
                return this.minDelayMinutesBetweenExecutions;
            }

            @Override
            public final java.lang.String getTargetRegion() {
                return this.targetRegion;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("conditions", om.valueToTree(this.getConditions()));
                data.set("minDelayMinutesBetweenExecutions", om.valueToTree(this.getMinDelayMinutesBetweenExecutions()));
                data.set("targetRegion", om.valueToTree(this.getTargetRegion()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.TriggerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TriggerProperty.Jsii$Proxy that = (TriggerProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!conditions.equals(that.conditions)) return false;
                if (!minDelayMinutesBetweenExecutions.equals(that.minDelayMinutesBetweenExecutions)) return false;
                if (!targetRegion.equals(that.targetRegion)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.conditions.hashCode());
                result = 31 * result + (this.minDelayMinutesBetweenExecutions.hashCode());
                result = 31 * result + (this.targetRegion.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents a workflow in a Region switch plan.
     * <p>
     * A workflow defines a sequence of steps to execute during a Region switch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.arcregionswitch.*;
     * StepProperty stepProperty_;
     * WorkflowProperty workflowProperty = WorkflowProperty.builder()
     *         .workflowTargetAction("workflowTargetAction")
     *         // the properties below are optional
     *         .steps(List.of(StepProperty.builder()
     *                 .executionBlockConfiguration(ExecutionBlockConfigurationProperty.builder()
     *                         .arcRoutingControlConfig(ArcRoutingControlConfigurationProperty.builder()
     *                                 .regionAndRoutingControls(Map.of(
     *                                         "regionAndRoutingControlsKey", List.of(ArcRoutingControlStateProperty.builder()
     *                                                 .routingControlArn("routingControlArn")
     *                                                 .state("state")
     *                                                 .build())))
     *                                 // the properties below are optional
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .timeoutMinutes(123)
     *                                 .build())
     *                         .customActionLambdaConfig(CustomActionLambdaConfigurationProperty.builder()
     *                                 .lambdas(List.of(LambdasProperty.builder()
     *                                         .arn("arn")
     *                                         .crossAccountRole("crossAccountRole")
     *                                         .externalId("externalId")
     *                                         .build()))
     *                                 .regionToRun("regionToRun")
     *                                 .retryIntervalMinutes(123)
     *                                 // the properties below are optional
     *                                 .timeoutMinutes(123)
     *                                 .ungraceful(LambdaUngracefulProperty.builder()
     *                                         .behavior("behavior")
     *                                         .build())
     *                                 .build())
     *                         .ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfigurationProperty.builder()
     *                                 .asgs(List.of(AsgProperty.builder()
     *                                         .arn("arn")
     *                                         .crossAccountRole("crossAccountRole")
     *                                         .externalId("externalId")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .capacityMonitoringApproach("capacityMonitoringApproach")
     *                                 .targetPercent(123)
     *                                 .timeoutMinutes(123)
     *                                 .ungraceful(Ec2UngracefulProperty.builder()
     *                                         .minimumSuccessPercentage(123)
     *                                         .build())
     *                                 .build())
     *                         .ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfigurationProperty.builder()
     *                                 .services(List.of(ServiceProperty.builder()
     *                                         .clusterArn("clusterArn")
     *                                         .crossAccountRole("crossAccountRole")
     *                                         .externalId("externalId")
     *                                         .serviceArn("serviceArn")
     *                                         .build()))
     *                                 // the properties below are optional
     *                                 .capacityMonitoringApproach("capacityMonitoringApproach")
     *                                 .targetPercent(123)
     *                                 .timeoutMinutes(123)
     *                                 .ungraceful(EcsUngracefulProperty.builder()
     *                                         .minimumSuccessPercentage(123)
     *                                         .build())
     *                                 .build())
     *                         .eksResourceScalingConfig(EksResourceScalingConfigurationProperty.builder()
     *                                 .kubernetesResourceType(KubernetesResourceTypeProperty.builder()
     *                                         .apiVersion("apiVersion")
     *                                         .kind("kind")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .capacityMonitoringApproach("capacityMonitoringApproach")
     *                                 .eksClusters(List.of(EksClusterProperty.builder()
     *                                         .clusterArn("clusterArn")
     *                                         // the properties below are optional
     *                                         .crossAccountRole("crossAccountRole")
     *                                         .externalId("externalId")
     *                                         .build()))
     *                                 .scalingResources(List.of(Map.of(
     *                                         "scalingResourcesKey", Map.of(
     *                                                 "scalingResourcesKey", KubernetesScalingResourceProperty.builder()
     *                                                         .name("name")
     *                                                         .namespace("namespace")
     *                                                         // the properties below are optional
     *                                                         .hpaName("hpaName")
     *                                                         .build()))))
     *                                 .targetPercent(123)
     *                                 .timeoutMinutes(123)
     *                                 .ungraceful(EksResourceScalingUngracefulProperty.builder()
     *                                         .minimumSuccessPercentage(123)
     *                                         .build())
     *                                 .build())
     *                         .executionApprovalConfig(ExecutionApprovalConfigurationProperty.builder()
     *                                 .approvalRole("approvalRole")
     *                                 // the properties below are optional
     *                                 .timeoutMinutes(123)
     *                                 .build())
     *                         .globalAuroraConfig(GlobalAuroraConfigurationProperty.builder()
     *                                 .behavior("behavior")
     *                                 .databaseClusterArns(List.of("databaseClusterArns"))
     *                                 .globalClusterIdentifier("globalClusterIdentifier")
     *                                 // the properties below are optional
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .timeoutMinutes(123)
     *                                 .ungraceful(GlobalAuroraUngracefulProperty.builder()
     *                                         .ungraceful("ungraceful")
     *                                         .build())
     *                                 .build())
     *                         .parallelConfig(ParallelExecutionBlockConfigurationProperty.builder()
     *                                 .steps(List.of(stepProperty_))
     *                                 .build())
     *                         .regionSwitchPlanConfig(RegionSwitchPlanConfigurationProperty.builder()
     *                                 .arn("arn")
     *                                 // the properties below are optional
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .build())
     *                         .route53HealthCheckConfig(Route53HealthCheckConfigurationProperty.builder()
     *                                 .hostedZoneId("hostedZoneId")
     *                                 .recordName("recordName")
     *                                 // the properties below are optional
     *                                 .crossAccountRole("crossAccountRole")
     *                                 .externalId("externalId")
     *                                 .recordSets(List.of(Route53ResourceRecordSetProperty.builder()
     *                                         .recordSetIdentifier("recordSetIdentifier")
     *                                         .region("region")
     *                                         .build()))
     *                                 .timeoutMinutes(123)
     *                                 .build())
     *                         .build())
     *                 .executionBlockType("executionBlockType")
     *                 .name("name")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .build()))
     *         .workflowDescription("workflowDescription")
     *         .workflowTargetRegion("workflowTargetRegion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-workflow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-workflow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlan.WorkflowProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkflowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkflowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action that the workflow performs.
         * <p>
         * Valid values include ACTIVATE and DEACTIVATE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-workflow.html#cfn-arcregionswitch-plan-workflow-workflowtargetaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-workflow.html#cfn-arcregionswitch-plan-workflow-workflowtargetaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWorkflowTargetAction();

        /**
         * The steps that make up the workflow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-workflow.html#cfn-arcregionswitch-plan-workflow-steps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-workflow.html#cfn-arcregionswitch-plan-workflow-steps</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSteps() {
            return null;
        }

        /**
         * The description of the workflow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-workflow.html#cfn-arcregionswitch-plan-workflow-workflowdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-workflow.html#cfn-arcregionswitch-plan-workflow-workflowdescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkflowDescription() {
            return null;
        }

        /**
         * The AWS Region that the workflow targets.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-workflow.html#cfn-arcregionswitch-plan-workflow-workflowtargetregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-arcregionswitch-plan-workflow.html#cfn-arcregionswitch-plan-workflow-workflowtargetregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkflowTargetRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkflowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkflowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkflowProperty> {
            java.lang.String workflowTargetAction;
            java.lang.Object steps;
            java.lang.String workflowDescription;
            java.lang.String workflowTargetRegion;

            /**
             * Sets the value of {@link WorkflowProperty#getWorkflowTargetAction}
             * @param workflowTargetAction The action that the workflow performs. This parameter is required.
             *                             Valid values include ACTIVATE and DEACTIVATE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflowTargetAction(java.lang.String workflowTargetAction) {
                this.workflowTargetAction = workflowTargetAction;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowProperty#getSteps}
             * @param steps The steps that make up the workflow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder steps(software.amazon.awscdk.IResolvable steps) {
                this.steps = steps;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowProperty#getSteps}
             * @param steps The steps that make up the workflow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder steps(java.util.List<? extends java.lang.Object> steps) {
                this.steps = steps;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowProperty#getWorkflowDescription}
             * @param workflowDescription The description of the workflow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflowDescription(java.lang.String workflowDescription) {
                this.workflowDescription = workflowDescription;
                return this;
            }

            /**
             * Sets the value of {@link WorkflowProperty#getWorkflowTargetRegion}
             * @param workflowTargetRegion The AWS Region that the workflow targets.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflowTargetRegion(java.lang.String workflowTargetRegion) {
                this.workflowTargetRegion = workflowTargetRegion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkflowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkflowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkflowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkflowProperty {
            private final java.lang.String workflowTargetAction;
            private final java.lang.Object steps;
            private final java.lang.String workflowDescription;
            private final java.lang.String workflowTargetRegion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.workflowTargetAction = software.amazon.jsii.Kernel.get(this, "workflowTargetAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.steps = software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workflowDescription = software.amazon.jsii.Kernel.get(this, "workflowDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workflowTargetRegion = software.amazon.jsii.Kernel.get(this, "workflowTargetRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.workflowTargetAction = java.util.Objects.requireNonNull(builder.workflowTargetAction, "workflowTargetAction is required");
                this.steps = builder.steps;
                this.workflowDescription = builder.workflowDescription;
                this.workflowTargetRegion = builder.workflowTargetRegion;
            }

            @Override
            public final java.lang.String getWorkflowTargetAction() {
                return this.workflowTargetAction;
            }

            @Override
            public final java.lang.Object getSteps() {
                return this.steps;
            }

            @Override
            public final java.lang.String getWorkflowDescription() {
                return this.workflowDescription;
            }

            @Override
            public final java.lang.String getWorkflowTargetRegion() {
                return this.workflowTargetRegion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("workflowTargetAction", om.valueToTree(this.getWorkflowTargetAction()));
                if (this.getSteps() != null) {
                    data.set("steps", om.valueToTree(this.getSteps()));
                }
                if (this.getWorkflowDescription() != null) {
                    data.set("workflowDescription", om.valueToTree(this.getWorkflowDescription()));
                }
                if (this.getWorkflowTargetRegion() != null) {
                    data.set("workflowTargetRegion", om.valueToTree(this.getWorkflowTargetRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlan.WorkflowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkflowProperty.Jsii$Proxy that = (WorkflowProperty.Jsii$Proxy) o;

                if (!workflowTargetAction.equals(that.workflowTargetAction)) return false;
                if (this.steps != null ? !this.steps.equals(that.steps) : that.steps != null) return false;
                if (this.workflowDescription != null ? !this.workflowDescription.equals(that.workflowDescription) : that.workflowDescription != null) return false;
                return this.workflowTargetRegion != null ? this.workflowTargetRegion.equals(that.workflowTargetRegion) : that.workflowTargetRegion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.workflowTargetAction.hashCode();
                result = 31 * result + (this.steps != null ? this.steps.hashCode() : 0);
                result = 31 * result + (this.workflowDescription != null ? this.workflowDescription.hashCode() : 0);
                result = 31 * result + (this.workflowTargetRegion != null ? this.workflowTargetRegion.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.arcregionswitch.CfnPlan}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.arcregionswitch.CfnPlan> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.arcregionswitch.CfnPlanProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.arcregionswitch.CfnPlanProps.Builder();
        }

        /**
         * The execution role for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-executionrole</a>
         * @param executionRole The execution role for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(final java.lang.String executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        /**
         * The name for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-name</a>
         * @param name The name for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive (activePassive).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-recoveryapproach">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-recoveryapproach</a>
         * @param recoveryApproach The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive (activePassive). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryApproach(final java.lang.String recoveryApproach) {
            this.props.recoveryApproach(recoveryApproach);
            return this;
        }

        /**
         * The AWS Regions for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-regions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-regions</a>
         * @param regions The AWS Regions for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(final java.util.List<java.lang.String> regions) {
            this.props.regions(regions);
            return this;
        }

        /**
         * The workflows for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-workflows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-workflows</a>
         * @param workflows The workflows for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflows(final software.amazon.awscdk.IResolvable workflows) {
            this.props.workflows(workflows);
            return this;
        }
        /**
         * The workflows for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-workflows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-workflows</a>
         * @param workflows The workflows for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflows(final java.util.List<? extends java.lang.Object> workflows) {
            this.props.workflows(workflows);
            return this;
        }

        /**
         * The associated application health alarms for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-associatedalarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-associatedalarms</a>
         * @param associatedAlarms The associated application health alarms for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedAlarms(final software.amazon.awscdk.IResolvable associatedAlarms) {
            this.props.associatedAlarms(associatedAlarms);
            return this;
        }
        /**
         * The associated application health alarms for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-associatedalarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-associatedalarms</a>
         * @param associatedAlarms The associated application health alarms for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedAlarms(final java.util.Map<java.lang.String, ? extends java.lang.Object> associatedAlarms) {
            this.props.associatedAlarms(associatedAlarms);
            return this;
        }

        /**
         * The description for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-description</a>
         * @param description The description for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The primary Region for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-primaryregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-primaryregion</a>
         * @param primaryRegion The primary Region for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryRegion(final java.lang.String primaryRegion) {
            this.props.primaryRegion(primaryRegion);
            return this;
        }

        /**
         * The recovery time objective for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-recoverytimeobjectiveminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-recoverytimeobjectiveminutes</a>
         * @param recoveryTimeObjectiveMinutes The recovery time objective for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryTimeObjectiveMinutes(final java.lang.Number recoveryTimeObjectiveMinutes) {
            this.props.recoveryTimeObjectiveMinutes(recoveryTimeObjectiveMinutes);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-tags</a>
         * @param tags This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The triggers for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-triggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-triggers</a>
         * @param triggers The triggers for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final software.amazon.awscdk.IResolvable triggers) {
            this.props.triggers(triggers);
            return this;
        }
        /**
         * The triggers for a plan.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-triggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-triggers</a>
         * @param triggers The triggers for a plan. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final java.util.List<? extends java.lang.Object> triggers) {
            this.props.triggers(triggers);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.arcregionswitch.CfnPlan}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.arcregionswitch.CfnPlan build() {
            return new software.amazon.awscdk.services.arcregionswitch.CfnPlan(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
