package software.amazon.awscdk.services.arcregionswitch;

/**
 * Properties for defining a <code>CfnPlan</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.arcregionswitch.*;
 * StepProperty stepProperty_;
 * CfnPlanProps cfnPlanProps = CfnPlanProps.builder()
 *         .executionRole("executionRole")
 *         .name("name")
 *         .recoveryApproach("recoveryApproach")
 *         .regions(List.of("regions"))
 *         .workflows(List.of(WorkflowProperty.builder()
 *                 .workflowTargetAction("workflowTargetAction")
 *                 // the properties below are optional
 *                 .steps(List.of(StepProperty.builder()
 *                         .executionBlockConfiguration(ExecutionBlockConfigurationProperty.builder()
 *                                 .arcRoutingControlConfig(ArcRoutingControlConfigurationProperty.builder()
 *                                         .regionAndRoutingControls(Map.of(
 *                                                 "regionAndRoutingControlsKey", List.of(ArcRoutingControlStateProperty.builder()
 *                                                         .routingControlArn("routingControlArn")
 *                                                         .state("state")
 *                                                         .build())))
 *                                         // the properties below are optional
 *                                         .crossAccountRole("crossAccountRole")
 *                                         .externalId("externalId")
 *                                         .timeoutMinutes(123)
 *                                         .build())
 *                                 .customActionLambdaConfig(CustomActionLambdaConfigurationProperty.builder()
 *                                         .lambdas(List.of(LambdasProperty.builder()
 *                                                 .arn("arn")
 *                                                 .crossAccountRole("crossAccountRole")
 *                                                 .externalId("externalId")
 *                                                 .build()))
 *                                         .regionToRun("regionToRun")
 *                                         .retryIntervalMinutes(123)
 *                                         // the properties below are optional
 *                                         .timeoutMinutes(123)
 *                                         .ungraceful(LambdaUngracefulProperty.builder()
 *                                                 .behavior("behavior")
 *                                                 .build())
 *                                         .build())
 *                                 .ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfigurationProperty.builder()
 *                                         .asgs(List.of(AsgProperty.builder()
 *                                                 .arn("arn")
 *                                                 .crossAccountRole("crossAccountRole")
 *                                                 .externalId("externalId")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .capacityMonitoringApproach("capacityMonitoringApproach")
 *                                         .targetPercent(123)
 *                                         .timeoutMinutes(123)
 *                                         .ungraceful(Ec2UngracefulProperty.builder()
 *                                                 .minimumSuccessPercentage(123)
 *                                                 .build())
 *                                         .build())
 *                                 .ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfigurationProperty.builder()
 *                                         .services(List.of(ServiceProperty.builder()
 *                                                 .clusterArn("clusterArn")
 *                                                 .crossAccountRole("crossAccountRole")
 *                                                 .externalId("externalId")
 *                                                 .serviceArn("serviceArn")
 *                                                 .build()))
 *                                         // the properties below are optional
 *                                         .capacityMonitoringApproach("capacityMonitoringApproach")
 *                                         .targetPercent(123)
 *                                         .timeoutMinutes(123)
 *                                         .ungraceful(EcsUngracefulProperty.builder()
 *                                                 .minimumSuccessPercentage(123)
 *                                                 .build())
 *                                         .build())
 *                                 .eksResourceScalingConfig(EksResourceScalingConfigurationProperty.builder()
 *                                         .kubernetesResourceType(KubernetesResourceTypeProperty.builder()
 *                                                 .apiVersion("apiVersion")
 *                                                 .kind("kind")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .capacityMonitoringApproach("capacityMonitoringApproach")
 *                                         .eksClusters(List.of(EksClusterProperty.builder()
 *                                                 .clusterArn("clusterArn")
 *                                                 // the properties below are optional
 *                                                 .crossAccountRole("crossAccountRole")
 *                                                 .externalId("externalId")
 *                                                 .build()))
 *                                         .scalingResources(List.of(Map.of(
 *                                                 "scalingResourcesKey", Map.of(
 *                                                         "scalingResourcesKey", KubernetesScalingResourceProperty.builder()
 *                                                                 .name("name")
 *                                                                 .namespace("namespace")
 *                                                                 // the properties below are optional
 *                                                                 .hpaName("hpaName")
 *                                                                 .build()))))
 *                                         .targetPercent(123)
 *                                         .timeoutMinutes(123)
 *                                         .ungraceful(EksResourceScalingUngracefulProperty.builder()
 *                                                 .minimumSuccessPercentage(123)
 *                                                 .build())
 *                                         .build())
 *                                 .executionApprovalConfig(ExecutionApprovalConfigurationProperty.builder()
 *                                         .approvalRole("approvalRole")
 *                                         // the properties below are optional
 *                                         .timeoutMinutes(123)
 *                                         .build())
 *                                 .globalAuroraConfig(GlobalAuroraConfigurationProperty.builder()
 *                                         .behavior("behavior")
 *                                         .databaseClusterArns(List.of("databaseClusterArns"))
 *                                         .globalClusterIdentifier("globalClusterIdentifier")
 *                                         // the properties below are optional
 *                                         .crossAccountRole("crossAccountRole")
 *                                         .externalId("externalId")
 *                                         .timeoutMinutes(123)
 *                                         .ungraceful(GlobalAuroraUngracefulProperty.builder()
 *                                                 .ungraceful("ungraceful")
 *                                                 .build())
 *                                         .build())
 *                                 .parallelConfig(ParallelExecutionBlockConfigurationProperty.builder()
 *                                         .steps(List.of(stepProperty_))
 *                                         .build())
 *                                 .regionSwitchPlanConfig(RegionSwitchPlanConfigurationProperty.builder()
 *                                         .arn("arn")
 *                                         // the properties below are optional
 *                                         .crossAccountRole("crossAccountRole")
 *                                         .externalId("externalId")
 *                                         .build())
 *                                 .route53HealthCheckConfig(Route53HealthCheckConfigurationProperty.builder()
 *                                         .hostedZoneId("hostedZoneId")
 *                                         .recordName("recordName")
 *                                         // the properties below are optional
 *                                         .crossAccountRole("crossAccountRole")
 *                                         .externalId("externalId")
 *                                         .recordSets(List.of(Route53ResourceRecordSetProperty.builder()
 *                                                 .recordSetIdentifier("recordSetIdentifier")
 *                                                 .region("region")
 *                                                 .build()))
 *                                         .timeoutMinutes(123)
 *                                         .build())
 *                                 .build())
 *                         .executionBlockType("executionBlockType")
 *                         .name("name")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build()))
 *                 .workflowDescription("workflowDescription")
 *                 .workflowTargetRegion("workflowTargetRegion")
 *                 .build()))
 *         // the properties below are optional
 *         .associatedAlarms(Map.of(
 *                 "associatedAlarmsKey", AssociatedAlarmProperty.builder()
 *                         .alarmType("alarmType")
 *                         .resourceIdentifier("resourceIdentifier")
 *                         // the properties below are optional
 *                         .crossAccountRole("crossAccountRole")
 *                         .externalId("externalId")
 *                         .build()))
 *         .description("description")
 *         .primaryRegion("primaryRegion")
 *         .recoveryTimeObjectiveMinutes(123)
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .triggers(List.of(TriggerProperty.builder()
 *                 .action("action")
 *                 .conditions(List.of(TriggerConditionProperty.builder()
 *                         .associatedAlarmName("associatedAlarmName")
 *                         .condition("condition")
 *                         .build()))
 *                 .minDelayMinutesBetweenExecutions(123)
 *                 .targetRegion("targetRegion")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.578Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arcregionswitch.CfnPlanProps")
@software.amazon.jsii.Jsii.Proxy(CfnPlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The execution role for a plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-executionrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

    /**
     * The name for a plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive (activePassive).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-recoveryapproach">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-recoveryapproach</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRecoveryApproach();

    /**
     * The AWS Regions for a plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-regions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-regions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getRegions();

    /**
     * The workflows for a plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-workflows">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-workflows</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getWorkflows();

    /**
     * The associated application health alarms for a plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-associatedalarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-associatedalarms</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedAlarms() {
        return null;
    }

    /**
     * The description for a plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The primary Region for a plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-primaryregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-primaryregion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrimaryRegion() {
        return null;
    }

    /**
     * The recovery time objective for a plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-recoverytimeobjectiveminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-recoverytimeobjectiveminutes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRecoveryTimeObjectiveMinutes() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * The triggers for a plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-triggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arcregionswitch-plan.html#cfn-arcregionswitch-plan-triggers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTriggers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPlanProps> {
        java.lang.String executionRole;
        java.lang.String name;
        java.lang.String recoveryApproach;
        java.util.List<java.lang.String> regions;
        java.lang.Object workflows;
        java.lang.Object associatedAlarms;
        java.lang.String description;
        java.lang.String primaryRegion;
        java.lang.Number recoveryTimeObjectiveMinutes;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object triggers;

        /**
         * Sets the value of {@link CfnPlanProps#getExecutionRole}
         * @param executionRole The execution role for a plan. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(java.lang.String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getName}
         * @param name The name for a plan. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getRecoveryApproach}
         * @param recoveryApproach The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive (activePassive). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryApproach(java.lang.String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getRegions}
         * @param regions The AWS Regions for a plan. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regions(java.util.List<java.lang.String> regions) {
            this.regions = regions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getWorkflows}
         * @param workflows The workflows for a plan. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflows(software.amazon.awscdk.IResolvable workflows) {
            this.workflows = workflows;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getWorkflows}
         * @param workflows The workflows for a plan. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workflows(java.util.List<? extends java.lang.Object> workflows) {
            this.workflows = workflows;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getAssociatedAlarms}
         * @param associatedAlarms The associated application health alarms for a plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedAlarms(software.amazon.awscdk.IResolvable associatedAlarms) {
            this.associatedAlarms = associatedAlarms;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getAssociatedAlarms}
         * @param associatedAlarms The associated application health alarms for a plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedAlarms(java.util.Map<java.lang.String, ? extends java.lang.Object> associatedAlarms) {
            this.associatedAlarms = associatedAlarms;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getDescription}
         * @param description The description for a plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getPrimaryRegion}
         * @param primaryRegion The primary Region for a plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryRegion(java.lang.String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getRecoveryTimeObjectiveMinutes}
         * @param recoveryTimeObjectiveMinutes The recovery time objective for a plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryTimeObjectiveMinutes(java.lang.Number recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getTriggers}
         * @param triggers The triggers for a plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(software.amazon.awscdk.IResolvable triggers) {
            this.triggers = triggers;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlanProps#getTriggers}
         * @param triggers The triggers for a plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(java.util.List<? extends java.lang.Object> triggers) {
            this.triggers = triggers;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPlanProps {
        private final java.lang.String executionRole;
        private final java.lang.String name;
        private final java.lang.String recoveryApproach;
        private final java.util.List<java.lang.String> regions;
        private final java.lang.Object workflows;
        private final java.lang.Object associatedAlarms;
        private final java.lang.String description;
        private final java.lang.String primaryRegion;
        private final java.lang.Number recoveryTimeObjectiveMinutes;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object triggers;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recoveryApproach = software.amazon.jsii.Kernel.get(this, "recoveryApproach", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regions = software.amazon.jsii.Kernel.get(this, "regions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.workflows = software.amazon.jsii.Kernel.get(this, "workflows", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.associatedAlarms = software.amazon.jsii.Kernel.get(this, "associatedAlarms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.primaryRegion = software.amazon.jsii.Kernel.get(this, "primaryRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recoveryTimeObjectiveMinutes = software.amazon.jsii.Kernel.get(this, "recoveryTimeObjectiveMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.triggers = software.amazon.jsii.Kernel.get(this, "triggers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.recoveryApproach = java.util.Objects.requireNonNull(builder.recoveryApproach, "recoveryApproach is required");
            this.regions = java.util.Objects.requireNonNull(builder.regions, "regions is required");
            this.workflows = java.util.Objects.requireNonNull(builder.workflows, "workflows is required");
            this.associatedAlarms = builder.associatedAlarms;
            this.description = builder.description;
            this.primaryRegion = builder.primaryRegion;
            this.recoveryTimeObjectiveMinutes = builder.recoveryTimeObjectiveMinutes;
            this.tags = builder.tags;
            this.triggers = builder.triggers;
        }

        @Override
        public final java.lang.String getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRecoveryApproach() {
            return this.recoveryApproach;
        }

        @Override
        public final java.util.List<java.lang.String> getRegions() {
            return this.regions;
        }

        @Override
        public final java.lang.Object getWorkflows() {
            return this.workflows;
        }

        @Override
        public final java.lang.Object getAssociatedAlarms() {
            return this.associatedAlarms;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getPrimaryRegion() {
            return this.primaryRegion;
        }

        @Override
        public final java.lang.Number getRecoveryTimeObjectiveMinutes() {
            return this.recoveryTimeObjectiveMinutes;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTriggers() {
            return this.triggers;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("recoveryApproach", om.valueToTree(this.getRecoveryApproach()));
            data.set("regions", om.valueToTree(this.getRegions()));
            data.set("workflows", om.valueToTree(this.getWorkflows()));
            if (this.getAssociatedAlarms() != null) {
                data.set("associatedAlarms", om.valueToTree(this.getAssociatedAlarms()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getPrimaryRegion() != null) {
                data.set("primaryRegion", om.valueToTree(this.getPrimaryRegion()));
            }
            if (this.getRecoveryTimeObjectiveMinutes() != null) {
                data.set("recoveryTimeObjectiveMinutes", om.valueToTree(this.getRecoveryTimeObjectiveMinutes()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTriggers() != null) {
                data.set("triggers", om.valueToTree(this.getTriggers()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arcregionswitch.CfnPlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPlanProps.Jsii$Proxy that = (CfnPlanProps.Jsii$Proxy) o;

            if (!executionRole.equals(that.executionRole)) return false;
            if (!name.equals(that.name)) return false;
            if (!recoveryApproach.equals(that.recoveryApproach)) return false;
            if (!regions.equals(that.regions)) return false;
            if (!workflows.equals(that.workflows)) return false;
            if (this.associatedAlarms != null ? !this.associatedAlarms.equals(that.associatedAlarms) : that.associatedAlarms != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.primaryRegion != null ? !this.primaryRegion.equals(that.primaryRegion) : that.primaryRegion != null) return false;
            if (this.recoveryTimeObjectiveMinutes != null ? !this.recoveryTimeObjectiveMinutes.equals(that.recoveryTimeObjectiveMinutes) : that.recoveryTimeObjectiveMinutes != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.triggers != null ? this.triggers.equals(that.triggers) : that.triggers == null;
        }

        @Override
        public final int hashCode() {
            int result = this.executionRole.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.recoveryApproach.hashCode());
            result = 31 * result + (this.regions.hashCode());
            result = 31 * result + (this.workflows.hashCode());
            result = 31 * result + (this.associatedAlarms != null ? this.associatedAlarms.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.primaryRegion != null ? this.primaryRegion.hashCode() : 0);
            result = 31 * result + (this.recoveryTimeObjectiveMinutes != null ? this.recoveryTimeObjectiveMinutes.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.triggers != null ? this.triggers.hashCode() : 0);
            return result;
        }
    }
}
