package software.amazon.awscdk.services.autoscaling;

/**
 * Specifies the termination criteria to apply before Amazon EC2 Auto Scaling chooses an instance for termination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * String arn;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(machineImage)
 *         // ...
 *         .terminationPolicies(List.of(TerminationPolicy.CUSTOM_LAMBDA_FUNCTION, TerminationPolicy.OLDEST_INSTANCE, TerminationPolicy.DEFAULT))
 *         //terminationPolicyCustomLambdaFunctionArn property must be specified if the TerminationPolicy.CUSTOM_LAMBDA_FUNCTION is used
 *         .terminationPolicyCustomLambdaFunctionArn(arn)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.785Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.TerminationPolicy")
public enum TerminationPolicy {
    /**
     * Terminate instances in the Auto Scaling group to align the remaining instances to the allocation strategy for the type of instance that is terminating (either a Spot Instance or an On-Demand Instance).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALLOCATION_STRATEGY,
    /**
     * Terminate instances that are closest to the next billing hour.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLOSEST_TO_NEXT_INSTANCE_HOUR,
    /**
     * Terminate instances according to the default termination policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEFAULT,
    /**
     * Terminate the newest instance in the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEWEST_INSTANCE,
    /**
     * Terminate the oldest instance in the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OLDEST_INSTANCE,
    /**
     * Terminate instances that have the oldest launch configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OLDEST_LAUNCH_CONFIGURATION,
    /**
     * Terminate instances that have the oldest launch template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OLDEST_LAUNCH_TEMPLATE,
    /**
     * Terminate instances using custom termination policy with lambda.
     * <p>
     * If this is
     * specified, you must also supply a value of lambda arn in the terminationPolicyCustomLambdaFunctionArn property.
     * <p>
     * If there are multiple termination policies specified, the custom termination policy with lambda
     * must be specified first in the order.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lambda-custom-termination-policy.html#lambda-custom-termination-policy-limitations">https://docs.aws.amazon.com/autoscaling/ec2/userguide/lambda-custom-termination-policy.html#lambda-custom-termination-policy-limitations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CUSTOM_LAMBDA_FUNCTION,
}
