package software.amazon.awscdk.services.b2bi;

/**
 * Creates a transformer. AWS B2B Data Interchange currently supports two scenarios:.
 * <p>
 * <ul>
 * <li><em>Inbound EDI</em> : the AWS customer receives an EDI file from their trading partner. AWS B2B Data Interchange converts this EDI file into a JSON or XML file with a service-defined structure. A mapping template provided by the customer, in JSONata or XSLT format, is optionally applied to this file to produce a JSON or XML file with the structure the customer requires.</li>
 * <li><em>Outbound EDI</em> : the AWS customer has a JSON or XML file containing data that they wish to use in an EDI file. A mapping template, provided by the customer (in either JSONata or XSLT format) is applied to this file to generate a JSON or XML file in the service-defined structure. This file is then converted to an EDI file.</li>
 * </ul>
 * <p>
 * <blockquote>
 * <p>
 * The following fields are provided for backwards compatibility only: <code>fileFormat</code> , <code>mappingTemplate</code> , <code>ediType</code> , and <code>sampleDocument</code> .
 * <p>
 * <ul>
 * <li>Use the <code>mapping</code> data type in place of <code>mappingTemplate</code> and <code>fileFormat</code></li>
 * <li>Use the <code>sampleDocuments</code> data type in place of <code>sampleDocument</code></li>
 * <li>Use either the <code>inputConversion</code> or <code>outputConversion</code> in place of <code>ediType</code></li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.b2bi.*;
 * CfnTransformer cfnTransformer = CfnTransformer.Builder.create(this, "MyCfnTransformer")
 *         .name("name")
 *         .status("status")
 *         // the properties below are optional
 *         .ediType(EdiTypeProperty.builder()
 *                 .x12Details(X12DetailsProperty.builder()
 *                         .transactionSet("transactionSet")
 *                         .version("version")
 *                         .build())
 *                 .build())
 *         .fileFormat("fileFormat")
 *         .inputConversion(InputConversionProperty.builder()
 *                 .fromFormat("fromFormat")
 *                 // the properties below are optional
 *                 .advancedOptions(AdvancedOptionsProperty.builder()
 *                         .x12(X12AdvancedOptionsProperty.builder()
 *                                 .splitOptions(X12SplitOptionsProperty.builder()
 *                                         .splitBy("splitBy")
 *                                         .build())
 *                                 .validationOptions(X12ValidationOptionsProperty.builder()
 *                                         .validationRules(List.of(X12ValidationRuleProperty.builder()
 *                                                 .codeListValidationRule(X12CodeListValidationRuleProperty.builder()
 *                                                         .elementId("elementId")
 *                                                         // the properties below are optional
 *                                                         .codesToAdd(List.of("codesToAdd"))
 *                                                         .codesToRemove(List.of("codesToRemove"))
 *                                                         .build())
 *                                                 .elementLengthValidationRule(X12ElementLengthValidationRuleProperty.builder()
 *                                                         .elementId("elementId")
 *                                                         .maxLength(123)
 *                                                         .minLength(123)
 *                                                         .build())
 *                                                 .elementRequirementValidationRule(X12ElementRequirementValidationRuleProperty.builder()
 *                                                         .elementPosition("elementPosition")
 *                                                         .requirement("requirement")
 *                                                         .build())
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .formatOptions(FormatOptionsProperty.builder()
 *                         .x12(X12DetailsProperty.builder()
 *                                 .transactionSet("transactionSet")
 *                                 .version("version")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .mapping(MappingProperty.builder()
 *                 .templateLanguage("templateLanguage")
 *                 // the properties below are optional
 *                 .template("template")
 *                 .build())
 *         .mappingTemplate("mappingTemplate")
 *         .outputConversion(OutputConversionProperty.builder()
 *                 .toFormat("toFormat")
 *                 // the properties below are optional
 *                 .advancedOptions(AdvancedOptionsProperty.builder()
 *                         .x12(X12AdvancedOptionsProperty.builder()
 *                                 .splitOptions(X12SplitOptionsProperty.builder()
 *                                         .splitBy("splitBy")
 *                                         .build())
 *                                 .validationOptions(X12ValidationOptionsProperty.builder()
 *                                         .validationRules(List.of(X12ValidationRuleProperty.builder()
 *                                                 .codeListValidationRule(X12CodeListValidationRuleProperty.builder()
 *                                                         .elementId("elementId")
 *                                                         // the properties below are optional
 *                                                         .codesToAdd(List.of("codesToAdd"))
 *                                                         .codesToRemove(List.of("codesToRemove"))
 *                                                         .build())
 *                                                 .elementLengthValidationRule(X12ElementLengthValidationRuleProperty.builder()
 *                                                         .elementId("elementId")
 *                                                         .maxLength(123)
 *                                                         .minLength(123)
 *                                                         .build())
 *                                                 .elementRequirementValidationRule(X12ElementRequirementValidationRuleProperty.builder()
 *                                                         .elementPosition("elementPosition")
 *                                                         .requirement("requirement")
 *                                                         .build())
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .formatOptions(FormatOptionsProperty.builder()
 *                         .x12(X12DetailsProperty.builder()
 *                                 .transactionSet("transactionSet")
 *                                 .version("version")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .sampleDocument("sampleDocument")
 *         .sampleDocuments(SampleDocumentsProperty.builder()
 *                 .bucketName("bucketName")
 *                 .keys(List.of(SampleDocumentKeysProperty.builder()
 *                         .input("input")
 *                         .output("output")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:26.830Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer")
public class CfnTransformer extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnTransformer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTransformer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.b2bi.CfnTransformer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTransformer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.b2bi.CfnTransformerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns a timestamp indicating when the transformer was created.
     * <p>
     * For example, <code>2023-07-20T19:58:44.624Z</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns a timestamp representing the date and time for the most recent change for the transformer object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrModifiedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrModifiedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns an Amazon Resource Name (ARN) for a specific transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTransformerArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTransformerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The system-assigned unique identifier for the transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTransformerId() {
        return software.amazon.jsii.Kernel.get(this, "attrTransformerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Returns the descriptive name for the transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the descriptive name for the transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * Returns the state of the newly created transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getStatus() {
        return software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the state of the newly created transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatus(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "status", java.util.Objects.requireNonNull(value, "status is required"));
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.Object getEdiType() {
        return software.amazon.jsii.Kernel.get(this, "ediType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setEdiType(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ediType", value);
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setEdiType(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.b2bi.CfnTransformer.EdiTypeProperty value) {
        software.amazon.jsii.Kernel.set(this, "ediType", value);
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.String getFileFormat() {
        return software.amazon.jsii.Kernel.get(this, "fileFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setFileFormat(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "fileFormat", value);
    }

    /**
     * Returns a structure that contains the format options for the transformation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInputConversion() {
        return software.amazon.jsii.Kernel.get(this, "inputConversion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Returns a structure that contains the format options for the transformation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputConversion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputConversion", value);
    }

    /**
     * Returns a structure that contains the format options for the transformation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputConversion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.b2bi.CfnTransformer.InputConversionProperty value) {
        software.amazon.jsii.Kernel.set(this, "inputConversion", value);
    }

    /**
     * Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMapping() {
        return software.amazon.jsii.Kernel.get(this, "mapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMapping(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mapping", value);
    }

    /**
     * Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMapping(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.b2bi.CfnTransformer.MappingProperty value) {
        software.amazon.jsii.Kernel.set(this, "mapping", value);
    }

    /**
     * (deprecated) This shape is deprecated: This is a legacy trait.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.String getMappingTemplate() {
        return software.amazon.jsii.Kernel.get(this, "mappingTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) This shape is deprecated: This is a legacy trait.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setMappingTemplate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "mappingTemplate", value);
    }

    /**
     * Returns the <code>OutputConversion</code> object, which contains the format options for the outbound transformation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOutputConversion() {
        return software.amazon.jsii.Kernel.get(this, "outputConversion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Returns the <code>OutputConversion</code> object, which contains the format options for the outbound transformation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputConversion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputConversion", value);
    }

    /**
     * Returns the <code>OutputConversion</code> object, which contains the format options for the outbound transformation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputConversion(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.b2bi.CfnTransformer.OutputConversionProperty value) {
        software.amazon.jsii.Kernel.set(this, "outputConversion", value);
    }

    /**
     * (deprecated) This shape is deprecated: This is a legacy trait.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.Nullable java.lang.String getSampleDocument() {
        return software.amazon.jsii.Kernel.get(this, "sampleDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) This shape is deprecated: This is a legacy trait.
     * <p>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public void setSampleDocument(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sampleDocument", value);
    }

    /**
     * Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSampleDocuments() {
        return software.amazon.jsii.Kernel.get(this, "sampleDocuments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSampleDocuments(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sampleDocuments", value);
    }

    /**
     * Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSampleDocuments(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.b2bi.CfnTransformer.SampleDocumentsProperty value) {
        software.amazon.jsii.Kernel.set(this, "sampleDocuments", value);
    }

    /**
     * A key-value pair for a specific transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A key-value pair for a specific transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * A structure that contains advanced options for EDI processing.
     * <p>
     * Currently, only X12 advanced options are supported.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * AdvancedOptionsProperty advancedOptionsProperty = AdvancedOptionsProperty.builder()
     *         .x12(X12AdvancedOptionsProperty.builder()
     *                 .splitOptions(X12SplitOptionsProperty.builder()
     *                         .splitBy("splitBy")
     *                         .build())
     *                 .validationOptions(X12ValidationOptionsProperty.builder()
     *                         .validationRules(List.of(X12ValidationRuleProperty.builder()
     *                                 .codeListValidationRule(X12CodeListValidationRuleProperty.builder()
     *                                         .elementId("elementId")
     *                                         // the properties below are optional
     *                                         .codesToAdd(List.of("codesToAdd"))
     *                                         .codesToRemove(List.of("codesToRemove"))
     *                                         .build())
     *                                 .elementLengthValidationRule(X12ElementLengthValidationRuleProperty.builder()
     *                                         .elementId("elementId")
     *                                         .maxLength(123)
     *                                         .minLength(123)
     *                                         .build())
     *                                 .elementRequirementValidationRule(X12ElementRequirementValidationRuleProperty.builder()
     *                                         .elementPosition("elementPosition")
     *                                         .requirement("requirement")
     *                                         .build())
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-advancedoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-advancedoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.AdvancedOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure that contains X12-specific advanced options, such as split options for processing X12 EDI files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-advancedoptions.html#cfn-b2bi-transformer-advancedoptions-x12">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-advancedoptions.html#cfn-b2bi-transformer-advancedoptions-x12</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getX12() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedOptionsProperty> {
            java.lang.Object x12;

            /**
             * Sets the value of {@link AdvancedOptionsProperty#getX12}
             * @param x12 A structure that contains X12-specific advanced options, such as split options for processing X12 EDI files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder x12(software.amazon.awscdk.IResolvable x12) {
                this.x12 = x12;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedOptionsProperty#getX12}
             * @param x12 A structure that contains X12-specific advanced options, such as split options for processing X12 EDI files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder x12(software.amazon.awscdk.services.b2bi.CfnTransformer.X12AdvancedOptionsProperty x12) {
                this.x12 = x12;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedOptionsProperty {
            private final java.lang.Object x12;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.x12 = software.amazon.jsii.Kernel.get(this, "x12", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.x12 = builder.x12;
            }

            @Override
            public final java.lang.Object getX12() {
                return this.x12;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getX12() != null) {
                    data.set("x12", om.valueToTree(this.getX12()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.AdvancedOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedOptionsProperty.Jsii$Proxy that = (AdvancedOptionsProperty.Jsii$Proxy) o;

                return this.x12 != null ? this.x12.equals(that.x12) : that.x12 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.x12 != null ? this.x12.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * EdiTypeProperty ediTypeProperty = EdiTypeProperty.builder()
     *         .x12Details(X12DetailsProperty.builder()
     *                 .transactionSet("transactionSet")
     *                 .version("version")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-editype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-editype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.EdiTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(EdiTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EdiTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-editype.html#cfn-b2bi-transformer-editype-x12details">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-editype.html#cfn-b2bi-transformer-editype-x12details</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getX12Details();

        /**
         * @return a {@link Builder} of {@link EdiTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EdiTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EdiTypeProperty> {
            java.lang.Object x12Details;

            /**
             * Sets the value of {@link EdiTypeProperty#getX12Details}
             * @param x12Details the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder x12Details(software.amazon.awscdk.IResolvable x12Details) {
                this.x12Details = x12Details;
                return this;
            }

            /**
             * Sets the value of {@link EdiTypeProperty#getX12Details}
             * @param x12Details the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder x12Details(software.amazon.awscdk.services.b2bi.CfnTransformer.X12DetailsProperty x12Details) {
                this.x12Details = x12Details;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EdiTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EdiTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EdiTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EdiTypeProperty {
            private final java.lang.Object x12Details;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.x12Details = software.amazon.jsii.Kernel.get(this, "x12Details", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.x12Details = java.util.Objects.requireNonNull(builder.x12Details, "x12Details is required");
            }

            @Override
            public final java.lang.Object getX12Details() {
                return this.x12Details;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("x12Details", om.valueToTree(this.getX12Details()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.EdiTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EdiTypeProperty.Jsii$Proxy that = (EdiTypeProperty.Jsii$Proxy) o;

                return this.x12Details.equals(that.x12Details);
            }

            @Override
            public final int hashCode() {
                int result = this.x12Details.hashCode();
                return result;
            }
        }
    }
    /**
     * A structure that contains the X12 transaction set and version.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * FormatOptionsProperty formatOptionsProperty = FormatOptionsProperty.builder()
     *         .x12(X12DetailsProperty.builder()
     *                 .transactionSet("transactionSet")
     *                 .version("version")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-formatoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-formatoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.FormatOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(FormatOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FormatOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-formatoptions.html#cfn-b2bi-transformer-formatoptions-x12">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-formatoptions.html#cfn-b2bi-transformer-formatoptions-x12</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getX12();

        /**
         * @return a {@link Builder} of {@link FormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FormatOptionsProperty> {
            java.lang.Object x12;

            /**
             * Sets the value of {@link FormatOptionsProperty#getX12}
             * @param x12 the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder x12(software.amazon.awscdk.IResolvable x12) {
                this.x12 = x12;
                return this;
            }

            /**
             * Sets the value of {@link FormatOptionsProperty#getX12}
             * @param x12 the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder x12(software.amazon.awscdk.services.b2bi.CfnTransformer.X12DetailsProperty x12) {
                this.x12 = x12;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FormatOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FormatOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FormatOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FormatOptionsProperty {
            private final java.lang.Object x12;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.x12 = software.amazon.jsii.Kernel.get(this, "x12", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.x12 = java.util.Objects.requireNonNull(builder.x12, "x12 is required");
            }

            @Override
            public final java.lang.Object getX12() {
                return this.x12;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("x12", om.valueToTree(this.getX12()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.FormatOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FormatOptionsProperty.Jsii$Proxy that = (FormatOptionsProperty.Jsii$Proxy) o;

                return this.x12.equals(that.x12);
            }

            @Override
            public final int hashCode() {
                int result = this.x12.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains the input formatting options for an inbound transformer (takes an X12-formatted EDI document as input and converts it to JSON or XML.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * InputConversionProperty inputConversionProperty = InputConversionProperty.builder()
     *         .fromFormat("fromFormat")
     *         // the properties below are optional
     *         .advancedOptions(AdvancedOptionsProperty.builder()
     *                 .x12(X12AdvancedOptionsProperty.builder()
     *                         .splitOptions(X12SplitOptionsProperty.builder()
     *                                 .splitBy("splitBy")
     *                                 .build())
     *                         .validationOptions(X12ValidationOptionsProperty.builder()
     *                                 .validationRules(List.of(X12ValidationRuleProperty.builder()
     *                                         .codeListValidationRule(X12CodeListValidationRuleProperty.builder()
     *                                                 .elementId("elementId")
     *                                                 // the properties below are optional
     *                                                 .codesToAdd(List.of("codesToAdd"))
     *                                                 .codesToRemove(List.of("codesToRemove"))
     *                                                 .build())
     *                                         .elementLengthValidationRule(X12ElementLengthValidationRuleProperty.builder()
     *                                                 .elementId("elementId")
     *                                                 .maxLength(123)
     *                                                 .minLength(123)
     *                                                 .build())
     *                                         .elementRequirementValidationRule(X12ElementRequirementValidationRuleProperty.builder()
     *                                                 .elementPosition("elementPosition")
     *                                                 .requirement("requirement")
     *                                                 .build())
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .formatOptions(FormatOptionsProperty.builder()
     *                 .x12(X12DetailsProperty.builder()
     *                         .transactionSet("transactionSet")
     *                         .version("version")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-inputconversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-inputconversion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.InputConversionProperty")
    @software.amazon.jsii.Jsii.Proxy(InputConversionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputConversionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The format for the transformer input: currently on <code>X12</code> is supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-inputconversion.html#cfn-b2bi-transformer-inputconversion-fromformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-inputconversion.html#cfn-b2bi-transformer-inputconversion-fromformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFromFormat();

        /**
         * Specifies advanced options for the input conversion process.
         * <p>
         * These options provide additional control over how EDI files are processed during transformation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-inputconversion.html#cfn-b2bi-transformer-inputconversion-advancedoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-inputconversion.html#cfn-b2bi-transformer-inputconversion-advancedoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedOptions() {
            return null;
        }

        /**
         * A structure that contains the formatting options for an inbound transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-inputconversion.html#cfn-b2bi-transformer-inputconversion-formatoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-inputconversion.html#cfn-b2bi-transformer-inputconversion-formatoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFormatOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputConversionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputConversionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputConversionProperty> {
            java.lang.String fromFormat;
            java.lang.Object advancedOptions;
            java.lang.Object formatOptions;

            /**
             * Sets the value of {@link InputConversionProperty#getFromFormat}
             * @param fromFormat The format for the transformer input: currently on <code>X12</code> is supported. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fromFormat(java.lang.String fromFormat) {
                this.fromFormat = fromFormat;
                return this;
            }

            /**
             * Sets the value of {@link InputConversionProperty#getAdvancedOptions}
             * @param advancedOptions Specifies advanced options for the input conversion process.
             *                        These options provide additional control over how EDI files are processed during transformation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedOptions(software.amazon.awscdk.IResolvable advancedOptions) {
                this.advancedOptions = advancedOptions;
                return this;
            }

            /**
             * Sets the value of {@link InputConversionProperty#getAdvancedOptions}
             * @param advancedOptions Specifies advanced options for the input conversion process.
             *                        These options provide additional control over how EDI files are processed during transformation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedOptions(software.amazon.awscdk.services.b2bi.CfnTransformer.AdvancedOptionsProperty advancedOptions) {
                this.advancedOptions = advancedOptions;
                return this;
            }

            /**
             * Sets the value of {@link InputConversionProperty#getFormatOptions}
             * @param formatOptions A structure that contains the formatting options for an inbound transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatOptions(software.amazon.awscdk.IResolvable formatOptions) {
                this.formatOptions = formatOptions;
                return this;
            }

            /**
             * Sets the value of {@link InputConversionProperty#getFormatOptions}
             * @param formatOptions A structure that contains the formatting options for an inbound transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatOptions(software.amazon.awscdk.services.b2bi.CfnTransformer.FormatOptionsProperty formatOptions) {
                this.formatOptions = formatOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputConversionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputConversionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputConversionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputConversionProperty {
            private final java.lang.String fromFormat;
            private final java.lang.Object advancedOptions;
            private final java.lang.Object formatOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fromFormat = software.amazon.jsii.Kernel.get(this, "fromFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.advancedOptions = software.amazon.jsii.Kernel.get(this, "advancedOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.formatOptions = software.amazon.jsii.Kernel.get(this, "formatOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fromFormat = java.util.Objects.requireNonNull(builder.fromFormat, "fromFormat is required");
                this.advancedOptions = builder.advancedOptions;
                this.formatOptions = builder.formatOptions;
            }

            @Override
            public final java.lang.String getFromFormat() {
                return this.fromFormat;
            }

            @Override
            public final java.lang.Object getAdvancedOptions() {
                return this.advancedOptions;
            }

            @Override
            public final java.lang.Object getFormatOptions() {
                return this.formatOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fromFormat", om.valueToTree(this.getFromFormat()));
                if (this.getAdvancedOptions() != null) {
                    data.set("advancedOptions", om.valueToTree(this.getAdvancedOptions()));
                }
                if (this.getFormatOptions() != null) {
                    data.set("formatOptions", om.valueToTree(this.getFormatOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.InputConversionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputConversionProperty.Jsii$Proxy that = (InputConversionProperty.Jsii$Proxy) o;

                if (!fromFormat.equals(that.fromFormat)) return false;
                if (this.advancedOptions != null ? !this.advancedOptions.equals(that.advancedOptions) : that.advancedOptions != null) return false;
                return this.formatOptions != null ? this.formatOptions.equals(that.formatOptions) : that.formatOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fromFormat.hashCode();
                result = 31 * result + (this.advancedOptions != null ? this.advancedOptions.hashCode() : 0);
                result = 31 * result + (this.formatOptions != null ? this.formatOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the mapping template for the transformer.
     * <p>
     * This template is used to map the parsed EDI file using JSONata or XSLT.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * MappingProperty mappingProperty = MappingProperty.builder()
     *         .templateLanguage("templateLanguage")
     *         // the properties below are optional
     *         .template("template")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-mapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-mapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.MappingProperty")
    @software.amazon.jsii.Jsii.Proxy(MappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The transformation language for the template, either XSLT or JSONATA.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-mapping.html#cfn-b2bi-transformer-mapping-templatelanguage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-mapping.html#cfn-b2bi-transformer-mapping-templatelanguage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTemplateLanguage();

        /**
         * A string that represents the mapping template, in the transformation language specified in <code>templateLanguage</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-mapping.html#cfn-b2bi-transformer-mapping-template">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-mapping.html#cfn-b2bi-transformer-mapping-template</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTemplate() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MappingProperty> {
            java.lang.String templateLanguage;
            java.lang.String template;

            /**
             * Sets the value of {@link MappingProperty#getTemplateLanguage}
             * @param templateLanguage The transformation language for the template, either XSLT or JSONATA. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateLanguage(java.lang.String templateLanguage) {
                this.templateLanguage = templateLanguage;
                return this;
            }

            /**
             * Sets the value of {@link MappingProperty#getTemplate}
             * @param template A string that represents the mapping template, in the transformation language specified in <code>templateLanguage</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder template(java.lang.String template) {
                this.template = template;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MappingProperty {
            private final java.lang.String templateLanguage;
            private final java.lang.String template;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.templateLanguage = software.amazon.jsii.Kernel.get(this, "templateLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.template = software.amazon.jsii.Kernel.get(this, "template", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.templateLanguage = java.util.Objects.requireNonNull(builder.templateLanguage, "templateLanguage is required");
                this.template = builder.template;
            }

            @Override
            public final java.lang.String getTemplateLanguage() {
                return this.templateLanguage;
            }

            @Override
            public final java.lang.String getTemplate() {
                return this.template;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("templateLanguage", om.valueToTree(this.getTemplateLanguage()));
                if (this.getTemplate() != null) {
                    data.set("template", om.valueToTree(this.getTemplate()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.MappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MappingProperty.Jsii$Proxy that = (MappingProperty.Jsii$Proxy) o;

                if (!templateLanguage.equals(that.templateLanguage)) return false;
                return this.template != null ? this.template.equals(that.template) : that.template == null;
            }

            @Override
            public final int hashCode() {
                int result = this.templateLanguage.hashCode();
                result = 31 * result + (this.template != null ? this.template.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the formatting options for an outbound transformer (takes JSON or XML as input and converts it to an EDI document (currently only X12 format is supported).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * OutputConversionProperty outputConversionProperty = OutputConversionProperty.builder()
     *         .toFormat("toFormat")
     *         // the properties below are optional
     *         .advancedOptions(AdvancedOptionsProperty.builder()
     *                 .x12(X12AdvancedOptionsProperty.builder()
     *                         .splitOptions(X12SplitOptionsProperty.builder()
     *                                 .splitBy("splitBy")
     *                                 .build())
     *                         .validationOptions(X12ValidationOptionsProperty.builder()
     *                                 .validationRules(List.of(X12ValidationRuleProperty.builder()
     *                                         .codeListValidationRule(X12CodeListValidationRuleProperty.builder()
     *                                                 .elementId("elementId")
     *                                                 // the properties below are optional
     *                                                 .codesToAdd(List.of("codesToAdd"))
     *                                                 .codesToRemove(List.of("codesToRemove"))
     *                                                 .build())
     *                                         .elementLengthValidationRule(X12ElementLengthValidationRuleProperty.builder()
     *                                                 .elementId("elementId")
     *                                                 .maxLength(123)
     *                                                 .minLength(123)
     *                                                 .build())
     *                                         .elementRequirementValidationRule(X12ElementRequirementValidationRuleProperty.builder()
     *                                                 .elementPosition("elementPosition")
     *                                                 .requirement("requirement")
     *                                                 .build())
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .formatOptions(FormatOptionsProperty.builder()
     *                 .x12(X12DetailsProperty.builder()
     *                         .transactionSet("transactionSet")
     *                         .version("version")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.OutputConversionProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputConversionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputConversionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The format for the output from an outbound transformer: only X12 is currently supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html#cfn-b2bi-transformer-outputconversion-toformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html#cfn-b2bi-transformer-outputconversion-toformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getToFormat();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html#cfn-b2bi-transformer-outputconversion-advancedoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html#cfn-b2bi-transformer-outputconversion-advancedoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedOptions() {
            return null;
        }

        /**
         * A structure that contains the X12 transaction set and version for the transformer output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html#cfn-b2bi-transformer-outputconversion-formatoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-outputconversion.html#cfn-b2bi-transformer-outputconversion-formatoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFormatOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputConversionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputConversionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputConversionProperty> {
            java.lang.String toFormat;
            java.lang.Object advancedOptions;
            java.lang.Object formatOptions;

            /**
             * Sets the value of {@link OutputConversionProperty#getToFormat}
             * @param toFormat The format for the output from an outbound transformer: only X12 is currently supported. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder toFormat(java.lang.String toFormat) {
                this.toFormat = toFormat;
                return this;
            }

            /**
             * Sets the value of {@link OutputConversionProperty#getAdvancedOptions}
             * @param advancedOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedOptions(software.amazon.awscdk.IResolvable advancedOptions) {
                this.advancedOptions = advancedOptions;
                return this;
            }

            /**
             * Sets the value of {@link OutputConversionProperty#getAdvancedOptions}
             * @param advancedOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder advancedOptions(software.amazon.awscdk.services.b2bi.CfnTransformer.AdvancedOptionsProperty advancedOptions) {
                this.advancedOptions = advancedOptions;
                return this;
            }

            /**
             * Sets the value of {@link OutputConversionProperty#getFormatOptions}
             * @param formatOptions A structure that contains the X12 transaction set and version for the transformer output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatOptions(software.amazon.awscdk.IResolvable formatOptions) {
                this.formatOptions = formatOptions;
                return this;
            }

            /**
             * Sets the value of {@link OutputConversionProperty#getFormatOptions}
             * @param formatOptions A structure that contains the X12 transaction set and version for the transformer output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatOptions(software.amazon.awscdk.services.b2bi.CfnTransformer.FormatOptionsProperty formatOptions) {
                this.formatOptions = formatOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputConversionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputConversionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputConversionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputConversionProperty {
            private final java.lang.String toFormat;
            private final java.lang.Object advancedOptions;
            private final java.lang.Object formatOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.toFormat = software.amazon.jsii.Kernel.get(this, "toFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.advancedOptions = software.amazon.jsii.Kernel.get(this, "advancedOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.formatOptions = software.amazon.jsii.Kernel.get(this, "formatOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.toFormat = java.util.Objects.requireNonNull(builder.toFormat, "toFormat is required");
                this.advancedOptions = builder.advancedOptions;
                this.formatOptions = builder.formatOptions;
            }

            @Override
            public final java.lang.String getToFormat() {
                return this.toFormat;
            }

            @Override
            public final java.lang.Object getAdvancedOptions() {
                return this.advancedOptions;
            }

            @Override
            public final java.lang.Object getFormatOptions() {
                return this.formatOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("toFormat", om.valueToTree(this.getToFormat()));
                if (this.getAdvancedOptions() != null) {
                    data.set("advancedOptions", om.valueToTree(this.getAdvancedOptions()));
                }
                if (this.getFormatOptions() != null) {
                    data.set("formatOptions", om.valueToTree(this.getFormatOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.OutputConversionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputConversionProperty.Jsii$Proxy that = (OutputConversionProperty.Jsii$Proxy) o;

                if (!toFormat.equals(that.toFormat)) return false;
                if (this.advancedOptions != null ? !this.advancedOptions.equals(that.advancedOptions) : that.advancedOptions != null) return false;
                return this.formatOptions != null ? this.formatOptions.equals(that.formatOptions) : that.formatOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.toFormat.hashCode();
                result = 31 * result + (this.advancedOptions != null ? this.advancedOptions.hashCode() : 0);
                result = 31 * result + (this.formatOptions != null ? this.formatOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An array of the Amazon S3 keys used to identify the location for your sample documents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * SampleDocumentKeysProperty sampleDocumentKeysProperty = SampleDocumentKeysProperty.builder()
     *         .input("input")
     *         .output("output")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocumentkeys.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocumentkeys.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.SampleDocumentKeysProperty")
    @software.amazon.jsii.Jsii.Proxy(SampleDocumentKeysProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SampleDocumentKeysProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of keys for your input sample documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocumentkeys.html#cfn-b2bi-transformer-sampledocumentkeys-input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocumentkeys.html#cfn-b2bi-transformer-sampledocumentkeys-input</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInput() {
            return null;
        }

        /**
         * An array of keys for your output sample documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocumentkeys.html#cfn-b2bi-transformer-sampledocumentkeys-output">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocumentkeys.html#cfn-b2bi-transformer-sampledocumentkeys-output</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SampleDocumentKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SampleDocumentKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SampleDocumentKeysProperty> {
            java.lang.String input;
            java.lang.String output;

            /**
             * Sets the value of {@link SampleDocumentKeysProperty#getInput}
             * @param input An array of keys for your input sample documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.String input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link SampleDocumentKeysProperty#getOutput}
             * @param output An array of keys for your output sample documents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder output(java.lang.String output) {
                this.output = output;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SampleDocumentKeysProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SampleDocumentKeysProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SampleDocumentKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SampleDocumentKeysProperty {
            private final java.lang.String input;
            private final java.lang.String output;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.input = builder.input;
                this.output = builder.output;
            }

            @Override
            public final java.lang.String getInput() {
                return this.input;
            }

            @Override
            public final java.lang.String getOutput() {
                return this.output;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getOutput() != null) {
                    data.set("output", om.valueToTree(this.getOutput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.SampleDocumentKeysProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SampleDocumentKeysProperty.Jsii$Proxy that = (SampleDocumentKeysProperty.Jsii$Proxy) o;

                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                return this.output != null ? this.output.equals(that.output) : that.output == null;
            }

            @Override
            public final int hashCode() {
                int result = this.input != null ? this.input.hashCode() : 0;
                result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * SampleDocumentsProperty sampleDocumentsProperty = SampleDocumentsProperty.builder()
     *         .bucketName("bucketName")
     *         .keys(List.of(SampleDocumentKeysProperty.builder()
     *                 .input("input")
     *                 .output("output")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocuments.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocuments.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.SampleDocumentsProperty")
    @software.amazon.jsii.Jsii.Proxy(SampleDocumentsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SampleDocumentsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains the Amazon S3 bucket that is used to hold your sample documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocuments.html#cfn-b2bi-transformer-sampledocuments-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocuments.html#cfn-b2bi-transformer-sampledocuments-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * Contains an array of the Amazon S3 keys used to identify the location for your sample documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocuments.html#cfn-b2bi-transformer-sampledocuments-keys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-sampledocuments.html#cfn-b2bi-transformer-sampledocuments-keys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKeys();

        /**
         * @return a {@link Builder} of {@link SampleDocumentsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SampleDocumentsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SampleDocumentsProperty> {
            java.lang.String bucketName;
            java.lang.Object keys;

            /**
             * Sets the value of {@link SampleDocumentsProperty#getBucketName}
             * @param bucketName Contains the Amazon S3 bucket that is used to hold your sample documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link SampleDocumentsProperty#getKeys}
             * @param keys Contains an array of the Amazon S3 keys used to identify the location for your sample documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keys(software.amazon.awscdk.IResolvable keys) {
                this.keys = keys;
                return this;
            }

            /**
             * Sets the value of {@link SampleDocumentsProperty#getKeys}
             * @param keys Contains an array of the Amazon S3 keys used to identify the location for your sample documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keys(java.util.List<? extends java.lang.Object> keys) {
                this.keys = keys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SampleDocumentsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SampleDocumentsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SampleDocumentsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SampleDocumentsProperty {
            private final java.lang.String bucketName;
            private final java.lang.Object keys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keys = software.amazon.jsii.Kernel.get(this, "keys", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.keys = java.util.Objects.requireNonNull(builder.keys, "keys is required");
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.Object getKeys() {
                return this.keys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("keys", om.valueToTree(this.getKeys()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.SampleDocumentsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SampleDocumentsProperty.Jsii$Proxy that = (SampleDocumentsProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                return this.keys.equals(that.keys);
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.keys.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains advanced options specific to X12 EDI processing, such as splitting large X12 files into smaller units.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12AdvancedOptionsProperty x12AdvancedOptionsProperty = X12AdvancedOptionsProperty.builder()
     *         .splitOptions(X12SplitOptionsProperty.builder()
     *                 .splitBy("splitBy")
     *                 .build())
     *         .validationOptions(X12ValidationOptionsProperty.builder()
     *                 .validationRules(List.of(X12ValidationRuleProperty.builder()
     *                         .codeListValidationRule(X12CodeListValidationRuleProperty.builder()
     *                                 .elementId("elementId")
     *                                 // the properties below are optional
     *                                 .codesToAdd(List.of("codesToAdd"))
     *                                 .codesToRemove(List.of("codesToRemove"))
     *                                 .build())
     *                         .elementLengthValidationRule(X12ElementLengthValidationRuleProperty.builder()
     *                                 .elementId("elementId")
     *                                 .maxLength(123)
     *                                 .minLength(123)
     *                                 .build())
     *                         .elementRequirementValidationRule(X12ElementRequirementValidationRuleProperty.builder()
     *                                 .elementPosition("elementPosition")
     *                                 .requirement("requirement")
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12advancedoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12advancedoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.X12AdvancedOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(X12AdvancedOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12AdvancedOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies options for splitting X12 EDI files.
         * <p>
         * These options control how large X12 files are divided into smaller, more manageable units.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12advancedoptions.html#cfn-b2bi-transformer-x12advancedoptions-splitoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12advancedoptions.html#cfn-b2bi-transformer-x12advancedoptions-splitoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSplitOptions() {
            return null;
        }

        /**
         * Specifies validation options for X12 EDI processing.
         * <p>
         * These options control how validation rules are applied during EDI document processing, including custom validation rules for element length constraints, code list validations, and element requirement checks.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12advancedoptions.html#cfn-b2bi-transformer-x12advancedoptions-validationoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12advancedoptions.html#cfn-b2bi-transformer-x12advancedoptions-validationoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValidationOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12AdvancedOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12AdvancedOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12AdvancedOptionsProperty> {
            java.lang.Object splitOptions;
            java.lang.Object validationOptions;

            /**
             * Sets the value of {@link X12AdvancedOptionsProperty#getSplitOptions}
             * @param splitOptions Specifies options for splitting X12 EDI files.
             *                     These options control how large X12 files are divided into smaller, more manageable units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder splitOptions(software.amazon.awscdk.IResolvable splitOptions) {
                this.splitOptions = splitOptions;
                return this;
            }

            /**
             * Sets the value of {@link X12AdvancedOptionsProperty#getSplitOptions}
             * @param splitOptions Specifies options for splitting X12 EDI files.
             *                     These options control how large X12 files are divided into smaller, more manageable units.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder splitOptions(software.amazon.awscdk.services.b2bi.CfnTransformer.X12SplitOptionsProperty splitOptions) {
                this.splitOptions = splitOptions;
                return this;
            }

            /**
             * Sets the value of {@link X12AdvancedOptionsProperty#getValidationOptions}
             * @param validationOptions Specifies validation options for X12 EDI processing.
             *                          These options control how validation rules are applied during EDI document processing, including custom validation rules for element length constraints, code list validations, and element requirement checks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationOptions(software.amazon.awscdk.IResolvable validationOptions) {
                this.validationOptions = validationOptions;
                return this;
            }

            /**
             * Sets the value of {@link X12AdvancedOptionsProperty#getValidationOptions}
             * @param validationOptions Specifies validation options for X12 EDI processing.
             *                          These options control how validation rules are applied during EDI document processing, including custom validation rules for element length constraints, code list validations, and element requirement checks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationOptions(software.amazon.awscdk.services.b2bi.CfnTransformer.X12ValidationOptionsProperty validationOptions) {
                this.validationOptions = validationOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12AdvancedOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12AdvancedOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12AdvancedOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12AdvancedOptionsProperty {
            private final java.lang.Object splitOptions;
            private final java.lang.Object validationOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.splitOptions = software.amazon.jsii.Kernel.get(this, "splitOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.validationOptions = software.amazon.jsii.Kernel.get(this, "validationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.splitOptions = builder.splitOptions;
                this.validationOptions = builder.validationOptions;
            }

            @Override
            public final java.lang.Object getSplitOptions() {
                return this.splitOptions;
            }

            @Override
            public final java.lang.Object getValidationOptions() {
                return this.validationOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSplitOptions() != null) {
                    data.set("splitOptions", om.valueToTree(this.getSplitOptions()));
                }
                if (this.getValidationOptions() != null) {
                    data.set("validationOptions", om.valueToTree(this.getValidationOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.X12AdvancedOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12AdvancedOptionsProperty.Jsii$Proxy that = (X12AdvancedOptionsProperty.Jsii$Proxy) o;

                if (this.splitOptions != null ? !this.splitOptions.equals(that.splitOptions) : that.splitOptions != null) return false;
                return this.validationOptions != null ? this.validationOptions.equals(that.validationOptions) : that.validationOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.splitOptions != null ? this.splitOptions.hashCode() : 0;
                result = 31 * result + (this.validationOptions != null ? this.validationOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Code list validation rule configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12CodeListValidationRuleProperty x12CodeListValidationRuleProperty = X12CodeListValidationRuleProperty.builder()
     *         .elementId("elementId")
     *         // the properties below are optional
     *         .codesToAdd(List.of("codesToAdd"))
     *         .codesToRemove(List.of("codesToRemove"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12codelistvalidationrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12codelistvalidationrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.X12CodeListValidationRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(X12CodeListValidationRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12CodeListValidationRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the four-digit element ID to which the code list modifications apply.
         * <p>
         * This identifies which X12 element will have its allowed code values modified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12codelistvalidationrule.html#cfn-b2bi-transformer-x12codelistvalidationrule-elementid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12codelistvalidationrule.html#cfn-b2bi-transformer-x12codelistvalidationrule-elementid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getElementId();

        /**
         * Specifies a list of code values to add to the element's allowed values.
         * <p>
         * These codes will be considered valid for the specified element in addition to the standard codes defined by the X12 specification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12codelistvalidationrule.html#cfn-b2bi-transformer-x12codelistvalidationrule-codestoadd">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12codelistvalidationrule.html#cfn-b2bi-transformer-x12codelistvalidationrule-codestoadd</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCodesToAdd() {
            return null;
        }

        /**
         * Specifies a list of code values to remove from the element's allowed values.
         * <p>
         * These codes will be considered invalid for the specified element, even if they are part of the standard codes defined by the X12 specification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12codelistvalidationrule.html#cfn-b2bi-transformer-x12codelistvalidationrule-codestoremove">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12codelistvalidationrule.html#cfn-b2bi-transformer-x12codelistvalidationrule-codestoremove</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCodesToRemove() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12CodeListValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12CodeListValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12CodeListValidationRuleProperty> {
            java.lang.String elementId;
            java.util.List<java.lang.String> codesToAdd;
            java.util.List<java.lang.String> codesToRemove;

            /**
             * Sets the value of {@link X12CodeListValidationRuleProperty#getElementId}
             * @param elementId Specifies the four-digit element ID to which the code list modifications apply. This parameter is required.
             *                  This identifies which X12 element will have its allowed code values modified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elementId(java.lang.String elementId) {
                this.elementId = elementId;
                return this;
            }

            /**
             * Sets the value of {@link X12CodeListValidationRuleProperty#getCodesToAdd}
             * @param codesToAdd Specifies a list of code values to add to the element's allowed values.
             *                   These codes will be considered valid for the specified element in addition to the standard codes defined by the X12 specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codesToAdd(java.util.List<java.lang.String> codesToAdd) {
                this.codesToAdd = codesToAdd;
                return this;
            }

            /**
             * Sets the value of {@link X12CodeListValidationRuleProperty#getCodesToRemove}
             * @param codesToRemove Specifies a list of code values to remove from the element's allowed values.
             *                      These codes will be considered invalid for the specified element, even if they are part of the standard codes defined by the X12 specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codesToRemove(java.util.List<java.lang.String> codesToRemove) {
                this.codesToRemove = codesToRemove;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12CodeListValidationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12CodeListValidationRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12CodeListValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12CodeListValidationRuleProperty {
            private final java.lang.String elementId;
            private final java.util.List<java.lang.String> codesToAdd;
            private final java.util.List<java.lang.String> codesToRemove;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.elementId = software.amazon.jsii.Kernel.get(this, "elementId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.codesToAdd = software.amazon.jsii.Kernel.get(this, "codesToAdd", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.codesToRemove = software.amazon.jsii.Kernel.get(this, "codesToRemove", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.elementId = java.util.Objects.requireNonNull(builder.elementId, "elementId is required");
                this.codesToAdd = builder.codesToAdd;
                this.codesToRemove = builder.codesToRemove;
            }

            @Override
            public final java.lang.String getElementId() {
                return this.elementId;
            }

            @Override
            public final java.util.List<java.lang.String> getCodesToAdd() {
                return this.codesToAdd;
            }

            @Override
            public final java.util.List<java.lang.String> getCodesToRemove() {
                return this.codesToRemove;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("elementId", om.valueToTree(this.getElementId()));
                if (this.getCodesToAdd() != null) {
                    data.set("codesToAdd", om.valueToTree(this.getCodesToAdd()));
                }
                if (this.getCodesToRemove() != null) {
                    data.set("codesToRemove", om.valueToTree(this.getCodesToRemove()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.X12CodeListValidationRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12CodeListValidationRuleProperty.Jsii$Proxy that = (X12CodeListValidationRuleProperty.Jsii$Proxy) o;

                if (!elementId.equals(that.elementId)) return false;
                if (this.codesToAdd != null ? !this.codesToAdd.equals(that.codesToAdd) : that.codesToAdd != null) return false;
                return this.codesToRemove != null ? this.codesToRemove.equals(that.codesToRemove) : that.codesToRemove == null;
            }

            @Override
            public final int hashCode() {
                int result = this.elementId.hashCode();
                result = 31 * result + (this.codesToAdd != null ? this.codesToAdd.hashCode() : 0);
                result = 31 * result + (this.codesToRemove != null ? this.codesToRemove.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that contains the X12 transaction set and version.
     * <p>
     * The X12 structure is used when the system transforms an EDI (electronic data interchange) file.
     * <p>
     * <blockquote>
     * <p>
     * If an EDI input file contains more than one transaction, each transaction must have the same transaction set and version, for example 214/4010. If not, the transformer cannot parse the file.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12DetailsProperty x12DetailsProperty = X12DetailsProperty.builder()
     *         .transactionSet("transactionSet")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12details.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12details.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.X12DetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(X12DetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12DetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Returns an enumerated type where each value identifies an X12 transaction set.
         * <p>
         * Transaction sets are maintained by the X12 Accredited Standards Committee.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12details.html#cfn-b2bi-transformer-x12details-transactionset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12details.html#cfn-b2bi-transformer-x12details-transactionset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransactionSet() {
            return null;
        }

        /**
         * Returns the version to use for the specified X12 transaction set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12details.html#cfn-b2bi-transformer-x12details-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12details.html#cfn-b2bi-transformer-x12details-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12DetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12DetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12DetailsProperty> {
            java.lang.String transactionSet;
            java.lang.String version;

            /**
             * Sets the value of {@link X12DetailsProperty#getTransactionSet}
             * @param transactionSet Returns an enumerated type where each value identifies an X12 transaction set.
             *                       Transaction sets are maintained by the X12 Accredited Standards Committee.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transactionSet(java.lang.String transactionSet) {
                this.transactionSet = transactionSet;
                return this;
            }

            /**
             * Sets the value of {@link X12DetailsProperty#getVersion}
             * @param version Returns the version to use for the specified X12 transaction set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12DetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12DetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12DetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12DetailsProperty {
            private final java.lang.String transactionSet;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.transactionSet = software.amazon.jsii.Kernel.get(this, "transactionSet", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.transactionSet = builder.transactionSet;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getTransactionSet() {
                return this.transactionSet;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTransactionSet() != null) {
                    data.set("transactionSet", om.valueToTree(this.getTransactionSet()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.X12DetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12DetailsProperty.Jsii$Proxy that = (X12DetailsProperty.Jsii$Proxy) o;

                if (this.transactionSet != null ? !this.transactionSet.equals(that.transactionSet) : that.transactionSet != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.transactionSet != null ? this.transactionSet.hashCode() : 0;
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a validation rule that specifies custom length constraints for a specific X12 element.
     * <p>
     * This rule allows you to override the standard minimum and maximum length requirements for an element, enabling validation of trading partner-specific length requirements that may differ from the X12 specification. Both minimum and maximum length values must be specified.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12ElementLengthValidationRuleProperty x12ElementLengthValidationRuleProperty = X12ElementLengthValidationRuleProperty.builder()
     *         .elementId("elementId")
     *         .maxLength(123)
     *         .minLength(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementlengthvalidationrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementlengthvalidationrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.X12ElementLengthValidationRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(X12ElementLengthValidationRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12ElementLengthValidationRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the four-digit element ID to which the length constraints will be applied.
         * <p>
         * This identifies which X12 element will have its length requirements modified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementlengthvalidationrule.html#cfn-b2bi-transformer-x12elementlengthvalidationrule-elementid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementlengthvalidationrule.html#cfn-b2bi-transformer-x12elementlengthvalidationrule-elementid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getElementId();

        /**
         * Specifies the maximum allowed length for the identified element.
         * <p>
         * This value defines the upper limit for the element's content length.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementlengthvalidationrule.html#cfn-b2bi-transformer-x12elementlengthvalidationrule-maxlength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementlengthvalidationrule.html#cfn-b2bi-transformer-x12elementlengthvalidationrule-maxlength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxLength();

        /**
         * Specifies the minimum required length for the identified element.
         * <p>
         * This value defines the lower limit for the element's content length.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementlengthvalidationrule.html#cfn-b2bi-transformer-x12elementlengthvalidationrule-minlength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementlengthvalidationrule.html#cfn-b2bi-transformer-x12elementlengthvalidationrule-minlength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinLength();

        /**
         * @return a {@link Builder} of {@link X12ElementLengthValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12ElementLengthValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12ElementLengthValidationRuleProperty> {
            java.lang.String elementId;
            java.lang.Number maxLength;
            java.lang.Number minLength;

            /**
             * Sets the value of {@link X12ElementLengthValidationRuleProperty#getElementId}
             * @param elementId Specifies the four-digit element ID to which the length constraints will be applied. This parameter is required.
             *                  This identifies which X12 element will have its length requirements modified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elementId(java.lang.String elementId) {
                this.elementId = elementId;
                return this;
            }

            /**
             * Sets the value of {@link X12ElementLengthValidationRuleProperty#getMaxLength}
             * @param maxLength Specifies the maximum allowed length for the identified element. This parameter is required.
             *                  This value defines the upper limit for the element's content length.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxLength(java.lang.Number maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            /**
             * Sets the value of {@link X12ElementLengthValidationRuleProperty#getMinLength}
             * @param minLength Specifies the minimum required length for the identified element. This parameter is required.
             *                  This value defines the lower limit for the element's content length.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minLength(java.lang.Number minLength) {
                this.minLength = minLength;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12ElementLengthValidationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12ElementLengthValidationRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12ElementLengthValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12ElementLengthValidationRuleProperty {
            private final java.lang.String elementId;
            private final java.lang.Number maxLength;
            private final java.lang.Number minLength;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.elementId = software.amazon.jsii.Kernel.get(this, "elementId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.maxLength = software.amazon.jsii.Kernel.get(this, "maxLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minLength = software.amazon.jsii.Kernel.get(this, "minLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.elementId = java.util.Objects.requireNonNull(builder.elementId, "elementId is required");
                this.maxLength = java.util.Objects.requireNonNull(builder.maxLength, "maxLength is required");
                this.minLength = java.util.Objects.requireNonNull(builder.minLength, "minLength is required");
            }

            @Override
            public final java.lang.String getElementId() {
                return this.elementId;
            }

            @Override
            public final java.lang.Number getMaxLength() {
                return this.maxLength;
            }

            @Override
            public final java.lang.Number getMinLength() {
                return this.minLength;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("elementId", om.valueToTree(this.getElementId()));
                data.set("maxLength", om.valueToTree(this.getMaxLength()));
                data.set("minLength", om.valueToTree(this.getMinLength()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.X12ElementLengthValidationRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12ElementLengthValidationRuleProperty.Jsii$Proxy that = (X12ElementLengthValidationRuleProperty.Jsii$Proxy) o;

                if (!elementId.equals(that.elementId)) return false;
                if (!maxLength.equals(that.maxLength)) return false;
                return this.minLength.equals(that.minLength);
            }

            @Override
            public final int hashCode() {
                int result = this.elementId.hashCode();
                result = 31 * result + (this.maxLength.hashCode());
                result = 31 * result + (this.minLength.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines a validation rule that modifies the requirement status of a specific X12 element within a segment.
     * <p>
     * This rule allows you to make optional elements mandatory or mandatory elements optional, providing flexibility to accommodate different trading partner requirements and business rules. The rule targets a specific element position within a segment and sets its requirement status to either OPTIONAL or MANDATORY.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12ElementRequirementValidationRuleProperty x12ElementRequirementValidationRuleProperty = X12ElementRequirementValidationRuleProperty.builder()
     *         .elementPosition("elementPosition")
     *         .requirement("requirement")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementrequirementvalidationrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementrequirementvalidationrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.X12ElementRequirementValidationRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(X12ElementRequirementValidationRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12ElementRequirementValidationRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the position of the element within an X12 segment for which the requirement status will be modified.
         * <p>
         * The format follows the pattern of segment identifier followed by element position (e.g., "ST-01" for the first element of the ST segment).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementrequirementvalidationrule.html#cfn-b2bi-transformer-x12elementrequirementvalidationrule-elementposition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementrequirementvalidationrule.html#cfn-b2bi-transformer-x12elementrequirementvalidationrule-elementposition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getElementPosition();

        /**
         * Specifies the requirement status for the element at the specified position.
         * <p>
         * Valid values are OPTIONAL (the element may be omitted) or MANDATORY (the element must be present).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementrequirementvalidationrule.html#cfn-b2bi-transformer-x12elementrequirementvalidationrule-requirement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12elementrequirementvalidationrule.html#cfn-b2bi-transformer-x12elementrequirementvalidationrule-requirement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRequirement();

        /**
         * @return a {@link Builder} of {@link X12ElementRequirementValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12ElementRequirementValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12ElementRequirementValidationRuleProperty> {
            java.lang.String elementPosition;
            java.lang.String requirement;

            /**
             * Sets the value of {@link X12ElementRequirementValidationRuleProperty#getElementPosition}
             * @param elementPosition Specifies the position of the element within an X12 segment for which the requirement status will be modified. This parameter is required.
             *                        The format follows the pattern of segment identifier followed by element position (e.g., "ST-01" for the first element of the ST segment).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elementPosition(java.lang.String elementPosition) {
                this.elementPosition = elementPosition;
                return this;
            }

            /**
             * Sets the value of {@link X12ElementRequirementValidationRuleProperty#getRequirement}
             * @param requirement Specifies the requirement status for the element at the specified position. This parameter is required.
             *                    Valid values are OPTIONAL (the element may be omitted) or MANDATORY (the element must be present).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requirement(java.lang.String requirement) {
                this.requirement = requirement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12ElementRequirementValidationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12ElementRequirementValidationRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12ElementRequirementValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12ElementRequirementValidationRuleProperty {
            private final java.lang.String elementPosition;
            private final java.lang.String requirement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.elementPosition = software.amazon.jsii.Kernel.get(this, "elementPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.requirement = software.amazon.jsii.Kernel.get(this, "requirement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.elementPosition = java.util.Objects.requireNonNull(builder.elementPosition, "elementPosition is required");
                this.requirement = java.util.Objects.requireNonNull(builder.requirement, "requirement is required");
            }

            @Override
            public final java.lang.String getElementPosition() {
                return this.elementPosition;
            }

            @Override
            public final java.lang.String getRequirement() {
                return this.requirement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("elementPosition", om.valueToTree(this.getElementPosition()));
                data.set("requirement", om.valueToTree(this.getRequirement()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.X12ElementRequirementValidationRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12ElementRequirementValidationRuleProperty.Jsii$Proxy that = (X12ElementRequirementValidationRuleProperty.Jsii$Proxy) o;

                if (!elementPosition.equals(that.elementPosition)) return false;
                return this.requirement.equals(that.requirement);
            }

            @Override
            public final int hashCode() {
                int result = this.elementPosition.hashCode();
                result = 31 * result + (this.requirement.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains options for splitting X12 EDI files into smaller units.
     * <p>
     * This is useful for processing large EDI files more efficiently.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12SplitOptionsProperty x12SplitOptionsProperty = X12SplitOptionsProperty.builder()
     *         .splitBy("splitBy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12splitoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12splitoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.X12SplitOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(X12SplitOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12SplitOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the method used to split X12 EDI files.
         * <p>
         * Valid values include <code>TRANSACTION</code> (split by individual transaction sets), or <code>NONE</code> (no splitting).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12splitoptions.html#cfn-b2bi-transformer-x12splitoptions-splitby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12splitoptions.html#cfn-b2bi-transformer-x12splitoptions-splitby</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSplitBy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12SplitOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12SplitOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12SplitOptionsProperty> {
            java.lang.String splitBy;

            /**
             * Sets the value of {@link X12SplitOptionsProperty#getSplitBy}
             * @param splitBy Specifies the method used to split X12 EDI files.
             *                Valid values include <code>TRANSACTION</code> (split by individual transaction sets), or <code>NONE</code> (no splitting).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder splitBy(java.lang.String splitBy) {
                this.splitBy = splitBy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12SplitOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12SplitOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12SplitOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12SplitOptionsProperty {
            private final java.lang.String splitBy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.splitBy = software.amazon.jsii.Kernel.get(this, "splitBy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.splitBy = builder.splitBy;
            }

            @Override
            public final java.lang.String getSplitBy() {
                return this.splitBy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSplitBy() != null) {
                    data.set("splitBy", om.valueToTree(this.getSplitBy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.X12SplitOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12SplitOptionsProperty.Jsii$Proxy that = (X12SplitOptionsProperty.Jsii$Proxy) o;

                return this.splitBy != null ? this.splitBy.equals(that.splitBy) : that.splitBy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.splitBy != null ? this.splitBy.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains configuration options for X12 EDI validation.
     * <p>
     * This structure allows you to specify custom validation rules that will be applied during EDI document processing, including element length constraints, code list modifications, and element requirement changes. These validation options provide flexibility to accommodate trading partner-specific requirements while maintaining EDI compliance. The validation rules are applied in addition to standard X12 validation to ensure documents meet both standard and custom requirements.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12ValidationOptionsProperty x12ValidationOptionsProperty = X12ValidationOptionsProperty.builder()
     *         .validationRules(List.of(X12ValidationRuleProperty.builder()
     *                 .codeListValidationRule(X12CodeListValidationRuleProperty.builder()
     *                         .elementId("elementId")
     *                         // the properties below are optional
     *                         .codesToAdd(List.of("codesToAdd"))
     *                         .codesToRemove(List.of("codesToRemove"))
     *                         .build())
     *                 .elementLengthValidationRule(X12ElementLengthValidationRuleProperty.builder()
     *                         .elementId("elementId")
     *                         .maxLength(123)
     *                         .minLength(123)
     *                         .build())
     *                 .elementRequirementValidationRule(X12ElementRequirementValidationRuleProperty.builder()
     *                         .elementPosition("elementPosition")
     *                         .requirement("requirement")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.X12ValidationOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(X12ValidationOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12ValidationOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a list of validation rules to apply during EDI document processing.
         * <p>
         * These rules can include code list modifications, element length constraints, and element requirement changes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationoptions.html#cfn-b2bi-transformer-x12validationoptions-validationrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationoptions.html#cfn-b2bi-transformer-x12validationoptions-validationrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValidationRules() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12ValidationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12ValidationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12ValidationOptionsProperty> {
            java.lang.Object validationRules;

            /**
             * Sets the value of {@link X12ValidationOptionsProperty#getValidationRules}
             * @param validationRules Specifies a list of validation rules to apply during EDI document processing.
             *                        These rules can include code list modifications, element length constraints, and element requirement changes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationRules(software.amazon.awscdk.IResolvable validationRules) {
                this.validationRules = validationRules;
                return this;
            }

            /**
             * Sets the value of {@link X12ValidationOptionsProperty#getValidationRules}
             * @param validationRules Specifies a list of validation rules to apply during EDI document processing.
             *                        These rules can include code list modifications, element length constraints, and element requirement changes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder validationRules(java.util.List<? extends java.lang.Object> validationRules) {
                this.validationRules = validationRules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12ValidationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12ValidationOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12ValidationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12ValidationOptionsProperty {
            private final java.lang.Object validationRules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.validationRules = software.amazon.jsii.Kernel.get(this, "validationRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.validationRules = builder.validationRules;
            }

            @Override
            public final java.lang.Object getValidationRules() {
                return this.validationRules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValidationRules() != null) {
                    data.set("validationRules", om.valueToTree(this.getValidationRules()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.X12ValidationOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12ValidationOptionsProperty.Jsii$Proxy that = (X12ValidationOptionsProperty.Jsii$Proxy) o;

                return this.validationRules != null ? this.validationRules.equals(that.validationRules) : that.validationRules == null;
            }

            @Override
            public final int hashCode() {
                int result = this.validationRules != null ? this.validationRules.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Represents a single validation rule that can be applied during X12 EDI processing.
     * <p>
     * This is a union type that can contain one of several specific validation rule types: code list validation rules for modifying allowed element codes, element length validation rules for enforcing custom length constraints, or element requirement validation rules for changing mandatory/optional status. Each validation rule targets specific aspects of EDI document validation to ensure compliance with trading partner requirements and business rules.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.b2bi.*;
     * X12ValidationRuleProperty x12ValidationRuleProperty = X12ValidationRuleProperty.builder()
     *         .codeListValidationRule(X12CodeListValidationRuleProperty.builder()
     *                 .elementId("elementId")
     *                 // the properties below are optional
     *                 .codesToAdd(List.of("codesToAdd"))
     *                 .codesToRemove(List.of("codesToRemove"))
     *                 .build())
     *         .elementLengthValidationRule(X12ElementLengthValidationRuleProperty.builder()
     *                 .elementId("elementId")
     *                 .maxLength(123)
     *                 .minLength(123)
     *                 .build())
     *         .elementRequirementValidationRule(X12ElementRequirementValidationRuleProperty.builder()
     *                 .elementPosition("elementPosition")
     *                 .requirement("requirement")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_b2bi.CfnTransformer.X12ValidationRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(X12ValidationRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface X12ValidationRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies a code list validation rule that modifies the allowed code values for a specific X12 element.
         * <p>
         * This rule enables you to customize which codes are considered valid for an element, allowing for trading partner-specific code requirements.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationrule.html#cfn-b2bi-transformer-x12validationrule-codelistvalidationrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationrule.html#cfn-b2bi-transformer-x12validationrule-codelistvalidationrule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCodeListValidationRule() {
            return null;
        }

        /**
         * Specifies an element length validation rule that defines custom length constraints for a specific X12 element.
         * <p>
         * This rule allows you to enforce minimum and maximum length requirements that may differ from the standard X12 specification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationrule.html#cfn-b2bi-transformer-x12validationrule-elementlengthvalidationrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationrule.html#cfn-b2bi-transformer-x12validationrule-elementlengthvalidationrule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElementLengthValidationRule() {
            return null;
        }

        /**
         * Specifies an element requirement validation rule that modifies whether a specific X12 element is required or optional within a segment.
         * <p>
         * This rule provides flexibility to accommodate different trading partner requirements for element presence.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationrule.html#cfn-b2bi-transformer-x12validationrule-elementrequirementvalidationrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-b2bi-transformer-x12validationrule.html#cfn-b2bi-transformer-x12validationrule-elementrequirementvalidationrule</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElementRequirementValidationRule() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link X12ValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link X12ValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<X12ValidationRuleProperty> {
            java.lang.Object codeListValidationRule;
            java.lang.Object elementLengthValidationRule;
            java.lang.Object elementRequirementValidationRule;

            /**
             * Sets the value of {@link X12ValidationRuleProperty#getCodeListValidationRule}
             * @param codeListValidationRule Specifies a code list validation rule that modifies the allowed code values for a specific X12 element.
             *                               This rule enables you to customize which codes are considered valid for an element, allowing for trading partner-specific code requirements.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeListValidationRule(software.amazon.awscdk.IResolvable codeListValidationRule) {
                this.codeListValidationRule = codeListValidationRule;
                return this;
            }

            /**
             * Sets the value of {@link X12ValidationRuleProperty#getCodeListValidationRule}
             * @param codeListValidationRule Specifies a code list validation rule that modifies the allowed code values for a specific X12 element.
             *                               This rule enables you to customize which codes are considered valid for an element, allowing for trading partner-specific code requirements.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder codeListValidationRule(software.amazon.awscdk.services.b2bi.CfnTransformer.X12CodeListValidationRuleProperty codeListValidationRule) {
                this.codeListValidationRule = codeListValidationRule;
                return this;
            }

            /**
             * Sets the value of {@link X12ValidationRuleProperty#getElementLengthValidationRule}
             * @param elementLengthValidationRule Specifies an element length validation rule that defines custom length constraints for a specific X12 element.
             *                                    This rule allows you to enforce minimum and maximum length requirements that may differ from the standard X12 specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elementLengthValidationRule(software.amazon.awscdk.IResolvable elementLengthValidationRule) {
                this.elementLengthValidationRule = elementLengthValidationRule;
                return this;
            }

            /**
             * Sets the value of {@link X12ValidationRuleProperty#getElementLengthValidationRule}
             * @param elementLengthValidationRule Specifies an element length validation rule that defines custom length constraints for a specific X12 element.
             *                                    This rule allows you to enforce minimum and maximum length requirements that may differ from the standard X12 specification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elementLengthValidationRule(software.amazon.awscdk.services.b2bi.CfnTransformer.X12ElementLengthValidationRuleProperty elementLengthValidationRule) {
                this.elementLengthValidationRule = elementLengthValidationRule;
                return this;
            }

            /**
             * Sets the value of {@link X12ValidationRuleProperty#getElementRequirementValidationRule}
             * @param elementRequirementValidationRule Specifies an element requirement validation rule that modifies whether a specific X12 element is required or optional within a segment.
             *                                         This rule provides flexibility to accommodate different trading partner requirements for element presence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elementRequirementValidationRule(software.amazon.awscdk.IResolvable elementRequirementValidationRule) {
                this.elementRequirementValidationRule = elementRequirementValidationRule;
                return this;
            }

            /**
             * Sets the value of {@link X12ValidationRuleProperty#getElementRequirementValidationRule}
             * @param elementRequirementValidationRule Specifies an element requirement validation rule that modifies whether a specific X12 element is required or optional within a segment.
             *                                         This rule provides flexibility to accommodate different trading partner requirements for element presence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elementRequirementValidationRule(software.amazon.awscdk.services.b2bi.CfnTransformer.X12ElementRequirementValidationRuleProperty elementRequirementValidationRule) {
                this.elementRequirementValidationRule = elementRequirementValidationRule;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link X12ValidationRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public X12ValidationRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link X12ValidationRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements X12ValidationRuleProperty {
            private final java.lang.Object codeListValidationRule;
            private final java.lang.Object elementLengthValidationRule;
            private final java.lang.Object elementRequirementValidationRule;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.codeListValidationRule = software.amazon.jsii.Kernel.get(this, "codeListValidationRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elementLengthValidationRule = software.amazon.jsii.Kernel.get(this, "elementLengthValidationRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.elementRequirementValidationRule = software.amazon.jsii.Kernel.get(this, "elementRequirementValidationRule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.codeListValidationRule = builder.codeListValidationRule;
                this.elementLengthValidationRule = builder.elementLengthValidationRule;
                this.elementRequirementValidationRule = builder.elementRequirementValidationRule;
            }

            @Override
            public final java.lang.Object getCodeListValidationRule() {
                return this.codeListValidationRule;
            }

            @Override
            public final java.lang.Object getElementLengthValidationRule() {
                return this.elementLengthValidationRule;
            }

            @Override
            public final java.lang.Object getElementRequirementValidationRule() {
                return this.elementRequirementValidationRule;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCodeListValidationRule() != null) {
                    data.set("codeListValidationRule", om.valueToTree(this.getCodeListValidationRule()));
                }
                if (this.getElementLengthValidationRule() != null) {
                    data.set("elementLengthValidationRule", om.valueToTree(this.getElementLengthValidationRule()));
                }
                if (this.getElementRequirementValidationRule() != null) {
                    data.set("elementRequirementValidationRule", om.valueToTree(this.getElementRequirementValidationRule()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_b2bi.CfnTransformer.X12ValidationRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                X12ValidationRuleProperty.Jsii$Proxy that = (X12ValidationRuleProperty.Jsii$Proxy) o;

                if (this.codeListValidationRule != null ? !this.codeListValidationRule.equals(that.codeListValidationRule) : that.codeListValidationRule != null) return false;
                if (this.elementLengthValidationRule != null ? !this.elementLengthValidationRule.equals(that.elementLengthValidationRule) : that.elementLengthValidationRule != null) return false;
                return this.elementRequirementValidationRule != null ? this.elementRequirementValidationRule.equals(that.elementRequirementValidationRule) : that.elementRequirementValidationRule == null;
            }

            @Override
            public final int hashCode() {
                int result = this.codeListValidationRule != null ? this.codeListValidationRule.hashCode() : 0;
                result = 31 * result + (this.elementLengthValidationRule != null ? this.elementLengthValidationRule.hashCode() : 0);
                result = 31 * result + (this.elementRequirementValidationRule != null ? this.elementRequirementValidationRule.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.b2bi.CfnTransformer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.b2bi.CfnTransformer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.b2bi.CfnTransformerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.b2bi.CfnTransformerProps.Builder();
        }

        /**
         * Returns the descriptive name for the transformer.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-name</a>
         * @param name Returns the descriptive name for the transformer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Returns the state of the newly created transformer.
         * <p>
         * The transformer can be either <code>active</code> or <code>inactive</code> . For the transformer to be used in a capability, its status must <code>active</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-status</a>
         * @param status Returns the state of the newly created transformer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(final java.lang.String status) {
            this.props.status(status);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-editype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-editype</a>
         * @deprecated this property has been deprecated
         * @param ediType This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder ediType(final software.amazon.awscdk.IResolvable ediType) {
            this.props.ediType(ediType);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-editype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-editype</a>
         * @deprecated this property has been deprecated
         * @param ediType This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder ediType(final software.amazon.awscdk.services.b2bi.CfnTransformer.EdiTypeProperty ediType) {
            this.props.ediType(ediType);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-fileformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-fileformat</a>
         * @deprecated this property has been deprecated
         * @param fileFormat This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder fileFormat(final java.lang.String fileFormat) {
            this.props.fileFormat(fileFormat);
            return this;
        }

        /**
         * Returns a structure that contains the format options for the transformation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-inputconversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-inputconversion</a>
         * @param inputConversion Returns a structure that contains the format options for the transformation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputConversion(final software.amazon.awscdk.IResolvable inputConversion) {
            this.props.inputConversion(inputConversion);
            return this;
        }
        /**
         * Returns a structure that contains the format options for the transformation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-inputconversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-inputconversion</a>
         * @param inputConversion Returns a structure that contains the format options for the transformation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputConversion(final software.amazon.awscdk.services.b2bi.CfnTransformer.InputConversionProperty inputConversion) {
            this.props.inputConversion(inputConversion);
            return this;
        }

        /**
         * Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mapping</a>
         * @param mapping Returns the structure that contains the mapping template and its language (either XSLT or JSONATA). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapping(final software.amazon.awscdk.IResolvable mapping) {
            this.props.mapping(mapping);
            return this;
        }
        /**
         * Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mapping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mapping</a>
         * @param mapping Returns the structure that contains the mapping template and its language (either XSLT or JSONATA). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapping(final software.amazon.awscdk.services.b2bi.CfnTransformer.MappingProperty mapping) {
            this.props.mapping(mapping);
            return this;
        }

        /**
         * (deprecated) This shape is deprecated: This is a legacy trait.
         * <p>
         * Please use input-conversion or output-conversion.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mappingtemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-mappingtemplate</a>
         * @deprecated this property has been deprecated
         * @param mappingTemplate This shape is deprecated: This is a legacy trait. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder mappingTemplate(final java.lang.String mappingTemplate) {
            this.props.mappingTemplate(mappingTemplate);
            return this;
        }

        /**
         * Returns the <code>OutputConversion</code> object, which contains the format options for the outbound transformation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-outputconversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-outputconversion</a>
         * @param outputConversion Returns the <code>OutputConversion</code> object, which contains the format options for the outbound transformation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputConversion(final software.amazon.awscdk.IResolvable outputConversion) {
            this.props.outputConversion(outputConversion);
            return this;
        }
        /**
         * Returns the <code>OutputConversion</code> object, which contains the format options for the outbound transformation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-outputconversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-outputconversion</a>
         * @param outputConversion Returns the <code>OutputConversion</code> object, which contains the format options for the outbound transformation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputConversion(final software.amazon.awscdk.services.b2bi.CfnTransformer.OutputConversionProperty outputConversion) {
            this.props.outputConversion(outputConversion);
            return this;
        }

        /**
         * (deprecated) This shape is deprecated: This is a legacy trait.
         * <p>
         * Please use input-conversion or output-conversion.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocument</a>
         * @deprecated this property has been deprecated
         * @param sampleDocument This shape is deprecated: This is a legacy trait. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder sampleDocument(final java.lang.String sampleDocument) {
            this.props.sampleDocument(sampleDocument);
            return this;
        }

        /**
         * Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocuments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocuments</a>
         * @param sampleDocuments Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sampleDocuments(final software.amazon.awscdk.IResolvable sampleDocuments) {
            this.props.sampleDocuments(sampleDocuments);
            return this;
        }
        /**
         * Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocuments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-sampledocuments</a>
         * @param sampleDocuments Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sampleDocuments(final software.amazon.awscdk.services.b2bi.CfnTransformer.SampleDocumentsProperty sampleDocuments) {
            this.props.sampleDocuments(sampleDocuments);
            return this;
        }

        /**
         * A key-value pair for a specific transformer.
         * <p>
         * Tags are metadata that you can use to search for and group capabilities for various purposes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-b2bi-transformer.html#cfn-b2bi-transformer-tags</a>
         * @param tags A key-value pair for a specific transformer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.b2bi.CfnTransformer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.b2bi.CfnTransformer build() {
            return new software.amazon.awscdk.services.b2bi.CfnTransformer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
