package software.amazon.awscdk.services.batch;

/**
 * A secret environment variable.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ISecret mySecret;
 * EcsJobDefinition jobDefn = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "containerDefn")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .secrets(Map.of(
 *                         "MY_SECRET_ENV_VAR", Secret.fromSecretsManager(mySecret)))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:27.127Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.Secret")
public abstract class Secret extends software.amazon.jsii.JsiiObject {

    protected Secret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Secret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Secret() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a environment variable value from a secret stored in AWS Secrets Manager.
     * <p>
     * @param secret the secret stored in AWS Secrets Manager. This parameter is required.
     * @param field the name of the field with the value that you want to set as the environment variable value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Secret fromSecretsManager(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret, final @org.jetbrains.annotations.Nullable java.lang.String field) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.Secret.class, "fromSecretsManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required"), field });
    }

    /**
     * Creates a environment variable value from a secret stored in AWS Secrets Manager.
     * <p>
     * @param secret the secret stored in AWS Secrets Manager. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Secret fromSecretsManager(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.Secret.class, "fromSecretsManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * Creates a environment variable value from a secret stored in AWS Secrets Manager.
     * <p>
     * @param secret the secret stored in AWS Secrets Manager. This parameter is required.
     * @param versionInfo the version information to reference the secret. This parameter is required.
     * @param field the name of the field with the value that you want to set as the environment variable value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Secret fromSecretsManagerVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.SecretVersionInfo versionInfo, final @org.jetbrains.annotations.Nullable java.lang.String field) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.Secret.class, "fromSecretsManagerVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required"), java.util.Objects.requireNonNull(versionInfo, "versionInfo is required"), field });
    }

    /**
     * Creates a environment variable value from a secret stored in AWS Secrets Manager.
     * <p>
     * @param secret the secret stored in AWS Secrets Manager. This parameter is required.
     * @param versionInfo the version information to reference the secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Secret fromSecretsManagerVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.SecretVersionInfo versionInfo) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.Secret.class, "fromSecretsManagerVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required"), java.util.Objects.requireNonNull(versionInfo, "versionInfo is required") });
    }

    /**
     * Creates an environment variable value from a parameter stored in AWS Systems Manager Parameter Store.
     * <p>
     * @param parameter This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Secret fromSsmParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IParameter parameter) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.Secret.class, "fromSsmParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Secret.class), new Object[] { java.util.Objects.requireNonNull(parameter, "parameter is required") });
    }

    /**
     * Grants reading the secret to a principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * The ARN of the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getArn();

    /**
     * Whether this secret uses a specific JSON field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.Boolean getHasField();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.batch.Secret {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The ARN of the secret.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getArn() {
            return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Whether this secret uses a specific JSON field.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getHasField() {
            return software.amazon.jsii.Kernel.get(this, "hasField", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Grants reading the secret to a principal.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }
    }
}
