package software.amazon.awscdk.services.cassandra;

/**
 * Properties for defining a <code>CfnKeyspace</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cassandra.*;
 * CfnKeyspaceProps cfnKeyspaceProps = CfnKeyspaceProps.builder()
 *         .clientSideTimestampsEnabled(false)
 *         .keyspaceName("keyspaceName")
 *         .replicationSpecification(ReplicationSpecificationProperty.builder()
 *                 .regionList(List.of("regionList"))
 *                 .replicationStrategy("replicationStrategy")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:27.443Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnKeyspaceProps")
@software.amazon.jsii.Jsii.Proxy(CfnKeyspaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnKeyspaceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether client-side timestamps are enabled (true) or disabled (false) for all tables in the keyspace.
     * <p>
     * To add a Region to a single-Region keyspace with at least one table, the value must be set to true. After you've enabled client-side timestamps for a table, you can’t disable it again.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-clientsidetimestampsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-clientsidetimestampsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClientSideTimestampsEnabled() {
        return null;
    }

    /**
     * The name of the keyspace to be created.
     * <p>
     * The keyspace name is case sensitive. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the keyspace name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
     * <p>
     * <em>Length constraints:</em> Minimum length of 1. Maximum length of 48.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-keyspacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-keyspacename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyspaceName() {
        return null;
    }

    /**
     * Specifies the <code>ReplicationStrategy</code> of a keyspace. The options are:.
     * <p>
     * <ul>
     * <li><code>SINGLE_REGION</code> for a single Region keyspace (optional) or</li>
     * <li><code>MULTI_REGION</code> for a multi-Region keyspace</li>
     * </ul>
     * <p>
     * If no <code>ReplicationStrategy</code> is provided, the default is <code>SINGLE_REGION</code> . If you choose <code>MULTI_REGION</code> , you must also provide a <code>RegionList</code> with the AWS Regions that the keyspace is replicated in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-replicationspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-replicationspecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReplicationSpecification() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cassandra-keyspace.html#cfn-cassandra-keyspace-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnKeyspaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnKeyspaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnKeyspaceProps> {
        java.lang.Object clientSideTimestampsEnabled;
        java.lang.String keyspaceName;
        java.lang.Object replicationSpecification;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnKeyspaceProps#getClientSideTimestampsEnabled}
         * @param clientSideTimestampsEnabled Indicates whether client-side timestamps are enabled (true) or disabled (false) for all tables in the keyspace.
         *                                    To add a Region to a single-Region keyspace with at least one table, the value must be set to true. After you've enabled client-side timestamps for a table, you can’t disable it again.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSideTimestampsEnabled(java.lang.Boolean clientSideTimestampsEnabled) {
            this.clientSideTimestampsEnabled = clientSideTimestampsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyspaceProps#getClientSideTimestampsEnabled}
         * @param clientSideTimestampsEnabled Indicates whether client-side timestamps are enabled (true) or disabled (false) for all tables in the keyspace.
         *                                    To add a Region to a single-Region keyspace with at least one table, the value must be set to true. After you've enabled client-side timestamps for a table, you can’t disable it again.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSideTimestampsEnabled(software.amazon.awscdk.IResolvable clientSideTimestampsEnabled) {
            this.clientSideTimestampsEnabled = clientSideTimestampsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyspaceProps#getKeyspaceName}
         * @param keyspaceName The name of the keyspace to be created.
         *                     The keyspace name is case sensitive. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the keyspace name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
         *                     <p>
         *                     <em>Length constraints:</em> Minimum length of 1. Maximum length of 48.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyspaceName(java.lang.String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyspaceProps#getReplicationSpecification}
         * @param replicationSpecification Specifies the <code>ReplicationStrategy</code> of a keyspace. The options are:.
         *                                 <ul>
         *                                 <li><code>SINGLE_REGION</code> for a single Region keyspace (optional) or</li>
         *                                 <li><code>MULTI_REGION</code> for a multi-Region keyspace</li>
         *                                 </ul>
         *                                 <p>
         *                                 If no <code>ReplicationStrategy</code> is provided, the default is <code>SINGLE_REGION</code> . If you choose <code>MULTI_REGION</code> , you must also provide a <code>RegionList</code> with the AWS Regions that the keyspace is replicated in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSpecification(software.amazon.awscdk.IResolvable replicationSpecification) {
            this.replicationSpecification = replicationSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyspaceProps#getReplicationSpecification}
         * @param replicationSpecification Specifies the <code>ReplicationStrategy</code> of a keyspace. The options are:.
         *                                 <ul>
         *                                 <li><code>SINGLE_REGION</code> for a single Region keyspace (optional) or</li>
         *                                 <li><code>MULTI_REGION</code> for a multi-Region keyspace</li>
         *                                 </ul>
         *                                 <p>
         *                                 If no <code>ReplicationStrategy</code> is provided, the default is <code>SINGLE_REGION</code> . If you choose <code>MULTI_REGION</code> , you must also provide a <code>RegionList</code> with the AWS Regions that the keyspace is replicated in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSpecification(software.amazon.awscdk.services.cassandra.CfnKeyspace.ReplicationSpecificationProperty replicationSpecification) {
            this.replicationSpecification = replicationSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyspaceProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnKeyspaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnKeyspaceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnKeyspaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnKeyspaceProps {
        private final java.lang.Object clientSideTimestampsEnabled;
        private final java.lang.String keyspaceName;
        private final java.lang.Object replicationSpecification;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientSideTimestampsEnabled = software.amazon.jsii.Kernel.get(this, "clientSideTimestampsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.keyspaceName = software.amazon.jsii.Kernel.get(this, "keyspaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicationSpecification = software.amazon.jsii.Kernel.get(this, "replicationSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientSideTimestampsEnabled = builder.clientSideTimestampsEnabled;
            this.keyspaceName = builder.keyspaceName;
            this.replicationSpecification = builder.replicationSpecification;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getClientSideTimestampsEnabled() {
            return this.clientSideTimestampsEnabled;
        }

        @Override
        public final java.lang.String getKeyspaceName() {
            return this.keyspaceName;
        }

        @Override
        public final java.lang.Object getReplicationSpecification() {
            return this.replicationSpecification;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getClientSideTimestampsEnabled() != null) {
                data.set("clientSideTimestampsEnabled", om.valueToTree(this.getClientSideTimestampsEnabled()));
            }
            if (this.getKeyspaceName() != null) {
                data.set("keyspaceName", om.valueToTree(this.getKeyspaceName()));
            }
            if (this.getReplicationSpecification() != null) {
                data.set("replicationSpecification", om.valueToTree(this.getReplicationSpecification()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnKeyspaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnKeyspaceProps.Jsii$Proxy that = (CfnKeyspaceProps.Jsii$Proxy) o;

            if (this.clientSideTimestampsEnabled != null ? !this.clientSideTimestampsEnabled.equals(that.clientSideTimestampsEnabled) : that.clientSideTimestampsEnabled != null) return false;
            if (this.keyspaceName != null ? !this.keyspaceName.equals(that.keyspaceName) : that.keyspaceName != null) return false;
            if (this.replicationSpecification != null ? !this.replicationSpecification.equals(that.replicationSpecification) : that.replicationSpecification != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientSideTimestampsEnabled != null ? this.clientSideTimestampsEnabled.hashCode() : 0;
            result = 31 * result + (this.keyspaceName != null ? this.keyspaceName.hashCode() : 0);
            result = 31 * result + (this.replicationSpecification != null ? this.replicationSpecification.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
