package software.amazon.awscdk.services.cloudformation;

/**
 * Properties for defining a <code>CfnStack</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudformation.*;
 * CfnStackProps cfnStackProps = CfnStackProps.builder()
 *         .notificationArns(List.of("notificationArns"))
 *         .parameters(Map.of(
 *                 "parametersKey", "parameters"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .templateUrl("templateUrl")
 *         .timeoutInMinutes(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:27.656Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudformation.CfnStackProps")
@software.amazon.jsii.Jsii.Proxy(CfnStackProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStackProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon SNS topic ARNs to publish stack related events.
     * <p>
     * You can find your Amazon SNS topic ARNs using the Amazon SNS console or your Command Line Interface (CLI).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-notificationarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-notificationarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationArns() {
        return null;
    }

    /**
     * The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
     * <p>
     * Each parameter has a name corresponding to a parameter defined in the embedded template and a value representing the value that you want to set for the parameter.
     * <p>
     * <blockquote>
     * <p>
     * If you use the <code>Ref</code> function to pass a parameter value to a nested stack, comma-delimited list parameters must be of type <code>String</code> . In other words, you can't pass values that are of type <code>CommaDelimitedList</code> to nested stacks.
     * <p>
     * </blockquote>
     * <p>
     * Required if the nested stack requires input parameters.
     * <p>
     * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-parameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
        return null;
    }

    /**
     * Key-value pairs to associate with this stack.
     * <p>
     * CloudFormation also propagates these tags to the resources created in the stack. A maximum number of 50 tags can be specified.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The URL of a file that contains the template body.
     * <p>
     * The URL must point to a template (max size: 1 MB) that's located in an Amazon S3 bucket. The location for an Amazon S3 bucket must start with <code>https://</code> .
     * <p>
     * Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-templateurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-templateurl</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateUrl() {
        return null;
    }

    /**
     * The length of time, in minutes, that CloudFormation waits for the nested stack to reach the <code>CREATE_COMPLETE</code> state.
     * <p>
     * The default is no timeout. When CloudFormation detects that the nested stack has reached the <code>CREATE_COMPLETE</code> state, it marks the nested stack resource as <code>CREATE_COMPLETE</code> in the parent stack and resumes creating the parent stack. If the timeout period expires before the nested stack reaches <code>CREATE_COMPLETE</code> , CloudFormation marks the nested stack as failed and rolls back both the nested stack and parent stack.
     * <p>
     * Updates aren't supported.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-timeoutinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-stack.html#cfn-cloudformation-stack-timeoutinminutes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMinutes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStackProps> {
        java.util.List<java.lang.String> notificationArns;
        java.lang.Object parameters;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String templateUrl;
        java.lang.Number timeoutInMinutes;

        /**
         * Sets the value of {@link CfnStackProps#getNotificationArns}
         * @param notificationArns The Amazon SNS topic ARNs to publish stack related events.
         *                         You can find your Amazon SNS topic ARNs using the Amazon SNS console or your Command Line Interface (CLI).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationArns(java.util.List<java.lang.String> notificationArns) {
            this.notificationArns = notificationArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getParameters}
         * @param parameters The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
         *                   Each parameter has a name corresponding to a parameter defined in the embedded template and a value representing the value that you want to set for the parameter.
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   If you use the <code>Ref</code> function to pass a parameter value to a nested stack, comma-delimited list parameters must be of type <code>String</code> . In other words, you can't pass values that are of type <code>CommaDelimitedList</code> to nested stacks.
         *                   <p>
         *                   </blockquote>
         *                   <p>
         *                   Required if the nested stack requires input parameters.
         *                   <p>
         *                   Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getParameters}
         * @param parameters The set value pairs that represent the parameters passed to CloudFormation when this nested stack is created.
         *                   Each parameter has a name corresponding to a parameter defined in the embedded template and a value representing the value that you want to set for the parameter.
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   If you use the <code>Ref</code> function to pass a parameter value to a nested stack, comma-delimited list parameters must be of type <code>String</code> . In other words, you can't pass values that are of type <code>CommaDelimitedList</code> to nested stacks.
         *                   <p>
         *                   </blockquote>
         *                   <p>
         *                   Required if the nested stack requires input parameters.
         *                   <p>
         *                   Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getTags}
         * @param tags Key-value pairs to associate with this stack.
         *             CloudFormation also propagates these tags to the resources created in the stack. A maximum number of 50 tags can be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getTemplateUrl}
         * @param templateUrl The URL of a file that contains the template body.
         *                    The URL must point to a template (max size: 1 MB) that's located in an Amazon S3 bucket. The location for an Amazon S3 bucket must start with <code>https://</code> .
         *                    <p>
         *                    Whether an update causes interruptions depends on the resources that are being updated. An update never causes a nested stack to be replaced.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateUrl(java.lang.String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        /**
         * Sets the value of {@link CfnStackProps#getTimeoutInMinutes}
         * @param timeoutInMinutes The length of time, in minutes, that CloudFormation waits for the nested stack to reach the <code>CREATE_COMPLETE</code> state.
         *                         The default is no timeout. When CloudFormation detects that the nested stack has reached the <code>CREATE_COMPLETE</code> state, it marks the nested stack resource as <code>CREATE_COMPLETE</code> in the parent stack and resumes creating the parent stack. If the timeout period expires before the nested stack reaches <code>CREATE_COMPLETE</code> , CloudFormation marks the nested stack as failed and rolls back both the nested stack and parent stack.
         *                         <p>
         *                         Updates aren't supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutInMinutes(java.lang.Number timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStackProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStackProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStackProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStackProps {
        private final java.util.List<java.lang.String> notificationArns;
        private final java.lang.Object parameters;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String templateUrl;
        private final java.lang.Number timeoutInMinutes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.notificationArns = software.amazon.jsii.Kernel.get(this, "notificationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.templateUrl = software.amazon.jsii.Kernel.get(this, "templateUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeoutInMinutes = software.amazon.jsii.Kernel.get(this, "timeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.notificationArns = builder.notificationArns;
            this.parameters = builder.parameters;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.templateUrl = builder.templateUrl;
            this.timeoutInMinutes = builder.timeoutInMinutes;
        }

        @Override
        public final java.util.List<java.lang.String> getNotificationArns() {
            return this.notificationArns;
        }

        @Override
        public final java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTemplateUrl() {
            return this.templateUrl;
        }

        @Override
        public final java.lang.Number getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getNotificationArns() != null) {
                data.set("notificationArns", om.valueToTree(this.getNotificationArns()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTemplateUrl() != null) {
                data.set("templateUrl", om.valueToTree(this.getTemplateUrl()));
            }
            if (this.getTimeoutInMinutes() != null) {
                data.set("timeoutInMinutes", om.valueToTree(this.getTimeoutInMinutes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudformation.CfnStackProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStackProps.Jsii$Proxy that = (CfnStackProps.Jsii$Proxy) o;

            if (this.notificationArns != null ? !this.notificationArns.equals(that.notificationArns) : that.notificationArns != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.templateUrl != null ? !this.templateUrl.equals(that.templateUrl) : that.templateUrl != null) return false;
            return this.timeoutInMinutes != null ? this.timeoutInMinutes.equals(that.timeoutInMinutes) : that.timeoutInMinutes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.notificationArns != null ? this.notificationArns.hashCode() : 0;
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.templateUrl != null ? this.templateUrl.hashCode() : 0);
            result = 31 * result + (this.timeoutInMinutes != null ? this.timeoutInMinutes.hashCode() : 0);
            return result;
        }
    }
}
