package software.amazon.awscdk.services.cloudfront;

/**
 * An Origin Access Control for Lambda Function URLs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn;
 * FunctionUrl fnUrl = fn.addFunctionUrl(FunctionUrlOptions.builder()
 *         .authType(FunctionUrlAuthType.AWS_IAM)
 *         .build());
 * // Define a custom OAC
 * FunctionUrlOriginAccessControl oac = FunctionUrlOriginAccessControl.Builder.create(this, "MyOAC")
 *         .originAccessControlName("CustomLambdaOAC")
 *         .signing(Signing.SIGV4_ALWAYS)
 *         .build();
 * // Set up Lambda Function URL with OAC in CloudFront Distribution
 * // Set up Lambda Function URL with OAC in CloudFront Distribution
 * Distribution.Builder.create(this, "MyDistribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(FunctionUrlOrigin.withOriginAccessControl(fnUrl, FunctionUrlOriginWithOACProps.builder()
 *                         .originAccessControl(oac)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originaccesscontrol.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-originaccesscontrol.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:27.854Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.FunctionUrlOriginAccessControl")
public class FunctionUrlOriginAccessControl extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cloudfront.IOriginAccessControl {

    protected FunctionUrlOriginAccessControl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FunctionUrlOriginAccessControl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.FunctionUrlOriginAccessControl.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FunctionUrlOriginAccessControl(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.FunctionUrlOriginAccessControlProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FunctionUrlOriginAccessControl(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a Lambda Function URL origin access control from its id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param originAccessControlId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOriginAccessControl fromOriginAccessControlId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String originAccessControlId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.FunctionUrlOriginAccessControl.class, "fromOriginAccessControlId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginAccessControl.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(originAccessControlId, "originAccessControlId is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The unique identifier of this Origin Access Control.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOriginAccessControlId() {
        return software.amazon.jsii.Kernel.get(this, "originAccessControlId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.FunctionUrlOriginAccessControl}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.FunctionUrlOriginAccessControl> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudfront.FunctionUrlOriginAccessControlProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A description of the origin access control.
         * <p>
         * Default: - no description
         * <p>
         * @return {@code this}
         * @param description A description of the origin access control. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * A name to identify the origin access control, with a maximum length of 64 characters.
         * <p>
         * Default: - a generated name
         * <p>
         * @return {@code this}
         * @param originAccessControlName A name to identify the origin access control, with a maximum length of 64 characters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessControlName(final java.lang.String originAccessControlName) {
            this.props().originAccessControlName(originAccessControlName);
            return this;
        }

        /**
         * Specifies which requests CloudFront signs and the signing protocol.
         * <p>
         * Default: SIGV4_ALWAYS
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originaccesscontrol-originaccesscontrolconfig.html#cfn-cloudfront-originaccesscontrol-originaccesscontrolconfig-signingbehavior">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-originaccesscontrol-originaccesscontrolconfig.html#cfn-cloudfront-originaccesscontrol-originaccesscontrolconfig-signingbehavior</a>
         * @param signing Specifies which requests CloudFront signs and the signing protocol. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signing(final software.amazon.awscdk.services.cloudfront.Signing signing) {
            this.props().signing(signing);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.FunctionUrlOriginAccessControl}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.FunctionUrlOriginAccessControl build() {
            return new software.amazon.awscdk.services.cloudfront.FunctionUrlOriginAccessControl(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.FunctionUrlOriginAccessControlProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.FunctionUrlOriginAccessControlProps.Builder();
            }
            return this.props;
        }
    }
}
