package software.amazon.awscdk.services.cloudfront;

/**
 * Maximum HTTP version to support.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Configure a distribution to use HTTP/2 and HTTP/3
 * // Configure a distribution to use HTTP/2 and HTTP/3
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder().origin(new HttpOrigin("www.example.com")).build())
 *         .httpVersion(HttpVersion.HTTP2_AND_3)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:27.856Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.HttpVersion")
public enum HttpVersion {
    /**
     * HTTP 1.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP1_1,
    /**
     * HTTP 2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP2,
    /**
     * HTTP 2 and HTTP 3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP2_AND_3,
    /**
     * HTTP 3.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HTTP3,
}
