package software.amazon.awscdk.services.cloudfront.origins;

/**
 * Represents a distribution's VPC origin.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creates a distribution from a Network Load Balancer
 * Vpc vpc;
 * // Create a network load balancer in a VPC. 'internetFacing' can be 'false'.
 * NetworkLoadBalancer nlb = NetworkLoadBalancer.Builder.create(this, "NLB")
 *         .vpc(vpc)
 *         .internetFacing(false)
 *         .vpcSubnets(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_ISOLATED).build())
 *         .securityGroups(List.of(SecurityGroup.Builder.create(this, "NLB-SG").vpc(vpc).build()))
 *         .build();
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder().origin(VpcOrigin.withNetworkLoadBalancer(nlb)).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:27.949Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.VpcOrigin")
public abstract class VpcOrigin extends software.amazon.awscdk.services.cloudfront.OriginBase {

    protected VpcOrigin(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpcOrigin(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param domainName This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected VpcOrigin(final @org.jetbrains.annotations.NotNull java.lang.String domainName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.origins.VpcOriginProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(domainName, "domainName is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Create a VPC origin with an Application Load Balancer.
     * <p>
     * @param alb This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.origins.VpcOrigin withApplicationLoadBalancer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer alb, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.VpcOriginWithEndpointProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class, "withApplicationLoadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class), new Object[] { java.util.Objects.requireNonNull(alb, "alb is required"), props });
    }

    /**
     * Create a VPC origin with an Application Load Balancer.
     * <p>
     * @param alb This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.origins.VpcOrigin withApplicationLoadBalancer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer alb) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class, "withApplicationLoadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class), new Object[] { java.util.Objects.requireNonNull(alb, "alb is required") });
    }

    /**
     * Create a VPC origin with an EC2 instance.
     * <p>
     * @param instance This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.origins.VpcOrigin withEc2Instance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IInstance instance, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.VpcOriginWithEndpointProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class, "withEc2Instance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class), new Object[] { java.util.Objects.requireNonNull(instance, "instance is required"), props });
    }

    /**
     * Create a VPC origin with an EC2 instance.
     * <p>
     * @param instance This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.origins.VpcOrigin withEc2Instance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IInstance instance) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class, "withEc2Instance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class), new Object[] { java.util.Objects.requireNonNull(instance, "instance is required") });
    }

    /**
     * Create a VPC origin with a Network Load Balancer.
     * <p>
     * @param nlb This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.origins.VpcOrigin withNetworkLoadBalancer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer nlb, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.VpcOriginWithEndpointProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class, "withNetworkLoadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class), new Object[] { java.util.Objects.requireNonNull(nlb, "nlb is required"), props });
    }

    /**
     * Create a VPC origin with a Network Load Balancer.
     * <p>
     * @param nlb This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.origins.VpcOrigin withNetworkLoadBalancer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer nlb) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class, "withNetworkLoadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class), new Object[] { java.util.Objects.requireNonNull(nlb, "nlb is required") });
    }

    /**
     * Create a VPC origin with an existing VPC origin resource.
     * <p>
     * @param origin This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.origins.VpcOrigin withVpcOrigin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IVpcOrigin origin, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.VpcOriginProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class, "withVpcOrigin", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class), new Object[] { java.util.Objects.requireNonNull(origin, "origin is required"), props });
    }

    /**
     * Create a VPC origin with an existing VPC origin resource.
     * <p>
     * @param origin This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.origins.VpcOrigin withVpcOrigin(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IVpcOrigin origin) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class, "withVpcOrigin", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.origins.VpcOrigin.class), new Object[] { java.util.Objects.requireNonNull(origin, "origin is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistribution.VpcOriginConfigProperty renderVpcOriginConfig() {
        return software.amazon.jsii.Kernel.call(this, "renderVpcOriginConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CfnDistribution.VpcOriginConfigProperty.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.origins.VpcOriginProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.origins.VpcOriginProps.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IVpcOrigin getVpcOrigin() {
        return software.amazon.jsii.Kernel.get(this, "vpcOrigin", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IVpcOrigin.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void setVpcOrigin(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IVpcOrigin value) {
        software.amazon.jsii.Kernel.set(this, "vpcOrigin", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.cloudfront.origins.VpcOrigin implements software.amazon.awscdk.services.cloudfront.IOrigin.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
