package software.amazon.awscdk.services.cloudwatch;

/**
 * CloudWatch Alarm that uses anomaly detection to trigger alarms.
 * <p>
 * This alarm type is specifically designed for use with anomaly detection operators
 * like LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a metric
 * Metric metric = Metric.Builder.create()
 *         .namespace("AWS/EC2")
 *         .metricName("CPUUtilization")
 *         .statistic("Average")
 *         .period(Duration.minutes(5))
 *         .build();
 * // Create an anomaly detection alarm
 * AnomalyDetectionAlarm alarm = AnomalyDetectionAlarm.Builder.create(this, "AnomalyAlarm")
 *         .metric(metric)
 *         .evaluationPeriods(1)
 *         // Number of standard deviations for the band (default: 2)
 *         .stdDevs(2)
 *         // Alarm outside on either side of the band, or just below or above it (default: outside)
 *         .comparisonOperator(ComparisonOperator.LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD)
 *         .alarmDescription("Alarm when metric is outside the expected band")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.042Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.AnomalyDetectionAlarm")
public class AnomalyDetectionAlarm extends software.amazon.awscdk.services.cloudwatch.Alarm {

    protected AnomalyDetectionAlarm(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AnomalyDetectionAlarm(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.AnomalyDetectionAlarm.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AnomalyDetectionAlarm(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.AnomalyDetectionAlarmProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.AnomalyDetectionAlarm}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.AnomalyDetectionAlarm> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudwatch.AnomalyDetectionAlarmProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudwatch.AnomalyDetectionAlarmProps.Builder();
        }

        /**
         * The number of periods over which data is compared to the specified threshold.
         * <p>
         * @return {@code this}
         * @param evaluationPeriods The number of periods over which data is compared to the specified threshold. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluationPeriods(final java.lang.Number evaluationPeriods) {
            this.props.evaluationPeriods(evaluationPeriods);
            return this;
        }

        /**
         * The metric to add the alarm on.
         * <p>
         * Metric objects can be obtained from most resources, or you can construct
         * custom Metric objects by instantiating one.
         * <p>
         * @return {@code this}
         * @param metric The metric to add the alarm on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metric(final software.amazon.awscdk.services.cloudwatch.IMetric metric) {
            this.props.metric(metric);
            return this;
        }

        /**
         * Whether the actions for this alarm are enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param actionsEnabled Whether the actions for this alarm are enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(final java.lang.Boolean actionsEnabled) {
            this.props.actionsEnabled(actionsEnabled);
            return this;
        }

        /**
         * Description for the alarm.
         * <p>
         * Default: No description
         * <p>
         * @return {@code this}
         * @param alarmDescription Description for the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmDescription(final java.lang.String alarmDescription) {
            this.props.alarmDescription(alarmDescription);
            return this;
        }

        /**
         * Name of the alarm.
         * <p>
         * Default: Automatically generated name
         * <p>
         * @return {@code this}
         * @param alarmName Name of the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmName(final java.lang.String alarmName) {
            this.props.alarmName(alarmName);
            return this;
        }

        /**
         * Comparison operator to use to check if metric is breaching.
         * <p>
         * Must be one of the anomaly detection operators:
         * <p>
         * <ul>
         * <li>LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD</li>
         * <li>GREATER_THAN_UPPER_THRESHOLD</li>
         * <li>LESS_THAN_LOWER_THRESHOLD</li>
         * </ul>
         * <p>
         * Default: LESS_THAN_LOWER_OR_GREATER_THAN_UPPER_THRESHOLD
         * <p>
         * @return {@code this}
         * @param comparisonOperator Comparison operator to use to check if metric is breaching. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comparisonOperator(final software.amazon.awscdk.services.cloudwatch.ComparisonOperator comparisonOperator) {
            this.props.comparisonOperator(comparisonOperator);
            return this;
        }

        /**
         * The number of datapoints that must be breaching to trigger the alarm.
         * <p>
         * This is used only if you are setting an "M
         * out of N" alarm. In that case, this value is the M. For more information, see Evaluating an Alarm in the Amazon
         * CloudWatch User Guide.
         * <p>
         * Default: ``evaluationPeriods``
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/AlarmThatSendsEmail.html#alarm-evaluation</a>
         * @param datapointsToAlarm The number of datapoints that must be breaching to trigger the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datapointsToAlarm(final java.lang.Number datapointsToAlarm) {
            this.props.datapointsToAlarm(datapointsToAlarm);
            return this;
        }

        /**
         * Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant.
         * <p>
         * Used only for alarms that are based on percentiles.
         * <p>
         * Default: - Not configured.
         * <p>
         * @return {@code this}
         * @param evaluateLowSampleCountPercentile Specifies whether to evaluate the data and potentially change the alarm state if there are too few data points to be statistically significant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder evaluateLowSampleCountPercentile(final java.lang.String evaluateLowSampleCountPercentile) {
            this.props.evaluateLowSampleCountPercentile(evaluateLowSampleCountPercentile);
            return this;
        }

        /**
         * (deprecated) The period over which the specified statistic is applied.
         * <p>
         * Cannot be used with <code>MathExpression</code> objects.
         * <p>
         * Default: - The period from the metric
         * <p>
         * @return {@code this}
         * @deprecated Use <code>metric.with({ period: ... })</code> to encode the period into the Metric object
         * @param period The period over which the specified statistic is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder period(final software.amazon.awscdk.Duration period) {
            this.props.period(period);
            return this;
        }

        /**
         * (deprecated) What function to use for aggregating.
         * <p>
         * Can be one of the following:
         * <p>
         * <ul>
         * <li>"Minimum" | "min"</li>
         * <li>"Maximum" | "max"</li>
         * <li>"Average" | "avg"</li>
         * <li>"Sum" | "sum"</li>
         * <li>"SampleCount | "n"</li>
         * <li>"pNN.NN"</li>
         * </ul>
         * <p>
         * Cannot be used with <code>MathExpression</code> objects.
         * <p>
         * Default: - The statistic from the metric
         * <p>
         * @return {@code this}
         * @deprecated Use <code>metric.with({ statistic: ... })</code> to encode the period into the Metric object
         * @param statistic What function to use for aggregating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder statistic(final java.lang.String statistic) {
            this.props.statistic(statistic);
            return this;
        }

        /**
         * The number of standard deviations to use for the anomaly detection band.
         * <p>
         * The higher the value, the wider the band.
         * <p>
         * <ul>
         * <li>Must be greater than 0. A value of 0 or negative values would not make sense in the context of calculating standard deviations.</li>
         * <li>There is no strict maximum value defined, as standard deviations can theoretically extend infinitely. However, in practice, values beyond 5 or 6 standard deviations are rarely used, as they would result in an extremely wide anomaly detection band, potentially missing significant anomalies.</li>
         * </ul>
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param stdDevs The number of standard deviations to use for the anomaly detection band. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stdDevs(final java.lang.Number stdDevs) {
            this.props.stdDevs(stdDevs);
            return this;
        }

        /**
         * Sets how this alarm is to handle missing data points.
         * <p>
         * Default: TreatMissingData.Missing
         * <p>
         * @return {@code this}
         * @param treatMissingData Sets how this alarm is to handle missing data points. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder treatMissingData(final software.amazon.awscdk.services.cloudwatch.TreatMissingData treatMissingData) {
            this.props.treatMissingData(treatMissingData);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.AnomalyDetectionAlarm}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.AnomalyDetectionAlarm build() {
            return new software.amazon.awscdk.services.cloudwatch.AnomalyDetectionAlarm(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
