package software.amazon.awscdk.services.cloudwatch;

/**
 * A dashboard gauge widget that displays metrics.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * Alarm errorAlarm;
 * Metric gaugeMetric;
 * dashboard.addWidgets(GaugeWidget.Builder.create()
 *         .metrics(List.of(gaugeMetric))
 *         .leftYAxis(YAxisProps.builder()
 *                 .min(0)
 *                 .max(1000)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.092Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.GaugeWidget")
public class GaugeWidget extends software.amazon.awscdk.services.cloudwatch.ConcreteWidget {

    protected GaugeWidget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GaugeWidget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GaugeWidget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.GaugeWidgetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add another metric to the left Y axis of the GaugeWidget.
     * <p>
     * @param metric the metric to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addMetric(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IMetric metric) {
        software.amazon.jsii.Kernel.call(this, "addMetric", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(metric, "metric is required") });
    }

    /**
     * Return the widget JSON for use in the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.GaugeWidget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.GaugeWidget> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.GaugeWidgetProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cloudwatch.GaugeWidgetProps.Builder();
        }

        /**
         * The AWS account ID where the metrics are located.
         * <p>
         * This enables cross-account functionality for CloudWatch dashboards.
         * Before using this feature, ensure that proper cross-account sharing is configured
         * between the monitoring account and source account.
         * <p>
         * For more information, see:
         * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
         * <p>
         * Default: - Current account
         * <p>
         * @return {@code this}
         * @param accountId The AWS account ID where the metrics are located. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountId(final java.lang.String accountId) {
            this.props.accountId(accountId);
            return this;
        }

        /**
         * Height of the widget.
         * <p>
         * Default: - 6 for Alarm and Graph widgets.
         * 3 for single value widgets where most recent value of a metric is displayed.
         * <p>
         * @return {@code this}
         * @param height Height of the widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(final java.lang.Number height) {
            this.props.height(height);
            return this;
        }

        /**
         * The region the metrics of this graph should be taken from.
         * <p>
         * Default: - Current region
         * <p>
         * @return {@code this}
         * @param region The region the metrics of this graph should be taken from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * Title for the graph.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param title Title for the graph. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(final java.lang.String title) {
            this.props.title(title);
            return this;
        }

        /**
         * Width of the widget, in a grid of 24 units wide.
         * <p>
         * Default: 6
         * <p>
         * @return {@code this}
         * @param width Width of the widget, in a grid of 24 units wide. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(final java.lang.Number width) {
            this.props.width(width);
            return this;
        }

        /**
         * Annotations for the left Y axis.
         * <p>
         * Default: - No annotations
         * <p>
         * @return {@code this}
         * @param annotations Annotations for the left Y axis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder annotations(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.HorizontalAnnotation> annotations) {
            this.props.annotations(annotations);
            return this;
        }

        /**
         * The end of the time range to use for each widget independently from those of the dashboard.
         * <p>
         * If you specify a value for end, you must also specify a value for start.
         * Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * <p>
         * Default: When the dashboard loads, the end date will be the current time.
         * <p>
         * @return {@code this}
         * @param end The end of the time range to use for each widget independently from those of the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder end(final java.lang.String end) {
            this.props.end(end);
            return this;
        }

        /**
         * Left Y axis.
         * <p>
         * Default: {min:0,max:100}
         * <p>
         * @return {@code this}
         * @param leftYAxis Left Y axis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder leftYAxis(final software.amazon.awscdk.services.cloudwatch.YAxisProps leftYAxis) {
            this.props.leftYAxis(leftYAxis);
            return this;
        }

        /**
         * Position of the legend.
         * <p>
         * Default: - bottom
         * <p>
         * @return {@code this}
         * @param legendPosition Position of the legend. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder legendPosition(final software.amazon.awscdk.services.cloudwatch.LegendPosition legendPosition) {
            this.props.legendPosition(legendPosition);
            return this;
        }

        /**
         * Whether the graph should show live data.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param liveData Whether the graph should show live data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder liveData(final java.lang.Boolean liveData) {
            this.props.liveData(liveData);
            return this;
        }

        /**
         * Metrics to display on left Y axis.
         * <p>
         * Default: - No metrics
         * <p>
         * @return {@code this}
         * @param metrics Metrics to display on left Y axis. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metrics(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IMetric> metrics) {
            this.props.metrics(metrics);
            return this;
        }

        /**
         * The default period for all metrics in this widget.
         * <p>
         * The period is the length of time represented by one data point on the graph.
         * This default can be overridden within each metric definition.
         * <p>
         * Default: cdk.Duration.seconds(300)
         * <p>
         * @return {@code this}
         * @param period The default period for all metrics in this widget. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder period(final software.amazon.awscdk.Duration period) {
            this.props.period(period);
            return this;
        }

        /**
         * Whether to show the value from the entire time range. Only applicable for Bar and Pie charts.
         * <p>
         * If false, values will be from the most recent period of your chosen time range;
         * if true, shows the value from the entire time range.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param setPeriodToTimeRange Whether to show the value from the entire time range. Only applicable for Bar and Pie charts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setPeriodToTimeRange(final java.lang.Boolean setPeriodToTimeRange) {
            this.props.setPeriodToTimeRange(setPeriodToTimeRange);
            return this;
        }

        /**
         * The start of the time range to use for each widget independently from those of the dashboard.
         * <p>
         * You can specify start without specifying end to specify a relative time range that ends with the current time.
         * In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for
         * minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months.
         * You can also use start along with an end field, to specify an absolute time range.
         * When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * <p>
         * Default: When the dashboard loads, the start time will be the default time range.
         * <p>
         * @return {@code this}
         * @param start The start of the time range to use for each widget independently from those of the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder start(final java.lang.String start) {
            this.props.start(start);
            return this;
        }

        /**
         * The default statistic to be displayed for each metric.
         * <p>
         * This default can be overridden within the definition of each individual metric
         * <p>
         * Default: - The statistic for each metric is used
         * <p>
         * @return {@code this}
         * @param statistic The default statistic to be displayed for each metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statistic(final java.lang.String statistic) {
            this.props.statistic(statistic);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.GaugeWidget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.GaugeWidget build() {
            return new software.amazon.awscdk.services.cloudwatch.GaugeWidget(
                this.props.build()
            );
        }
    }
}
