package software.amazon.awscdk.services.cloudwatch;

/**
 * A class for providing values for use with {@link VariableInputType.SELECT} and {@link VariableInputType.RADIO} dashboard variables.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Dashboard dashboard = Dashboard.Builder.create(this, "Dash")
 *         .defaultInterval(Duration.days(7))
 *         .variables(List.of(DashboardVariable.Builder.create()
 *                 .id("region")
 *                 .type(VariableType.PROPERTY)
 *                 .label("Region")
 *                 .inputType(VariableInputType.RADIO)
 *                 .value("region")
 *                 .values(Values.fromValues(VariableValue.builder().label("IAD").value("us-east-1").build(), VariableValue.builder().label("DUB").value("us-west-2").build()))
 *                 .defaultValue(DefaultValue.value("us-east-1"))
 *                 .visible(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.135Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.Values")
public abstract class Values extends software.amazon.jsii.JsiiObject {

    protected Values(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Values(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Values() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Create values from a search expression.
     * <p>
     * @param expression search expression that specifies a namespace, dimension name(s) and a metric name. This parameter is required.
     * @param populateFrom dimension the dimension name, that the search expression retrieves, whose values will be used to populate the values to choose from. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Values fromSearch(final @org.jetbrains.annotations.NotNull java.lang.String expression, final @org.jetbrains.annotations.NotNull java.lang.String populateFrom) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Values.class, "fromSearch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Values.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required"), java.util.Objects.requireNonNull(populateFrom, "populateFrom is required") });
    }

    /**
     * Create values from the components of search expression.
     * <p>
     * @param components This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Values fromSearchComponents(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.SearchComponents components) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Values.class, "fromSearchComponents", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Values.class), new Object[] { java.util.Objects.requireNonNull(components, "components is required") });
    }

    /**
     * Create values from an array of possible variable values.
     * <p>
     * @param values This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Values fromValues(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.VariableValue... values) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Values.class, "fromValues", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Values.class), java.util.Arrays.<Object>stream(values).toArray(Object[]::new));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.Object toJson();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.cloudwatch.Values {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.Object toJson() {
            return software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }
    }
}
