package software.amazon.awscdk.services.codebuild;

/**
 * Creation properties for <code>GitHubEnterpriseSourceCredentials</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.codebuild.*;
 * SecretValue secretValue;
 * GitHubEnterpriseSourceCredentialsProps gitHubEnterpriseSourceCredentialsProps = GitHubEnterpriseSourceCredentialsProps.builder()
 *         .accessToken(secretValue)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.262Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.GitHubEnterpriseSourceCredentialsProps")
@software.amazon.jsii.Jsii.Proxy(GitHubEnterpriseSourceCredentialsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GitHubEnterpriseSourceCredentialsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The personal access token to use when contacting the instance of the GitHub Enterprise API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue getAccessToken();

    /**
     * @return a {@link Builder} of {@link GitHubEnterpriseSourceCredentialsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GitHubEnterpriseSourceCredentialsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GitHubEnterpriseSourceCredentialsProps> {
        software.amazon.awscdk.SecretValue accessToken;

        /**
         * Sets the value of {@link GitHubEnterpriseSourceCredentialsProps#getAccessToken}
         * @param accessToken The personal access token to use when contacting the instance of the GitHub Enterprise API. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessToken(software.amazon.awscdk.SecretValue accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GitHubEnterpriseSourceCredentialsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GitHubEnterpriseSourceCredentialsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GitHubEnterpriseSourceCredentialsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitHubEnterpriseSourceCredentialsProps {
        private final software.amazon.awscdk.SecretValue accessToken;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessToken = java.util.Objects.requireNonNull(builder.accessToken, "accessToken is required");
        }

        @Override
        public final software.amazon.awscdk.SecretValue getAccessToken() {
            return this.accessToken;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessToken", om.valueToTree(this.getAccessToken()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.GitHubEnterpriseSourceCredentialsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GitHubEnterpriseSourceCredentialsProps.Jsii$Proxy that = (GitHubEnterpriseSourceCredentialsProps.Jsii$Proxy) o;

            return this.accessToken.equals(that.accessToken);
        }

        @Override
        public final int hashCode() {
            int result = this.accessToken.hashCode();
            return result;
        }
    }
}
