package software.amazon.awscdk.services.codepipeline;

/**
 * The <code>AWS::CodePipeline::CustomActionType</code> resource creates a custom action for activities that aren't included in the CodePipeline default actions, such as running an internally developed build process or a test suite.
 * <p>
 * You can use these custom actions in the stage of a pipeline. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create and Add a Custom Action in AWS CodePipeline</a> in the <em>AWS CodePipeline User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * CfnCustomActionType cfnCustomActionType = CfnCustomActionType.Builder.create(this, "MyCfnCustomActionType")
 *         .category("category")
 *         .inputArtifactDetails(ArtifactDetailsProperty.builder()
 *                 .maximumCount(123)
 *                 .minimumCount(123)
 *                 .build())
 *         .outputArtifactDetails(ArtifactDetailsProperty.builder()
 *                 .maximumCount(123)
 *                 .minimumCount(123)
 *                 .build())
 *         .provider("provider")
 *         .version("version")
 *         // the properties below are optional
 *         .configurationProperties(List.of(ConfigurationPropertiesProperty.builder()
 *                 .key(false)
 *                 .name("name")
 *                 .required(false)
 *                 .secret(false)
 *                 // the properties below are optional
 *                 .description("description")
 *                 .queryable(false)
 *                 .type("type")
 *                 .build()))
 *         .settings(SettingsProperty.builder()
 *                 .entityUrlTemplate("entityUrlTemplate")
 *                 .executionUrlTemplate("executionUrlTemplate")
 *                 .revisionUrlTemplate("revisionUrlTemplate")
 *                 .thirdPartyConfigurationUrl("thirdPartyConfigurationUrl")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.447Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnCustomActionType")
public class CfnCustomActionType extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnCustomActionType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCustomActionType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codepipeline.CfnCustomActionType.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCustomActionType(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.CfnCustomActionTypeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The category of the custom action, such as a build action or a test action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCategory() {
        return software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The category of the custom action, such as a build action or a test action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCategory(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "category", java.util.Objects.requireNonNull(value, "category is required"));
    }

    /**
     * The details of the input artifact for the action, such as its commit ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInputArtifactDetails() {
        return software.amazon.jsii.Kernel.get(this, "inputArtifactDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The details of the input artifact for the action, such as its commit ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputArtifactDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inputArtifactDetails", java.util.Objects.requireNonNull(value, "inputArtifactDetails is required"));
    }

    /**
     * The details of the input artifact for the action, such as its commit ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputArtifactDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ArtifactDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "inputArtifactDetails", java.util.Objects.requireNonNull(value, "inputArtifactDetails is required"));
    }

    /**
     * The details of the output artifact of the action, such as its commit ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOutputArtifactDetails() {
        return software.amazon.jsii.Kernel.get(this, "outputArtifactDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The details of the output artifact of the action, such as its commit ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputArtifactDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "outputArtifactDetails", java.util.Objects.requireNonNull(value, "outputArtifactDetails is required"));
    }

    /**
     * The details of the output artifact of the action, such as its commit ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputArtifactDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ArtifactDetailsProperty value) {
        software.amazon.jsii.Kernel.set(this, "outputArtifactDetails", java.util.Objects.requireNonNull(value, "outputArtifactDetails is required"));
    }

    /**
     * The provider of the service used in the custom action, such as CodeDeploy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProvider() {
        return software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The provider of the service used in the custom action, such as CodeDeploy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvider(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "provider", java.util.Objects.requireNonNull(value, "provider is required"));
    }

    /**
     * The version identifier of the custom action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version identifier of the custom action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "version", java.util.Objects.requireNonNull(value, "version is required"));
    }

    /**
     * The configuration properties for the custom action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationProperties() {
        return software.amazon.jsii.Kernel.get(this, "configurationProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration properties for the custom action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configurationProperties", value);
    }

    /**
     * The configuration properties for the custom action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationProperties(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ConfigurationPropertiesProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ConfigurationPropertiesProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "configurationProperties", value);
    }

    /**
     * URLs that provide users information about this custom action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSettings() {
        return software.amazon.jsii.Kernel.get(this, "settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * URLs that provide users information about this custom action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "settings", value);
    }

    /**
     * URLs that provide users information about this custom action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.CfnCustomActionType.SettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "settings", value);
    }

    /**
     * The tags for the custom action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags for the custom action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Returns information about the details of an artifact.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * ArtifactDetailsProperty artifactDetailsProperty = ArtifactDetailsProperty.builder()
     *         .maximumCount(123)
     *         .minimumCount(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnCustomActionType.ArtifactDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArtifactDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArtifactDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of artifacts allowed for the action type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html#cfn-codepipeline-customactiontype-artifactdetails-maximumcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html#cfn-codepipeline-customactiontype-artifactdetails-maximumcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaximumCount();

        /**
         * The minimum number of artifacts allowed for the action type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html#cfn-codepipeline-customactiontype-artifactdetails-minimumcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html#cfn-codepipeline-customactiontype-artifactdetails-minimumcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimumCount();

        /**
         * @return a {@link Builder} of {@link ArtifactDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArtifactDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArtifactDetailsProperty> {
            java.lang.Number maximumCount;
            java.lang.Number minimumCount;

            /**
             * Sets the value of {@link ArtifactDetailsProperty#getMaximumCount}
             * @param maximumCount The maximum number of artifacts allowed for the action type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumCount(java.lang.Number maximumCount) {
                this.maximumCount = maximumCount;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactDetailsProperty#getMinimumCount}
             * @param minimumCount The minimum number of artifacts allowed for the action type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumCount(java.lang.Number minimumCount) {
                this.minimumCount = minimumCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArtifactDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArtifactDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArtifactDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArtifactDetailsProperty {
            private final java.lang.Number maximumCount;
            private final java.lang.Number minimumCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximumCount = software.amazon.jsii.Kernel.get(this, "maximumCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumCount = software.amazon.jsii.Kernel.get(this, "minimumCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximumCount = java.util.Objects.requireNonNull(builder.maximumCount, "maximumCount is required");
                this.minimumCount = java.util.Objects.requireNonNull(builder.minimumCount, "minimumCount is required");
            }

            @Override
            public final java.lang.Number getMaximumCount() {
                return this.maximumCount;
            }

            @Override
            public final java.lang.Number getMinimumCount() {
                return this.minimumCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maximumCount", om.valueToTree(this.getMaximumCount()));
                data.set("minimumCount", om.valueToTree(this.getMinimumCount()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnCustomActionType.ArtifactDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArtifactDetailsProperty.Jsii$Proxy that = (ArtifactDetailsProperty.Jsii$Proxy) o;

                if (!maximumCount.equals(that.maximumCount)) return false;
                return this.minimumCount.equals(that.minimumCount);
            }

            @Override
            public final int hashCode() {
                int result = this.maximumCount.hashCode();
                result = 31 * result + (this.minimumCount.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration properties for the custom action.
     * <p>
     * <blockquote>
     * <p>
     * You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom Action for a Pipeline</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * ConfigurationPropertiesProperty configurationPropertiesProperty = ConfigurationPropertiesProperty.builder()
     *         .key(false)
     *         .name("name")
     *         .required(false)
     *         .secret(false)
     *         // the properties below are optional
     *         .description("description")
     *         .queryable(false)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnCustomActionType.ConfigurationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether the configuration property is a key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKey();

        /**
         * The name of the action configuration property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Whether the configuration property is a required value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-required">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-required</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRequired();

        /**
         * Whether the configuration property is secret.
         * <p>
         * Secrets are hidden from all calls except for <code>GetJobDetails</code> , <code>GetThirdPartyJobDetails</code> , <code>PollForJobs</code> , and <code>PollForThirdPartyJobs</code> .
         * <p>
         * When updating a pipeline, passing * * * * * without changing any other values of the action preserves the previous value of the secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-secret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-secret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSecret();

        /**
         * The description of the action configuration property that is displayed to users.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * Indicates that the property is used with <code>PollForJobs</code> .
         * <p>
         * When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.
         * <p>
         * If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-queryable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-queryable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryable() {
            return null;
        }

        /**
         * The type of the configuration property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationPropertiesProperty> {
            java.lang.Object key;
            java.lang.String name;
            java.lang.Object required;
            java.lang.Object secret;
            java.lang.String description;
            java.lang.Object queryable;
            java.lang.String type;

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getKey}
             * @param key Whether the configuration property is a key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.Boolean key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getKey}
             * @param key Whether the configuration property is a key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(software.amazon.awscdk.IResolvable key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getName}
             * @param name The name of the action configuration property. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getRequired}
             * @param required Whether the configuration property is a required value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(java.lang.Boolean required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getRequired}
             * @param required Whether the configuration property is a required value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(software.amazon.awscdk.IResolvable required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getSecret}
             * @param secret Whether the configuration property is secret. This parameter is required.
             *               Secrets are hidden from all calls except for <code>GetJobDetails</code> , <code>GetThirdPartyJobDetails</code> , <code>PollForJobs</code> , and <code>PollForThirdPartyJobs</code> .
             *               <p>
             *               When updating a pipeline, passing * * * * * without changing any other values of the action preserves the previous value of the secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secret(java.lang.Boolean secret) {
                this.secret = secret;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getSecret}
             * @param secret Whether the configuration property is secret. This parameter is required.
             *               Secrets are hidden from all calls except for <code>GetJobDetails</code> , <code>GetThirdPartyJobDetails</code> , <code>PollForJobs</code> , and <code>PollForThirdPartyJobs</code> .
             *               <p>
             *               When updating a pipeline, passing * * * * * without changing any other values of the action preserves the previous value of the secret.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secret(software.amazon.awscdk.IResolvable secret) {
                this.secret = secret;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getDescription}
             * @param description The description of the action configuration property that is displayed to users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getQueryable}
             * @param queryable Indicates that the property is used with <code>PollForJobs</code> .
             *                  When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.
             *                  <p>
             *                  If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryable(java.lang.Boolean queryable) {
                this.queryable = queryable;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getQueryable}
             * @param queryable Indicates that the property is used with <code>PollForJobs</code> .
             *                  When creating a custom action, an action can have up to one queryable property. If it has one, that property must be both required and not secret.
             *                  <p>
             *                  If you create a pipeline with a custom action type, and that custom action contains a queryable property, the value for that configuration property is subject to other restrictions. The value must be less than or equal to twenty (20) characters. The value can contain only alphanumeric characters, underscores, and hyphens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryable(software.amazon.awscdk.IResolvable queryable) {
                this.queryable = queryable;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getType}
             * @param type The type of the configuration property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationPropertiesProperty {
            private final java.lang.Object key;
            private final java.lang.String name;
            private final java.lang.Object required;
            private final java.lang.Object secret;
            private final java.lang.String description;
            private final java.lang.Object queryable;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.required = software.amazon.jsii.Kernel.get(this, "required", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryable = software.amazon.jsii.Kernel.get(this, "queryable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.required = java.util.Objects.requireNonNull(builder.required, "required is required");
                this.secret = java.util.Objects.requireNonNull(builder.secret, "secret is required");
                this.description = builder.description;
                this.queryable = builder.queryable;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Object getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getRequired() {
                return this.required;
            }

            @Override
            public final java.lang.Object getSecret() {
                return this.secret;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getQueryable() {
                return this.queryable;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("required", om.valueToTree(this.getRequired()));
                data.set("secret", om.valueToTree(this.getSecret()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getQueryable() != null) {
                    data.set("queryable", om.valueToTree(this.getQueryable()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnCustomActionType.ConfigurationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationPropertiesProperty.Jsii$Proxy that = (ConfigurationPropertiesProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                if (!name.equals(that.name)) return false;
                if (!required.equals(that.required)) return false;
                if (!secret.equals(that.secret)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.queryable != null ? !this.queryable.equals(that.queryable) : that.queryable != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.required.hashCode());
                result = 31 * result + (this.secret.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.queryable != null ? this.queryable.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>Settings</code> is a property of the <code>AWS::CodePipeline::CustomActionType</code> resource that provides URLs that users can access to view information about the CodePipeline custom action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * SettingsProperty settingsProperty = SettingsProperty.builder()
     *         .entityUrlTemplate("entityUrlTemplate")
     *         .executionUrlTemplate("executionUrlTemplate")
     *         .revisionUrlTemplate("revisionUrlTemplate")
     *         .thirdPartyConfigurationUrl("thirdPartyConfigurationUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnCustomActionType.SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL returned to the CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for a CodeDeploy deployment group.
         * <p>
         * This link is provided as part of the action display in the pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-entityurltemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-entityurltemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntityUrlTemplate() {
            return null;
        }

        /**
         * The URL returned to the CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for CodeDeploy.
         * <p>
         * This link is shown on the pipeline view page in the CodePipeline console and provides a link to the execution entity of the external action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-executionurltemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-executionurltemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionUrlTemplate() {
            return null;
        }

        /**
         * The URL returned to the CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-revisionurltemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-revisionurltemplate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRevisionUrlTemplate() {
            return null;
        }

        /**
         * The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-thirdpartyconfigurationurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-thirdpartyconfigurationurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getThirdPartyConfigurationUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SettingsProperty> {
            java.lang.String entityUrlTemplate;
            java.lang.String executionUrlTemplate;
            java.lang.String revisionUrlTemplate;
            java.lang.String thirdPartyConfigurationUrl;

            /**
             * Sets the value of {@link SettingsProperty#getEntityUrlTemplate}
             * @param entityUrlTemplate The URL returned to the CodePipeline console that provides a deep link to the resources of the external system, such as the configuration page for a CodeDeploy deployment group.
             *                          This link is provided as part of the action display in the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityUrlTemplate(java.lang.String entityUrlTemplate) {
                this.entityUrlTemplate = entityUrlTemplate;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getExecutionUrlTemplate}
             * @param executionUrlTemplate The URL returned to the CodePipeline console that contains a link to the top-level landing page for the external system, such as the console page for CodeDeploy.
             *                             This link is shown on the pipeline view page in the CodePipeline console and provides a link to the execution entity of the external action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionUrlTemplate(java.lang.String executionUrlTemplate) {
                this.executionUrlTemplate = executionUrlTemplate;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getRevisionUrlTemplate}
             * @param revisionUrlTemplate The URL returned to the CodePipeline console that contains a link to the page where customers can update or change the configuration of the external action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revisionUrlTemplate(java.lang.String revisionUrlTemplate) {
                this.revisionUrlTemplate = revisionUrlTemplate;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getThirdPartyConfigurationUrl}
             * @param thirdPartyConfigurationUrl The URL of a sign-up page where users can sign up for an external service and perform initial configuration of the action provided by that service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thirdPartyConfigurationUrl(java.lang.String thirdPartyConfigurationUrl) {
                this.thirdPartyConfigurationUrl = thirdPartyConfigurationUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SettingsProperty {
            private final java.lang.String entityUrlTemplate;
            private final java.lang.String executionUrlTemplate;
            private final java.lang.String revisionUrlTemplate;
            private final java.lang.String thirdPartyConfigurationUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityUrlTemplate = software.amazon.jsii.Kernel.get(this, "entityUrlTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.executionUrlTemplate = software.amazon.jsii.Kernel.get(this, "executionUrlTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.revisionUrlTemplate = software.amazon.jsii.Kernel.get(this, "revisionUrlTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.thirdPartyConfigurationUrl = software.amazon.jsii.Kernel.get(this, "thirdPartyConfigurationUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityUrlTemplate = builder.entityUrlTemplate;
                this.executionUrlTemplate = builder.executionUrlTemplate;
                this.revisionUrlTemplate = builder.revisionUrlTemplate;
                this.thirdPartyConfigurationUrl = builder.thirdPartyConfigurationUrl;
            }

            @Override
            public final java.lang.String getEntityUrlTemplate() {
                return this.entityUrlTemplate;
            }

            @Override
            public final java.lang.String getExecutionUrlTemplate() {
                return this.executionUrlTemplate;
            }

            @Override
            public final java.lang.String getRevisionUrlTemplate() {
                return this.revisionUrlTemplate;
            }

            @Override
            public final java.lang.String getThirdPartyConfigurationUrl() {
                return this.thirdPartyConfigurationUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEntityUrlTemplate() != null) {
                    data.set("entityUrlTemplate", om.valueToTree(this.getEntityUrlTemplate()));
                }
                if (this.getExecutionUrlTemplate() != null) {
                    data.set("executionUrlTemplate", om.valueToTree(this.getExecutionUrlTemplate()));
                }
                if (this.getRevisionUrlTemplate() != null) {
                    data.set("revisionUrlTemplate", om.valueToTree(this.getRevisionUrlTemplate()));
                }
                if (this.getThirdPartyConfigurationUrl() != null) {
                    data.set("thirdPartyConfigurationUrl", om.valueToTree(this.getThirdPartyConfigurationUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnCustomActionType.SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SettingsProperty.Jsii$Proxy that = (SettingsProperty.Jsii$Proxy) o;

                if (this.entityUrlTemplate != null ? !this.entityUrlTemplate.equals(that.entityUrlTemplate) : that.entityUrlTemplate != null) return false;
                if (this.executionUrlTemplate != null ? !this.executionUrlTemplate.equals(that.executionUrlTemplate) : that.executionUrlTemplate != null) return false;
                if (this.revisionUrlTemplate != null ? !this.revisionUrlTemplate.equals(that.revisionUrlTemplate) : that.revisionUrlTemplate != null) return false;
                return this.thirdPartyConfigurationUrl != null ? this.thirdPartyConfigurationUrl.equals(that.thirdPartyConfigurationUrl) : that.thirdPartyConfigurationUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.entityUrlTemplate != null ? this.entityUrlTemplate.hashCode() : 0;
                result = 31 * result + (this.executionUrlTemplate != null ? this.executionUrlTemplate.hashCode() : 0);
                result = 31 * result + (this.revisionUrlTemplate != null ? this.revisionUrlTemplate.hashCode() : 0);
                result = 31 * result + (this.thirdPartyConfigurationUrl != null ? this.thirdPartyConfigurationUrl.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.CfnCustomActionType}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.CfnCustomActionType> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codepipeline.CfnCustomActionTypeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codepipeline.CfnCustomActionTypeProps.Builder();
        }

        /**
         * The category of the custom action, such as a build action or a test action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-category</a>
         * @param category The category of the custom action, such as a build action or a test action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder category(final java.lang.String category) {
            this.props.category(category);
            return this;
        }

        /**
         * The details of the input artifact for the action, such as its commit ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails</a>
         * @param inputArtifactDetails The details of the input artifact for the action, such as its commit ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputArtifactDetails(final software.amazon.awscdk.IResolvable inputArtifactDetails) {
            this.props.inputArtifactDetails(inputArtifactDetails);
            return this;
        }
        /**
         * The details of the input artifact for the action, such as its commit ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails</a>
         * @param inputArtifactDetails The details of the input artifact for the action, such as its commit ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputArtifactDetails(final software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ArtifactDetailsProperty inputArtifactDetails) {
            this.props.inputArtifactDetails(inputArtifactDetails);
            return this;
        }

        /**
         * The details of the output artifact of the action, such as its commit ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails</a>
         * @param outputArtifactDetails The details of the output artifact of the action, such as its commit ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputArtifactDetails(final software.amazon.awscdk.IResolvable outputArtifactDetails) {
            this.props.outputArtifactDetails(outputArtifactDetails);
            return this;
        }
        /**
         * The details of the output artifact of the action, such as its commit ID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails</a>
         * @param outputArtifactDetails The details of the output artifact of the action, such as its commit ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputArtifactDetails(final software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ArtifactDetailsProperty outputArtifactDetails) {
            this.props.outputArtifactDetails(outputArtifactDetails);
            return this;
        }

        /**
         * The provider of the service used in the custom action, such as CodeDeploy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-provider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-provider</a>
         * @param provider The provider of the service used in the custom action, such as CodeDeploy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(final java.lang.String provider) {
            this.props.provider(provider);
            return this;
        }

        /**
         * The version identifier of the custom action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-version</a>
         * @param version The version identifier of the custom action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final java.lang.String version) {
            this.props.version(version);
            return this;
        }

        /**
         * The configuration properties for the custom action.
         * <p>
         * <blockquote>
         * <p>
         * You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom Action for a Pipeline</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties</a>
         * @param configurationProperties The configuration properties for the custom action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationProperties(final software.amazon.awscdk.IResolvable configurationProperties) {
            this.props.configurationProperties(configurationProperties);
            return this;
        }
        /**
         * The configuration properties for the custom action.
         * <p>
         * <blockquote>
         * <p>
         * You can refer to a name in the configuration properties of the custom action within the URL templates by following the format of {Config:name}, as long as the configuration property is both required and not secret. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/how-to-create-custom-action.html">Create a Custom Action for a Pipeline</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties</a>
         * @param configurationProperties The configuration properties for the custom action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationProperties(final java.util.List<? extends java.lang.Object> configurationProperties) {
            this.props.configurationProperties(configurationProperties);
            return this;
        }

        /**
         * URLs that provide users information about this custom action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings</a>
         * @param settings URLs that provide users information about this custom action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(final software.amazon.awscdk.IResolvable settings) {
            this.props.settings(settings);
            return this;
        }
        /**
         * URLs that provide users information about this custom action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings</a>
         * @param settings URLs that provide users information about this custom action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(final software.amazon.awscdk.services.codepipeline.CfnCustomActionType.SettingsProperty settings) {
            this.props.settings(settings);
            return this;
        }

        /**
         * The tags for the custom action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-tags</a>
         * @param tags The tags for the custom action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.CfnCustomActionType}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.CfnCustomActionType build() {
            return new software.amazon.awscdk.services.codepipeline.CfnCustomActionType(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
