package software.amazon.awscdk.services.codepipeline;

/**
 * Represents a rule in AWS CodePipeline that can be used to add conditions and controls to pipeline execution.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodeStarConnectionsSourceAction sourceAction;
 * CodeBuildAction buildAction;
 * Pipeline.Builder.create(this, "Pipeline")
 *         .pipelineType(PipelineType.V2)
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Build")
 *                 .actions(List.of(buildAction))
 *                 // BeforeEntry condition - checks before entering the stage
 *                 .beforeEntry(Conditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("LambdaCheck")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "FunctionName", "LambdaFunctionName"))
 *                                         .build()))
 *                                 .result(Result.FAIL)
 *                                 .build()))
 *                         .build())
 *                 // OnSuccess condition - checks after successful stage completion
 *                 .onSuccess(Conditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .result(Result.FAIL)
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("CloudWatchCheck")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "AlarmName", "AlarmName1",
 *                                                 "WaitTime", "300",  // 5 minutes
 *                                                 "FunctionName", "funcName2"))
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 // OnFailure condition - handles stage failure
 *                 .onFailure(FailureConditions.builder()
 *                         .conditions(List.of(Condition.builder()
 *                                 .result(Result.ROLLBACK)
 *                                 .rules(List.of(Rule.Builder.create()
 *                                         .name("RollBackOnFailure")
 *                                         .provider("LambdaInvoke")
 *                                         .version("1")
 *                                         .configuration(Map.of(
 *                                                 "AlarmName", "Alarm",
 *                                                 "WaitTime", "300",  // 5 minutes
 *                                                 "FunctionName", "funcName1"))
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.515Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.Rule")
public class Rule extends software.amazon.jsii.JsiiObject {

    protected Rule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Rule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new Rule instance.
     * <p>
     * @param props <ul><li>Configuration properties for the rule.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Rule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.RuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns a reference to the rule that can be used in pipeline stage conditions.
     * <p>
     * @return A string in the format "#{rule.ruleName}" that can be used to reference this rule
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String reference() {
        return software.amazon.jsii.Kernel.call(this, "reference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the rule, if specified in the properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRuleName() {
        return software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.Rule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.Rule> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.RuleProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.RuleProps.Builder();
        }

        /**
         * The shell commands to run with your commands rule in CodePipeline.
         * <p>
         * All commands are supported except multi-line formats. While CodeBuild logs and permissions are used,
         * you do not need to create any resources in CodeBuild.
         * <p>
         * Default: - No commands
         * <p>
         * @return {@code this}
         * @param commands The shell commands to run with your commands rule in CodePipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commands(final java.util.List<java.lang.String> commands) {
            this.props.commands(commands);
            return this;
        }

        /**
         * The action configuration fields for the rule.
         * <p>
         * This can include custom parameters specific to the rule type.
         * <p>
         * Default: - No configuration
         * <p>
         * @return {@code this}
         * @param configuration The action configuration fields for the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final com.fasterxml.jackson.databind.node.ObjectNode configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * The input artifacts fields for the rule, such as specifying an input file for the rule.
         * <p>
         * Each string in the array represents an artifact name that this rule will use as input.
         * <p>
         * Default: - No input artifacts
         * <p>
         * @return {@code this}
         * @param inputArtifacts The input artifacts fields for the rule, such as specifying an input file for the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputArtifacts(final java.util.List<java.lang.String> inputArtifacts) {
            this.props.inputArtifacts(inputArtifacts);
            return this;
        }

        /**
         * The name of the rule that is created for the condition.
         * <p>
         * Must be unique within the pipeline.
         * <p>
         * Default: - A unique name will be generated
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "VariableCheck";
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param name The name of the rule that is created for the condition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The rule provider that implements the rule's functionality.
         * <p>
         * Default: - No provider, must be specified if rule is used
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * "DeploymentWindow";
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="AWS CodePipeline rule reference for available providers">AWS CodePipeline rule reference for available providers</a>
         * @param provider The rule provider that implements the rule's functionality. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(final java.lang.String provider) {
            this.props.provider(provider);
            return this;
        }

        /**
         * The AWS Region for the condition associated with the rule.
         * <p>
         * If not specified, uses the pipeline's region.
         * <p>
         * Default: - Pipeline's region
         * <p>
         * @return {@code this}
         * @param region The AWS Region for the condition associated with the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * The IAM role that the rule will use to execute its actions.
         * <p>
         * The role must have sufficient permissions to perform the rule's tasks.
         * <p>
         * Default: - A new role will be created
         * <p>
         * @return {@code this}
         * @param role The IAM role that the rule will use to execute its actions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.Role role) {
            this.props.role(role);
            return this;
        }

        /**
         * The version of the rule to use.
         * <p>
         * Different versions may have different features or behaviors.
         * <p>
         * Default: '1'
         * <p>
         * @return {@code this}
         * @param version The version of the rule to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final java.lang.String version) {
            this.props.version(version);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.Rule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.Rule build() {
            return new software.amazon.awscdk.services.codepipeline.Rule(
                this.props.build()
            );
        }
    }
}
