package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Number or percentage of max instances for EC2 deploy action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * Ec2MaxInstances ec2MaxInstances = Ec2MaxInstances.percentage(123);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.598Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.Ec2MaxInstances")
public abstract class Ec2MaxInstances extends software.amazon.jsii.JsiiObject {

    protected Ec2MaxInstances(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Ec2MaxInstances(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Ec2MaxInstances() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Max percentage of instances.
     * <p>
     * Valid range: from 1 to 100
     * <p>
     * @param percentage This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances percentage(final @org.jetbrains.annotations.NotNull java.lang.Number percentage) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances.class, "percentage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances.class), new Object[] { java.util.Objects.requireNonNull(percentage, "percentage is required") });
    }

    /**
     * Max number of instances.
     * <p>
     * Valid range: from 1 to number of your instances
     * <p>
     * @param targets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances targets(final @org.jetbrains.annotations.NotNull java.lang.Number targets) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances.class, "targets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances.class), new Object[] { java.util.Objects.requireNonNull(targets, "targets is required") });
    }

    /**
     * Template value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getValue();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.codepipeline.actions.Ec2MaxInstances {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Template value.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getValue() {
            return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
