package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Construction properties of the <code>InspectorEcrImageScanAction</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.*;
 * Pipeline pipeline;
 * IRepository repository;
 * Artifact scanOutput = new Artifact();
 * InspectorEcrImageScanAction scanAction = InspectorEcrImageScanAction.Builder.create()
 *         .actionName("InspectorEcrImageScanAction")
 *         .output(scanOutput)
 *         .repository(repository)
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("Scan")
 *         .actions(List.of(scanAction))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.609Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.InspectorEcrImageScanActionProps")
@software.amazon.jsii.Jsii.Proxy(InspectorEcrImageScanActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InspectorEcrImageScanActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.actions.InspectorScanActionBaseProps {

    /**
     * The Amazon ECR repository where the image is pushed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository getRepository();

    /**
     * The tag used for the image.
     * <p>
     * Default: 'latest'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageTag() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InspectorEcrImageScanActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InspectorEcrImageScanActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InspectorEcrImageScanActionProps> {
        software.amazon.awscdk.services.ecr.IRepository repository;
        java.lang.String imageTag;
        software.amazon.awscdk.services.codepipeline.Artifact output;
        java.lang.Number criticalThreshold;
        java.lang.Number highThreshold;
        java.lang.Number lowThreshold;
        java.lang.Number mediumThreshold;
        software.amazon.awscdk.services.iam.IRole role;
        java.lang.String actionName;
        java.lang.Number runOrder;
        java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link InspectorEcrImageScanActionProps#getRepository}
         * @param repository The Amazon ECR repository where the image is pushed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(software.amazon.awscdk.services.ecr.IRepository repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Sets the value of {@link InspectorEcrImageScanActionProps#getImageTag}
         * @param imageTag The tag used for the image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTag(java.lang.String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        /**
         * Sets the value of {@link InspectorEcrImageScanActionProps#getOutput}
         * @param output Vulnerability details of your source in the form of a Software Bill of Materials (SBOM) file. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.output = output;
            return this;
        }

        /**
         * Sets the value of {@link InspectorEcrImageScanActionProps#getCriticalThreshold}
         * @param criticalThreshold The number of critical severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criticalThreshold(java.lang.Number criticalThreshold) {
            this.criticalThreshold = criticalThreshold;
            return this;
        }

        /**
         * Sets the value of {@link InspectorEcrImageScanActionProps#getHighThreshold}
         * @param highThreshold The number of high severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder highThreshold(java.lang.Number highThreshold) {
            this.highThreshold = highThreshold;
            return this;
        }

        /**
         * Sets the value of {@link InspectorEcrImageScanActionProps#getLowThreshold}
         * @param lowThreshold The number of low severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lowThreshold(java.lang.Number lowThreshold) {
            this.lowThreshold = lowThreshold;
            return this;
        }

        /**
         * Sets the value of {@link InspectorEcrImageScanActionProps#getMediumThreshold}
         * @param mediumThreshold The number of medium severity vulnerabilities found in your source beyond which CodePipeline should fail the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mediumThreshold(java.lang.Number mediumThreshold) {
            this.mediumThreshold = mediumThreshold;
            return this;
        }

        /**
         * Sets the value of {@link InspectorEcrImageScanActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your <code>IAction.bind</code>
         *             method in the <code>ActionBindOptions.role</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link InspectorEcrImageScanActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link InspectorEcrImageScanActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link InspectorEcrImageScanActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InspectorEcrImageScanActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InspectorEcrImageScanActionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InspectorEcrImageScanActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InspectorEcrImageScanActionProps {
        private final software.amazon.awscdk.services.ecr.IRepository repository;
        private final java.lang.String imageTag;
        private final software.amazon.awscdk.services.codepipeline.Artifact output;
        private final java.lang.Number criticalThreshold;
        private final java.lang.Number highThreshold;
        private final java.lang.Number lowThreshold;
        private final java.lang.Number mediumThreshold;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
            this.imageTag = software.amazon.jsii.Kernel.get(this, "imageTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.criticalThreshold = software.amazon.jsii.Kernel.get(this, "criticalThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.highThreshold = software.amazon.jsii.Kernel.get(this, "highThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.lowThreshold = software.amazon.jsii.Kernel.get(this, "lowThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.mediumThreshold = software.amazon.jsii.Kernel.get(this, "mediumThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repository = java.util.Objects.requireNonNull(builder.repository, "repository is required");
            this.imageTag = builder.imageTag;
            this.output = java.util.Objects.requireNonNull(builder.output, "output is required");
            this.criticalThreshold = builder.criticalThreshold;
            this.highThreshold = builder.highThreshold;
            this.lowThreshold = builder.lowThreshold;
            this.mediumThreshold = builder.mediumThreshold;
            this.role = builder.role;
            this.actionName = java.util.Objects.requireNonNull(builder.actionName, "actionName is required");
            this.runOrder = builder.runOrder;
            this.variablesNamespace = builder.variablesNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.ecr.IRepository getRepository() {
            return this.repository;
        }

        @Override
        public final java.lang.String getImageTag() {
            return this.imageTag;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getOutput() {
            return this.output;
        }

        @Override
        public final java.lang.Number getCriticalThreshold() {
            return this.criticalThreshold;
        }

        @Override
        public final java.lang.Number getHighThreshold() {
            return this.highThreshold;
        }

        @Override
        public final java.lang.Number getLowThreshold() {
            return this.lowThreshold;
        }

        @Override
        public final java.lang.Number getMediumThreshold() {
            return this.mediumThreshold;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("repository", om.valueToTree(this.getRepository()));
            if (this.getImageTag() != null) {
                data.set("imageTag", om.valueToTree(this.getImageTag()));
            }
            data.set("output", om.valueToTree(this.getOutput()));
            if (this.getCriticalThreshold() != null) {
                data.set("criticalThreshold", om.valueToTree(this.getCriticalThreshold()));
            }
            if (this.getHighThreshold() != null) {
                data.set("highThreshold", om.valueToTree(this.getHighThreshold()));
            }
            if (this.getLowThreshold() != null) {
                data.set("lowThreshold", om.valueToTree(this.getLowThreshold()));
            }
            if (this.getMediumThreshold() != null) {
                data.set("mediumThreshold", om.valueToTree(this.getMediumThreshold()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.InspectorEcrImageScanActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InspectorEcrImageScanActionProps.Jsii$Proxy that = (InspectorEcrImageScanActionProps.Jsii$Proxy) o;

            if (!repository.equals(that.repository)) return false;
            if (this.imageTag != null ? !this.imageTag.equals(that.imageTag) : that.imageTag != null) return false;
            if (!output.equals(that.output)) return false;
            if (this.criticalThreshold != null ? !this.criticalThreshold.equals(that.criticalThreshold) : that.criticalThreshold != null) return false;
            if (this.highThreshold != null ? !this.highThreshold.equals(that.highThreshold) : that.highThreshold != null) return false;
            if (this.lowThreshold != null ? !this.lowThreshold.equals(that.lowThreshold) : that.lowThreshold != null) return false;
            if (this.mediumThreshold != null ? !this.mediumThreshold.equals(that.mediumThreshold) : that.mediumThreshold != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.repository.hashCode();
            result = 31 * result + (this.imageTag != null ? this.imageTag.hashCode() : 0);
            result = 31 * result + (this.output.hashCode());
            result = 31 * result + (this.criticalThreshold != null ? this.criticalThreshold.hashCode() : 0);
            result = 31 * result + (this.highThreshold != null ? this.highThreshold.hashCode() : 0);
            result = 31 * result + (this.lowThreshold != null ? this.lowThreshold.hashCode() : 0);
            result = 31 * result + (this.mediumThreshold != null ? this.mediumThreshold.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
