package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a <code>CfnIdentityPool</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.*;
 * OpenIdConnectProvider myProvider;
 * CfnIdentityPool.Builder.create(this, "IdentityPool")
 *         .openIdConnectProviderArns(List.of(myProvider.getOpenIdConnectProviderArn()))
 *         // And the other properties for your identity pool
 *         .allowUnauthenticatedIdentities(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.712Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnIdentityPoolProps")
@software.amazon.jsii.Jsii.Proxy(CfnIdentityPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIdentityPoolProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether the identity pool supports unauthenticated logins.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowunauthenticatedidentities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAllowUnauthenticatedIdentities();

    /**
     * Enables the Basic (Classic) authentication flow.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-allowclassicflow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowClassicFlow() {
        return null;
    }

    /**
     * The events to configure.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoevents</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCognitoEvents() {
        return null;
    }

    /**
     * The Amazon Cognito user pools and their client IDs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitoidentityproviders</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCognitoIdentityProviders() {
        return null;
    }

    /**
     * Configuration options for configuring Amazon Cognito streams.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-cognitostreams</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCognitoStreams() {
        return null;
    }

    /**
     * The "domain" Amazon Cognito uses when referencing your users.
     * <p>
     * This name acts as a placeholder that allows your backend and the Amazon Cognito service to communicate about the developer provider. For the <code>DeveloperProviderName</code> , you can use letters and periods (.), underscores (_), and dashes (-).
     * <p>
     * <em>Minimum length</em> : 1
     * <p>
     * <em>Maximum length</em> : 100
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-developerprovidername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-developerprovidername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeveloperProviderName() {
        return null;
    }

    /**
     * The name of your Amazon Cognito identity pool.
     * <p>
     * <em>Minimum length</em> : 1
     * <p>
     * <em>Maximum length</em> : 128
     * <p>
     * <em>Pattern</em> : <code>[\w\s+=,.&#64;-]+</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypoolname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypoolname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIdentityPoolName() {
        return null;
    }

    /**
     * Tags to assign to the identity pool.
     * <p>
     * A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypooltags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-identitypooltags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getIdentityPoolTags() {
        return null;
    }

    /**
     * The Amazon Resource Names (ARNs) of the OpenID connect providers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-openidconnectproviderarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-openidconnectproviderarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOpenIdConnectProviderArns() {
        return null;
    }

    /**
     * The configuration options to be applied to the identity pool.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-pushsync</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPushSync() {
        return null;
    }

    /**
     * The Amazon Resource Names (ARNs) of the Security Assertion Markup Language (SAML) providers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-samlproviderarns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-samlproviderarns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSamlProviderArns() {
        return null;
    }

    /**
     * Key-value pairs that map provider names to provider app IDs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-supportedloginproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-identitypool.html#cfn-cognito-identitypool-supportedloginproviders</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSupportedLoginProviders() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIdentityPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIdentityPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIdentityPoolProps> {
        java.lang.Object allowUnauthenticatedIdentities;
        java.lang.Object allowClassicFlow;
        java.lang.Object cognitoEvents;
        java.lang.Object cognitoIdentityProviders;
        java.lang.Object cognitoStreams;
        java.lang.String developerProviderName;
        java.lang.String identityPoolName;
        java.util.List<software.amazon.awscdk.CfnTag> identityPoolTags;
        java.util.List<java.lang.String> openIdConnectProviderArns;
        java.lang.Object pushSync;
        java.util.List<java.lang.String> samlProviderArns;
        java.lang.Object supportedLoginProviders;

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getAllowUnauthenticatedIdentities}
         * @param allowUnauthenticatedIdentities Specifies whether the identity pool supports unauthenticated logins. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowUnauthenticatedIdentities(java.lang.Boolean allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getAllowUnauthenticatedIdentities}
         * @param allowUnauthenticatedIdentities Specifies whether the identity pool supports unauthenticated logins. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowUnauthenticatedIdentities(software.amazon.awscdk.IResolvable allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getAllowClassicFlow}
         * @param allowClassicFlow Enables the Basic (Classic) authentication flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowClassicFlow(java.lang.Boolean allowClassicFlow) {
            this.allowClassicFlow = allowClassicFlow;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getAllowClassicFlow}
         * @param allowClassicFlow Enables the Basic (Classic) authentication flow.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowClassicFlow(software.amazon.awscdk.IResolvable allowClassicFlow) {
            this.allowClassicFlow = allowClassicFlow;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getCognitoEvents}
         * @param cognitoEvents The events to configure.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoEvents(java.lang.Object cognitoEvents) {
            this.cognitoEvents = cognitoEvents;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getCognitoIdentityProviders}
         * @param cognitoIdentityProviders The Amazon Cognito user pools and their client IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoIdentityProviders(software.amazon.awscdk.IResolvable cognitoIdentityProviders) {
            this.cognitoIdentityProviders = cognitoIdentityProviders;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getCognitoIdentityProviders}
         * @param cognitoIdentityProviders The Amazon Cognito user pools and their client IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoIdentityProviders(java.util.List<? extends java.lang.Object> cognitoIdentityProviders) {
            this.cognitoIdentityProviders = cognitoIdentityProviders;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getCognitoStreams}
         * @param cognitoStreams Configuration options for configuring Amazon Cognito streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoStreams(software.amazon.awscdk.IResolvable cognitoStreams) {
            this.cognitoStreams = cognitoStreams;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getCognitoStreams}
         * @param cognitoStreams Configuration options for configuring Amazon Cognito streams.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoStreams(software.amazon.awscdk.services.cognito.CfnIdentityPool.CognitoStreamsProperty cognitoStreams) {
            this.cognitoStreams = cognitoStreams;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getDeveloperProviderName}
         * @param developerProviderName The "domain" Amazon Cognito uses when referencing your users.
         *                              This name acts as a placeholder that allows your backend and the Amazon Cognito service to communicate about the developer provider. For the <code>DeveloperProviderName</code> , you can use letters and periods (.), underscores (_), and dashes (-).
         *                              <p>
         *                              <em>Minimum length</em> : 1
         *                              <p>
         *                              <em>Maximum length</em> : 100
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder developerProviderName(java.lang.String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getIdentityPoolName}
         * @param identityPoolName The name of your Amazon Cognito identity pool.
         *                         <em>Minimum length</em> : 1
         *                         <p>
         *                         <em>Maximum length</em> : 128
         *                         <p>
         *                         <em>Pattern</em> : <code>[\w\s+=,.&#64;-]+</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityPoolName(java.lang.String identityPoolName) {
            this.identityPoolName = identityPoolName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getIdentityPoolTags}
         * @param identityPoolTags Tags to assign to the identity pool.
         *                         A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder identityPoolTags(java.util.List<? extends software.amazon.awscdk.CfnTag> identityPoolTags) {
            this.identityPoolTags = (java.util.List<software.amazon.awscdk.CfnTag>)identityPoolTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getOpenIdConnectProviderArns}
         * @param openIdConnectProviderArns The Amazon Resource Names (ARNs) of the OpenID connect providers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openIdConnectProviderArns(java.util.List<java.lang.String> openIdConnectProviderArns) {
            this.openIdConnectProviderArns = openIdConnectProviderArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getPushSync}
         * @param pushSync The configuration options to be applied to the identity pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pushSync(software.amazon.awscdk.IResolvable pushSync) {
            this.pushSync = pushSync;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getPushSync}
         * @param pushSync The configuration options to be applied to the identity pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pushSync(software.amazon.awscdk.services.cognito.CfnIdentityPool.PushSyncProperty pushSync) {
            this.pushSync = pushSync;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getSamlProviderArns}
         * @param samlProviderArns The Amazon Resource Names (ARNs) of the Security Assertion Markup Language (SAML) providers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samlProviderArns(java.util.List<java.lang.String> samlProviderArns) {
            this.samlProviderArns = samlProviderArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnIdentityPoolProps#getSupportedLoginProviders}
         * @param supportedLoginProviders Key-value pairs that map provider names to provider app IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportedLoginProviders(java.lang.Object supportedLoginProviders) {
            this.supportedLoginProviders = supportedLoginProviders;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIdentityPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIdentityPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIdentityPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIdentityPoolProps {
        private final java.lang.Object allowUnauthenticatedIdentities;
        private final java.lang.Object allowClassicFlow;
        private final java.lang.Object cognitoEvents;
        private final java.lang.Object cognitoIdentityProviders;
        private final java.lang.Object cognitoStreams;
        private final java.lang.String developerProviderName;
        private final java.lang.String identityPoolName;
        private final java.util.List<software.amazon.awscdk.CfnTag> identityPoolTags;
        private final java.util.List<java.lang.String> openIdConnectProviderArns;
        private final java.lang.Object pushSync;
        private final java.util.List<java.lang.String> samlProviderArns;
        private final java.lang.Object supportedLoginProviders;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowUnauthenticatedIdentities = software.amazon.jsii.Kernel.get(this, "allowUnauthenticatedIdentities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.allowClassicFlow = software.amazon.jsii.Kernel.get(this, "allowClassicFlow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cognitoEvents = software.amazon.jsii.Kernel.get(this, "cognitoEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cognitoIdentityProviders = software.amazon.jsii.Kernel.get(this, "cognitoIdentityProviders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cognitoStreams = software.amazon.jsii.Kernel.get(this, "cognitoStreams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.developerProviderName = software.amazon.jsii.Kernel.get(this, "developerProviderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityPoolName = software.amazon.jsii.Kernel.get(this, "identityPoolName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identityPoolTags = software.amazon.jsii.Kernel.get(this, "identityPoolTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.openIdConnectProviderArns = software.amazon.jsii.Kernel.get(this, "openIdConnectProviderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.pushSync = software.amazon.jsii.Kernel.get(this, "pushSync", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.samlProviderArns = software.amazon.jsii.Kernel.get(this, "samlProviderArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.supportedLoginProviders = software.amazon.jsii.Kernel.get(this, "supportedLoginProviders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowUnauthenticatedIdentities = java.util.Objects.requireNonNull(builder.allowUnauthenticatedIdentities, "allowUnauthenticatedIdentities is required");
            this.allowClassicFlow = builder.allowClassicFlow;
            this.cognitoEvents = builder.cognitoEvents;
            this.cognitoIdentityProviders = builder.cognitoIdentityProviders;
            this.cognitoStreams = builder.cognitoStreams;
            this.developerProviderName = builder.developerProviderName;
            this.identityPoolName = builder.identityPoolName;
            this.identityPoolTags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.identityPoolTags;
            this.openIdConnectProviderArns = builder.openIdConnectProviderArns;
            this.pushSync = builder.pushSync;
            this.samlProviderArns = builder.samlProviderArns;
            this.supportedLoginProviders = builder.supportedLoginProviders;
        }

        @Override
        public final java.lang.Object getAllowUnauthenticatedIdentities() {
            return this.allowUnauthenticatedIdentities;
        }

        @Override
        public final java.lang.Object getAllowClassicFlow() {
            return this.allowClassicFlow;
        }

        @Override
        public final java.lang.Object getCognitoEvents() {
            return this.cognitoEvents;
        }

        @Override
        public final java.lang.Object getCognitoIdentityProviders() {
            return this.cognitoIdentityProviders;
        }

        @Override
        public final java.lang.Object getCognitoStreams() {
            return this.cognitoStreams;
        }

        @Override
        public final java.lang.String getDeveloperProviderName() {
            return this.developerProviderName;
        }

        @Override
        public final java.lang.String getIdentityPoolName() {
            return this.identityPoolName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getIdentityPoolTags() {
            return this.identityPoolTags;
        }

        @Override
        public final java.util.List<java.lang.String> getOpenIdConnectProviderArns() {
            return this.openIdConnectProviderArns;
        }

        @Override
        public final java.lang.Object getPushSync() {
            return this.pushSync;
        }

        @Override
        public final java.util.List<java.lang.String> getSamlProviderArns() {
            return this.samlProviderArns;
        }

        @Override
        public final java.lang.Object getSupportedLoginProviders() {
            return this.supportedLoginProviders;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allowUnauthenticatedIdentities", om.valueToTree(this.getAllowUnauthenticatedIdentities()));
            if (this.getAllowClassicFlow() != null) {
                data.set("allowClassicFlow", om.valueToTree(this.getAllowClassicFlow()));
            }
            if (this.getCognitoEvents() != null) {
                data.set("cognitoEvents", om.valueToTree(this.getCognitoEvents()));
            }
            if (this.getCognitoIdentityProviders() != null) {
                data.set("cognitoIdentityProviders", om.valueToTree(this.getCognitoIdentityProviders()));
            }
            if (this.getCognitoStreams() != null) {
                data.set("cognitoStreams", om.valueToTree(this.getCognitoStreams()));
            }
            if (this.getDeveloperProviderName() != null) {
                data.set("developerProviderName", om.valueToTree(this.getDeveloperProviderName()));
            }
            if (this.getIdentityPoolName() != null) {
                data.set("identityPoolName", om.valueToTree(this.getIdentityPoolName()));
            }
            if (this.getIdentityPoolTags() != null) {
                data.set("identityPoolTags", om.valueToTree(this.getIdentityPoolTags()));
            }
            if (this.getOpenIdConnectProviderArns() != null) {
                data.set("openIdConnectProviderArns", om.valueToTree(this.getOpenIdConnectProviderArns()));
            }
            if (this.getPushSync() != null) {
                data.set("pushSync", om.valueToTree(this.getPushSync()));
            }
            if (this.getSamlProviderArns() != null) {
                data.set("samlProviderArns", om.valueToTree(this.getSamlProviderArns()));
            }
            if (this.getSupportedLoginProviders() != null) {
                data.set("supportedLoginProviders", om.valueToTree(this.getSupportedLoginProviders()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnIdentityPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIdentityPoolProps.Jsii$Proxy that = (CfnIdentityPoolProps.Jsii$Proxy) o;

            if (!allowUnauthenticatedIdentities.equals(that.allowUnauthenticatedIdentities)) return false;
            if (this.allowClassicFlow != null ? !this.allowClassicFlow.equals(that.allowClassicFlow) : that.allowClassicFlow != null) return false;
            if (this.cognitoEvents != null ? !this.cognitoEvents.equals(that.cognitoEvents) : that.cognitoEvents != null) return false;
            if (this.cognitoIdentityProviders != null ? !this.cognitoIdentityProviders.equals(that.cognitoIdentityProviders) : that.cognitoIdentityProviders != null) return false;
            if (this.cognitoStreams != null ? !this.cognitoStreams.equals(that.cognitoStreams) : that.cognitoStreams != null) return false;
            if (this.developerProviderName != null ? !this.developerProviderName.equals(that.developerProviderName) : that.developerProviderName != null) return false;
            if (this.identityPoolName != null ? !this.identityPoolName.equals(that.identityPoolName) : that.identityPoolName != null) return false;
            if (this.identityPoolTags != null ? !this.identityPoolTags.equals(that.identityPoolTags) : that.identityPoolTags != null) return false;
            if (this.openIdConnectProviderArns != null ? !this.openIdConnectProviderArns.equals(that.openIdConnectProviderArns) : that.openIdConnectProviderArns != null) return false;
            if (this.pushSync != null ? !this.pushSync.equals(that.pushSync) : that.pushSync != null) return false;
            if (this.samlProviderArns != null ? !this.samlProviderArns.equals(that.samlProviderArns) : that.samlProviderArns != null) return false;
            return this.supportedLoginProviders != null ? this.supportedLoginProviders.equals(that.supportedLoginProviders) : that.supportedLoginProviders == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowUnauthenticatedIdentities.hashCode();
            result = 31 * result + (this.allowClassicFlow != null ? this.allowClassicFlow.hashCode() : 0);
            result = 31 * result + (this.cognitoEvents != null ? this.cognitoEvents.hashCode() : 0);
            result = 31 * result + (this.cognitoIdentityProviders != null ? this.cognitoIdentityProviders.hashCode() : 0);
            result = 31 * result + (this.cognitoStreams != null ? this.cognitoStreams.hashCode() : 0);
            result = 31 * result + (this.developerProviderName != null ? this.developerProviderName.hashCode() : 0);
            result = 31 * result + (this.identityPoolName != null ? this.identityPoolName.hashCode() : 0);
            result = 31 * result + (this.identityPoolTags != null ? this.identityPoolTags.hashCode() : 0);
            result = 31 * result + (this.openIdConnectProviderArns != null ? this.openIdConnectProviderArns.hashCode() : 0);
            result = 31 * result + (this.pushSync != null ? this.pushSync.hashCode() : 0);
            result = 31 * result + (this.samlProviderArns != null ? this.samlProviderArns.hashCode() : 0);
            result = 31 * result + (this.supportedLoginProviders != null ? this.supportedLoginProviders.hashCode() : 0);
            return result;
        }
    }
}
