package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a <code>CfnManagedLoginBranding</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * Object settings;
 * CfnManagedLoginBrandingProps cfnManagedLoginBrandingProps = CfnManagedLoginBrandingProps.builder()
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .assets(List.of(AssetTypeProperty.builder()
 *                 .category("category")
 *                 .colorMode("colorMode")
 *                 .extension("extension")
 *                 // the properties below are optional
 *                 .bytes("bytes")
 *                 .resourceId("resourceId")
 *                 .build()))
 *         .clientId("clientId")
 *         .returnMergedResources(false)
 *         .settings(settings)
 *         .useCognitoProvidedValues(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.722Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnManagedLoginBrandingProps")
@software.amazon.jsii.Jsii.Proxy(CfnManagedLoginBrandingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnManagedLoginBrandingProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The user pool where the branding style is assigned.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-userpoolid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * An array of image files that you want to apply to roles like backgrounds, logos, and icons.
     * <p>
     * Each object must also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-assets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-assets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssets() {
        return null;
    }

    /**
     * The app client that you want to assign the branding style to.
     * <p>
     * Each style is linked to an app client until you delete it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-clientid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientId() {
        return null;
    }

    /**
     * When <code>true</code> , returns values for branding options that are unchanged from Amazon Cognito defaults.
     * <p>
     * When <code>false</code> or when you omit this parameter, returns only values that you customized in your branding style.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-returnmergedresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-returnmergedresources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReturnMergedResources() {
        return null;
    }

    /**
     * A JSON file, encoded as a <code>Document</code> type, with the the settings that you want to apply to your style.
     * <p>
     * The following components are not currently implemented and reserved for future use:
     * <p>
     * <ul>
     * <li><code>signUp</code></li>
     * <li><code>instructions</code></li>
     * <li><code>sessionTimerDisplay</code></li>
     * <li><code>languageSelector</code> (for localization, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html#managed-login-localization">Managed login localization)</a></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-settings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-settings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSettings() {
        return null;
    }

    /**
     * When true, applies the default branding style options.
     * <p>
     * This option reverts to default style options that are managed by Amazon Cognito. You can modify them later in the branding editor.
     * <p>
     * When you specify <code>true</code> for this option, you must also omit values for <code>Settings</code> and <code>Assets</code> in the request.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-usecognitoprovidedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-managedloginbranding.html#cfn-cognito-managedloginbranding-usecognitoprovidedvalues</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseCognitoProvidedValues() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnManagedLoginBrandingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnManagedLoginBrandingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnManagedLoginBrandingProps> {
        java.lang.String userPoolId;
        java.lang.Object assets;
        java.lang.String clientId;
        java.lang.Object returnMergedResources;
        java.lang.Object settings;
        java.lang.Object useCognitoProvidedValues;

        /**
         * Sets the value of {@link CfnManagedLoginBrandingProps#getUserPoolId}
         * @param userPoolId The user pool where the branding style is assigned. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnManagedLoginBrandingProps#getAssets}
         * @param assets An array of image files that you want to apply to roles like backgrounds, logos, and icons.
         *               Each object must also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assets(software.amazon.awscdk.IResolvable assets) {
            this.assets = assets;
            return this;
        }

        /**
         * Sets the value of {@link CfnManagedLoginBrandingProps#getAssets}
         * @param assets An array of image files that you want to apply to roles like backgrounds, logos, and icons.
         *               Each object must also indicate whether it is for dark mode, light mode, or browser-adaptive mode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assets(java.util.List<? extends java.lang.Object> assets) {
            this.assets = assets;
            return this;
        }

        /**
         * Sets the value of {@link CfnManagedLoginBrandingProps#getClientId}
         * @param clientId The app client that you want to assign the branding style to.
         *                 Each style is linked to an app client until you delete it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link CfnManagedLoginBrandingProps#getReturnMergedResources}
         * @param returnMergedResources When <code>true</code> , returns values for branding options that are unchanged from Amazon Cognito defaults.
         *                              When <code>false</code> or when you omit this parameter, returns only values that you customized in your branding style.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnMergedResources(java.lang.Boolean returnMergedResources) {
            this.returnMergedResources = returnMergedResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnManagedLoginBrandingProps#getReturnMergedResources}
         * @param returnMergedResources When <code>true</code> , returns values for branding options that are unchanged from Amazon Cognito defaults.
         *                              When <code>false</code> or when you omit this parameter, returns only values that you customized in your branding style.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnMergedResources(software.amazon.awscdk.IResolvable returnMergedResources) {
            this.returnMergedResources = returnMergedResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnManagedLoginBrandingProps#getSettings}
         * @param settings A JSON file, encoded as a <code>Document</code> type, with the the settings that you want to apply to your style.
         *                 The following components are not currently implemented and reserved for future use:
         *                 <p>
         *                 <ul>
         *                 <li><code>signUp</code></li>
         *                 <li><code>instructions</code></li>
         *                 <li><code>sessionTimerDisplay</code></li>
         *                 <li><code>languageSelector</code> (for localization, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-managed-login.html#managed-login-localization">Managed login localization)</a></li>
         *                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(java.lang.Object settings) {
            this.settings = settings;
            return this;
        }

        /**
         * Sets the value of {@link CfnManagedLoginBrandingProps#getUseCognitoProvidedValues}
         * @param useCognitoProvidedValues When true, applies the default branding style options.
         *                                 This option reverts to default style options that are managed by Amazon Cognito. You can modify them later in the branding editor.
         *                                 <p>
         *                                 When you specify <code>true</code> for this option, you must also omit values for <code>Settings</code> and <code>Assets</code> in the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCognitoProvidedValues(java.lang.Boolean useCognitoProvidedValues) {
            this.useCognitoProvidedValues = useCognitoProvidedValues;
            return this;
        }

        /**
         * Sets the value of {@link CfnManagedLoginBrandingProps#getUseCognitoProvidedValues}
         * @param useCognitoProvidedValues When true, applies the default branding style options.
         *                                 This option reverts to default style options that are managed by Amazon Cognito. You can modify them later in the branding editor.
         *                                 <p>
         *                                 When you specify <code>true</code> for this option, you must also omit values for <code>Settings</code> and <code>Assets</code> in the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCognitoProvidedValues(software.amazon.awscdk.IResolvable useCognitoProvidedValues) {
            this.useCognitoProvidedValues = useCognitoProvidedValues;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnManagedLoginBrandingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnManagedLoginBrandingProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnManagedLoginBrandingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnManagedLoginBrandingProps {
        private final java.lang.String userPoolId;
        private final java.lang.Object assets;
        private final java.lang.String clientId;
        private final java.lang.Object returnMergedResources;
        private final java.lang.Object settings;
        private final java.lang.Object useCognitoProvidedValues;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assets = software.amazon.jsii.Kernel.get(this, "assets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.returnMergedResources = software.amazon.jsii.Kernel.get(this, "returnMergedResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.settings = software.amazon.jsii.Kernel.get(this, "settings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.useCognitoProvidedValues = software.amazon.jsii.Kernel.get(this, "useCognitoProvidedValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
            this.assets = builder.assets;
            this.clientId = builder.clientId;
            this.returnMergedResources = builder.returnMergedResources;
            this.settings = builder.settings;
            this.useCognitoProvidedValues = builder.useCognitoProvidedValues;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final java.lang.Object getAssets() {
            return this.assets;
        }

        @Override
        public final java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public final java.lang.Object getReturnMergedResources() {
            return this.returnMergedResources;
        }

        @Override
        public final java.lang.Object getSettings() {
            return this.settings;
        }

        @Override
        public final java.lang.Object getUseCognitoProvidedValues() {
            return this.useCognitoProvidedValues;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getAssets() != null) {
                data.set("assets", om.valueToTree(this.getAssets()));
            }
            if (this.getClientId() != null) {
                data.set("clientId", om.valueToTree(this.getClientId()));
            }
            if (this.getReturnMergedResources() != null) {
                data.set("returnMergedResources", om.valueToTree(this.getReturnMergedResources()));
            }
            if (this.getSettings() != null) {
                data.set("settings", om.valueToTree(this.getSettings()));
            }
            if (this.getUseCognitoProvidedValues() != null) {
                data.set("useCognitoProvidedValues", om.valueToTree(this.getUseCognitoProvidedValues()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnManagedLoginBrandingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnManagedLoginBrandingProps.Jsii$Proxy that = (CfnManagedLoginBrandingProps.Jsii$Proxy) o;

            if (!userPoolId.equals(that.userPoolId)) return false;
            if (this.assets != null ? !this.assets.equals(that.assets) : that.assets != null) return false;
            if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) return false;
            if (this.returnMergedResources != null ? !this.returnMergedResources.equals(that.returnMergedResources) : that.returnMergedResources != null) return false;
            if (this.settings != null ? !this.settings.equals(that.settings) : that.settings != null) return false;
            return this.useCognitoProvidedValues != null ? this.useCognitoProvidedValues.equals(that.useCognitoProvidedValues) : that.useCognitoProvidedValues == null;
        }

        @Override
        public final int hashCode() {
            int result = this.userPoolId.hashCode();
            result = 31 * result + (this.assets != null ? this.assets.hashCode() : 0);
            result = 31 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
            result = 31 * result + (this.returnMergedResources != null ? this.returnMergedResources.hashCode() : 0);
            result = 31 * result + (this.settings != null ? this.settings.hashCode() : 0);
            result = 31 * result + (this.useCognitoProvidedValues != null ? this.useCognitoProvidedValues.hashCode() : 0);
            return result;
        }
    }
}
