package software.amazon.awscdk.services.cognito;

/**
 * Properties to initialize UserPoolGoogleIdentityProvider.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool userpool = new UserPool(this, "Pool");
 * SecretValue secret = Secret.fromSecretAttributes(this, "CognitoClientSecret", SecretAttributes.builder()
 *         .secretCompleteArn("arn:aws:secretsmanager:xxx:xxx:secret:xxx-xxx")
 *         .build()).getSecretValue();
 * UserPoolIdentityProviderGoogle provider = UserPoolIdentityProviderGoogle.Builder.create(this, "Google")
 *         .clientId("amzn-client-id")
 *         .clientSecretValue(secret)
 *         .userPool(userpool)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.855Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolIdentityProviderGoogleProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolIdentityProviderGoogleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolIdentityProviderGoogleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cognito.UserPoolIdentityProviderProps {

    /**
     * The client id recognized by Google APIs.
     * <p>
     * @see <a href="https://developers.google.com/identity/sign-in/web/sign-in#specify_your_apps_client_id">https://developers.google.com/identity/sign-in/web/sign-in#specify_your_apps_client_id</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientId();

    /**
     * (deprecated) The client secret to be accompanied with clientId for Google APIs to authenticate the client.
     * <p>
     * Default: none
     * <p>
     * @see <a href="https://developers.google.com/identity/sign-in/web/sign-in">https://developers.google.com/identity/sign-in/web/sign-in</a>
     * @deprecated use clientSecretValue instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getClientSecret() {
        return null;
    }

    /**
     * The client secret to be accompanied with clientId for Google APIs to authenticate the client as SecretValue.
     * <p>
     * Default: none
     * <p>
     * @see <a href="https://developers.google.com/identity/sign-in/web/sign-in">https://developers.google.com/identity/sign-in/web/sign-in</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.SecretValue getClientSecretValue() {
        return null;
    }

    /**
     * The list of Google permissions to obtain for getting access to the Google profile.
     * <p>
     * Default: [ profile ]
     * <p>
     * @see <a href="https://developers.google.com/identity/sign-in/web/sign-in">https://developers.google.com/identity/sign-in/web/sign-in</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getScopes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolIdentityProviderGoogleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolIdentityProviderGoogleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolIdentityProviderGoogleProps> {
        java.lang.String clientId;
        java.lang.String clientSecret;
        software.amazon.awscdk.SecretValue clientSecretValue;
        java.util.List<java.lang.String> scopes;
        software.amazon.awscdk.services.cognito.IUserPool userPool;
        software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Sets the value of {@link UserPoolIdentityProviderGoogleProps#getClientId}
         * @param clientId The client id recognized by Google APIs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderGoogleProps#getClientSecret}
         * @param clientSecret The client secret to be accompanied with clientId for Google APIs to authenticate the client.
         * @return {@code this}
         * @deprecated use clientSecretValue instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder clientSecret(java.lang.String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderGoogleProps#getClientSecretValue}
         * @param clientSecretValue The client secret to be accompanied with clientId for Google APIs to authenticate the client as SecretValue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientSecretValue(software.amazon.awscdk.SecretValue clientSecretValue) {
            this.clientSecretValue = clientSecretValue;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderGoogleProps#getScopes}
         * @param scopes The list of Google permissions to obtain for getting access to the Google profile.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopes(java.util.List<java.lang.String> scopes) {
            this.scopes = scopes;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderGoogleProps#getUserPool}
         * @param userPool The user pool to which this construct provides identities. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolIdentityProviderGoogleProps#getAttributeMapping}
         * @param attributeMapping Mapping attributes from the identity provider to standard and custom attributes of the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeMapping(software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            this.attributeMapping = attributeMapping;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolIdentityProviderGoogleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolIdentityProviderGoogleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolIdentityProviderGoogleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolIdentityProviderGoogleProps {
        private final java.lang.String clientId;
        private final java.lang.String clientSecret;
        private final software.amazon.awscdk.SecretValue clientSecretValue;
        private final java.util.List<java.lang.String> scopes;
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clientSecretValue = software.amazon.jsii.Kernel.get(this, "clientSecretValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
            this.scopes = software.amazon.jsii.Kernel.get(this, "scopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.userPool = software.amazon.jsii.Kernel.get(this, "userPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class));
            this.attributeMapping = software.amazon.jsii.Kernel.get(this, "attributeMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.AttributeMapping.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
            this.clientSecret = builder.clientSecret;
            this.clientSecretValue = builder.clientSecretValue;
            this.scopes = builder.scopes;
            this.userPool = java.util.Objects.requireNonNull(builder.userPool, "userPool is required");
            this.attributeMapping = builder.attributeMapping;
        }

        @Override
        public final java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public final java.lang.String getClientSecret() {
            return this.clientSecret;
        }

        @Override
        public final software.amazon.awscdk.SecretValue getClientSecretValue() {
            return this.clientSecretValue;
        }

        @Override
        public final java.util.List<java.lang.String> getScopes() {
            return this.scopes;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.AttributeMapping getAttributeMapping() {
            return this.attributeMapping;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientId", om.valueToTree(this.getClientId()));
            if (this.getClientSecret() != null) {
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));
            }
            if (this.getClientSecretValue() != null) {
                data.set("clientSecretValue", om.valueToTree(this.getClientSecretValue()));
            }
            if (this.getScopes() != null) {
                data.set("scopes", om.valueToTree(this.getScopes()));
            }
            data.set("userPool", om.valueToTree(this.getUserPool()));
            if (this.getAttributeMapping() != null) {
                data.set("attributeMapping", om.valueToTree(this.getAttributeMapping()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolIdentityProviderGoogleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolIdentityProviderGoogleProps.Jsii$Proxy that = (UserPoolIdentityProviderGoogleProps.Jsii$Proxy) o;

            if (!clientId.equals(that.clientId)) return false;
            if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) return false;
            if (this.clientSecretValue != null ? !this.clientSecretValue.equals(that.clientSecretValue) : that.clientSecretValue != null) return false;
            if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) return false;
            if (!userPool.equals(that.userPool)) return false;
            return this.attributeMapping != null ? this.attributeMapping.equals(that.attributeMapping) : that.attributeMapping == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientId.hashCode();
            result = 31 * result + (this.clientSecret != null ? this.clientSecret.hashCode() : 0);
            result = 31 * result + (this.clientSecretValue != null ? this.clientSecretValue.hashCode() : 0);
            result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
            result = 31 * result + (this.userPool.hashCode());
            result = 31 * result + (this.attributeMapping != null ? this.attributeMapping.hashCode() : 0);
            return result;
        }
    }
}
