package software.amazon.awscdk.services.cognito;

/**
 * The email verification style.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .selfSignUpEnabled(true)
 *         .userVerification(UserVerificationConfig.builder()
 *                 .emailSubject("Verify your email for our awesome app!")
 *                 .emailBody("Thanks for signing up to our awesome app! Your verification code is {####}")
 *                 .emailStyle(VerificationEmailStyle.CODE)
 *                 .smsMessage("Thanks for signing up to our awesome app! Your verification code is {####}")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:28.866Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.VerificationEmailStyle")
public enum VerificationEmailStyle {
    /**
     * Verify email via code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CODE,
    /**
     * Verify email via link.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LINK,
}
