package software.amazon.awscdk.services.datasync;

/**
 * The <code>AWS::DataSync::Task</code> resource specifies a task.
 * <p>
 * A task is a set of two locations (source and destination) and a set of <code>Options</code> that you use to control the behavior of a task. If you don't specify <code>Options</code> when you create a task, AWS DataSync populates them with service defaults.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.datasync.*;
 * CfnTask cfnTask = CfnTask.Builder.create(this, "MyCfnTask")
 *         .destinationLocationArn("destinationLocationArn")
 *         .sourceLocationArn("sourceLocationArn")
 *         // the properties below are optional
 *         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *         .excludes(List.of(FilterRuleProperty.builder()
 *                 .filterType("filterType")
 *                 .value("value")
 *                 .build()))
 *         .includes(List.of(FilterRuleProperty.builder()
 *                 .filterType("filterType")
 *                 .value("value")
 *                 .build()))
 *         .manifestConfig(ManifestConfigProperty.builder()
 *                 .source(SourceProperty.builder()
 *                         .s3(ManifestConfigSourceS3Property.builder()
 *                                 .bucketAccessRoleArn("bucketAccessRoleArn")
 *                                 .manifestObjectPath("manifestObjectPath")
 *                                 .manifestObjectVersionId("manifestObjectVersionId")
 *                                 .s3BucketArn("s3BucketArn")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .action("action")
 *                 .format("format")
 *                 .build())
 *         .name("name")
 *         .options(OptionsProperty.builder()
 *                 .atime("atime")
 *                 .bytesPerSecond(123)
 *                 .gid("gid")
 *                 .logLevel("logLevel")
 *                 .mtime("mtime")
 *                 .objectTags("objectTags")
 *                 .overwriteMode("overwriteMode")
 *                 .posixPermissions("posixPermissions")
 *                 .preserveDeletedFiles("preserveDeletedFiles")
 *                 .preserveDevices("preserveDevices")
 *                 .securityDescriptorCopyFlags("securityDescriptorCopyFlags")
 *                 .taskQueueing("taskQueueing")
 *                 .transferMode("transferMode")
 *                 .uid("uid")
 *                 .verifyMode("verifyMode")
 *                 .build())
 *         .schedule(TaskScheduleProperty.builder()
 *                 .scheduleExpression("scheduleExpression")
 *                 .status("status")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskMode("taskMode")
 *         .taskReportConfig(TaskReportConfigProperty.builder()
 *                 .destination(DestinationProperty.builder()
 *                         .s3(S3Property.builder()
 *                                 .bucketAccessRoleArn("bucketAccessRoleArn")
 *                                 .s3BucketArn("s3BucketArn")
 *                                 .subdirectory("subdirectory")
 *                                 .build())
 *                         .build())
 *                 .outputType("outputType")
 *                 // the properties below are optional
 *                 .objectVersionIds("objectVersionIds")
 *                 .overrides(OverridesProperty.builder()
 *                         .deleted(DeletedProperty.builder()
 *                                 .reportLevel("reportLevel")
 *                                 .build())
 *                         .skipped(SkippedProperty.builder()
 *                                 .reportLevel("reportLevel")
 *                                 .build())
 *                         .transferred(TransferredProperty.builder()
 *                                 .reportLevel("reportLevel")
 *                                 .build())
 *                         .verified(VerifiedProperty.builder()
 *                                 .reportLevel("reportLevel")
 *                                 .build())
 *                         .build())
 *                 .reportLevel("reportLevel")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:29.343Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask")
public class CfnTask extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.datasync.CfnTask.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTask(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.datasync.CfnTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARNs of the destination elastic network interfaces (ENIs) that were created for your subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrDestinationNetworkInterfaceArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrDestinationNetworkInterfaceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The ARNs of the source ENIs that were created for your subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrSourceNetworkInterfaceArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrSourceNetworkInterfaceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The status of the task that was described.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTaskArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTaskArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS storage resource's location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDestinationLocationArn() {
        return software.amazon.jsii.Kernel.get(this, "destinationLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an AWS storage resource's location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationLocationArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "destinationLocationArn", java.util.Objects.requireNonNull(value, "destinationLocationArn is required"));
    }

    /**
     * Specifies the ARN of your transfer's source location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSourceLocationArn() {
        return software.amazon.jsii.Kernel.get(this, "sourceLocationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the ARN of your transfer's source location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceLocationArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceLocationArn", java.util.Objects.requireNonNull(value, "sourceLocationArn is required"));
    }

    /**
     * Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloudWatchLogGroupArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cloudWatchLogGroupArn", value);
    }

    /**
     * Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExcludes() {
        return software.amazon.jsii.Kernel.get(this, "excludes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "excludes", value);
    }

    /**
     * Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExcludes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.datasync.CfnTask.FilterRuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.datasync.CfnTask.FilterRuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "excludes", value);
    }

    /**
     * Specifies include filters that define the files, objects, and folders in your source location that you want DataSync to transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIncludes() {
        return software.amazon.jsii.Kernel.get(this, "includes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies include filters that define the files, objects, and folders in your source location that you want DataSync to transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "includes", value);
    }

    /**
     * Specifies include filters that define the files, objects, and folders in your source location that you want DataSync to transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludes(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.datasync.CfnTask.FilterRuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.datasync.CfnTask.FilterRuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "includes", value);
    }

    /**
     * The configuration of the manifest that lists the files or objects that you want DataSync to transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getManifestConfig() {
        return software.amazon.jsii.Kernel.get(this, "manifestConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the manifest that lists the files or objects that you want DataSync to transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManifestConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "manifestConfig", value);
    }

    /**
     * The configuration of the manifest that lists the files or objects that you want DataSync to transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setManifestConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datasync.CfnTask.ManifestConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "manifestConfig", value);
    }

    /**
     * Specifies the name of your task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of your task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
        return software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "options", value);
    }

    /**
     * Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datasync.CfnTask.OptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "options", value);
    }

    /**
     * Specifies a schedule for when you want your task to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies a schedule for when you want your task to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * Specifies a schedule for when you want your task to run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datasync.CfnTask.TaskScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * Specifies the tags that you want to apply to your task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Specifies the tags that you want to apply to your task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The task mode that you're using.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTaskMode() {
        return software.amazon.jsii.Kernel.get(this, "taskMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The task mode that you're using.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "taskMode", value);
    }

    /**
     * The configuration of your task report, which provides detailed information about your DataSync transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTaskReportConfig() {
        return software.amazon.jsii.Kernel.get(this, "taskReportConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of your task report, which provides detailed information about your DataSync transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskReportConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "taskReportConfig", value);
    }

    /**
     * The configuration of your task report, which provides detailed information about your DataSync transfer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskReportConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.datasync.CfnTask.TaskReportConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "taskReportConfig", value);
    }
    /**
     * Specifies the level of reporting for the files, objects, and directories that Datasync attempted to delete in your destination location.
     * <p>
     * This only applies if you configure your task to delete data in the destination that isn't in the source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * DeletedProperty deletedProperty = DeletedProperty.builder()
     *         .reportLevel("reportLevel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-deleted.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-deleted.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.DeletedProperty")
    @software.amazon.jsii.Jsii.Proxy(DeletedProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeletedProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-deleted.html#cfn-datasync-task-deleted-reportlevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-deleted.html#cfn-datasync-task-deleted-reportlevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReportLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeletedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeletedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeletedProperty> {
            java.lang.String reportLevel;

            /**
             * Sets the value of {@link DeletedProperty#getReportLevel}
             * @param reportLevel Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportLevel(java.lang.String reportLevel) {
                this.reportLevel = reportLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeletedProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeletedProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeletedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeletedProperty {
            private final java.lang.String reportLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reportLevel = software.amazon.jsii.Kernel.get(this, "reportLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reportLevel = builder.reportLevel;
            }

            @Override
            public final java.lang.String getReportLevel() {
                return this.reportLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReportLevel() != null) {
                    data.set("reportLevel", om.valueToTree(this.getReportLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.DeletedProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeletedProperty.Jsii$Proxy that = (DeletedProperty.Jsii$Proxy) o;

                return this.reportLevel != null ? this.reportLevel.equals(that.reportLevel) : that.reportLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.reportLevel != null ? this.reportLevel.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies where DataSync uploads your task report.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * DestinationProperty destinationProperty = DestinationProperty.builder()
     *         .s3(S3Property.builder()
     *                 .bucketAccessRoleArn("bucketAccessRoleArn")
     *                 .s3BucketArn("s3BucketArn")
     *                 .subdirectory("subdirectory")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-destination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-destination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.DestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the Amazon S3 bucket where DataSync uploads your task report.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-destination.html#cfn-datasync-task-destination-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-destination.html#cfn-datasync-task-destination-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationProperty> {
            java.lang.Object s3;

            /**
             * Sets the value of {@link DestinationProperty#getS3}
             * @param s3 Specifies the Amazon S3 bucket where DataSync uploads your task report.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link DestinationProperty#getS3}
             * @param s3 Specifies the Amazon S3 bucket where DataSync uploads your task report.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.datasync.CfnTask.S3Property s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationProperty {
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.DestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationProperty.Jsii$Proxy that = (DestinationProperty.Jsii$Proxy) o;

                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3 != null ? this.s3.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies which files, folders, and objects to include or exclude when transferring files from source to destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * FilterRuleProperty filterRuleProperty = FilterRuleProperty.builder()
     *         .filterType("filterType")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-filterrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-filterrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.FilterRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(FilterRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FilterRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of filter rule to apply.
         * <p>
         * AWS DataSync only supports the SIMPLE_PATTERN rule type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-filterrule.html#cfn-datasync-task-filterrule-filtertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-filterrule.html#cfn-datasync-task-filterrule-filtertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFilterType() {
            return null;
        }

        /**
         * A single filter string that consists of the patterns to include or exclude.
         * <p>
         * The patterns are delimited by "|" (that is, a pipe), for example: <code>/folder1|/folder2</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-filterrule.html#cfn-datasync-task-filterrule-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-filterrule.html#cfn-datasync-task-filterrule-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FilterRuleProperty> {
            java.lang.String filterType;
            java.lang.String value;

            /**
             * Sets the value of {@link FilterRuleProperty#getFilterType}
             * @param filterType The type of filter rule to apply.
             *                   AWS DataSync only supports the SIMPLE_PATTERN rule type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filterType(java.lang.String filterType) {
                this.filterType = filterType;
                return this;
            }

            /**
             * Sets the value of {@link FilterRuleProperty#getValue}
             * @param value A single filter string that consists of the patterns to include or exclude.
             *              The patterns are delimited by "|" (that is, a pipe), for example: <code>/folder1|/folder2</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FilterRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FilterRuleProperty {
            private final java.lang.String filterType;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filterType = software.amazon.jsii.Kernel.get(this, "filterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filterType = builder.filterType;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getFilterType() {
                return this.filterType;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFilterType() != null) {
                    data.set("filterType", om.valueToTree(this.getFilterType()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.FilterRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FilterRuleProperty.Jsii$Proxy that = (FilterRuleProperty.Jsii$Proxy) o;

                if (this.filterType != null ? !this.filterType.equals(that.filterType) : that.filterType != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.filterType != null ? this.filterType.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures a manifest, which is a list of files or objects that you want AWS DataSync to transfer.
     * <p>
     * For more information and configuration examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * ManifestConfigProperty manifestConfigProperty = ManifestConfigProperty.builder()
     *         .source(SourceProperty.builder()
     *                 .s3(ManifestConfigSourceS3Property.builder()
     *                         .bucketAccessRoleArn("bucketAccessRoleArn")
     *                         .manifestObjectPath("manifestObjectPath")
     *                         .manifestObjectVersionId("manifestObjectVersionId")
     *                         .s3BucketArn("s3BucketArn")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .action("action")
     *         .format("format")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.ManifestConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ManifestConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManifestConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the manifest that you want DataSync to use and where it's hosted.
         * <p>
         * <blockquote>
         * <p>
         * You must specify this parameter if you're configuring a new manifest on or after February 7, 2024.
         * <p>
         * If you don't, you'll get a 400 status code and <code>ValidationException</code> error stating that you're missing the IAM role for DataSync to access the S3 bucket where you're hosting your manifest. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access">Providing DataSync access to your manifest</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfig.html#cfn-datasync-task-manifestconfig-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfig.html#cfn-datasync-task-manifestconfig-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSource();

        /**
         * Specifies what DataSync uses the manifest for.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfig.html#cfn-datasync-task-manifestconfig-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfig.html#cfn-datasync-task-manifestconfig-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
            return null;
        }

        /**
         * Specifies the file format of your manifest.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create">Creating a manifest</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfig.html#cfn-datasync-task-manifestconfig-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfig.html#cfn-datasync-task-manifestconfig-format</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManifestConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManifestConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManifestConfigProperty> {
            java.lang.Object source;
            java.lang.String action;
            java.lang.String format;

            /**
             * Sets the value of {@link ManifestConfigProperty#getSource}
             * @param source Specifies the manifest that you want DataSync to use and where it's hosted. This parameter is required.
             *               <blockquote>
             *               <p>
             *               You must specify this parameter if you're configuring a new manifest on or after February 7, 2024.
             *               <p>
             *               If you don't, you'll get a 400 status code and <code>ValidationException</code> error stating that you're missing the IAM role for DataSync to access the S3 bucket where you're hosting your manifest. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access">Providing DataSync access to your manifest</a> .
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.IResolvable source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link ManifestConfigProperty#getSource}
             * @param source Specifies the manifest that you want DataSync to use and where it's hosted. This parameter is required.
             *               <blockquote>
             *               <p>
             *               You must specify this parameter if you're configuring a new manifest on or after February 7, 2024.
             *               <p>
             *               If you don't, you'll get a 400 status code and <code>ValidationException</code> error stating that you're missing the IAM role for DataSync to access the S3 bucket where you're hosting your manifest. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access">Providing DataSync access to your manifest</a> .
             *               <p>
             *               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(software.amazon.awscdk.services.datasync.CfnTask.SourceProperty source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link ManifestConfigProperty#getAction}
             * @param action Specifies what DataSync uses the manifest for.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link ManifestConfigProperty#getFormat}
             * @param format Specifies the file format of your manifest.
             *               For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create">Creating a manifest</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManifestConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManifestConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManifestConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManifestConfigProperty {
            private final java.lang.Object source;
            private final java.lang.String action;
            private final java.lang.String format;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.action = builder.action;
                this.format = builder.format;
            }

            @Override
            public final java.lang.Object getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("source", om.valueToTree(this.getSource()));
                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }
                if (this.getFormat() != null) {
                    data.set("format", om.valueToTree(this.getFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.ManifestConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManifestConfigProperty.Jsii$Proxy that = (ManifestConfigProperty.Jsii$Proxy) o;

                if (!source.equals(that.source)) return false;
                if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
                return this.format != null ? this.format.equals(that.format) : that.format == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source.hashCode();
                result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
                result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the S3 bucket where you're hosting the manifest that you want AWS DataSync to use.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * ManifestConfigSourceS3Property manifestConfigSourceS3Property = ManifestConfigSourceS3Property.builder()
     *         .bucketAccessRoleArn("bucketAccessRoleArn")
     *         .manifestObjectPath("manifestObjectPath")
     *         .manifestObjectVersionId("manifestObjectVersionId")
     *         .s3BucketArn("s3BucketArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfigsources3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfigsources3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.ManifestConfigSourceS3Property")
    @software.amazon.jsii.Jsii.Proxy(ManifestConfigSourceS3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManifestConfigSourceS3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the AWS Identity and Access Management (IAM) role that allows DataSync to access your manifest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfigsources3.html#cfn-datasync-task-manifestconfigsources3-bucketaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfigsources3.html#cfn-datasync-task-manifestconfigsources3-bucketaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketAccessRoleArn() {
            return null;
        }

        /**
         * Specifies the Amazon S3 object key of your manifest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfigsources3.html#cfn-datasync-task-manifestconfigsources3-manifestobjectpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfigsources3.html#cfn-datasync-task-manifestconfigsources3-manifestobjectpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestObjectPath() {
            return null;
        }

        /**
         * Specifies the object version ID of the manifest that you want DataSync to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfigsources3.html#cfn-datasync-task-manifestconfigsources3-manifestobjectversionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfigsources3.html#cfn-datasync-task-manifestconfigsources3-manifestobjectversionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestObjectVersionId() {
            return null;
        }

        /**
         * Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfigsources3.html#cfn-datasync-task-manifestconfigsources3-s3bucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-manifestconfigsources3.html#cfn-datasync-task-manifestconfigsources3-s3bucketarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManifestConfigSourceS3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManifestConfigSourceS3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManifestConfigSourceS3Property> {
            java.lang.String bucketAccessRoleArn;
            java.lang.String manifestObjectPath;
            java.lang.String manifestObjectVersionId;
            java.lang.String s3BucketArn;

            /**
             * Sets the value of {@link ManifestConfigSourceS3Property#getBucketAccessRoleArn}
             * @param bucketAccessRoleArn Specifies the AWS Identity and Access Management (IAM) role that allows DataSync to access your manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketAccessRoleArn(java.lang.String bucketAccessRoleArn) {
                this.bucketAccessRoleArn = bucketAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link ManifestConfigSourceS3Property#getManifestObjectPath}
             * @param manifestObjectPath Specifies the Amazon S3 object key of your manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestObjectPath(java.lang.String manifestObjectPath) {
                this.manifestObjectPath = manifestObjectPath;
                return this;
            }

            /**
             * Sets the value of {@link ManifestConfigSourceS3Property#getManifestObjectVersionId}
             * @param manifestObjectVersionId Specifies the object version ID of the manifest that you want DataSync to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestObjectVersionId(java.lang.String manifestObjectVersionId) {
                this.manifestObjectVersionId = manifestObjectVersionId;
                return this;
            }

            /**
             * Sets the value of {@link ManifestConfigSourceS3Property#getS3BucketArn}
             * @param s3BucketArn Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketArn(java.lang.String s3BucketArn) {
                this.s3BucketArn = s3BucketArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManifestConfigSourceS3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManifestConfigSourceS3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManifestConfigSourceS3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManifestConfigSourceS3Property {
            private final java.lang.String bucketAccessRoleArn;
            private final java.lang.String manifestObjectPath;
            private final java.lang.String manifestObjectVersionId;
            private final java.lang.String s3BucketArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketAccessRoleArn = software.amazon.jsii.Kernel.get(this, "bucketAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.manifestObjectPath = software.amazon.jsii.Kernel.get(this, "manifestObjectPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.manifestObjectVersionId = software.amazon.jsii.Kernel.get(this, "manifestObjectVersionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketArn = software.amazon.jsii.Kernel.get(this, "s3BucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketAccessRoleArn = builder.bucketAccessRoleArn;
                this.manifestObjectPath = builder.manifestObjectPath;
                this.manifestObjectVersionId = builder.manifestObjectVersionId;
                this.s3BucketArn = builder.s3BucketArn;
            }

            @Override
            public final java.lang.String getBucketAccessRoleArn() {
                return this.bucketAccessRoleArn;
            }

            @Override
            public final java.lang.String getManifestObjectPath() {
                return this.manifestObjectPath;
            }

            @Override
            public final java.lang.String getManifestObjectVersionId() {
                return this.manifestObjectVersionId;
            }

            @Override
            public final java.lang.String getS3BucketArn() {
                return this.s3BucketArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketAccessRoleArn() != null) {
                    data.set("bucketAccessRoleArn", om.valueToTree(this.getBucketAccessRoleArn()));
                }
                if (this.getManifestObjectPath() != null) {
                    data.set("manifestObjectPath", om.valueToTree(this.getManifestObjectPath()));
                }
                if (this.getManifestObjectVersionId() != null) {
                    data.set("manifestObjectVersionId", om.valueToTree(this.getManifestObjectVersionId()));
                }
                if (this.getS3BucketArn() != null) {
                    data.set("s3BucketArn", om.valueToTree(this.getS3BucketArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.ManifestConfigSourceS3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManifestConfigSourceS3Property.Jsii$Proxy that = (ManifestConfigSourceS3Property.Jsii$Proxy) o;

                if (this.bucketAccessRoleArn != null ? !this.bucketAccessRoleArn.equals(that.bucketAccessRoleArn) : that.bucketAccessRoleArn != null) return false;
                if (this.manifestObjectPath != null ? !this.manifestObjectPath.equals(that.manifestObjectPath) : that.manifestObjectPath != null) return false;
                if (this.manifestObjectVersionId != null ? !this.manifestObjectVersionId.equals(that.manifestObjectVersionId) : that.manifestObjectVersionId != null) return false;
                return this.s3BucketArn != null ? this.s3BucketArn.equals(that.s3BucketArn) : that.s3BucketArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketAccessRoleArn != null ? this.bucketAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.manifestObjectPath != null ? this.manifestObjectPath.hashCode() : 0);
                result = 31 * result + (this.manifestObjectVersionId != null ? this.manifestObjectVersionId.hashCode() : 0);
                result = 31 * result + (this.s3BucketArn != null ? this.s3BucketArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents the options that are available to control the behavior of a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> operation. This behavior includes preserving metadata, such as user ID (UID), group ID (GID), and file permissions; overwriting files in the destination; data integrity verification; and so on.
     * <p>
     * A task has a set of default options associated with it. If you don't specify an option in <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> , the default value is used. You can override the default options on each task execution by specifying an overriding <code>Options</code> value to <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html">StartTaskExecution</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * OptionsProperty optionsProperty = OptionsProperty.builder()
     *         .atime("atime")
     *         .bytesPerSecond(123)
     *         .gid("gid")
     *         .logLevel("logLevel")
     *         .mtime("mtime")
     *         .objectTags("objectTags")
     *         .overwriteMode("overwriteMode")
     *         .posixPermissions("posixPermissions")
     *         .preserveDeletedFiles("preserveDeletedFiles")
     *         .preserveDevices("preserveDevices")
     *         .securityDescriptorCopyFlags("securityDescriptorCopyFlags")
     *         .taskQueueing("taskQueueing")
     *         .transferMode("transferMode")
     *         .uid("uid")
     *         .verifyMode("verifyMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.OptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(OptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A file metadata value that shows the last time that a file was accessed (that is, when the file was read or written to).
         * <p>
         * If you set <code>Atime</code> to <code>BEST_EFFORT</code> , AWS DataSync attempts to preserve the original <code>Atime</code> attribute on all source files (that is, the version before the PREPARING phase). However, <code>Atime</code> 's behavior is not fully standard across platforms, so AWS DataSync can only do this on a best-effort basis.
         * <p>
         * Default value: <code>BEST_EFFORT</code>
         * <p>
         * <code>BEST_EFFORT</code> : Attempt to preserve the per-file <code>Atime</code> value (recommended).
         * <p>
         * <code>NONE</code> : Ignore <code>Atime</code> .
         * <p>
         * <blockquote>
         * <p>
         * If <code>Atime</code> is set to <code>BEST_EFFORT</code> , <code>Mtime</code> must be set to <code>PRESERVE</code> .
         * <p>
         * If <code>Atime</code> is set to <code>NONE</code> , <code>Mtime</code> must also be <code>NONE</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-atime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-atime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAtime() {
            return null;
        }

        /**
         * A value that limits the bandwidth used by AWS DataSync .
         * <p>
         * For example, if you want AWS DataSync to use a maximum of 1 MB, set this value to <code>1048576</code> (=1024*1024).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-bytespersecond">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-bytespersecond</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBytesPerSecond() {
            return null;
        }

        /**
         * The group ID (GID) of the file's owners.
         * <p>
         * Default value: <code>INT_VALUE</code>
         * <p>
         * <code>INT_VALUE</code> : Preserve the integer value of the user ID (UID) and group ID (GID) (recommended).
         * <p>
         * <code>NAME</code> : Currently not supported.
         * <p>
         * <code>NONE</code> : Ignore the UID and GID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-gid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-gid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGid() {
            return null;
        }

        /**
         * Specifies the type of logs that DataSync publishes to a Amazon CloudWatch Logs log group.
         * <p>
         * To specify the log group, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a> .
         * <p>
         * <ul>
         * <li><code>BASIC</code> - Publishes logs with only basic information (such as transfer errors).</li>
         * <li><code>TRANSFER</code> - Publishes logs for all files or objects that your DataSync task transfers and performs data-integrity checks on.</li>
         * <li><code>OFF</code> - No logs are published.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-loglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-loglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogLevel() {
            return null;
        }

        /**
         * A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase.
         * <p>
         * This option is required for cases when you need to run the same task more than one time.
         * <p>
         * Default value: <code>PRESERVE</code>
         * <p>
         * <code>PRESERVE</code> : Preserve original <code>Mtime</code> (recommended)
         * <p>
         * <code>NONE</code> : Ignore <code>Mtime</code> .
         * <p>
         * <blockquote>
         * <p>
         * If <code>Mtime</code> is set to <code>PRESERVE</code> , <code>Atime</code> must be set to <code>BEST_EFFORT</code> .
         * <p>
         * If <code>Mtime</code> is set to <code>NONE</code> , <code>Atime</code> must also be set to <code>NONE</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-mtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-mtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMtime() {
            return null;
        }

        /**
         * Specifies whether you want DataSync to <code>PRESERVE</code> object tags (default behavior) when transferring between object storage systems.
         * <p>
         * If you want your DataSync task to ignore object tags, specify the <code>NONE</code> value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-objecttags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-objecttags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectTags() {
            return null;
        }

        /**
         * Specifies whether DataSync should modify or preserve data at the destination location.
         * <p>
         * <ul>
         * <li><code>ALWAYS</code> (default) - DataSync modifies data in the destination location when source data (including metadata) has changed.</li>
         * </ul>
         * <p>
         * If DataSync overwrites objects, you might incur additional charges for certain Amazon S3 storage classes (for example, for retrieval or early deletion). For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Storage class considerations with Amazon S3 transfers</a> .
         * <p>
         * <ul>
         * <li><code>NEVER</code> - DataSync doesn't overwrite data in the destination location even if the source data has changed. You can use this option to protect against overwriting changes made to files or objects in the destination.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-overwritemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-overwritemode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOverwriteMode() {
            return null;
        }

        /**
         * A value that determines which users or groups can access a file for a specific purpose, such as reading, writing, or execution of the file.
         * <p>
         * This option should be set only for Network File System (NFS), Amazon EFS, and Amazon S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a> .
         * <p>
         * Default value: <code>PRESERVE</code>
         * <p>
         * <code>PRESERVE</code> : Preserve POSIX-style permissions (recommended).
         * <p>
         * <code>NONE</code> : Ignore permissions.
         * <p>
         * <blockquote>
         * <p>
         * AWS DataSync can preserve extant permissions of a source location.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-posixpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-posixpermissions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPosixPermissions() {
            return null;
        }

        /**
         * A value that specifies whether files in the destination that don't exist in the source file system are preserved.
         * <p>
         * This option can affect your storage costs. If your task deletes objects, you might incur minimum storage duration charges for certain storage classes. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync</a> in the <em>AWS DataSync User Guide</em> .
         * <p>
         * Default value: <code>PRESERVE</code>
         * <p>
         * <code>PRESERVE</code> : Ignore destination files that aren't present in the source (recommended).
         * <p>
         * <code>REMOVE</code> : Delete destination files that aren't present in the source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-preservedeletedfiles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-preservedeletedfiles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreserveDeletedFiles() {
            return null;
        }

        /**
         * A value that determines whether AWS DataSync should preserve the metadata of block and character devices in the source file system, and re-create the files with that device name and metadata on the destination.
         * <p>
         * DataSync does not copy the contents of such devices, only the name and metadata.
         * <p>
         * <blockquote>
         * <p>
         * AWS DataSync can't sync the actual contents of such devices, because they are nonterminal and don't return an end-of-file (EOF) marker.
         * <p>
         * </blockquote>
         * <p>
         * Default value: <code>NONE</code>
         * <p>
         * <code>NONE</code> : Ignore special devices (recommended).
         * <p>
         * <code>PRESERVE</code> : Preserve character and block device metadata. This option isn't currently supported for Amazon EFS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-preservedevices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-preservedevices</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreserveDevices() {
            return null;
        }

        /**
         * A value that determines which components of the SMB security descriptor are copied from source to destination objects.
         * <p>
         * This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. For more information about how DataSync handles metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How DataSync Handles Metadata and Special Files</a> .
         * <p>
         * Default value: <code>OWNER_DACL</code>
         * <p>
         * <code>OWNER_DACL</code> : For each copied object, DataSync copies the following metadata:
         * <p>
         * <ul>
         * <li>Object owner.</li>
         * <li>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</li>
         * </ul>
         * <p>
         * When you use option, DataSync does NOT copy the NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.
         * <p>
         * <code>OWNER_DACL_SACL</code> : For each copied object, DataSync copies the following metadata:
         * <p>
         * <ul>
         * <li>Object owner.</li>
         * <li>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</li>
         * <li>NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</li>
         * </ul>
         * <p>
         * Copying SACLs requires granting additional permissions to the Windows user that DataSync uses to access your SMB location. For information about choosing a user that ensures sufficient permissions to files, folders, and metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#SMBuser">user</a> .
         * <p>
         * <code>NONE</code> : None of the SMB security descriptor components are copied. Destination objects are owned by the user that was provided for accessing the destination location. DACLs and SACLs are set based on the destination server’s configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-securitydescriptorcopyflags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-securitydescriptorcopyflags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecurityDescriptorCopyFlags() {
            return null;
        }

        /**
         * Specifies whether your transfer tasks should be put into a queue during certain scenarios when <a href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#running-multiple-tasks">running multiple tasks</a> . This is <code>ENABLED</code> by default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-taskqueueing">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-taskqueueing</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTaskQueueing() {
            return null;
        }

        /**
         * A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing it to the destination location.
         * <p>
         * <code>CHANGED</code> : DataSync copies only data or metadata that is new or different from the source location to the destination location.
         * <p>
         * <code>ALL</code> : DataSync copies all source location content to the destination, without comparing it to existing content on the destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-transfermode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-transfermode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransferMode() {
            return null;
        }

        /**
         * The user ID (UID) of the file's owner.
         * <p>
         * Default value: <code>INT_VALUE</code>
         * <p>
         * <code>INT_VALUE</code> : Preserve the integer value of the UID and group ID (GID) (recommended).
         * <p>
         * <code>NAME</code> : Currently not supported
         * <p>
         * <code>NONE</code> : Ignore the UID and GID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-uid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-uid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUid() {
            return null;
        }

        /**
         * A value that determines whether a data integrity verification is performed at the end of a task execution after all data and metadata have been transferred.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure task settings</a> .
         * <p>
         * Default value: <code>POINT_IN_TIME_CONSISTENT</code>
         * <p>
         * <code>ONLY_FILES_TRANSFERRED</code> (recommended): Perform verification only on files that were transferred.
         * <p>
         * <code>POINT_IN_TIME_CONSISTENT</code> : Scan the entire source and entire destination at the end of the transfer to verify that the source and destination are fully synchronized. This option isn't supported when transferring to S3 Glacier or S3 Glacier Deep Archive storage classes.
         * <p>
         * <code>NONE</code> : No additional verification is done at the end of the transfer, but all data transmissions are integrity-checked with checksum verification during the transfer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-verifymode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-options.html#cfn-datasync-task-options-verifymode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVerifyMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OptionsProperty> {
            java.lang.String atime;
            java.lang.Number bytesPerSecond;
            java.lang.String gid;
            java.lang.String logLevel;
            java.lang.String mtime;
            java.lang.String objectTags;
            java.lang.String overwriteMode;
            java.lang.String posixPermissions;
            java.lang.String preserveDeletedFiles;
            java.lang.String preserveDevices;
            java.lang.String securityDescriptorCopyFlags;
            java.lang.String taskQueueing;
            java.lang.String transferMode;
            java.lang.String uid;
            java.lang.String verifyMode;

            /**
             * Sets the value of {@link OptionsProperty#getAtime}
             * @param atime A file metadata value that shows the last time that a file was accessed (that is, when the file was read or written to).
             *              If you set <code>Atime</code> to <code>BEST_EFFORT</code> , AWS DataSync attempts to preserve the original <code>Atime</code> attribute on all source files (that is, the version before the PREPARING phase). However, <code>Atime</code> 's behavior is not fully standard across platforms, so AWS DataSync can only do this on a best-effort basis.
             *              <p>
             *              Default value: <code>BEST_EFFORT</code>
             *              <p>
             *              <code>BEST_EFFORT</code> : Attempt to preserve the per-file <code>Atime</code> value (recommended).
             *              <p>
             *              <code>NONE</code> : Ignore <code>Atime</code> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              If <code>Atime</code> is set to <code>BEST_EFFORT</code> , <code>Mtime</code> must be set to <code>PRESERVE</code> .
             *              <p>
             *              If <code>Atime</code> is set to <code>NONE</code> , <code>Mtime</code> must also be <code>NONE</code> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder atime(java.lang.String atime) {
                this.atime = atime;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getBytesPerSecond}
             * @param bytesPerSecond A value that limits the bandwidth used by AWS DataSync .
             *                       For example, if you want AWS DataSync to use a maximum of 1 MB, set this value to <code>1048576</code> (=1024*1024).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bytesPerSecond(java.lang.Number bytesPerSecond) {
                this.bytesPerSecond = bytesPerSecond;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getGid}
             * @param gid The group ID (GID) of the file's owners.
             *            Default value: <code>INT_VALUE</code>
             *            <p>
             *            <code>INT_VALUE</code> : Preserve the integer value of the user ID (UID) and group ID (GID) (recommended).
             *            <p>
             *            <code>NAME</code> : Currently not supported.
             *            <p>
             *            <code>NONE</code> : Ignore the UID and GID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gid(java.lang.String gid) {
                this.gid = gid;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getLogLevel}
             * @param logLevel Specifies the type of logs that DataSync publishes to a Amazon CloudWatch Logs log group.
             *                 To specify the log group, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn">CloudWatchLogGroupArn</a> .
             *                 <p>
             *                 <ul>
             *                 <li><code>BASIC</code> - Publishes logs with only basic information (such as transfer errors).</li>
             *                 <li><code>TRANSFER</code> - Publishes logs for all files or objects that your DataSync task transfers and performs data-integrity checks on.</li>
             *                 <li><code>OFF</code> - No logs are published.</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logLevel(java.lang.String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getMtime}
             * @param mtime A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase.
             *              This option is required for cases when you need to run the same task more than one time.
             *              <p>
             *              Default value: <code>PRESERVE</code>
             *              <p>
             *              <code>PRESERVE</code> : Preserve original <code>Mtime</code> (recommended)
             *              <p>
             *              <code>NONE</code> : Ignore <code>Mtime</code> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              If <code>Mtime</code> is set to <code>PRESERVE</code> , <code>Atime</code> must be set to <code>BEST_EFFORT</code> .
             *              <p>
             *              If <code>Mtime</code> is set to <code>NONE</code> , <code>Atime</code> must also be set to <code>NONE</code> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mtime(java.lang.String mtime) {
                this.mtime = mtime;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getObjectTags}
             * @param objectTags Specifies whether you want DataSync to <code>PRESERVE</code> object tags (default behavior) when transferring between object storage systems.
             *                   If you want your DataSync task to ignore object tags, specify the <code>NONE</code> value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectTags(java.lang.String objectTags) {
                this.objectTags = objectTags;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getOverwriteMode}
             * @param overwriteMode Specifies whether DataSync should modify or preserve data at the destination location.
             *                      <ul>
             *                      <li><code>ALWAYS</code> (default) - DataSync modifies data in the destination location when source data (including metadata) has changed.</li>
             *                      </ul>
             *                      <p>
             *                      If DataSync overwrites objects, you might incur additional charges for certain Amazon S3 storage classes (for example, for retrieval or early deletion). For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Storage class considerations with Amazon S3 transfers</a> .
             *                      <p>
             *                      <ul>
             *                      <li><code>NEVER</code> - DataSync doesn't overwrite data in the destination location even if the source data has changed. You can use this option to protect against overwriting changes made to files or objects in the destination.</li>
             *                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteMode(java.lang.String overwriteMode) {
                this.overwriteMode = overwriteMode;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getPosixPermissions}
             * @param posixPermissions A value that determines which users or groups can access a file for a specific purpose, such as reading, writing, or execution of the file.
             *                         This option should be set only for Network File System (NFS), Amazon EFS, and Amazon S3 locations. For more information about what metadata is copied by DataSync, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied">Metadata Copied by DataSync</a> .
             *                         <p>
             *                         Default value: <code>PRESERVE</code>
             *                         <p>
             *                         <code>PRESERVE</code> : Preserve POSIX-style permissions (recommended).
             *                         <p>
             *                         <code>NONE</code> : Ignore permissions.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         AWS DataSync can preserve extant permissions of a source location.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder posixPermissions(java.lang.String posixPermissions) {
                this.posixPermissions = posixPermissions;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getPreserveDeletedFiles}
             * @param preserveDeletedFiles A value that specifies whether files in the destination that don't exist in the source file system are preserved.
             *                             This option can affect your storage costs. If your task deletes objects, you might incur minimum storage duration charges for certain storage classes. For detailed information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes">Considerations when working with Amazon S3 storage classes in DataSync</a> in the <em>AWS DataSync User Guide</em> .
             *                             <p>
             *                             Default value: <code>PRESERVE</code>
             *                             <p>
             *                             <code>PRESERVE</code> : Ignore destination files that aren't present in the source (recommended).
             *                             <p>
             *                             <code>REMOVE</code> : Delete destination files that aren't present in the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveDeletedFiles(java.lang.String preserveDeletedFiles) {
                this.preserveDeletedFiles = preserveDeletedFiles;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getPreserveDevices}
             * @param preserveDevices A value that determines whether AWS DataSync should preserve the metadata of block and character devices in the source file system, and re-create the files with that device name and metadata on the destination.
             *                        DataSync does not copy the contents of such devices, only the name and metadata.
             *                        <p>
             *                        <blockquote>
             *                        <p>
             *                        AWS DataSync can't sync the actual contents of such devices, because they are nonterminal and don't return an end-of-file (EOF) marker.
             *                        <p>
             *                        </blockquote>
             *                        <p>
             *                        Default value: <code>NONE</code>
             *                        <p>
             *                        <code>NONE</code> : Ignore special devices (recommended).
             *                        <p>
             *                        <code>PRESERVE</code> : Preserve character and block device metadata. This option isn't currently supported for Amazon EFS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveDevices(java.lang.String preserveDevices) {
                this.preserveDevices = preserveDevices;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getSecurityDescriptorCopyFlags}
             * @param securityDescriptorCopyFlags A value that determines which components of the SMB security descriptor are copied from source to destination objects.
             *                                    This value is only used for transfers between SMB and Amazon FSx for Windows File Server locations, or between two Amazon FSx for Windows File Server locations. For more information about how DataSync handles metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html">How DataSync Handles Metadata and Special Files</a> .
             *                                    <p>
             *                                    Default value: <code>OWNER_DACL</code>
             *                                    <p>
             *                                    <code>OWNER_DACL</code> : For each copied object, DataSync copies the following metadata:
             *                                    <p>
             *                                    <ul>
             *                                    <li>Object owner.</li>
             *                                    <li>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</li>
             *                                    </ul>
             *                                    <p>
             *                                    When you use option, DataSync does NOT copy the NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.
             *                                    <p>
             *                                    <code>OWNER_DACL_SACL</code> : For each copied object, DataSync copies the following metadata:
             *                                    <p>
             *                                    <ul>
             *                                    <li>Object owner.</li>
             *                                    <li>NTFS discretionary access control lists (DACLs), which determine whether to grant access to an object.</li>
             *                                    <li>NTFS system access control lists (SACLs), which are used by administrators to log attempts to access a secured object.</li>
             *                                    </ul>
             *                                    <p>
             *                                    Copying SACLs requires granting additional permissions to the Windows user that DataSync uses to access your SMB location. For information about choosing a user that ensures sufficient permissions to files, folders, and metadata, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#SMBuser">user</a> .
             *                                    <p>
             *                                    <code>NONE</code> : None of the SMB security descriptor components are copied. Destination objects are owned by the user that was provided for accessing the destination location. DACLs and SACLs are set based on the destination server’s configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityDescriptorCopyFlags(java.lang.String securityDescriptorCopyFlags) {
                this.securityDescriptorCopyFlags = securityDescriptorCopyFlags;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getTaskQueueing}
             * @param taskQueueing Specifies whether your transfer tasks should be put into a queue during certain scenarios when <a href="https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#running-multiple-tasks">running multiple tasks</a> . This is <code>ENABLED</code> by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskQueueing(java.lang.String taskQueueing) {
                this.taskQueueing = taskQueueing;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getTransferMode}
             * @param transferMode A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing it to the destination location.
             *                     <code>CHANGED</code> : DataSync copies only data or metadata that is new or different from the source location to the destination location.
             *                     <p>
             *                     <code>ALL</code> : DataSync copies all source location content to the destination, without comparing it to existing content on the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transferMode(java.lang.String transferMode) {
                this.transferMode = transferMode;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getUid}
             * @param uid The user ID (UID) of the file's owner.
             *            Default value: <code>INT_VALUE</code>
             *            <p>
             *            <code>INT_VALUE</code> : Preserve the integer value of the UID and group ID (GID) (recommended).
             *            <p>
             *            <code>NAME</code> : Currently not supported
             *            <p>
             *            <code>NONE</code> : Ignore the UID and GID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uid(java.lang.String uid) {
                this.uid = uid;
                return this;
            }

            /**
             * Sets the value of {@link OptionsProperty#getVerifyMode}
             * @param verifyMode A value that determines whether a data integrity verification is performed at the end of a task execution after all data and metadata have been transferred.
             *                   For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/create-task.html">Configure task settings</a> .
             *                   <p>
             *                   Default value: <code>POINT_IN_TIME_CONSISTENT</code>
             *                   <p>
             *                   <code>ONLY_FILES_TRANSFERRED</code> (recommended): Perform verification only on files that were transferred.
             *                   <p>
             *                   <code>POINT_IN_TIME_CONSISTENT</code> : Scan the entire source and entire destination at the end of the transfer to verify that the source and destination are fully synchronized. This option isn't supported when transferring to S3 Glacier or S3 Glacier Deep Archive storage classes.
             *                   <p>
             *                   <code>NONE</code> : No additional verification is done at the end of the transfer, but all data transmissions are integrity-checked with checksum verification during the transfer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verifyMode(java.lang.String verifyMode) {
                this.verifyMode = verifyMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OptionsProperty {
            private final java.lang.String atime;
            private final java.lang.Number bytesPerSecond;
            private final java.lang.String gid;
            private final java.lang.String logLevel;
            private final java.lang.String mtime;
            private final java.lang.String objectTags;
            private final java.lang.String overwriteMode;
            private final java.lang.String posixPermissions;
            private final java.lang.String preserveDeletedFiles;
            private final java.lang.String preserveDevices;
            private final java.lang.String securityDescriptorCopyFlags;
            private final java.lang.String taskQueueing;
            private final java.lang.String transferMode;
            private final java.lang.String uid;
            private final java.lang.String verifyMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.atime = software.amazon.jsii.Kernel.get(this, "atime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bytesPerSecond = software.amazon.jsii.Kernel.get(this, "bytesPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.gid = software.amazon.jsii.Kernel.get(this, "gid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mtime = software.amazon.jsii.Kernel.get(this, "mtime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectTags = software.amazon.jsii.Kernel.get(this, "objectTags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overwriteMode = software.amazon.jsii.Kernel.get(this, "overwriteMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.posixPermissions = software.amazon.jsii.Kernel.get(this, "posixPermissions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preserveDeletedFiles = software.amazon.jsii.Kernel.get(this, "preserveDeletedFiles", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.preserveDevices = software.amazon.jsii.Kernel.get(this, "preserveDevices", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityDescriptorCopyFlags = software.amazon.jsii.Kernel.get(this, "securityDescriptorCopyFlags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.taskQueueing = software.amazon.jsii.Kernel.get(this, "taskQueueing", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transferMode = software.amazon.jsii.Kernel.get(this, "transferMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.uid = software.amazon.jsii.Kernel.get(this, "uid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.verifyMode = software.amazon.jsii.Kernel.get(this, "verifyMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.atime = builder.atime;
                this.bytesPerSecond = builder.bytesPerSecond;
                this.gid = builder.gid;
                this.logLevel = builder.logLevel;
                this.mtime = builder.mtime;
                this.objectTags = builder.objectTags;
                this.overwriteMode = builder.overwriteMode;
                this.posixPermissions = builder.posixPermissions;
                this.preserveDeletedFiles = builder.preserveDeletedFiles;
                this.preserveDevices = builder.preserveDevices;
                this.securityDescriptorCopyFlags = builder.securityDescriptorCopyFlags;
                this.taskQueueing = builder.taskQueueing;
                this.transferMode = builder.transferMode;
                this.uid = builder.uid;
                this.verifyMode = builder.verifyMode;
            }

            @Override
            public final java.lang.String getAtime() {
                return this.atime;
            }

            @Override
            public final java.lang.Number getBytesPerSecond() {
                return this.bytesPerSecond;
            }

            @Override
            public final java.lang.String getGid() {
                return this.gid;
            }

            @Override
            public final java.lang.String getLogLevel() {
                return this.logLevel;
            }

            @Override
            public final java.lang.String getMtime() {
                return this.mtime;
            }

            @Override
            public final java.lang.String getObjectTags() {
                return this.objectTags;
            }

            @Override
            public final java.lang.String getOverwriteMode() {
                return this.overwriteMode;
            }

            @Override
            public final java.lang.String getPosixPermissions() {
                return this.posixPermissions;
            }

            @Override
            public final java.lang.String getPreserveDeletedFiles() {
                return this.preserveDeletedFiles;
            }

            @Override
            public final java.lang.String getPreserveDevices() {
                return this.preserveDevices;
            }

            @Override
            public final java.lang.String getSecurityDescriptorCopyFlags() {
                return this.securityDescriptorCopyFlags;
            }

            @Override
            public final java.lang.String getTaskQueueing() {
                return this.taskQueueing;
            }

            @Override
            public final java.lang.String getTransferMode() {
                return this.transferMode;
            }

            @Override
            public final java.lang.String getUid() {
                return this.uid;
            }

            @Override
            public final java.lang.String getVerifyMode() {
                return this.verifyMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAtime() != null) {
                    data.set("atime", om.valueToTree(this.getAtime()));
                }
                if (this.getBytesPerSecond() != null) {
                    data.set("bytesPerSecond", om.valueToTree(this.getBytesPerSecond()));
                }
                if (this.getGid() != null) {
                    data.set("gid", om.valueToTree(this.getGid()));
                }
                if (this.getLogLevel() != null) {
                    data.set("logLevel", om.valueToTree(this.getLogLevel()));
                }
                if (this.getMtime() != null) {
                    data.set("mtime", om.valueToTree(this.getMtime()));
                }
                if (this.getObjectTags() != null) {
                    data.set("objectTags", om.valueToTree(this.getObjectTags()));
                }
                if (this.getOverwriteMode() != null) {
                    data.set("overwriteMode", om.valueToTree(this.getOverwriteMode()));
                }
                if (this.getPosixPermissions() != null) {
                    data.set("posixPermissions", om.valueToTree(this.getPosixPermissions()));
                }
                if (this.getPreserveDeletedFiles() != null) {
                    data.set("preserveDeletedFiles", om.valueToTree(this.getPreserveDeletedFiles()));
                }
                if (this.getPreserveDevices() != null) {
                    data.set("preserveDevices", om.valueToTree(this.getPreserveDevices()));
                }
                if (this.getSecurityDescriptorCopyFlags() != null) {
                    data.set("securityDescriptorCopyFlags", om.valueToTree(this.getSecurityDescriptorCopyFlags()));
                }
                if (this.getTaskQueueing() != null) {
                    data.set("taskQueueing", om.valueToTree(this.getTaskQueueing()));
                }
                if (this.getTransferMode() != null) {
                    data.set("transferMode", om.valueToTree(this.getTransferMode()));
                }
                if (this.getUid() != null) {
                    data.set("uid", om.valueToTree(this.getUid()));
                }
                if (this.getVerifyMode() != null) {
                    data.set("verifyMode", om.valueToTree(this.getVerifyMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.OptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OptionsProperty.Jsii$Proxy that = (OptionsProperty.Jsii$Proxy) o;

                if (this.atime != null ? !this.atime.equals(that.atime) : that.atime != null) return false;
                if (this.bytesPerSecond != null ? !this.bytesPerSecond.equals(that.bytesPerSecond) : that.bytesPerSecond != null) return false;
                if (this.gid != null ? !this.gid.equals(that.gid) : that.gid != null) return false;
                if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) return false;
                if (this.mtime != null ? !this.mtime.equals(that.mtime) : that.mtime != null) return false;
                if (this.objectTags != null ? !this.objectTags.equals(that.objectTags) : that.objectTags != null) return false;
                if (this.overwriteMode != null ? !this.overwriteMode.equals(that.overwriteMode) : that.overwriteMode != null) return false;
                if (this.posixPermissions != null ? !this.posixPermissions.equals(that.posixPermissions) : that.posixPermissions != null) return false;
                if (this.preserveDeletedFiles != null ? !this.preserveDeletedFiles.equals(that.preserveDeletedFiles) : that.preserveDeletedFiles != null) return false;
                if (this.preserveDevices != null ? !this.preserveDevices.equals(that.preserveDevices) : that.preserveDevices != null) return false;
                if (this.securityDescriptorCopyFlags != null ? !this.securityDescriptorCopyFlags.equals(that.securityDescriptorCopyFlags) : that.securityDescriptorCopyFlags != null) return false;
                if (this.taskQueueing != null ? !this.taskQueueing.equals(that.taskQueueing) : that.taskQueueing != null) return false;
                if (this.transferMode != null ? !this.transferMode.equals(that.transferMode) : that.transferMode != null) return false;
                if (this.uid != null ? !this.uid.equals(that.uid) : that.uid != null) return false;
                return this.verifyMode != null ? this.verifyMode.equals(that.verifyMode) : that.verifyMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.atime != null ? this.atime.hashCode() : 0;
                result = 31 * result + (this.bytesPerSecond != null ? this.bytesPerSecond.hashCode() : 0);
                result = 31 * result + (this.gid != null ? this.gid.hashCode() : 0);
                result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
                result = 31 * result + (this.mtime != null ? this.mtime.hashCode() : 0);
                result = 31 * result + (this.objectTags != null ? this.objectTags.hashCode() : 0);
                result = 31 * result + (this.overwriteMode != null ? this.overwriteMode.hashCode() : 0);
                result = 31 * result + (this.posixPermissions != null ? this.posixPermissions.hashCode() : 0);
                result = 31 * result + (this.preserveDeletedFiles != null ? this.preserveDeletedFiles.hashCode() : 0);
                result = 31 * result + (this.preserveDevices != null ? this.preserveDevices.hashCode() : 0);
                result = 31 * result + (this.securityDescriptorCopyFlags != null ? this.securityDescriptorCopyFlags.hashCode() : 0);
                result = 31 * result + (this.taskQueueing != null ? this.taskQueueing.hashCode() : 0);
                result = 31 * result + (this.transferMode != null ? this.transferMode.hashCode() : 0);
                result = 31 * result + (this.uid != null ? this.uid.hashCode() : 0);
                result = 31 * result + (this.verifyMode != null ? this.verifyMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Customizes the reporting level for aspects of your task report.
     * <p>
     * For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that Datasync attempted to delete in your destination location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * OverridesProperty overridesProperty = OverridesProperty.builder()
     *         .deleted(DeletedProperty.builder()
     *                 .reportLevel("reportLevel")
     *                 .build())
     *         .skipped(SkippedProperty.builder()
     *                 .reportLevel("reportLevel")
     *                 .build())
     *         .transferred(TransferredProperty.builder()
     *                 .reportLevel("reportLevel")
     *                 .build())
     *         .verified(VerifiedProperty.builder()
     *                 .reportLevel("reportLevel")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-overrides.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-overrides.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.OverridesProperty")
    @software.amazon.jsii.Jsii.Proxy(OverridesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OverridesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the level of reporting for the files, objects, and directories that Datasync attempted to delete in your destination location.
         * <p>
         * This only applies if you configure your task to delete data in the destination that isn't in the source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-overrides.html#cfn-datasync-task-overrides-deleted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-overrides.html#cfn-datasync-task-overrides-deleted</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleted() {
            return null;
        }

        /**
         * Specifies the level of reporting for the files, objects, and directories that Datasync attempted to skip during your transfer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-overrides.html#cfn-datasync-task-overrides-skipped">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-overrides.html#cfn-datasync-task-overrides-skipped</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSkipped() {
            return null;
        }

        /**
         * Specifies the level of reporting for the files, objects, and directories that Datasync attempted to transfer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-overrides.html#cfn-datasync-task-overrides-transferred">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-overrides.html#cfn-datasync-task-overrides-transferred</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTransferred() {
            return null;
        }

        /**
         * Specifies the level of reporting for the files, objects, and directories that Datasync attempted to verify at the end of your transfer.
         * <p>
         * This only applies if you configure your task to verify data during and after the transfer (which Datasync does by default)
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-overrides.html#cfn-datasync-task-overrides-verified">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-overrides.html#cfn-datasync-task-overrides-verified</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVerified() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OverridesProperty> {
            java.lang.Object deleted;
            java.lang.Object skipped;
            java.lang.Object transferred;
            java.lang.Object verified;

            /**
             * Sets the value of {@link OverridesProperty#getDeleted}
             * @param deleted Specifies the level of reporting for the files, objects, and directories that Datasync attempted to delete in your destination location.
             *                This only applies if you configure your task to delete data in the destination that isn't in the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleted(software.amazon.awscdk.IResolvable deleted) {
                this.deleted = deleted;
                return this;
            }

            /**
             * Sets the value of {@link OverridesProperty#getDeleted}
             * @param deleted Specifies the level of reporting for the files, objects, and directories that Datasync attempted to delete in your destination location.
             *                This only applies if you configure your task to delete data in the destination that isn't in the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleted(software.amazon.awscdk.services.datasync.CfnTask.DeletedProperty deleted) {
                this.deleted = deleted;
                return this;
            }

            /**
             * Sets the value of {@link OverridesProperty#getSkipped}
             * @param skipped Specifies the level of reporting for the files, objects, and directories that Datasync attempted to skip during your transfer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skipped(software.amazon.awscdk.IResolvable skipped) {
                this.skipped = skipped;
                return this;
            }

            /**
             * Sets the value of {@link OverridesProperty#getSkipped}
             * @param skipped Specifies the level of reporting for the files, objects, and directories that Datasync attempted to skip during your transfer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skipped(software.amazon.awscdk.services.datasync.CfnTask.SkippedProperty skipped) {
                this.skipped = skipped;
                return this;
            }

            /**
             * Sets the value of {@link OverridesProperty#getTransferred}
             * @param transferred Specifies the level of reporting for the files, objects, and directories that Datasync attempted to transfer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transferred(software.amazon.awscdk.IResolvable transferred) {
                this.transferred = transferred;
                return this;
            }

            /**
             * Sets the value of {@link OverridesProperty#getTransferred}
             * @param transferred Specifies the level of reporting for the files, objects, and directories that Datasync attempted to transfer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transferred(software.amazon.awscdk.services.datasync.CfnTask.TransferredProperty transferred) {
                this.transferred = transferred;
                return this;
            }

            /**
             * Sets the value of {@link OverridesProperty#getVerified}
             * @param verified Specifies the level of reporting for the files, objects, and directories that Datasync attempted to verify at the end of your transfer.
             *                 This only applies if you configure your task to verify data during and after the transfer (which Datasync does by default)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verified(software.amazon.awscdk.IResolvable verified) {
                this.verified = verified;
                return this;
            }

            /**
             * Sets the value of {@link OverridesProperty#getVerified}
             * @param verified Specifies the level of reporting for the files, objects, and directories that Datasync attempted to verify at the end of your transfer.
             *                 This only applies if you configure your task to verify data during and after the transfer (which Datasync does by default)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verified(software.amazon.awscdk.services.datasync.CfnTask.VerifiedProperty verified) {
                this.verified = verified;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OverridesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OverridesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OverridesProperty {
            private final java.lang.Object deleted;
            private final java.lang.Object skipped;
            private final java.lang.Object transferred;
            private final java.lang.Object verified;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deleted = software.amazon.jsii.Kernel.get(this, "deleted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.skipped = software.amazon.jsii.Kernel.get(this, "skipped", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.transferred = software.amazon.jsii.Kernel.get(this, "transferred", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.verified = software.amazon.jsii.Kernel.get(this, "verified", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deleted = builder.deleted;
                this.skipped = builder.skipped;
                this.transferred = builder.transferred;
                this.verified = builder.verified;
            }

            @Override
            public final java.lang.Object getDeleted() {
                return this.deleted;
            }

            @Override
            public final java.lang.Object getSkipped() {
                return this.skipped;
            }

            @Override
            public final java.lang.Object getTransferred() {
                return this.transferred;
            }

            @Override
            public final java.lang.Object getVerified() {
                return this.verified;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeleted() != null) {
                    data.set("deleted", om.valueToTree(this.getDeleted()));
                }
                if (this.getSkipped() != null) {
                    data.set("skipped", om.valueToTree(this.getSkipped()));
                }
                if (this.getTransferred() != null) {
                    data.set("transferred", om.valueToTree(this.getTransferred()));
                }
                if (this.getVerified() != null) {
                    data.set("verified", om.valueToTree(this.getVerified()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.OverridesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OverridesProperty.Jsii$Proxy that = (OverridesProperty.Jsii$Proxy) o;

                if (this.deleted != null ? !this.deleted.equals(that.deleted) : that.deleted != null) return false;
                if (this.skipped != null ? !this.skipped.equals(that.skipped) : that.skipped != null) return false;
                if (this.transferred != null ? !this.transferred.equals(that.transferred) : that.transferred != null) return false;
                return this.verified != null ? this.verified.equals(that.verified) : that.verified == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deleted != null ? this.deleted.hashCode() : 0;
                result = 31 * result + (this.skipped != null ? this.skipped.hashCode() : 0);
                result = 31 * result + (this.transferred != null ? this.transferred.hashCode() : 0);
                result = 31 * result + (this.verified != null ? this.verified.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * S3Property s3Property = S3Property.builder()
     *         .bucketAccessRoleArn("bucketAccessRoleArn")
     *         .s3BucketArn("s3BucketArn")
     *         .subdirectory("subdirectory")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-s3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-s3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.S3Property")
    @software.amazon.jsii.Jsii.Proxy(S3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-s3.html#cfn-datasync-task-s3-bucketaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-s3.html#cfn-datasync-task-s3-bucketaccessrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketAccessRoleArn() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-s3.html#cfn-datasync-task-s3-s3bucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-s3.html#cfn-datasync-task-s3-s3bucketarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketArn() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-s3.html#cfn-datasync-task-s3-subdirectory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-s3.html#cfn-datasync-task-s3-subdirectory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubdirectory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3Property> {
            java.lang.String bucketAccessRoleArn;
            java.lang.String s3BucketArn;
            java.lang.String subdirectory;

            /**
             * Sets the value of {@link S3Property#getBucketAccessRoleArn}
             * @param bucketAccessRoleArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketAccessRoleArn(java.lang.String bucketAccessRoleArn) {
                this.bucketAccessRoleArn = bucketAccessRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getS3BucketArn}
             * @param s3BucketArn the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketArn(java.lang.String s3BucketArn) {
                this.s3BucketArn = s3BucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getSubdirectory}
             * @param subdirectory the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subdirectory(java.lang.String subdirectory) {
                this.subdirectory = subdirectory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3Property {
            private final java.lang.String bucketAccessRoleArn;
            private final java.lang.String s3BucketArn;
            private final java.lang.String subdirectory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketAccessRoleArn = software.amazon.jsii.Kernel.get(this, "bucketAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BucketArn = software.amazon.jsii.Kernel.get(this, "s3BucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subdirectory = software.amazon.jsii.Kernel.get(this, "subdirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketAccessRoleArn = builder.bucketAccessRoleArn;
                this.s3BucketArn = builder.s3BucketArn;
                this.subdirectory = builder.subdirectory;
            }

            @Override
            public final java.lang.String getBucketAccessRoleArn() {
                return this.bucketAccessRoleArn;
            }

            @Override
            public final java.lang.String getS3BucketArn() {
                return this.s3BucketArn;
            }

            @Override
            public final java.lang.String getSubdirectory() {
                return this.subdirectory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketAccessRoleArn() != null) {
                    data.set("bucketAccessRoleArn", om.valueToTree(this.getBucketAccessRoleArn()));
                }
                if (this.getS3BucketArn() != null) {
                    data.set("s3BucketArn", om.valueToTree(this.getS3BucketArn()));
                }
                if (this.getSubdirectory() != null) {
                    data.set("subdirectory", om.valueToTree(this.getSubdirectory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.S3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3Property.Jsii$Proxy that = (S3Property.Jsii$Proxy) o;

                if (this.bucketAccessRoleArn != null ? !this.bucketAccessRoleArn.equals(that.bucketAccessRoleArn) : that.bucketAccessRoleArn != null) return false;
                if (this.s3BucketArn != null ? !this.s3BucketArn.equals(that.s3BucketArn) : that.s3BucketArn != null) return false;
                return this.subdirectory != null ? this.subdirectory.equals(that.subdirectory) : that.subdirectory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketAccessRoleArn != null ? this.bucketAccessRoleArn.hashCode() : 0;
                result = 31 * result + (this.s3BucketArn != null ? this.s3BucketArn.hashCode() : 0);
                result = 31 * result + (this.subdirectory != null ? this.subdirectory.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the level of reporting for the files, objects, and directories that Datasync attempted to skip during your transfer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * SkippedProperty skippedProperty = SkippedProperty.builder()
     *         .reportLevel("reportLevel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-skipped.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-skipped.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.SkippedProperty")
    @software.amazon.jsii.Jsii.Proxy(SkippedProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SkippedProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-skipped.html#cfn-datasync-task-skipped-reportlevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-skipped.html#cfn-datasync-task-skipped-reportlevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReportLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SkippedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SkippedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SkippedProperty> {
            java.lang.String reportLevel;

            /**
             * Sets the value of {@link SkippedProperty#getReportLevel}
             * @param reportLevel Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportLevel(java.lang.String reportLevel) {
                this.reportLevel = reportLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SkippedProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SkippedProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SkippedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SkippedProperty {
            private final java.lang.String reportLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reportLevel = software.amazon.jsii.Kernel.get(this, "reportLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reportLevel = builder.reportLevel;
            }

            @Override
            public final java.lang.String getReportLevel() {
                return this.reportLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReportLevel() != null) {
                    data.set("reportLevel", om.valueToTree(this.getReportLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.SkippedProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SkippedProperty.Jsii$Proxy that = (SkippedProperty.Jsii$Proxy) o;

                return this.reportLevel != null ? this.reportLevel.equals(that.reportLevel) : that.reportLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.reportLevel != null ? this.reportLevel.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the manifest that you want DataSync to use and where it's hosted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * SourceProperty sourceProperty = SourceProperty.builder()
     *         .s3(ManifestConfigSourceS3Property.builder()
     *                 .bucketAccessRoleArn("bucketAccessRoleArn")
     *                 .manifestObjectPath("manifestObjectPath")
     *                 .manifestObjectVersionId("manifestObjectVersionId")
     *                 .s3BucketArn("s3BucketArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-source.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-source.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the S3 bucket where you're hosting the manifest that you want AWS DataSync to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-source.html#cfn-datasync-task-source-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-source.html#cfn-datasync-task-source-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceProperty> {
            java.lang.Object s3;

            /**
             * Sets the value of {@link SourceProperty#getS3}
             * @param s3 Specifies the S3 bucket where you're hosting the manifest that you want AWS DataSync to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getS3}
             * @param s3 Specifies the S3 bucket where you're hosting the manifest that you want AWS DataSync to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.datasync.CfnTask.ManifestConfigSourceS3Property s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceProperty {
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceProperty.Jsii$Proxy that = (SourceProperty.Jsii$Proxy) o;

                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3 != null ? this.s3.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies how you want to configure a task report, which provides detailed information about for your AWS DataSync transfer.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Task reports</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * TaskReportConfigProperty taskReportConfigProperty = TaskReportConfigProperty.builder()
     *         .destination(DestinationProperty.builder()
     *                 .s3(S3Property.builder()
     *                         .bucketAccessRoleArn("bucketAccessRoleArn")
     *                         .s3BucketArn("s3BucketArn")
     *                         .subdirectory("subdirectory")
     *                         .build())
     *                 .build())
     *         .outputType("outputType")
     *         // the properties below are optional
     *         .objectVersionIds("objectVersionIds")
     *         .overrides(OverridesProperty.builder()
     *                 .deleted(DeletedProperty.builder()
     *                         .reportLevel("reportLevel")
     *                         .build())
     *                 .skipped(SkippedProperty.builder()
     *                         .reportLevel("reportLevel")
     *                         .build())
     *                 .transferred(TransferredProperty.builder()
     *                         .reportLevel("reportLevel")
     *                         .build())
     *                 .verified(VerifiedProperty.builder()
     *                         .reportLevel("reportLevel")
     *                         .build())
     *                 .build())
     *         .reportLevel("reportLevel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.TaskReportConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskReportConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskReportConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the Amazon S3 bucket where DataSync uploads your task report.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html#task-report-access">Task reports</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html#cfn-datasync-task-taskreportconfig-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html#cfn-datasync-task-taskreportconfig-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestination();

        /**
         * Specifies the type of task report that you want:.
         * <p>
         * <ul>
         * <li><code>SUMMARY_ONLY</code> : Provides necessary details about your task, including the number of files, objects, and directories transferred and transfer duration.</li>
         * <li><code>STANDARD</code> : Provides complete details about your task, including a full list of files, objects, and directories that were transferred, skipped, verified, and more.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html#cfn-datasync-task-taskreportconfig-outputtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html#cfn-datasync-task-taskreportconfig-outputtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputType();

        /**
         * Specifies whether your task report includes the new version of each object transferred into an S3 bucket.
         * <p>
         * This only applies if you <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html">enable versioning on your bucket</a> . Keep in mind that setting this to <code>INCLUDE</code> can increase the duration of your task execution.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html#cfn-datasync-task-taskreportconfig-objectversionids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html#cfn-datasync-task-taskreportconfig-objectversionids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectVersionIds() {
            return null;
        }

        /**
         * Customizes the reporting level for aspects of your task report.
         * <p>
         * For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that DataSync attempted to delete in your destination location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html#cfn-datasync-task-taskreportconfig-overrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html#cfn-datasync-task-taskreportconfig-overrides</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
            return null;
        }

        /**
         * Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
         * <p>
         * <ul>
         * <li><code>ERRORS_ONLY</code> : A report shows what DataSync was unable to transfer, skip, verify, and delete.</li>
         * <li><code>SUCCESSES_AND_ERRORS</code> : A report shows what DataSync was able and unable to transfer, skip, verify, and delete.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html#cfn-datasync-task-taskreportconfig-reportlevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskreportconfig.html#cfn-datasync-task-taskreportconfig-reportlevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReportLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TaskReportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskReportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskReportConfigProperty> {
            java.lang.Object destination;
            java.lang.String outputType;
            java.lang.String objectVersionIds;
            java.lang.Object overrides;
            java.lang.String reportLevel;

            /**
             * Sets the value of {@link TaskReportConfigProperty#getDestination}
             * @param destination Specifies the Amazon S3 bucket where DataSync uploads your task report. This parameter is required.
             *                    For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html#task-report-access">Task reports</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.IResolvable destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link TaskReportConfigProperty#getDestination}
             * @param destination Specifies the Amazon S3 bucket where DataSync uploads your task report. This parameter is required.
             *                    For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html#task-report-access">Task reports</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(software.amazon.awscdk.services.datasync.CfnTask.DestinationProperty destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link TaskReportConfigProperty#getOutputType}
             * @param outputType Specifies the type of task report that you want:. This parameter is required.
             *                   <ul>
             *                   <li><code>SUMMARY_ONLY</code> : Provides necessary details about your task, including the number of files, objects, and directories transferred and transfer duration.</li>
             *                   <li><code>STANDARD</code> : Provides complete details about your task, including a full list of files, objects, and directories that were transferred, skipped, verified, and more.</li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputType(java.lang.String outputType) {
                this.outputType = outputType;
                return this;
            }

            /**
             * Sets the value of {@link TaskReportConfigProperty#getObjectVersionIds}
             * @param objectVersionIds Specifies whether your task report includes the new version of each object transferred into an S3 bucket.
             *                         This only applies if you <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html">enable versioning on your bucket</a> . Keep in mind that setting this to <code>INCLUDE</code> can increase the duration of your task execution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectVersionIds(java.lang.String objectVersionIds) {
                this.objectVersionIds = objectVersionIds;
                return this;
            }

            /**
             * Sets the value of {@link TaskReportConfigProperty#getOverrides}
             * @param overrides Customizes the reporting level for aspects of your task report.
             *                  For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that DataSync attempted to delete in your destination location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link TaskReportConfigProperty#getOverrides}
             * @param overrides Customizes the reporting level for aspects of your task report.
             *                  For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that DataSync attempted to delete in your destination location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.services.datasync.CfnTask.OverridesProperty overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link TaskReportConfigProperty#getReportLevel}
             * @param reportLevel Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
             *                    <ul>
             *                    <li><code>ERRORS_ONLY</code> : A report shows what DataSync was unable to transfer, skip, verify, and delete.</li>
             *                    <li><code>SUCCESSES_AND_ERRORS</code> : A report shows what DataSync was able and unable to transfer, skip, verify, and delete.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportLevel(java.lang.String reportLevel) {
                this.reportLevel = reportLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskReportConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskReportConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskReportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskReportConfigProperty {
            private final java.lang.Object destination;
            private final java.lang.String outputType;
            private final java.lang.String objectVersionIds;
            private final java.lang.Object overrides;
            private final java.lang.String reportLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputType = software.amazon.jsii.Kernel.get(this, "outputType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectVersionIds = software.amazon.jsii.Kernel.get(this, "objectVersionIds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.reportLevel = software.amazon.jsii.Kernel.get(this, "reportLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.outputType = java.util.Objects.requireNonNull(builder.outputType, "outputType is required");
                this.objectVersionIds = builder.objectVersionIds;
                this.overrides = builder.overrides;
                this.reportLevel = builder.reportLevel;
            }

            @Override
            public final java.lang.Object getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getOutputType() {
                return this.outputType;
            }

            @Override
            public final java.lang.String getObjectVersionIds() {
                return this.objectVersionIds;
            }

            @Override
            public final java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            public final java.lang.String getReportLevel() {
                return this.reportLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("outputType", om.valueToTree(this.getOutputType()));
                if (this.getObjectVersionIds() != null) {
                    data.set("objectVersionIds", om.valueToTree(this.getObjectVersionIds()));
                }
                if (this.getOverrides() != null) {
                    data.set("overrides", om.valueToTree(this.getOverrides()));
                }
                if (this.getReportLevel() != null) {
                    data.set("reportLevel", om.valueToTree(this.getReportLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.TaskReportConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskReportConfigProperty.Jsii$Proxy that = (TaskReportConfigProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                if (!outputType.equals(that.outputType)) return false;
                if (this.objectVersionIds != null ? !this.objectVersionIds.equals(that.objectVersionIds) : that.objectVersionIds != null) return false;
                if (this.overrides != null ? !this.overrides.equals(that.overrides) : that.overrides != null) return false;
                return this.reportLevel != null ? this.reportLevel.equals(that.reportLevel) : that.reportLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.outputType.hashCode());
                result = 31 * result + (this.objectVersionIds != null ? this.objectVersionIds.hashCode() : 0);
                result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
                result = 31 * result + (this.reportLevel != null ? this.reportLevel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures your AWS DataSync task to run on a <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">schedule</a> (at a minimum interval of 1 hour).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * TaskScheduleProperty taskScheduleProperty = TaskScheduleProperty.builder()
     *         .scheduleExpression("scheduleExpression")
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskschedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskschedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.TaskScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies your task schedule by using a cron or rate expression.
         * <p>
         * Use cron expressions for task schedules that run on a specific time and day. For example, the following cron expression creates a task schedule that runs at 8 AM on the first Wednesday of every month:
         * <p>
         * <code>cron(0 8 * * 3#1)</code>
         * <p>
         * Use rate expressions for task schedules that run on a regular interval. For example, the following rate expression creates a task schedule that runs every 12 hours:
         * <p>
         * <code>rate(12 hours)</code>
         * <p>
         * For information about cron and rate expression syntax, see the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-scheduled-rule-pattern.html"><em>Amazon EventBridge User Guide</em></a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskschedule.html#cfn-datasync-task-taskschedule-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskschedule.html#cfn-datasync-task-taskschedule-scheduleexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpression() {
            return null;
        }

        /**
         * Specifies whether to enable or disable your task schedule.
         * <p>
         * Your schedule is enabled by default, but there can be situations where you need to disable it. For example, you might need to pause a recurring transfer to fix an issue with your task or perform maintenance on your storage system.
         * <p>
         * DataSync might disable your schedule automatically if your task fails repeatedly with the same error. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html">TaskScheduleDetails</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskschedule.html#cfn-datasync-task-taskschedule-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-taskschedule.html#cfn-datasync-task-taskschedule-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TaskScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskScheduleProperty> {
            java.lang.String scheduleExpression;
            java.lang.String status;

            /**
             * Sets the value of {@link TaskScheduleProperty#getScheduleExpression}
             * @param scheduleExpression Specifies your task schedule by using a cron or rate expression.
             *                           Use cron expressions for task schedules that run on a specific time and day. For example, the following cron expression creates a task schedule that runs at 8 AM on the first Wednesday of every month:
             *                           <p>
             *                           <code>cron(0 8 * * 3#1)</code>
             *                           <p>
             *                           Use rate expressions for task schedules that run on a regular interval. For example, the following rate expression creates a task schedule that runs every 12 hours:
             *                           <p>
             *                           <code>rate(12 hours)</code>
             *                           <p>
             *                           For information about cron and rate expression syntax, see the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-scheduled-rule-pattern.html"><em>Amazon EventBridge User Guide</em></a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Sets the value of {@link TaskScheduleProperty#getStatus}
             * @param status Specifies whether to enable or disable your task schedule.
             *               Your schedule is enabled by default, but there can be situations where you need to disable it. For example, you might need to pause a recurring transfer to fix an issue with your task or perform maintenance on your storage system.
             *               <p>
             *               DataSync might disable your schedule automatically if your task fails repeatedly with the same error. For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/API_TaskScheduleDetails.html">TaskScheduleDetails</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskScheduleProperty {
            private final java.lang.String scheduleExpression;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = builder.scheduleExpression;
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getScheduleExpression() != null) {
                    data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.TaskScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskScheduleProperty.Jsii$Proxy that = (TaskScheduleProperty.Jsii$Proxy) o;

                if (this.scheduleExpression != null ? !this.scheduleExpression.equals(that.scheduleExpression) : that.scheduleExpression != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression != null ? this.scheduleExpression.hashCode() : 0;
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the level of reporting for the files, objects, and directories that Datasync attempted to transfer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * TransferredProperty transferredProperty = TransferredProperty.builder()
     *         .reportLevel("reportLevel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-transferred.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-transferred.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.TransferredProperty")
    @software.amazon.jsii.Jsii.Proxy(TransferredProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TransferredProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-transferred.html#cfn-datasync-task-transferred-reportlevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-transferred.html#cfn-datasync-task-transferred-reportlevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReportLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TransferredProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TransferredProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TransferredProperty> {
            java.lang.String reportLevel;

            /**
             * Sets the value of {@link TransferredProperty#getReportLevel}
             * @param reportLevel Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportLevel(java.lang.String reportLevel) {
                this.reportLevel = reportLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TransferredProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TransferredProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TransferredProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransferredProperty {
            private final java.lang.String reportLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reportLevel = software.amazon.jsii.Kernel.get(this, "reportLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reportLevel = builder.reportLevel;
            }

            @Override
            public final java.lang.String getReportLevel() {
                return this.reportLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReportLevel() != null) {
                    data.set("reportLevel", om.valueToTree(this.getReportLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.TransferredProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TransferredProperty.Jsii$Proxy that = (TransferredProperty.Jsii$Proxy) o;

                return this.reportLevel != null ? this.reportLevel.equals(that.reportLevel) : that.reportLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.reportLevel != null ? this.reportLevel.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the level of reporting for the files, objects, and directories that Datasync attempted to verify at the end of your transfer.
     * <p>
     * This only applies if you configure your task to verify data during and after the transfer (which Datasync does by default)
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.datasync.*;
     * VerifiedProperty verifiedProperty = VerifiedProperty.builder()
     *         .reportLevel("reportLevel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-verified.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-verified.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_datasync.CfnTask.VerifiedProperty")
    @software.amazon.jsii.Jsii.Proxy(VerifiedProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VerifiedProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-verified.html#cfn-datasync-task-verified-reportlevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-datasync-task-verified.html#cfn-datasync-task-verified-reportlevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReportLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VerifiedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VerifiedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VerifiedProperty> {
            java.lang.String reportLevel;

            /**
             * Sets the value of {@link VerifiedProperty#getReportLevel}
             * @param reportLevel Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reportLevel(java.lang.String reportLevel) {
                this.reportLevel = reportLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VerifiedProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VerifiedProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VerifiedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VerifiedProperty {
            private final java.lang.String reportLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reportLevel = software.amazon.jsii.Kernel.get(this, "reportLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reportLevel = builder.reportLevel;
            }

            @Override
            public final java.lang.String getReportLevel() {
                return this.reportLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getReportLevel() != null) {
                    data.set("reportLevel", om.valueToTree(this.getReportLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_datasync.CfnTask.VerifiedProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VerifiedProperty.Jsii$Proxy that = (VerifiedProperty.Jsii$Proxy) o;

                return this.reportLevel != null ? this.reportLevel.equals(that.reportLevel) : that.reportLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.reportLevel != null ? this.reportLevel.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.datasync.CfnTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.datasync.CfnTask> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.datasync.CfnTaskProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.datasync.CfnTaskProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of an AWS storage resource's location.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-destinationlocationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-destinationlocationarn</a>
         * @param destinationLocationArn The Amazon Resource Name (ARN) of an AWS storage resource's location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationLocationArn(final java.lang.String destinationLocationArn) {
            this.props.destinationLocationArn(destinationLocationArn);
            return this;
        }

        /**
         * Specifies the ARN of your transfer's source location.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-sourcelocationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-sourcelocationarn</a>
         * @param sourceLocationArn Specifies the ARN of your transfer's source location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceLocationArn(final java.lang.String sourceLocationArn) {
            this.props.sourceLocationArn(sourceLocationArn);
            return this;
        }

        /**
         * Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task.
         * <p>
         * For Enhanced mode tasks, you don't need to specify anything. DataSync automatically sends logs to a CloudWatch log group named <code>/aws/datasync</code> .
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/configure-logging.html">Monitoring data transfers with CloudWatch Logs</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-cloudwatchloggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-cloudwatchloggrouparn</a>
         * @param cloudWatchLogGroupArn Specifies the Amazon Resource Name (ARN) of an Amazon CloudWatch log group for monitoring your task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogGroupArn(final java.lang.String cloudWatchLogGroupArn) {
            this.props.cloudWatchLogGroupArn(cloudWatchLogGroupArn);
            return this;
        }

        /**
         * Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer.
         * <p>
         * For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-excludes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-excludes</a>
         * @param excludes Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludes(final software.amazon.awscdk.IResolvable excludes) {
            this.props.excludes(excludes);
            return this;
        }
        /**
         * Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer.
         * <p>
         * For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-excludes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-excludes</a>
         * @param excludes Specifies exclude filters that define the files, objects, and folders in your source location that you don't want DataSync to transfer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludes(final java.util.List<? extends java.lang.Object> excludes) {
            this.props.excludes(excludes);
            return this;
        }

        /**
         * Specifies include filters that define the files, objects, and folders in your source location that you want DataSync to transfer.
         * <p>
         * For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-includes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-includes</a>
         * @param includes Specifies include filters that define the files, objects, and folders in your source location that you want DataSync to transfer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includes(final software.amazon.awscdk.IResolvable includes) {
            this.props.includes(includes);
            return this;
        }
        /**
         * Specifies include filters that define the files, objects, and folders in your source location that you want DataSync to transfer.
         * <p>
         * For more information and examples, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html">Specifying what DataSync transfers by using filters</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-includes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-includes</a>
         * @param includes Specifies include filters that define the files, objects, and folders in your source location that you want DataSync to transfer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includes(final java.util.List<? extends java.lang.Object> includes) {
            this.props.includes(includes);
            return this;
        }

        /**
         * The configuration of the manifest that lists the files or objects that you want DataSync to transfer.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-manifestconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-manifestconfig</a>
         * @param manifestConfig The configuration of the manifest that lists the files or objects that you want DataSync to transfer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestConfig(final software.amazon.awscdk.IResolvable manifestConfig) {
            this.props.manifestConfig(manifestConfig);
            return this;
        }
        /**
         * The configuration of the manifest that lists the files or objects that you want DataSync to transfer.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html">Specifying what DataSync transfers by using a manifest</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-manifestconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-manifestconfig</a>
         * @param manifestConfig The configuration of the manifest that lists the files or objects that you want DataSync to transfer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifestConfig(final software.amazon.awscdk.services.datasync.CfnTask.ManifestConfigProperty manifestConfig) {
            this.props.manifestConfig(manifestConfig);
            return this;
        }

        /**
         * Specifies the name of your task.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-name</a>
         * @param name Specifies the name of your task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-options</a>
         * @param options Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final software.amazon.awscdk.IResolvable options) {
            this.props.options(options);
            return this;
        }
        /**
         * Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-options</a>
         * @param options Specifies your task's settings, such as preserving file metadata, verifying data integrity, among other options. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final software.amazon.awscdk.services.datasync.CfnTask.OptionsProperty options) {
            this.props.options(options);
            return this;
        }

        /**
         * Specifies a schedule for when you want your task to run.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-schedule</a>
         * @param schedule Specifies a schedule for when you want your task to run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }
        /**
         * Specifies a schedule for when you want your task to run.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html">Scheduling your task</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-schedule</a>
         * @param schedule Specifies a schedule for when you want your task to run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.datasync.CfnTask.TaskScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * Specifies the tags that you want to apply to your task.
         * <p>
         * <em>Tags</em> are key-value pairs that help you manage, filter, and search for your DataSync resources.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-tags</a>
         * @param tags Specifies the tags that you want to apply to your task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The task mode that you're using.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/choosing-task-mode.html">Choosing a task mode for your data transfer</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-taskmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-taskmode</a>
         * @param taskMode The task mode that you're using. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskMode(final java.lang.String taskMode) {
            this.props.taskMode(taskMode);
            return this;
        }

        /**
         * The configuration of your task report, which provides detailed information about your DataSync transfer.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync transfers with task reports</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-taskreportconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-taskreportconfig</a>
         * @param taskReportConfig The configuration of your task report, which provides detailed information about your DataSync transfer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskReportConfig(final software.amazon.awscdk.IResolvable taskReportConfig) {
            this.props.taskReportConfig(taskReportConfig);
            return this;
        }
        /**
         * The configuration of your task report, which provides detailed information about your DataSync transfer.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html">Monitoring your DataSync transfers with task reports</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-taskreportconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-datasync-task.html#cfn-datasync-task-taskreportconfig</a>
         * @param taskReportConfig The configuration of your task report, which provides detailed information about your DataSync transfer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskReportConfig(final software.amazon.awscdk.services.datasync.CfnTask.TaskReportConfigProperty taskReportConfig) {
            this.props.taskReportConfig(taskReportConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.datasync.CfnTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.datasync.CfnTask build() {
            return new software.amazon.awscdk.services.datasync.CfnTask(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
