package software.amazon.awscdk.services.dynamodb;

/**
 * Options used to configure global secondary indexes on a replica table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * TableV2 globalTable = TableV2.Builder.create(stack, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .contributorInsightsSpecification(ContributorInsightsSpecification.builder()
 *                 .enabled(true)
 *                 .build())
 *         .billing(Billing.provisioned(ThroughputProps.builder()
 *                 .readCapacity(Capacity.fixed(10))
 *                 .writeCapacity(Capacity.autoscaled(AutoscaledCapacityOptions.builder().maxCapacity(10).build()))
 *                 .build()))
 *         // each global secondary index will inherit contributor insights as true
 *         .globalSecondaryIndexes(List.of(GlobalSecondaryIndexPropsV2.builder()
 *                 .indexName("gsi1")
 *                 .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *                 .readCapacity(Capacity.fixed(15))
 *                 .build(), GlobalSecondaryIndexPropsV2.builder()
 *                 .indexName("gsi2")
 *                 .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *                 .writeCapacity(Capacity.autoscaled(AutoscaledCapacityOptions.builder().minCapacity(5).maxCapacity(20).build()))
 *                 .build()))
 *         .replicas(List.of(ReplicaTableProps.builder()
 *                 .region("us-east-1")
 *                 .globalSecondaryIndexOptions(Map.of(
 *                         "gsi1", ReplicaGlobalSecondaryIndexOptions.builder()
 *                                 .readCapacity(Capacity.autoscaled(AutoscaledCapacityOptions.builder().minCapacity(1).maxCapacity(10).build()))
 *                                 .build()))
 *                 .build(), ReplicaTableProps.builder()
 *                 .region("us-east-2")
 *                 .globalSecondaryIndexOptions(Map.of(
 *                         "gsi2", ReplicaGlobalSecondaryIndexOptions.builder()
 *                                 .contributorInsightsSpecification(ContributorInsightsSpecification.builder()
 *                                         .enabled(false)
 *                                         .build())
 *                                 .build()))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:29.835Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.ReplicaGlobalSecondaryIndexOptions")
@software.amazon.jsii.Jsii.Proxy(ReplicaGlobalSecondaryIndexOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ReplicaGlobalSecondaryIndexOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (deprecated) Whether CloudWatch contributor insights is enabled for a specific global secondary index on a replica table.
     * <p>
     * Default: - inherited from the primary table
     * <p>
     * @deprecated use <code>contributorInsightsSpecification</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getContributorInsights() {
        return null;
    }

    /**
     * Whether CloudWatch contributor insights is enabled and what mode is selected for a specific global secondary index on a replica table.
     * <p>
     * Default: - contributor insights is not enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.ContributorInsightsSpecification getContributorInsightsSpecification() {
        return null;
    }

    /**
     * The maximum read request units for a specific global secondary index on a replica table.
     * <p>
     * Note: This can only be configured if primary table billing is PAY_PER_REQUEST.
     * <p>
     * Default: - inherited from the primary table
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxReadRequestUnits() {
        return null;
    }

    /**
     * The read capacity for a specific global secondary index on a replica table.
     * <p>
     * Note: This can only be configured if primary table billing is provisioned.
     * <p>
     * Default: - inherited from the primary table
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.dynamodb.Capacity getReadCapacity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ReplicaGlobalSecondaryIndexOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ReplicaGlobalSecondaryIndexOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ReplicaGlobalSecondaryIndexOptions> {
        java.lang.Boolean contributorInsights;
        software.amazon.awscdk.services.dynamodb.ContributorInsightsSpecification contributorInsightsSpecification;
        java.lang.Number maxReadRequestUnits;
        software.amazon.awscdk.services.dynamodb.Capacity readCapacity;

        /**
         * Sets the value of {@link ReplicaGlobalSecondaryIndexOptions#getContributorInsights}
         * @param contributorInsights Whether CloudWatch contributor insights is enabled for a specific global secondary index on a replica table.
         * @return {@code this}
         * @deprecated use `contributorInsightsSpecification` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder contributorInsights(java.lang.Boolean contributorInsights) {
            this.contributorInsights = contributorInsights;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaGlobalSecondaryIndexOptions#getContributorInsightsSpecification}
         * @param contributorInsightsSpecification Whether CloudWatch contributor insights is enabled and what mode is selected for a specific global secondary index on a replica table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsightsSpecification(software.amazon.awscdk.services.dynamodb.ContributorInsightsSpecification contributorInsightsSpecification) {
            this.contributorInsightsSpecification = contributorInsightsSpecification;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaGlobalSecondaryIndexOptions#getMaxReadRequestUnits}
         * @param maxReadRequestUnits The maximum read request units for a specific global secondary index on a replica table.
         *                            Note: This can only be configured if primary table billing is PAY_PER_REQUEST.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReadRequestUnits(java.lang.Number maxReadRequestUnits) {
            this.maxReadRequestUnits = maxReadRequestUnits;
            return this;
        }

        /**
         * Sets the value of {@link ReplicaGlobalSecondaryIndexOptions#getReadCapacity}
         * @param readCapacity The read capacity for a specific global secondary index on a replica table.
         *                     Note: This can only be configured if primary table billing is provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(software.amazon.awscdk.services.dynamodb.Capacity readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ReplicaGlobalSecondaryIndexOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ReplicaGlobalSecondaryIndexOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ReplicaGlobalSecondaryIndexOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReplicaGlobalSecondaryIndexOptions {
        private final java.lang.Boolean contributorInsights;
        private final software.amazon.awscdk.services.dynamodb.ContributorInsightsSpecification contributorInsightsSpecification;
        private final java.lang.Number maxReadRequestUnits;
        private final software.amazon.awscdk.services.dynamodb.Capacity readCapacity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.contributorInsights = software.amazon.jsii.Kernel.get(this, "contributorInsights", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.contributorInsightsSpecification = software.amazon.jsii.Kernel.get(this, "contributorInsightsSpecification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ContributorInsightsSpecification.class));
            this.maxReadRequestUnits = software.amazon.jsii.Kernel.get(this, "maxReadRequestUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.readCapacity = software.amazon.jsii.Kernel.get(this, "readCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Capacity.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.contributorInsights = builder.contributorInsights;
            this.contributorInsightsSpecification = builder.contributorInsightsSpecification;
            this.maxReadRequestUnits = builder.maxReadRequestUnits;
            this.readCapacity = builder.readCapacity;
        }

        @Override
        public final java.lang.Boolean getContributorInsights() {
            return this.contributorInsights;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.ContributorInsightsSpecification getContributorInsightsSpecification() {
            return this.contributorInsightsSpecification;
        }

        @Override
        public final java.lang.Number getMaxReadRequestUnits() {
            return this.maxReadRequestUnits;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Capacity getReadCapacity() {
            return this.readCapacity;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContributorInsights() != null) {
                data.set("contributorInsights", om.valueToTree(this.getContributorInsights()));
            }
            if (this.getContributorInsightsSpecification() != null) {
                data.set("contributorInsightsSpecification", om.valueToTree(this.getContributorInsightsSpecification()));
            }
            if (this.getMaxReadRequestUnits() != null) {
                data.set("maxReadRequestUnits", om.valueToTree(this.getMaxReadRequestUnits()));
            }
            if (this.getReadCapacity() != null) {
                data.set("readCapacity", om.valueToTree(this.getReadCapacity()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.ReplicaGlobalSecondaryIndexOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ReplicaGlobalSecondaryIndexOptions.Jsii$Proxy that = (ReplicaGlobalSecondaryIndexOptions.Jsii$Proxy) o;

            if (this.contributorInsights != null ? !this.contributorInsights.equals(that.contributorInsights) : that.contributorInsights != null) return false;
            if (this.contributorInsightsSpecification != null ? !this.contributorInsightsSpecification.equals(that.contributorInsightsSpecification) : that.contributorInsightsSpecification != null) return false;
            if (this.maxReadRequestUnits != null ? !this.maxReadRequestUnits.equals(that.maxReadRequestUnits) : that.maxReadRequestUnits != null) return false;
            return this.readCapacity != null ? this.readCapacity.equals(that.readCapacity) : that.readCapacity == null;
        }

        @Override
        public final int hashCode() {
            int result = this.contributorInsights != null ? this.contributorInsights.hashCode() : 0;
            result = 31 * result + (this.contributorInsightsSpecification != null ? this.contributorInsightsSpecification.hashCode() : 0);
            result = 31 * result + (this.maxReadRequestUnits != null ? this.maxReadRequestUnits.hashCode() : 0);
            result = 31 * result + (this.readCapacity != null ? this.readCapacity.hashCode() : 0);
            return result;
        }
    }
}
