package software.amazon.awscdk.services.ec2;

/**
 * Properties to intialize a new Connections object.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * IPeer peer;
 * Port port;
 * SecurityGroup securityGroup;
 * ConnectionsProps connectionsProps = ConnectionsProps.builder()
 *         .defaultPort(port)
 *         .peer(peer)
 *         .securityGroups(List.of(securityGroup))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:30.455Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.ConnectionsProps")
@software.amazon.jsii.Jsii.Proxy(ConnectionsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ConnectionsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Default port range for initiating connections to and from this object.
     * <p>
     * Default: - No default port
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.Port getDefaultPort() {
        return null;
    }

    /**
     * Class that represents the rule by which others can connect to this connectable.
     * <p>
     * This object is required, but will be derived from securityGroup if that is passed.
     * <p>
     * Default: Derived from securityGroup if set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IPeer getPeer() {
        return null;
    }

    /**
     * What securityGroup(s) this object is managing connections for.
     * <p>
     * Default: No security groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ConnectionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConnectionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ConnectionsProps> {
        software.amazon.awscdk.services.ec2.Port defaultPort;
        software.amazon.awscdk.services.ec2.IPeer peer;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Sets the value of {@link ConnectionsProps#getDefaultPort}
         * @param defaultPort Default port range for initiating connections to and from this object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultPort(software.amazon.awscdk.services.ec2.Port defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionsProps#getPeer}
         * @param peer Class that represents the rule by which others can connect to this connectable.
         *             This object is required, but will be derived from securityGroup if that is passed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peer(software.amazon.awscdk.services.ec2.IPeer peer) {
            this.peer = peer;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionsProps#getSecurityGroups}
         * @param securityGroups What securityGroup(s) this object is managing connections for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ConnectionsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConnectionsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionsProps {
        private final software.amazon.awscdk.services.ec2.Port defaultPort;
        private final software.amazon.awscdk.services.ec2.IPeer peer;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultPort = software.amazon.jsii.Kernel.get(this, "defaultPort", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Port.class));
            this.peer = software.amazon.jsii.Kernel.get(this, "peer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPeer.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultPort = builder.defaultPort;
            this.peer = builder.peer;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.Port getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IPeer getPeer() {
            return this.peer;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDefaultPort() != null) {
                data.set("defaultPort", om.valueToTree(this.getDefaultPort()));
            }
            if (this.getPeer() != null) {
                data.set("peer", om.valueToTree(this.getPeer()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.ConnectionsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConnectionsProps.Jsii$Proxy that = (ConnectionsProps.Jsii$Proxy) o;

            if (this.defaultPort != null ? !this.defaultPort.equals(that.defaultPort) : that.defaultPort != null) return false;
            if (this.peer != null ? !this.peer.equals(that.peer) : that.peer != null) return false;
            return this.securityGroups != null ? this.securityGroups.equals(that.securityGroups) : that.securityGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultPort != null ? this.defaultPort.hashCode() : 0;
            result = 31 * result + (this.peer != null ? this.peer.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            return result;
        }
    }
}
