package software.amazon.awscdk.services.ec2;

/**
 * Options to add an interface endpoint to a VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Add gateway endpoints when creating the VPC
 * Vpc vpc = Vpc.Builder.create(this, "MyVpc")
 *         .gatewayEndpoints(Map.of(
 *                 "S3", GatewayVpcEndpointOptions.builder()
 *                         .service(GatewayVpcEndpointAwsService.S3)
 *                         .build()))
 *         .build();
 * // Alternatively gateway endpoints can be added on the VPC
 * GatewayVpcEndpoint dynamoDbEndpoint = vpc.addGatewayEndpoint("DynamoDbEndpoint", GatewayVpcEndpointOptions.builder()
 *         .service(GatewayVpcEndpointAwsService.DYNAMODB)
 *         .build());
 * // This allows to customize the endpoint policy
 * dynamoDbEndpoint.addToPolicy(
 * PolicyStatement.Builder.create() // Restrict to listing and describing tables
 *         .principals(List.of(new AnyPrincipal()))
 *         .actions(List.of("dynamodb:DescribeTable", "dynamodb:ListTables"))
 *         .resources(List.of("*")).build());
 * // Add an interface endpoint
 * vpc.addInterfaceEndpoint("EcrDockerEndpoint", InterfaceVpcEndpointOptions.builder()
 *         .service(InterfaceVpcEndpointAwsService.ECR_DOCKER)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:30.543Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InterfaceVpcEndpointOptions")
@software.amazon.jsii.Jsii.Proxy(InterfaceVpcEndpointOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InterfaceVpcEndpointOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The service to use for this interface VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService();

    /**
     * Type of DNS records created for the VPC endpoint.
     * <p>
     * Default: not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.VpcEndpointDnsRecordIpType getDnsRecordIpType() {
        return null;
    }

    /**
     * The IP address type for the endpoint.
     * <p>
     * Default: not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.VpcEndpointIpAddressType getIpAddressType() {
        return null;
    }

    /**
     * Limit to only those availability zones where the endpoint service can be created.
     * <p>
     * Setting this to 'true' requires a lookup to be performed at synthesis time. Account
     * and region must be set on the containing stack for this to work.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getLookupSupportedAzs() {
        return null;
    }

    /**
     * Whether to automatically allow VPC traffic to the endpoint.
     * <p>
     * If enabled, all traffic to the endpoint from within the VPC will be
     * automatically allowed. This is done based on the VPC's CIDR range.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOpen() {
        return null;
    }

    /**
     * Whether to associate a private hosted zone with the specified VPC.
     * <p>
     * This
     * allows you to make requests to the service using its default DNS hostname.
     * <p>
     * Default: set by the instance of IInterfaceVpcEndpointService, or true if
     * not defined by the instance of IInterfaceVpcEndpointService
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivateDnsEnabled() {
        return null;
    }

    /**
     * Whether to enable private DNS only for inbound endpoints.
     * <p>
     * Default: not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.VpcEndpointPrivateDnsOnlyForInboundResolverEndpoint getPrivateDnsOnlyForInboundResolverEndpoint() {
        return null;
    }

    /**
     * The security groups to associate with this interface VPC endpoint.
     * <p>
     * Default: - a new security group is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * The region where the VPC endpoint service is located.
     * <p>
     * Only needs to be specified for cross-region VPC endpoints.
     * <p>
     * Default: - Same region as the interface VPC endpoint
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceRegion() {
        return null;
    }

    /**
     * The subnets in which to create an endpoint network interface.
     * <p>
     * At most one
     * per availability zone.
     * <p>
     * Default: - private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InterfaceVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InterfaceVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InterfaceVpcEndpointOptions> {
        software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service;
        software.amazon.awscdk.services.ec2.VpcEndpointDnsRecordIpType dnsRecordIpType;
        software.amazon.awscdk.services.ec2.VpcEndpointIpAddressType ipAddressType;
        java.lang.Boolean lookupSupportedAzs;
        java.lang.Boolean open;
        java.lang.Boolean privateDnsEnabled;
        software.amazon.awscdk.services.ec2.VpcEndpointPrivateDnsOnlyForInboundResolverEndpoint privateDnsOnlyForInboundResolverEndpoint;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        java.lang.String serviceRegion;
        software.amazon.awscdk.services.ec2.SubnetSelection subnets;

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getService}
         * @param service The service to use for this interface VPC endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getDnsRecordIpType}
         * @param dnsRecordIpType Type of DNS records created for the VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsRecordIpType(software.amazon.awscdk.services.ec2.VpcEndpointDnsRecordIpType dnsRecordIpType) {
            this.dnsRecordIpType = dnsRecordIpType;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getIpAddressType}
         * @param ipAddressType The IP address type for the endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(software.amazon.awscdk.services.ec2.VpcEndpointIpAddressType ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getLookupSupportedAzs}
         * @param lookupSupportedAzs Limit to only those availability zones where the endpoint service can be created.
         *                           Setting this to 'true' requires a lookup to be performed at synthesis time. Account
         *                           and region must be set on the containing stack for this to work.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupSupportedAzs(java.lang.Boolean lookupSupportedAzs) {
            this.lookupSupportedAzs = lookupSupportedAzs;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getOpen}
         * @param open Whether to automatically allow VPC traffic to the endpoint.
         *             If enabled, all traffic to the endpoint from within the VPC will be
         *             automatically allowed. This is done based on the VPC's CIDR range.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder open(java.lang.Boolean open) {
            this.open = open;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getPrivateDnsEnabled}
         * @param privateDnsEnabled Whether to associate a private hosted zone with the specified VPC.
         *                          This
         *                          allows you to make requests to the service using its default DNS hostname.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsEnabled(java.lang.Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getPrivateDnsOnlyForInboundResolverEndpoint}
         * @param privateDnsOnlyForInboundResolverEndpoint Whether to enable private DNS only for inbound endpoints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateDnsOnlyForInboundResolverEndpoint(software.amazon.awscdk.services.ec2.VpcEndpointPrivateDnsOnlyForInboundResolverEndpoint privateDnsOnlyForInboundResolverEndpoint) {
            this.privateDnsOnlyForInboundResolverEndpoint = privateDnsOnlyForInboundResolverEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getSecurityGroups}
         * @param securityGroups The security groups to associate with this interface VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getServiceRegion}
         * @param serviceRegion The region where the VPC endpoint service is located.
         *                      Only needs to be specified for cross-region VPC endpoints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRegion(java.lang.String serviceRegion) {
            this.serviceRegion = serviceRegion;
            return this;
        }

        /**
         * Sets the value of {@link InterfaceVpcEndpointOptions#getSubnets}
         * @param subnets The subnets in which to create an endpoint network interface.
         *                At most one
         *                per availability zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(software.amazon.awscdk.services.ec2.SubnetSelection subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InterfaceVpcEndpointOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InterfaceVpcEndpointOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InterfaceVpcEndpointOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InterfaceVpcEndpointOptions {
        private final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService service;
        private final software.amazon.awscdk.services.ec2.VpcEndpointDnsRecordIpType dnsRecordIpType;
        private final software.amazon.awscdk.services.ec2.VpcEndpointIpAddressType ipAddressType;
        private final java.lang.Boolean lookupSupportedAzs;
        private final java.lang.Boolean open;
        private final java.lang.Boolean privateDnsEnabled;
        private final software.amazon.awscdk.services.ec2.VpcEndpointPrivateDnsOnlyForInboundResolverEndpoint privateDnsOnlyForInboundResolverEndpoint;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.lang.String serviceRegion;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService.class));
            this.dnsRecordIpType = software.amazon.jsii.Kernel.get(this, "dnsRecordIpType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpcEndpointDnsRecordIpType.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpcEndpointIpAddressType.class));
            this.lookupSupportedAzs = software.amazon.jsii.Kernel.get(this, "lookupSupportedAzs", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.open = software.amazon.jsii.Kernel.get(this, "open", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.privateDnsEnabled = software.amazon.jsii.Kernel.get(this, "privateDnsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.privateDnsOnlyForInboundResolverEndpoint = software.amazon.jsii.Kernel.get(this, "privateDnsOnlyForInboundResolverEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.VpcEndpointPrivateDnsOnlyForInboundResolverEndpoint.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.serviceRegion = software.amazon.jsii.Kernel.get(this, "serviceRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.dnsRecordIpType = builder.dnsRecordIpType;
            this.ipAddressType = builder.ipAddressType;
            this.lookupSupportedAzs = builder.lookupSupportedAzs;
            this.open = builder.open;
            this.privateDnsEnabled = builder.privateDnsEnabled;
            this.privateDnsOnlyForInboundResolverEndpoint = builder.privateDnsOnlyForInboundResolverEndpoint;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.serviceRegion = builder.serviceRegion;
            this.subnets = builder.subnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpointService getService() {
            return this.service;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.VpcEndpointDnsRecordIpType getDnsRecordIpType() {
            return this.dnsRecordIpType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.VpcEndpointIpAddressType getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.Boolean getLookupSupportedAzs() {
            return this.lookupSupportedAzs;
        }

        @Override
        public final java.lang.Boolean getOpen() {
            return this.open;
        }

        @Override
        public final java.lang.Boolean getPrivateDnsEnabled() {
            return this.privateDnsEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.VpcEndpointPrivateDnsOnlyForInboundResolverEndpoint getPrivateDnsOnlyForInboundResolverEndpoint() {
            return this.privateDnsOnlyForInboundResolverEndpoint;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.String getServiceRegion() {
            return this.serviceRegion;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnets() {
            return this.subnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("service", om.valueToTree(this.getService()));
            if (this.getDnsRecordIpType() != null) {
                data.set("dnsRecordIpType", om.valueToTree(this.getDnsRecordIpType()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getLookupSupportedAzs() != null) {
                data.set("lookupSupportedAzs", om.valueToTree(this.getLookupSupportedAzs()));
            }
            if (this.getOpen() != null) {
                data.set("open", om.valueToTree(this.getOpen()));
            }
            if (this.getPrivateDnsEnabled() != null) {
                data.set("privateDnsEnabled", om.valueToTree(this.getPrivateDnsEnabled()));
            }
            if (this.getPrivateDnsOnlyForInboundResolverEndpoint() != null) {
                data.set("privateDnsOnlyForInboundResolverEndpoint", om.valueToTree(this.getPrivateDnsOnlyForInboundResolverEndpoint()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getServiceRegion() != null) {
                data.set("serviceRegion", om.valueToTree(this.getServiceRegion()));
            }
            if (this.getSubnets() != null) {
                data.set("subnets", om.valueToTree(this.getSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.InterfaceVpcEndpointOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InterfaceVpcEndpointOptions.Jsii$Proxy that = (InterfaceVpcEndpointOptions.Jsii$Proxy) o;

            if (!service.equals(that.service)) return false;
            if (this.dnsRecordIpType != null ? !this.dnsRecordIpType.equals(that.dnsRecordIpType) : that.dnsRecordIpType != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.lookupSupportedAzs != null ? !this.lookupSupportedAzs.equals(that.lookupSupportedAzs) : that.lookupSupportedAzs != null) return false;
            if (this.open != null ? !this.open.equals(that.open) : that.open != null) return false;
            if (this.privateDnsEnabled != null ? !this.privateDnsEnabled.equals(that.privateDnsEnabled) : that.privateDnsEnabled != null) return false;
            if (this.privateDnsOnlyForInboundResolverEndpoint != null ? !this.privateDnsOnlyForInboundResolverEndpoint.equals(that.privateDnsOnlyForInboundResolverEndpoint) : that.privateDnsOnlyForInboundResolverEndpoint != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.serviceRegion != null ? !this.serviceRegion.equals(that.serviceRegion) : that.serviceRegion != null) return false;
            return this.subnets != null ? this.subnets.equals(that.subnets) : that.subnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.service.hashCode();
            result = 31 * result + (this.dnsRecordIpType != null ? this.dnsRecordIpType.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.lookupSupportedAzs != null ? this.lookupSupportedAzs.hashCode() : 0);
            result = 31 * result + (this.open != null ? this.open.hashCode() : 0);
            result = 31 * result + (this.privateDnsEnabled != null ? this.privateDnsEnabled.hashCode() : 0);
            result = 31 * result + (this.privateDnsOnlyForInboundResolverEndpoint != null ? this.privateDnsOnlyForInboundResolverEndpoint.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.serviceRegion != null ? this.serviceRegion.hashCode() : 0);
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            return result;
        }
    }
}
