package software.amazon.awscdk.services.ec2;

/**
 * Provider for NAT Gateways.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * NatGatewayProvider natGatewayProvider = NatGatewayProvider.Builder.create()
 *         .eipAllocationIds(List.of("eipAllocationIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:30.577Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.NatGatewayProvider")
public class NatGatewayProvider extends software.amazon.awscdk.services.ec2.NatProvider {

    protected NatGatewayProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NatGatewayProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NatGatewayProvider(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.NatGatewayProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NatGatewayProvider() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Called by the VPC to configure NAT.
     * <p>
     * Don't call this directly, the VPC will call it automatically.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void configureNat(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ConfigureNatOptions options) {
        software.amazon.jsii.Kernel.call(this, "configureNat", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Configures subnet with the gateway.
     * <p>
     * Don't call this directly, the VPC will call it automatically.
     * <p>
     * @param subnet This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void configureSubnet(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.PrivateSubnet subnet) {
        software.amazon.jsii.Kernel.call(this, "configureSubnet", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(subnet, "subnet is required") });
    }

    /**
     * Return list of gateways spawned by the provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.GatewayConfig> getConfiguredGateways() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "configuredGateways", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.GatewayConfig.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.NatGatewayProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.NatGatewayProvider> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.ec2.NatGatewayProps.Builder props;

        private Builder() {
        }

        /**
         * EIP allocation IDs for the NAT gateways.
         * <p>
         * Default: - No fixed EIPs allocated for the NAT gateways
         * <p>
         * @return {@code this}
         * @param eipAllocationIds EIP allocation IDs for the NAT gateways. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eipAllocationIds(final java.util.List<java.lang.String> eipAllocationIds) {
            this.props().eipAllocationIds(eipAllocationIds);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.NatGatewayProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.NatGatewayProvider build() {
            return new software.amazon.awscdk.services.ec2.NatGatewayProvider(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ec2.NatGatewayProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ec2.NatGatewayProps.Builder();
            }
            return this.props;
        }
    }
}
