package software.amazon.awscdk.services.ec2;

/**
 * Properties for a NAT instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * InstanceType instanceType;
 * NatInstanceProviderV2 provider = NatProvider.instanceV2(NatInstanceProps.builder()
 *         .instanceType(instanceType)
 *         .defaultAllowedTraffic(NatTrafficDirection.OUTBOUND_ONLY)
 *         .build());
 * Vpc.Builder.create(this, "TheVPC")
 *         .natGatewayProvider(provider)
 *         .build();
 * provider.connections.allowFrom(Peer.ipv4("1.2.3.4/8"), Port.HTTP);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:30.577Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.NatInstanceProps")
@software.amazon.jsii.Jsii.Proxy(NatInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NatInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Instance type of the NAT instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * Whether to associate a public IP address to the primary network interface attached to this instance.
     * <p>
     * Default: undefined - No public IP address associated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssociatePublicIpAddress() {
        return null;
    }

    /**
     * Specifying the CPU credit type for burstable EC2 instance types (T2, T3, T3a, etc).
     * <p>
     * The unlimited CPU credit option is not supported for T3 instances with dedicated host (<code>host</code>) tenancy.
     * <p>
     * Default: - T2 instances are standard, while T3, T4g, and T3a instances are unlimited.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CpuCredits getCreditSpecification() {
        return null;
    }

    /**
     * Direction to allow all traffic through the NAT instance by default.
     * <p>
     * By default, inbound and outbound traffic is allowed.
     * <p>
     * If you set this to another value than INBOUND_AND_OUTBOUND, you must
     * configure the NAT instance's security groups in another way, either by
     * passing in a fully configured Security Group using the <code>securityGroup</code>
     * property, or by configuring it using the <code>.securityGroup</code> or
     * <code>.connections</code> members after passing the NAT Instance Provider to a Vpc.
     * <p>
     * Default: NatTrafficDirection.INBOUND_AND_OUTBOUND
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.NatTrafficDirection getDefaultAllowedTraffic() {
        return null;
    }

    /**
     * (deprecated) Name of SSH keypair to grant access to instance.
     * <p>
     * Default: - No SSH access will be possible.
     * <p>
     * @deprecated <ul>
     * <li>Use <code>keyPair</code> instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * The SSH keypair to grant access to the instance.
     * <p>
     * Default: - No SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IKeyPair getKeyPair() {
        return null;
    }

    /**
     * The machine image (AMI) to use.
     * <p>
     * By default, will do an AMI lookup for the latest NAT instance image.
     * <p>
     * If you have a specific AMI ID you want to use, pass a <code>GenericLinuxImage</code>. For example:
     * <p>
     * <blockquote><pre>
     * NatProvider.instance(NatInstanceProps.builder()
     *         .instanceType(new InstanceType("t3.micro"))
     *         .machineImage(new GenericLinuxImage(Map.of(
     *                 "us-east-2", "ami-0f9c61b5a562a16af")))
     *         .build());
     * </pre></blockquote>
     * <p>
     * Default: - Latest NAT instance image
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
        return null;
    }

    /**
     * (deprecated) Security Group for NAT instances.
     * <p>
     * Default: - A new security group will be created
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * NatInstanceProviderV2 natGatewayProvider = NatProvider.instanceV2(NatInstanceProps.builder()
     *         .instanceType(new InstanceType("t3.small"))
     *         .defaultAllowedTraffic(NatTrafficDirection.NONE)
     *         .build());
     * Vpc vpc = Vpc.Builder.create(this, "Vpc").natGatewayProvider(natGatewayProvider).build();
     * SecurityGroup securityGroup = SecurityGroup.Builder.create(this, "SecurityGroup")
     *         .vpc(vpc)
     *         .allowAllOutbound(false)
     *         .build();
     * securityGroup.addEgressRule(Peer.anyIpv4(), Port.tcp(443));
     * for (Object gatewayInstance : natGatewayProvider.getGatewayInstances()) {
     *     gatewayInstance.addSecurityGroup(securityGroup);
     * }
     * </pre></blockquote>
     * <p>
     * @deprecated - Cannot create a new security group before the VPC is created,
     * and cannot create the VPC without the NAT provider.
     * Set {@link defaultAllowedTraffic } to {@link NatTrafficDirection.NONE }
     * and use {@link NatInstanceProviderV2.gatewayInstances } to retrieve
     * the instances on the fly and add security groups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * Custom user data to run on the NAT instances.
     * <p>
     * Default: UserData.forLinux().addCommands(...NatInstanceProviderV2.DEFAULT_USER_DATA_COMMANDS);  - Appropriate user data commands to initialize and configure the NAT instances
     * <p>
     * @see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_NAT_Instance.html#create-nat-ami">https://docs.aws.amazon.com/vpc/latest/userguide/VPC_NAT_Instance.html#create-nat-ami</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData getUserData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NatInstanceProps> {
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        java.lang.Boolean associatePublicIpAddress;
        software.amazon.awscdk.services.ec2.CpuCredits creditSpecification;
        software.amazon.awscdk.services.ec2.NatTrafficDirection defaultAllowedTraffic;
        java.lang.String keyName;
        software.amazon.awscdk.services.ec2.IKeyPair keyPair;
        software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        software.amazon.awscdk.services.ec2.UserData userData;

        /**
         * Sets the value of {@link NatInstanceProps#getInstanceType}
         * @param instanceType Instance type of the NAT instance. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getAssociatePublicIpAddress}
         * @param associatePublicIpAddress Whether to associate a public IP address to the primary network interface attached to this instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getCreditSpecification}
         * @param creditSpecification Specifying the CPU credit type for burstable EC2 instance types (T2, T3, T3a, etc).
         *                            The unlimited CPU credit option is not supported for T3 instances with dedicated host (<code>host</code>) tenancy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creditSpecification(software.amazon.awscdk.services.ec2.CpuCredits creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getDefaultAllowedTraffic}
         * @param defaultAllowedTraffic Direction to allow all traffic through the NAT instance by default.
         *                              By default, inbound and outbound traffic is allowed.
         *                              <p>
         *                              If you set this to another value than INBOUND_AND_OUTBOUND, you must
         *                              configure the NAT instance's security groups in another way, either by
         *                              passing in a fully configured Security Group using the <code>securityGroup</code>
         *                              property, or by configuring it using the <code>.securityGroup</code> or
         *                              <code>.connections</code> members after passing the NAT Instance Provider to a Vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAllowedTraffic(software.amazon.awscdk.services.ec2.NatTrafficDirection defaultAllowedTraffic) {
            this.defaultAllowedTraffic = defaultAllowedTraffic;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instance.
         * @return {@code this}
         * @deprecated - Use `keyPair` instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getKeyPair}
         * @param keyPair The SSH keypair to grant access to the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(software.amazon.awscdk.services.ec2.IKeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getMachineImage}
         * @param machineImage The machine image (AMI) to use.
         *                     By default, will do an AMI lookup for the latest NAT instance image.
         *                     <p>
         *                     If you have a specific AMI ID you want to use, pass a <code>GenericLinuxImage</code>. For example:
         *                     <p>
         *                     <blockquote><pre>
         *                     NatProvider.instance(NatInstanceProps.builder()
         *                             .instanceType(new InstanceType("t3.micro"))
         *                             .machineImage(new GenericLinuxImage(Map.of(
         *                                     "us-east-2", "ami-0f9c61b5a562a16af")))
         *                             .build());
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getSecurityGroup}
         * @param securityGroup Security Group for NAT instances.
         * @return {@code this}
         * @deprecated - Cannot create a new security group before the VPC is created,
and cannot create the VPC without the NAT provider.
Set {@link defaultAllowedTraffic } to {@link NatTrafficDirection.NONE }
and use {@link NatInstanceProviderV2.gatewayInstances } to retrieve
the instances on the fly and add security groups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link NatInstanceProps#getUserData}
         * @param userData Custom user data to run on the NAT instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NatInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NatInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NatInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NatInstanceProps {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final java.lang.Boolean associatePublicIpAddress;
        private final software.amazon.awscdk.services.ec2.CpuCredits creditSpecification;
        private final software.amazon.awscdk.services.ec2.NatTrafficDirection defaultAllowedTraffic;
        private final java.lang.String keyName;
        private final software.amazon.awscdk.services.ec2.IKeyPair keyPair;
        private final software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.UserData userData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.creditSpecification = software.amazon.jsii.Kernel.get(this, "creditSpecification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CpuCredits.class));
            this.defaultAllowedTraffic = software.amazon.jsii.Kernel.get(this, "defaultAllowedTraffic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.NatTrafficDirection.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyPair = software.amazon.jsii.Kernel.get(this, "keyPair", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IKeyPair.class));
            this.machineImage = software.amazon.jsii.Kernel.get(this, "machineImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.associatePublicIpAddress = builder.associatePublicIpAddress;
            this.creditSpecification = builder.creditSpecification;
            this.defaultAllowedTraffic = builder.defaultAllowedTraffic;
            this.keyName = builder.keyName;
            this.keyPair = builder.keyPair;
            this.machineImage = builder.machineImage;
            this.securityGroup = builder.securityGroup;
            this.userData = builder.userData;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.CpuCredits getCreditSpecification() {
            return this.creditSpecification;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.NatTrafficDirection getDefaultAllowedTraffic() {
            return this.defaultAllowedTraffic;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IKeyPair getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
            return this.machineImage;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getAssociatePublicIpAddress() != null) {
                data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
            }
            if (this.getCreditSpecification() != null) {
                data.set("creditSpecification", om.valueToTree(this.getCreditSpecification()));
            }
            if (this.getDefaultAllowedTraffic() != null) {
                data.set("defaultAllowedTraffic", om.valueToTree(this.getDefaultAllowedTraffic()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getKeyPair() != null) {
                data.set("keyPair", om.valueToTree(this.getKeyPair()));
            }
            if (this.getMachineImage() != null) {
                data.set("machineImage", om.valueToTree(this.getMachineImage()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.NatInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NatInstanceProps.Jsii$Proxy that = (NatInstanceProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
            if (this.creditSpecification != null ? !this.creditSpecification.equals(that.creditSpecification) : that.creditSpecification != null) return false;
            if (this.defaultAllowedTraffic != null ? !this.defaultAllowedTraffic.equals(that.defaultAllowedTraffic) : that.defaultAllowedTraffic != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.keyPair != null ? !this.keyPair.equals(that.keyPair) : that.keyPair != null) return false;
            if (this.machineImage != null ? !this.machineImage.equals(that.machineImage) : that.machineImage != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            return this.userData != null ? this.userData.equals(that.userData) : that.userData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
            result = 31 * result + (this.creditSpecification != null ? this.creditSpecification.hashCode() : 0);
            result = 31 * result + (this.defaultAllowedTraffic != null ? this.defaultAllowedTraffic.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.keyPair != null ? this.keyPair.hashCode() : 0);
            result = 31 * result + (this.machineImage != null ? this.machineImage.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            return result;
        }
    }
}
