package software.amazon.awscdk.services.ec2;

/**
 * Properties for creating a prefix list.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * PrefixList.Builder.create(this, "EmptyPrefixList")
 *         .maxEntries(100)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:30.591Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.PrefixListProps")
@software.amazon.jsii.Jsii.Proxy(PrefixListProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PrefixListProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.PrefixListOptions {

    /**
     * The address family of the prefix list.
     * <p>
     * Default: AddressFamily.IP_V4
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.AddressFamily getAddressFamily() {
        return null;
    }

    /**
     * The list of entries for the prefix list.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.CfnPrefixList.EntryProperty> getEntries() {
        return null;
    }

    /**
     * The name of the prefix list.
     * <p>
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrefixListName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PrefixListProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PrefixListProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PrefixListProps> {
        software.amazon.awscdk.services.ec2.AddressFamily addressFamily;
        java.util.List<software.amazon.awscdk.services.ec2.CfnPrefixList.EntryProperty> entries;
        java.lang.String prefixListName;
        java.lang.Number maxEntries;

        /**
         * Sets the value of {@link PrefixListProps#getAddressFamily}
         * @param addressFamily The address family of the prefix list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addressFamily(software.amazon.awscdk.services.ec2.AddressFamily addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        /**
         * Sets the value of {@link PrefixListProps#getEntries}
         * @param entries The list of entries for the prefix list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder entries(java.util.List<? extends software.amazon.awscdk.services.ec2.CfnPrefixList.EntryProperty> entries) {
            this.entries = (java.util.List<software.amazon.awscdk.services.ec2.CfnPrefixList.EntryProperty>)entries;
            return this;
        }

        /**
         * Sets the value of {@link PrefixListProps#getPrefixListName}
         * @param prefixListName The name of the prefix list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefixListName(java.lang.String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        /**
         * Sets the value of {@link PrefixListProps#getMaxEntries}
         * @param maxEntries The maximum number of entries for the prefix list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEntries(java.lang.Number maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PrefixListProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PrefixListProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PrefixListProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrefixListProps {
        private final software.amazon.awscdk.services.ec2.AddressFamily addressFamily;
        private final java.util.List<software.amazon.awscdk.services.ec2.CfnPrefixList.EntryProperty> entries;
        private final java.lang.String prefixListName;
        private final java.lang.Number maxEntries;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addressFamily = software.amazon.jsii.Kernel.get(this, "addressFamily", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AddressFamily.class));
            this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CfnPrefixList.EntryProperty.class)));
            this.prefixListName = software.amazon.jsii.Kernel.get(this, "prefixListName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxEntries = software.amazon.jsii.Kernel.get(this, "maxEntries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addressFamily = builder.addressFamily;
            this.entries = (java.util.List<software.amazon.awscdk.services.ec2.CfnPrefixList.EntryProperty>)builder.entries;
            this.prefixListName = builder.prefixListName;
            this.maxEntries = builder.maxEntries;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.AddressFamily getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.CfnPrefixList.EntryProperty> getEntries() {
            return this.entries;
        }

        @Override
        public final java.lang.String getPrefixListName() {
            return this.prefixListName;
        }

        @Override
        public final java.lang.Number getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAddressFamily() != null) {
                data.set("addressFamily", om.valueToTree(this.getAddressFamily()));
            }
            if (this.getEntries() != null) {
                data.set("entries", om.valueToTree(this.getEntries()));
            }
            if (this.getPrefixListName() != null) {
                data.set("prefixListName", om.valueToTree(this.getPrefixListName()));
            }
            if (this.getMaxEntries() != null) {
                data.set("maxEntries", om.valueToTree(this.getMaxEntries()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.PrefixListProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PrefixListProps.Jsii$Proxy that = (PrefixListProps.Jsii$Proxy) o;

            if (this.addressFamily != null ? !this.addressFamily.equals(that.addressFamily) : that.addressFamily != null) return false;
            if (this.entries != null ? !this.entries.equals(that.entries) : that.entries != null) return false;
            if (this.prefixListName != null ? !this.prefixListName.equals(that.prefixListName) : that.prefixListName != null) return false;
            return this.maxEntries != null ? this.maxEntries.equals(that.maxEntries) : that.maxEntries == null;
        }

        @Override
        public final int hashCode() {
            int result = this.addressFamily != null ? this.addressFamily.hashCode() : 0;
            result = 31 * result + (this.entries != null ? this.entries.hashCode() : 0);
            result = 31 * result + (this.prefixListName != null ? this.prefixListName.hashCode() : 0);
            result = 31 * result + (this.maxEntries != null ? this.maxEntries.hashCode() : 0);
            return result;
        }
    }
}
