package software.amazon.awscdk.services.ec2;

/**
 * CIDR Allocated Subnets.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * SubnetIpamOptions subnetIpamOptions = SubnetIpamOptions.builder()
 *         .allocatedSubnets(List.of(AllocatedSubnet.builder()
 *                 .cidr("cidr")
 *                 // the properties below are optional
 *                 .ipv6Cidr("ipv6Cidr")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:30.616Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.SubnetIpamOptions")
@software.amazon.jsii.Jsii.Proxy(SubnetIpamOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubnetIpamOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * CIDR Allocations for Subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet> getAllocatedSubnets();

    /**
     * @return a {@link Builder} of {@link SubnetIpamOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubnetIpamOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubnetIpamOptions> {
        java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet> allocatedSubnets;

        /**
         * Sets the value of {@link SubnetIpamOptions#getAllocatedSubnets}
         * @param allocatedSubnets CIDR Allocations for Subnets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder allocatedSubnets(java.util.List<? extends software.amazon.awscdk.services.ec2.AllocatedSubnet> allocatedSubnets) {
            this.allocatedSubnets = (java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet>)allocatedSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubnetIpamOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubnetIpamOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubnetIpamOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubnetIpamOptions {
        private final java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet> allocatedSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allocatedSubnets = software.amazon.jsii.Kernel.get(this, "allocatedSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AllocatedSubnet.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allocatedSubnets = (java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet>)java.util.Objects.requireNonNull(builder.allocatedSubnets, "allocatedSubnets is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet> getAllocatedSubnets() {
            return this.allocatedSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allocatedSubnets", om.valueToTree(this.getAllocatedSubnets()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.SubnetIpamOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubnetIpamOptions.Jsii$Proxy that = (SubnetIpamOptions.Jsii$Proxy) o;

            return this.allocatedSubnets.equals(that.allocatedSubnets);
        }

        @Override
        public final int hashCode() {
            int result = this.allocatedSubnets.hashCode();
            return result;
        }
    }
}
