package software.amazon.awscdk.services.ecs;

/**
 * A log driver that sends log information to CloudWatch Logs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * // Create a Task Definition for the container to start
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromAsset(resolve(__dirname, "..", "eventhandler-image")))
 *         .memoryLimitMiB(256)
 *         .logging(AwsLogDriver.Builder.create().streamPrefix("EventDemo").mode(AwsLogDriverMode.NON_BLOCKING).build())
 *         .build());
 * // An Rule that describes the event trigger (in this case a scheduled run)
 * Rule rule = Rule.Builder.create(this, "Rule")
 *         .schedule(Schedule.expression("rate(1 minute)"))
 *         .build();
 * // Pass an environment variable to the container 'TheContainer' in the task
 * rule.addTarget(EcsTask.Builder.create()
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .taskCount(1)
 *         .containerOverrides(List.of(ContainerOverride.builder()
 *                 .containerName("TheContainer")
 *                 .environment(List.of(TaskEnvironmentVariable.builder()
 *                         .name("I_WAS_TRIGGERED")
 *                         .value("From CloudWatch Events")
 *                         .build()))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:30.763Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AwsLogDriver")
public class AwsLogDriver extends software.amazon.awscdk.services.ecs.LogDriver {

    protected AwsLogDriver(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AwsLogDriver(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the AwsLogDriver class.
     * <p>
     * @param props the awslogs log driver configuration options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AwsLogDriver(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AwsLogDriverProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called when the log driver is configured on a container.
     * <p>
     * @param scope This parameter is required.
     * @param containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriverConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(containerDefinition, "containerDefinition is required") });
    }

    /**
     * The log group to send log streams to.
     * <p>
     * Only available after the LogDriver has been bound to a ContainerDefinition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
    }

    /**
     * The log group to send log streams to.
     * <p>
     * Only available after the LogDriver has been bound to a ContainerDefinition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogGroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup value) {
        software.amazon.jsii.Kernel.set(this, "logGroup", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.AwsLogDriver}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.AwsLogDriver> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ecs.AwsLogDriverProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ecs.AwsLogDriverProps.Builder();
        }

        /**
         * Prefix for the log streams.
         * <p>
         * The awslogs-stream-prefix option allows you to associate a log stream
         * with the specified prefix, the container name, and the ID of the Amazon
         * ECS task to which the container belongs. If you specify a prefix with
         * this option, then the log stream takes the following format:
         * <p>
         * <blockquote><pre>
         * prefix-name/container-name/ecs-task-id
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param streamPrefix Prefix for the log streams. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamPrefix(final java.lang.String streamPrefix) {
            this.props.streamPrefix(streamPrefix);
            return this;
        }

        /**
         * This option defines a multiline start pattern in Python strftime format.
         * <p>
         * A log message consists of a line that matches the pattern and any
         * following lines that don’t match the pattern. Thus the matched line is
         * the delimiter between log messages.
         * <p>
         * Default: - No multiline matching.
         * <p>
         * @return {@code this}
         * @param datetimeFormat This option defines a multiline start pattern in Python strftime format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datetimeFormat(final java.lang.String datetimeFormat) {
            this.props.datetimeFormat(datetimeFormat);
            return this;
        }

        /**
         * The log group to log to.
         * <p>
         * Default: - A log group is automatically created.
         * <p>
         * @return {@code this}
         * @param logGroup The log group to log to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(final software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.props.logGroup(logGroup);
            return this;
        }

        /**
         * The number of days log events are kept in CloudWatch Logs when the log group is automatically created by this construct.
         * <p>
         * Default: - Logs never expire.
         * <p>
         * @return {@code this}
         * @param logRetention The number of days log events are kept in CloudWatch Logs when the log group is automatically created by this construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(final software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        /**
         * When AwsLogDriverMode.NON_BLOCKING is configured, this parameter controls the size of the non-blocking buffer used to temporarily store messages. This parameter is not valid with AwsLogDriverMode.BLOCKING.
         * <p>
         * Default: - 1 megabyte if driver mode is non-blocking, otherwise this property is not set
         * <p>
         * @return {@code this}
         * @param maxBufferSize When AwsLogDriverMode.NON_BLOCKING is configured, this parameter controls the size of the non-blocking buffer used to temporarily store messages. This parameter is not valid with AwsLogDriverMode.BLOCKING. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBufferSize(final software.amazon.awscdk.Size maxBufferSize) {
            this.props.maxBufferSize(maxBufferSize);
            return this;
        }

        /**
         * The delivery mode of log messages from the container to awslogs.
         * <p>
         * Default: - AwsLogDriverMode.BLOCKING
         * <p>
         * @return {@code this}
         * @param mode The delivery mode of log messages from the container to awslogs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(final software.amazon.awscdk.services.ecs.AwsLogDriverMode mode) {
            this.props.mode(mode);
            return this;
        }

        /**
         * This option defines a multiline start pattern using a regular expression.
         * <p>
         * A log message consists of a line that matches the pattern and any
         * following lines that don’t match the pattern. Thus the matched line is
         * the delimiter between log messages.
         * <p>
         * This option is ignored if datetimeFormat is also configured.
         * <p>
         * Default: - No multiline matching.
         * <p>
         * @return {@code this}
         * @param multilinePattern This option defines a multiline start pattern using a regular expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multilinePattern(final java.lang.String multilinePattern) {
            this.props.multilinePattern(multilinePattern);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.AwsLogDriver}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.AwsLogDriver build() {
            return new software.amazon.awscdk.services.ecs.AwsLogDriver(
                this.props.build()
            );
        }
    }
}
