package software.amazon.awscdk.services.ecs;

/**
 * The deployment stratergy to use for ECS controller.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Function lambdaHook;
 * ApplicationTargetGroup blueTargetGroup;
 * ApplicationTargetGroup greenTargetGroup;
 * ApplicationListenerRule prodListenerRule;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .deploymentStrategy(DeploymentStrategy.BLUE_GREEN)
 *         .build();
 * service.addLifecycleHook(DeploymentLifecycleLambdaTarget.Builder.create(lambdaHook, "PreScaleHook")
 *         .lifecycleStages(List.of(DeploymentLifecycleStage.PRE_SCALE_UP))
 *         .build());
 * IEcsLoadBalancerTarget target = service.loadBalancerTarget(LoadBalancerTargetOptions.builder()
 *         .containerName("nginx")
 *         .containerPort(80)
 *         .protocol(Protocol.TCP)
 *         .alternateTarget(AlternateTarget.Builder.create("AlternateTarget")
 *                 .alternateTargetGroup(greenTargetGroup)
 *                 .productionListener(ListenerRuleConfiguration.applicationListenerRule(prodListenerRule))
 *                 .build())
 *         .build());
 * target.attachToApplicationTargetGroup(blueTargetGroup);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:30.942Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.DeploymentStrategy")
public enum DeploymentStrategy {
    /**
     * Rolling update deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ROLLING,
    /**
     * Blue/green deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BLUE_GREEN,
}
