package software.amazon.awscdk.services.ecs;

/**
 * Propagate tags for EBS Volume Configuration from either service or task definition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * FargateTaskDefinition taskDefinition = new FargateTaskDefinition(this, "TaskDef");
 * ContainerDefinition container = taskDefinition.addContainer("web", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .portMappings(List.of(PortMapping.builder()
 *                 .containerPort(80)
 *                 .protocol(Protocol.TCP)
 *                 .build()))
 *         .build());
 * ServiceManagedVolume volume = ServiceManagedVolume.Builder.create(this, "EBSVolume")
 *         .name("ebs1")
 *         .managedEBSVolume(ServiceManagedEBSVolumeConfiguration.builder()
 *                 .size(Size.gibibytes(15))
 *                 .volumeType(EbsDeviceVolumeType.GP3)
 *                 .fileSystemType(FileSystemType.XFS)
 *                 .tagSpecifications(List.of(EBSTagSpecification.builder()
 *                         .tags(Map.of(
 *                                 "purpose", "production"))
 *                         .propagateTags(EbsPropagatedTagSource.SERVICE)
 *                         .build()))
 *                 .build())
 *         .build();
 * volume.mountIn(container, ContainerMountPoint.builder()
 *         .containerPath("/var/lib")
 *         .readOnly(false)
 *         .build());
 * taskDefinition.addVolume(volume);
 * FargateService service = FargateService.Builder.create(this, "FargateService")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .minHealthyPercent(100)
 *         .build();
 * service.addVolume(volume);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:30.944Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.EbsPropagatedTagSource")
public enum EbsPropagatedTagSource {
    /**
     * SERVICE.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SERVICE,
    /**
     * TASK_DEFINITION.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TASK_DEFINITION,
}
