package software.amazon.awscdk.services.ecs;

/**
 * A log driver that sends log information to splunk Logs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * Secret secret;
 * SplunkLogDriver splunkLogDriver = SplunkLogDriver.Builder.create()
 *         .secretToken(secret)
 *         .url("url")
 *         // the properties below are optional
 *         .caName("caName")
 *         .caPath("caPath")
 *         .env(List.of("env"))
 *         .envRegex("envRegex")
 *         .format(SplunkLogFormat.INLINE)
 *         .gzip(false)
 *         .gzipLevel(123)
 *         .index("index")
 *         .insecureSkipVerify("insecureSkipVerify")
 *         .labels(List.of("labels"))
 *         .source("source")
 *         .sourceType("sourceType")
 *         .tag("tag")
 *         .verifyConnection(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:31.053Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.SplunkLogDriver")
public class SplunkLogDriver extends software.amazon.awscdk.services.ecs.LogDriver {

    protected SplunkLogDriver(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SplunkLogDriver(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the SplunkLogDriver class.
     * <p>
     * @param props the splunk log driver configuration options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SplunkLogDriver(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.SplunkLogDriverProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called when the log driver is configured on a container.
     * <p>
     * @param _scope This parameter is required.
     * @param _containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriverConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition _containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_containerDefinition, "_containerDefinition is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.SplunkLogDriver}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.SplunkLogDriver> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ecs.SplunkLogDriverProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ecs.SplunkLogDriverProps.Builder();
        }

        /**
         * The env option takes an array of keys.
         * <p>
         * If there is collision between
         * label and env keys, the value of the env takes precedence. Adds additional fields
         * to the extra attributes of a logging message.
         * <p>
         * Default: - No env
         * <p>
         * @return {@code this}
         * @param env The env option takes an array of keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(final java.util.List<java.lang.String> env) {
            this.props.env(env);
            return this;
        }

        /**
         * The env-regex option is similar to and compatible with env.
         * <p>
         * Its value is a regular
         * expression to match logging-related environment variables. It is used for advanced
         * log tag options.
         * <p>
         * Default: - No envRegex
         * <p>
         * @return {@code this}
         * @param envRegex The env-regex option is similar to and compatible with env. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder envRegex(final java.lang.String envRegex) {
            this.props.envRegex(envRegex);
            return this;
        }

        /**
         * The labels option takes an array of keys.
         * <p>
         * If there is collision
         * between label and env keys, the value of the env takes precedence. Adds additional
         * fields to the extra attributes of a logging message.
         * <p>
         * Default: - No labels
         * <p>
         * @return {@code this}
         * @param labels The labels option takes an array of keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(final java.util.List<java.lang.String> labels) {
            this.props.labels(labels);
            return this;
        }

        /**
         * By default, Docker uses the first 12 characters of the container ID to tag log messages.
         * <p>
         * Refer to the log tag option documentation for customizing the
         * log tag format.
         * <p>
         * Default: - The first 12 characters of the container ID
         * <p>
         * @return {@code this}
         * @param tag By default, Docker uses the first 12 characters of the container ID to tag log messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tag(final java.lang.String tag) {
            this.props.tag(tag);
            return this;
        }

        /**
         * Splunk HTTP Event Collector token (Secret).
         * <p>
         * The splunk-token is added to the SecretOptions property of the Log Driver Configuration. So the secret value will not be
         * resolved or viewable as plain text.
         * <p>
         * @return {@code this}
         * @param secretToken Splunk HTTP Event Collector token (Secret). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretToken(final software.amazon.awscdk.services.ecs.Secret secretToken) {
            this.props.secretToken(secretToken);
            return this;
        }

        /**
         * Path to your Splunk Enterprise, self-service Splunk Cloud instance, or Splunk Cloud managed cluster (including port and scheme used by HTTP Event Collector) in one of the following formats: https://your_splunk_instance:8088 or https://input-prd-p-XXXXXXX.cloud.splunk.com:8088 or https://http-inputs-XXXXXXXX.splunkcloud.com.
         * <p>
         * @return {@code this}
         * @param url Path to your Splunk Enterprise, self-service Splunk Cloud instance, or Splunk Cloud managed cluster (including port and scheme used by HTTP Event Collector) in one of the following formats: https://your_splunk_instance:8088 or https://input-prd-p-XXXXXXX.cloud.splunk.com:8088 or https://http-inputs-XXXXXXXX.splunkcloud.com. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder url(final java.lang.String url) {
            this.props.url(url);
            return this;
        }

        /**
         * Name to use for validating server certificate.
         * <p>
         * Default: - The hostname of the splunk-url
         * <p>
         * @return {@code this}
         * @param caName Name to use for validating server certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caName(final java.lang.String caName) {
            this.props.caName(caName);
            return this;
        }

        /**
         * Path to root certificate.
         * <p>
         * Default: - caPath not set.
         * <p>
         * @return {@code this}
         * @param caPath Path to root certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caPath(final java.lang.String caPath) {
            this.props.caPath(caPath);
            return this;
        }

        /**
         * Message format.
         * <p>
         * Can be inline, json or raw.
         * <p>
         * Default: - inline
         * <p>
         * @return {@code this}
         * @param format Message format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder format(final software.amazon.awscdk.services.ecs.SplunkLogFormat format) {
            this.props.format(format);
            return this;
        }

        /**
         * Enable/disable gzip compression to send events to Splunk Enterprise or Splunk Cloud instance.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param gzip Enable/disable gzip compression to send events to Splunk Enterprise or Splunk Cloud instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gzip(final java.lang.Boolean gzip) {
            this.props.gzip(gzip);
            return this;
        }

        /**
         * Set compression level for gzip.
         * <p>
         * Valid values are -1 (default), 0 (no compression),
         * 1 (best speed) ... 9 (best compression).
         * <p>
         * Default: - -1 (Default Compression)
         * <p>
         * @return {@code this}
         * @param gzipLevel Set compression level for gzip. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gzipLevel(final java.lang.Number gzipLevel) {
            this.props.gzipLevel(gzipLevel);
            return this;
        }

        /**
         * Event index.
         * <p>
         * Default: - index not set.
         * <p>
         * @return {@code this}
         * @param index Event index. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder index(final java.lang.String index) {
            this.props.index(index);
            return this;
        }

        /**
         * Ignore server certificate validation.
         * <p>
         * Default: - insecureSkipVerify not set.
         * <p>
         * @return {@code this}
         * @param insecureSkipVerify Ignore server certificate validation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insecureSkipVerify(final java.lang.String insecureSkipVerify) {
            this.props.insecureSkipVerify(insecureSkipVerify);
            return this;
        }

        /**
         * Event source.
         * <p>
         * Default: - source not set.
         * <p>
         * @return {@code this}
         * @param source Event source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final java.lang.String source) {
            this.props.source(source);
            return this;
        }

        /**
         * Event source type.
         * <p>
         * Default: - sourceType not set.
         * <p>
         * @return {@code this}
         * @param sourceType Event source type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceType(final java.lang.String sourceType) {
            this.props.sourceType(sourceType);
            return this;
        }

        /**
         * Verify on start, that docker can connect to Splunk server.
         * <p>
         * Default: - true
         * <p>
         * @return {@code this}
         * @param verifyConnection Verify on start, that docker can connect to Splunk server. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verifyConnection(final java.lang.Boolean verifyConnection) {
            this.props.verifyConnection(verifyConnection);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.SplunkLogDriver}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.SplunkLogDriver build() {
            return new software.amazon.awscdk.services.ecs.SplunkLogDriver(
                this.props.build()
            );
        }
    }
}
